/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IWorkBagProvider;
import edu.ksu.cis.indus.staticanalyses.flow.SendTokensWork;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFGNode
implements IFGNode {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$AbstractFGNode == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$AbstractFGNode = AbstractFGNode.class$("edu.ksu.cis.indus.staticanalyses.flow.AbstractFGNode")) : class$edu$ksu$cis$indus$staticanalyses$flow$AbstractFGNode));
    protected final Set succs = new HashSet();
    protected ITokenFilter filter;
    protected final ITokens tokens;
    protected final IWorkBagProvider workbagProvider;
    private SendTokensWork sendTokensWork;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$AbstractFGNode;

    protected AbstractFGNode(IWorkBagProvider iWorkBagProvider, ITokens iTokens) {
        this.workbagProvider = iWorkBagProvider;
        this.tokens = iTokens;
    }

    public Object getClone() {
        throw new UnsupportedOperationException("Parameterless prototype() method is not supported.");
    }

    public Object getClone(Object object) {
        throw new UnsupportedOperationException("prototype(param1) method is not supported.");
    }

    public void setFilter(ITokenFilter iTokenFilter) {
        this.filter = iTokenFilter;
    }

    public final ITokens getTokens() {
        return this.tokens;
    }

    public final Collection getValues() {
        return this.tokens.getValues();
    }

    public void addSucc(IFGNode iFGNode) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding " + iFGNode + " as the successor to " + this));
        }
        this.succs.add(iFGNode);
        this.onNewSucc(iFGNode);
    }

    public final void injectTokens(ITokens iTokens) {
        ITokens iTokens2 = iTokens.diffTokens(this.tokens);
        if (!iTokens2.isEmpty()) {
            this.tokens.addTokens(iTokens2);
            this.onNewTokens(iTokens2);
        }
    }

    public String toString() {
        return "IFGNode:" + this.hashCode();
    }

    protected void onNewSucc(IFGNode iFGNode) {
        ITokens iTokens = this.filter != null ? this.filter.filter(this.tokens) : this.tokens;
        ITokens iTokens2 = iTokens.diffTokens(iFGNode.getTokens());
        if (!iTokens2.isEmpty()) {
            this.generateWorkToInjectWorkInto(iTokens2, iFGNode);
        }
    }

    protected void onNewTokens(ITokens iTokens) {
        if (!this.succs.isEmpty()) {
            ITokens iTokens2 = this.filter != null ? this.filter.filter(iTokens) : iTokens;
            Iterator iterator = this.succs.iterator();
            while (iterator.hasNext()) {
                IFGNode iFGNode = (IFGNode)iterator.next();
                ITokens iTokens3 = iTokens2.diffTokens(iFGNode.getTokens());
                if (iTokens3.isEmpty()) continue;
                this.generateWorkToInjectWorkInto(iTokens3, iFGNode);
            }
        }
    }

    void forgetSendTokensWork() {
        this.sendTokensWork = null;
    }

    private void generateWorkToInjectWorkInto(ITokens iTokens, IFGNode iFGNode) {
        IWorkBag iWorkBag = this.workbagProvider.getWorkBag();
        if (iFGNode instanceof AbstractFGNode) {
            SendTokensWork sendTokensWork = ((AbstractFGNode)iFGNode).sendTokensWork;
            if (sendTokensWork == null) {
                ((AbstractFGNode)iFGNode).sendTokensWork = sendTokensWork = SendTokensWork.getWork(iFGNode, iTokens);
                iWorkBag.addWork((Object)sendTokensWork);
            } else {
                sendTokensWork.addTokens(iTokens);
            }
        } else {
            iWorkBag.addWork((Object)SendTokensWork.getWork(iFGNode, iTokens));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

