/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.ArrayVariant;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.FieldVariant;
import edu.ksu.cis.indus.staticanalyses.flow.InvocationVariant;
import edu.ksu.cis.indus.staticanalyses.flow.MethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.ModeFactory;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariant;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;

public abstract class AbstractAnalyzer
extends AbstractStatus
implements IValueAnalyzer {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$flow$AbstractAnalyzer == null ? (class$edu$ksu$cis$indus$staticanalyses$flow$AbstractAnalyzer = AbstractAnalyzer.class$("edu.ksu.cis.indus.staticanalyses.flow.AbstractAnalyzer")) : class$edu$ksu$cis$indus$staticanalyses$flow$AbstractAnalyzer));
    protected Context context;
    protected FA fa;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$AbstractAnalyzer;

    protected AbstractAnalyzer(Context context, String string, ITokenManager iTokenManager) {
        this.context = context;
        this.fa = new FA(this, string, iTokenManager);
    }

    public IEnvironment getEnvironment() {
        return this.fa;
    }

    public final Collection getThrowValues(InvokeExpr invokeExpr, SootClass sootClass) {
        InvocationVariant invocationVariant;
        MethodVariant methodVariant = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection collection = Collections.EMPTY_SET;
        if (methodVariant != null && (invocationVariant = (InvocationVariant)methodVariant.getASTVariant((Value)invokeExpr, this.context)) != null) {
            collection = invocationVariant.queryThrowNode(sootClass).getValues();
        }
        return collection;
    }

    public final Collection getValues(Object object, Context context) {
        Context context2 = this.context;
        this.context = context;
        Collection collection = Collections.EMPTY_LIST;
        if (object instanceof Value) {
            collection = this.getValues((Value)object);
        } else if (object instanceof SootField) {
            collection = this.getValues((SootField)object);
        } else if (object instanceof ParameterRef) {
            collection = this.getValues((ParameterRef)object);
        } else if (object instanceof ArrayType) {
            collection = this.getValues((ArrayType)object);
        } else {
            throw new IllegalArgumentException("v has to of type Value, SootField, ParameterRef, or ArrayType.");
        }
        this.context = context2;
        return collection;
    }

    public final Collection getValuesForThis(Context context) {
        Context context2 = this.context;
        this.context = context;
        MethodVariant methodVariant = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection collection = Collections.EMPTY_LIST;
        if (methodVariant != null) {
            collection = methodVariant.queryThisNode().getValues();
        }
        this.context = context2;
        return collection;
    }

    public final void analyze(Scene scene, SootMethod sootMethod) {
        if (sootMethod == null) {
            throw new IllegalStateException("Root method cannot be null.");
        }
        this.unstable();
        this.fa.analyze(scene, sootMethod);
        this.stable();
    }

    public final void analyze(Scene scene, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalStateException("There must be at least one root method to analyze.");
        }
        this.unstable();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            this.fa.analyze(scene, sootMethod);
        }
        this.stable();
    }

    public final void reset() {
        this.unstable();
        this.resetAnalysis();
        this.fa.reset();
    }

    protected final Collection getValues(ArrayType arrayType) {
        ArrayVariant arrayVariant = this.fa.queryArrayVariant(arrayType);
        Collection collection = Collections.EMPTY_SET;
        if (arrayVariant != null) {
            collection = arrayVariant.getFGNode().getValues();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Values for array type " + arrayType + " in node " + arrayVariant.getFGNode() + " are " + collection));
            }
        }
        return collection;
    }

    protected final Collection getValues(ParameterRef parameterRef) {
        MethodVariant methodVariant = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection collection = Collections.EMPTY_SET;
        if (methodVariant != null) {
            collection = methodVariant.queryParameterNode(parameterRef.getIndex()).getValues();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Values for param " + parameterRef + " in node " + methodVariant.queryParameterNode(parameterRef.getIndex()) + " are " + collection));
            }
        }
        return collection;
    }

    protected final Collection getValues(SootField sootField) {
        FieldVariant fieldVariant = this.fa.queryFieldVariant(sootField);
        Collection collection = Collections.EMPTY_SET;
        if (fieldVariant != null) {
            collection = fieldVariant.getValues();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Values for field  " + sootField + " are " + collection));
            }
        }
        return collection;
    }

    protected final Collection getValues(Value value) {
        ValuedVariant valuedVariant;
        MethodVariant methodVariant = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection collection = Collections.EMPTY_SET;
        if (methodVariant != null && (valuedVariant = methodVariant.queryASTVariant(value, this.context)) != null) {
            collection = valuedVariant.getFGNode().getValues();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Values for ast " + value + " in node " + valuedVariant.getFGNode() + " are " + collection));
            }
        }
        return collection;
    }

    protected void setModeFactory(ModeFactory modeFactory) {
        this.fa.setModeFactory(modeFactory);
    }

    protected final void resetAnalysis() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

