/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency.drivers;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.AliasedUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.AliasedUseDefInfov2;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzerBasedProcessor;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.CollectionTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DADriver
extends SootBasedDriver {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$drivers$DADriver == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$drivers$DADriver = DADriver.class$("edu.ksu.cis.indus.staticanalyses.dependency.drivers.DADriver")) : class$edu$ksu$cis$indus$staticanalyses$dependency$drivers$DADriver));
    protected AbstractAnalyzer aa;
    protected Collection das;
    protected final Map info = new HashMap();
    protected boolean ecbaRequired;
    EquivalenceClassBasedEscapeAnalysis ecba = null;
    ValueAnalyzerBasedProcessingController cgipc;
    private AliasedUseDefInfo aliasUD;
    private String[] args;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$drivers$DADriver;

    protected DADriver(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Please specify a class to consider for the analysis.");
            System.exit(-1);
        }
        this.args = stringArray;
    }

    private DADriver() {
    }

    protected void execute() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Loading classes....");
        }
        String string = "DADriver:FA";
        this.setClassNames(Arrays.asList(this.args));
        this.initialize();
        this.aa = OFAnalyzer.getFSOSAnalyzer(string, new CollectionTokenManager(new SootValueTypeManager()));
        ValueAnalyzerBasedProcessingController valueAnalyzerBasedProcessingController = new ValueAnalyzerBasedProcessingController();
        ArrayList<AbstractValueAnalyzerBasedProcessor> arrayList = new ArrayList<AbstractValueAnalyzerBasedProcessor>();
        CallGraph callGraph = new CallGraph();
        ThreadGraph threadGraph = new ThreadGraph(callGraph, new CFGAnalysis(callGraph, this.bbm));
        ArrayList arrayList2 = new ArrayList();
        this.cgipc = new ValueAnalyzerBasedProcessingController();
        this.cgipc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(callGraph));
        this.aliasUD = new AliasedUseDefInfov2(this.aa, callGraph, this.bbm);
        valueAnalyzerBasedProcessingController.setAnalyzer(this.aa);
        valueAnalyzerBasedProcessingController.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter(string));
        this.cgipc.setAnalyzer(this.aa);
        this.info.put("Callgraph Information", callGraph);
        this.info.put("Threadgraph Information", threadGraph);
        this.info.put("Pair management service", new Pair.PairManager());
        this.info.put("The Environment", this.aa.getEnvironment());
        this.info.put(IValueAnalyzer.ID, this.aa);
        this.info.put("Aliased Use-Def Information", this.aliasUD);
        if (this.ecbaRequired) {
            this.ecba = new EquivalenceClassBasedEscapeAnalysis(callGraph, threadGraph, this.bbm);
            this.info.put("Shared Access Information", this.ecba);
        }
        Iterator iterator = this.rootMethods.iterator();
        while (iterator.hasNext()) {
            arrayList2.clear();
            arrayList2.add(iterator.next());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: FA");
            }
            long l = System.currentTimeMillis();
            this.aa.reset();
            this.bbm.reset();
            if (this.ecbaRequired) {
                this.ecba.reset();
            }
            this.aa.analyze(this.scene, arrayList2);
            long l2 = System.currentTimeMillis();
            this.addTimeLog("FA", l2 - l);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: FA");
            }
            callGraph.reset();
            arrayList.clear();
            arrayList.add(callGraph);
            this.process(valueAnalyzerBasedProcessingController, arrayList);
            System.out.println("CALL GRAPH:\n" + callGraph.dumpGraph());
            arrayList.clear();
            threadGraph.reset();
            arrayList.add(threadGraph);
            this.process(this.cgipc, arrayList);
            System.out.println("THREAD GRAPH:\n" + threadGraph.dumpGraph());
            this.setupDependencyAnalyses();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: dependency analyses");
            }
            Object object = this.das.iterator();
            while (object.hasNext()) {
                AbstractDependencyAnalysis abstractDependencyAnalysis = (AbstractDependencyAnalysis)object.next();
                l = System.currentTimeMillis();
                abstractDependencyAnalysis.analyze();
                l2 = System.currentTimeMillis();
                this.addTimeLog(abstractDependencyAnalysis.getClass().getName() + "[" + abstractDependencyAnalysis.hashCode() + "] analysis", l2 - l);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: dependency analyses");
            }
            object = new HashMap();
            System.out.println("\nThread mapping:");
            int n = 1;
            Iterator iterator2 = threadGraph.getAllocationSites().iterator();
            while (iterator2.hasNext()) {
                IThreadGraphInfo.NewExprTriple newExprTriple = (IThreadGraphInfo.NewExprTriple)iterator2.next();
                String string2 = "T" + n++;
                object.put(newExprTriple, string2);
                if (newExprTriple.getMethod() == null) {
                    System.out.println(string2 + " -> " + newExprTriple.getExpr().getType());
                    continue;
                }
                System.out.println(string2 + " -> " + newExprTriple.getStmt() + "@" + newExprTriple.getMethod());
            }
            iterator2 = this.das.iterator();
            while (iterator2.hasNext()) {
                System.out.println(iterator2.next());
            }
            System.out.println("Total classes loaded: " + this.scene.getClasses().size());
            this.setLogger(LOGGER);
            this.printTimingStats();
        }
    }

    protected void process(ProcessingController processingController, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IValueAnalyzerBasedProcessor iValueAnalyzerBasedProcessor = (IValueAnalyzerBasedProcessor)iterator.next();
            iValueAnalyzerBasedProcessor.hookup(processingController);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: FA post processing");
        }
        long l = System.currentTimeMillis();
        processingController.process();
        long l2 = System.currentTimeMillis();
        this.addTimeLog("FA post processing", l2 - l);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: FA post processing");
        }
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            IValueAnalyzerBasedProcessor iValueAnalyzerBasedProcessor = (IValueAnalyzerBasedProcessor)iterator2.next();
            iValueAnalyzerBasedProcessor.unhook(processingController);
        }
    }

    protected void setupDependencyAnalyses() {
        ArrayList<AbstractDependencyAnalysis> arrayList = new ArrayList<AbstractDependencyAnalysis>();
        Iterator iterator = this.das.iterator();
        while (iterator.hasNext()) {
            AbstractDependencyAnalysis abstractDependencyAnalysis;
            block8: {
                abstractDependencyAnalysis = (AbstractDependencyAnalysis)iterator.next();
                abstractDependencyAnalysis.reset();
                abstractDependencyAnalysis.setBasicBlockGraphManager(this.bbm);
                try {
                    abstractDependencyAnalysis.initialize(this.info);
                }
                catch (InitializationException initializationException) {
                    if (!LOGGER.isWarnEnabled()) break block8;
                    LOGGER.warn((Object)(abstractDependencyAnalysis.getClass() + " failed to initialize, hence, will not be executed."), (Throwable)initializationException);
                    arrayList.add(abstractDependencyAnalysis);
                }
            }
            if (arrayList.contains(abstractDependencyAnalysis) || !abstractDependencyAnalysis.doesPreProcessing()) continue;
            abstractDependencyAnalysis.getPreProcessor().hookup(this.cgipc);
        }
        this.das.removeAll(arrayList);
        if (this.ecbaRequired) {
            this.ecba.hookup(this.cgipc);
        }
        this.aliasUD.hookup(this.cgipc);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: preprocessing for dependency analyses");
        }
        long l = System.currentTimeMillis();
        this.cgipc.process();
        long l2 = System.currentTimeMillis();
        this.addTimeLog("Dependency preprocessing", l2 - l);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: preprocessing for dependency analyses");
        }
        this.aliasUD.unhook(this.cgipc);
        if (this.ecbaRequired) {
            this.ecba.unhook(this.cgipc);
            this.ecba.analyze();
        }
        Iterator iterator2 = this.das.iterator();
        while (iterator2.hasNext()) {
            AbstractDependencyAnalysis abstractDependencyAnalysis = (AbstractDependencyAnalysis)iterator2.next();
            if (abstractDependencyAnalysis.getPreProcessor() == null) continue;
            abstractDependencyAnalysis.getPreProcessor().unhook(this.cgipc);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

