/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Quadraple;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;
import soot.Type;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.Stmt;

public final class SynchronizationDA
extends AbstractDependencyAnalysis
implements IMonitorInfo {
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$SynchronizationDA == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$SynchronizationDA = SynchronizationDA.class$("edu.ksu.cis.indus.staticanalyses.dependency.SynchronizationDA")) : class$edu$ksu$cis$indus$staticanalyses$dependency$SynchronizationDA));
    final Collection monitorTriples = new HashSet();
    final Collection syncedMethods = new HashSet();
    final Map method2enterMonitors = new HashMap();
    private IValueAnalyzer ofa;
    private final Map syncedMethod2dependents = new HashMap();
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$SynchronizationDA;
    static /* synthetic */ Class class$soot$jimple$EnterMonitorStmt;

    public SynchronizationDA() {
        this.preprocessor = new PreProcessor();
    }

    public Collection getDependees(Object object, Object object2) {
        return SynchronizationDA.getDepemdsHelper(this.dependent2dependee, object, object2);
    }

    public Collection getDependents(Object object, Object object2) {
        return SynchronizationDA.getDepemdsHelper(this.dependee2dependent, object, object2);
    }

    public Collection getDependentsOnSyncMethod(SootMethod sootMethod) {
        if (!this.syncedMethods.isEmpty()) {
            this.processSyncedMethods();
        }
        return (Collection)MapUtils.getObject((Map)this.syncedMethod2dependents, (Object)sootMethod, (Object)Collections.EMPTY_LIST);
    }

    public Object getId() {
        return IDependencyAnalysis.SYNCHRONIZATION_DA;
    }

    public Collection getMonitorTriples() {
        return Collections.unmodifiableCollection(this.monitorTriples);
    }

    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Synchronization Dependence processing");
        }
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        Iterator iterator = this.method2enterMonitors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SootMethod sootMethod = (SootMethod)entry.getKey();
            hashMap.clear();
            Iterator iterator2 = ((Collection)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                Stmt stmt = (Stmt)iterator2.next();
                if (hashSet.contains(stmt) || CollectionsUtilities.getMapFromMap((Map)this.dependee2dependent, (Object)sootMethod).get(stmt) != null) continue;
                hashSet.addAll(this.processMonitor(hashSet, stmt, sootMethod, hashMap));
            }
        }
        this.method2enterMonitors.clear();
        this.stable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("analyze() - " + this.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Synchronization Dependence processing");
        }
    }

    public void reset() {
        super.reset();
        this.monitorTriples.clear();
        this.syncedMethods.clear();
        this.syncedMethod2dependents.clear();
    }

    public String toString() {
        Object object;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer("Statistics for Synchronization dependence as calculated by " + this.getClass().getName() + "\n");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator2 = this.dependent2dependee.entrySet().iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            n = 0;
            object = (SootMethod)iterator.getKey();
            Iterator iterator3 = ((Map)iterator.getValue()).entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry = iterator3.next();
                Stmt stmt = (Stmt)entry.getKey();
                Iterator iterator4 = ((Collection)entry.getValue()).iterator();
                while (iterator4.hasNext()) {
                    Stmt stmt2 = (Stmt)iterator4.next();
                    stringBuffer2.append("\t\t" + stmt + "[" + stmt.hashCode() + "] -SDA-> " + stmt2 + "[" + stmt2.hashCode() + "]\n");
                }
                n += ((Collection)entry.getValue()).size();
            }
            stringBuffer.append("\tFor " + object + " there are " + n + " sync dependence edges.\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer2.delete(0, stringBuffer2.length());
            n2 += n;
        }
        int n3 = 0;
        iterator = this.dependent2dependee.values().iterator();
        while (iterator.hasNext()) {
            object = ((Map)iterator.next()).values().iterator();
            while (object.hasNext()) {
                n3 += ((Collection)object.next()).size();
            }
        }
        stringBuffer.append("A total of " + n2 + "/" + n3 + " synchronization dependence edges exist.\n");
        stringBuffer.append("MonitorInfo follows:\n");
        iterator = this.monitorTriples.iterator();
        while (iterator.hasNext()) {
            object = (Triple)iterator.next();
            if (object.getFirst() != null) {
                stringBuffer.append("[" + object.getFirst() + " " + object.getFirst().hashCode() + ", " + object.getSecond() + " " + object.getSecond().hashCode() + "] occurs in " + object.getThird() + "\n");
                continue;
            }
            stringBuffer.append(object.getThird() + " is synchronized.\n");
        }
        return stringBuffer.toString();
    }

    protected static Collection getDepemdsHelper(Map map, Object object, Object object2) {
        Collection collection;
        Collection<Object> collection2 = Collections.EMPTY_LIST;
        Map map2 = (Map)map.get(object2);
        if (map2 != null && (collection = (Collection)map2.get(object)) != null) {
            collection2 = Collections.unmodifiableCollection(collection);
        }
        return collection2;
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.ofa = (IValueAnalyzer)this.info.get(IValueAnalyzer.ID);
        if (this.ofa == null) {
            throw new InitializationException(IValueAnalyzer.ID + " was not provided in the info.");
        }
    }

    private void populateWorkBagToProcessSuccessors(IWorkBag iWorkBag, BasicBlockGraph.BasicBlock basicBlock, Stack stack, Collection collection) {
        Collection collection2 = basicBlock.getSuccsOf();
        if (collection2.size() == 1) {
            BasicBlockGraph.BasicBlock basicBlock2 = (BasicBlockGraph.BasicBlock)collection2.iterator().next();
            iWorkBag.addWork((Object)new Quadraple((Object)basicBlock2, (Object)basicBlock2.getLeaderStmt(), (Object)stack, (Object)collection));
        } else {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                BasicBlockGraph.BasicBlock basicBlock3 = (BasicBlockGraph.BasicBlock)iterator.next();
                Stack<Pair> stack2 = new Stack<Pair>();
                Iterator iterator2 = stack.iterator();
                while (iterator2.hasNext()) {
                    Pair pair = (Pair)iterator2.next();
                    stack2.add(new Pair(pair.getFirst(), ((HashSet)pair.getSecond()).clone()));
                }
                iWorkBag.addWork((Object)new Quadraple((Object)basicBlock3, (Object)basicBlock3.getLeaderStmt(), stack2, ((HashSet)collection).clone()));
            }
        }
    }

    private void populateWorkBagWithSuccessorsOfNestedMonitor(IWorkBag iWorkBag, Collection collection, Stack stack, Collection collection2, BasicBlockGraph basicBlockGraph) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BasicBlockGraph.BasicBlock basicBlock;
            Stmt stmt = (Stmt)iterator.next();
            if (stmt == (basicBlock = basicBlockGraph.getEnclosingBlock(stmt)).getTrailerStmt()) {
                this.populateWorkBagToProcessSuccessors(iWorkBag, basicBlock, stack, collection2);
                continue;
            }
            List list = basicBlock.getStmtsOf();
            iWorkBag.addWork((Object)new Quadraple((Object)basicBlock, list.get(list.indexOf(stmt) + 1), stack.clone(), ((HashSet)collection2).clone()));
        }
    }

    private Collection processExitMonitor(SootMethod sootMethod, Map map, Stack stack, Collection collection, Stmt stmt) {
        Pair pair = (Pair)stack.pop();
        EnterMonitorStmt enterMonitorStmt = (EnterMonitorStmt)pair.getFirst();
        ExitMonitorStmt exitMonitorStmt = (ExitMonitorStmt)stmt;
        Collection collection2 = collection;
        if (this.shouldCollectInfo(sootMethod, enterMonitorStmt, exitMonitorStmt)) {
            collection.add(enterMonitorStmt);
            collection.add(exitMonitorStmt);
            Map map2 = CollectionsUtilities.getMapFromMap((Map)this.dependent2dependee, (Object)sootMethod);
            Map map3 = CollectionsUtilities.getMapFromMap((Map)this.dependee2dependent, (Object)sootMethod);
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(enterMonitorStmt);
            hashSet.add(exitMonitorStmt);
            Triple triple = collection.iterator();
            while (triple.hasNext()) {
                Stmt stmt2 = (Stmt)triple.next();
                CollectionsUtilities.putAllIntoSetInMap((Map)map2, (Object)stmt2, hashSet);
            }
            CollectionsUtilities.putAllIntoSetInMap((Map)map3, (Object)enterMonitorStmt, (Collection)collection);
            CollectionsUtilities.putAllIntoSetInMap((Map)map3, (Object)exitMonitorStmt, (Collection)collection);
            triple = new Triple((Object)enterMonitorStmt, (Object)exitMonitorStmt, (Object)sootMethod);
            this.monitorTriples.add(triple);
            CollectionsUtilities.putIntoSetInMap((Map)map, (Object)enterMonitorStmt, (Object)exitMonitorStmt);
            collection2 = (HashSet)pair.getSecond();
            collection2.add(exitMonitorStmt);
        }
        return collection2;
    }

    private Collection processMonitor(Collection collection, Stmt stmt, SootMethod sootMethod, Map map) {
        HistoryAwareLIFOWorkBag historyAwareLIFOWorkBag = new HistoryAwareLIFOWorkBag(new HashSet());
        BasicBlockGraph basicBlockGraph = this.getBasicBlockGraph(sootMethod);
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(stmt);
        historyAwareLIFOWorkBag.addWork((Object)new Quadraple((Object)basicBlockGraph.getEnclosingBlock(stmt), (Object)stmt, new Stack(), new HashSet()));
        block0: do {
            Quadraple quadraple = (Quadraple)historyAwareLIFOWorkBag.getWork();
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)quadraple.getFirst();
            Stmt stmt2 = (Stmt)quadraple.getSecond();
            Stack stack = (Stack)quadraple.getThird();
            HashSet hashSet2 = (HashSet)quadraple.getFourth();
            boolean bl = false;
            Iterator iterator = basicBlock.getStmtsFrom(stmt2).iterator();
            while (iterator.hasNext()) {
                Stmt stmt3 = (Stmt)iterator.next();
                if (stmt3 instanceof EnterMonitorStmt) {
                    EnterMonitorStmt enterMonitorStmt = (EnterMonitorStmt)stmt3;
                    if (!collection.contains(enterMonitorStmt)) {
                        hashSet2.add(enterMonitorStmt);
                        stack.push(new Pair((Object)enterMonitorStmt, (Object)hashSet2));
                        hashSet2 = new HashSet();
                        hashSet.add(enterMonitorStmt);
                        continue;
                    }
                    Set set = CollectionsUtilities.getSetFromMap((Map)map, (Object)enterMonitorStmt);
                    this.populateWorkBagWithSuccessorsOfNestedMonitor((IWorkBag)historyAwareLIFOWorkBag, set, stack, hashSet2, basicBlockGraph);
                    bl = true;
                    break;
                }
                if (stmt3 instanceof ExitMonitorStmt) {
                    hashSet2 = this.processExitMonitor(sootMethod, map, stack, hashSet2, stmt3);
                    if (!stack.isEmpty()) continue;
                    continue block0;
                }
                hashSet2.add(stmt3);
            }
            if (bl || stack.isEmpty()) continue;
            this.populateWorkBagToProcessSuccessors((IWorkBag)historyAwareLIFOWorkBag, basicBlock, stack, hashSet2);
        } while (historyAwareLIFOWorkBag.hasWork());
        return hashSet;
    }

    private void processSyncedMethods() {
        ArrayList arrayList = new ArrayList();
        HashSet<Stmt> hashSet = new HashSet<Stmt>();
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof EnterMonitorStmt;
            }
        };
        Iterator iterator = this.syncedMethods.iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            Iterator iterator2 = this.getUnitGraph(sootMethod).iterator();
            while (iterator2.hasNext()) {
                Stmt stmt = (Stmt)iterator2.next();
                arrayList.clear();
                arrayList.addAll(this.getDependees(stmt, sootMethod));
                CollectionUtils.filter(arrayList, (Predicate)predicate);
                int n = stmt instanceof EnterMonitorStmt || stmt instanceof ExitMonitorStmt ? 1 : 0;
                if (arrayList.size() != n) continue;
                hashSet.add(stmt);
            }
            if (hashSet.isEmpty()) continue;
            this.syncedMethod2dependents.put(sootMethod, new ArrayList(hashSet));
            hashSet.clear();
        }
        this.syncedMethods.clear();
    }

    private boolean shouldCollectInfo(SootMethod sootMethod, EnterMonitorStmt enterMonitorStmt, ExitMonitorStmt exitMonitorStmt) {
        Type type;
        boolean bl;
        Type type2 = enterMonitorStmt.getOp().getType();
        boolean bl2 = bl = Util.isSameOrSubType((Type)type2, (Type)(type = exitMonitorStmt.getOp().getType()), (IEnvironment)this.ofa.getEnvironment()) || Util.isSameOrSubType((Type)type, (Type)type2, (IEnvironment)this.ofa.getEnvironment());
        if (!bl) {
            Context context = new Context();
            context.setRootMethod(sootMethod);
            context.setProgramPoint(enterMonitorStmt.getOpBox());
            context.setStmt((Stmt)enterMonitorStmt);
            Collection collection = this.ofa.getValues(enterMonitorStmt.getOp(), context);
            context.setProgramPoint(exitMonitorStmt.getOpBox());
            context.setStmt((Stmt)exitMonitorStmt);
            Collection collection2 = this.ofa.getValues(exitMonitorStmt.getOp(), context);
            if (!collection2.isEmpty() && !collection.isEmpty()) {
                bl = !CollectionUtils.intersection((Collection)collection2, (Collection)collection).isEmpty();
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PreProcessor
    extends AbstractValueAnalyzerBasedProcessor {
        private PreProcessor() {
        }

        public void callback(SootMethod sootMethod) {
            if (sootMethod.isSynchronized()) {
                Triple triple = new Triple(null, null, (Object)sootMethod);
                triple.optimize();
                SynchronizationDA.this.monitorTriples.add(triple);
                SynchronizationDA.this.syncedMethods.add(sootMethod);
            }
        }

        public void callback(Stmt stmt, Context context) {
            if (stmt instanceof EnterMonitorStmt) {
                CollectionsUtilities.putIntoSetInMap((Map)SynchronizationDA.this.method2enterMonitors, (Object)context.getCurrentMethod(), (Object)stmt);
            }
        }

        public void hookup(ProcessingController processingController) {
            processingController.register(class$soot$jimple$EnterMonitorStmt == null ? (class$soot$jimple$EnterMonitorStmt = SynchronizationDA.class$("soot.jimple.EnterMonitorStmt")) : class$soot$jimple$EnterMonitorStmt, (IProcessor)this);
            processingController.register((IProcessor)this);
        }

        public void unhook(ProcessingController processingController) {
            processingController.unregister(class$soot$jimple$EnterMonitorStmt == null ? (class$soot$jimple$EnterMonitorStmt = SynchronizationDA.class$("soot.jimple.EnterMonitorStmt")) : class$soot$jimple$EnterMonitorStmt, (IProcessor)this);
            processingController.unregister((IProcessor)this);
        }
    }
}

