/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;

final class StmtAndMethodBasedDependencyXMLizer
extends AbstractProcessor {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyXMLizer == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyXMLizer = StmtAndMethodBasedDependencyXMLizer.class$("edu.ksu.cis.indus.staticanalyses.dependency.StmtAndMethodBasedDependencyXMLizer")) : class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyXMLizer));
    private IDependencyAnalysis analysis;
    private IJimpleIDGenerator idGenerator;
    private XMLOutputter writer;
    private boolean processingClass;
    private boolean processingMethod;
    private int totalDependences;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyXMLizer;

    public StmtAndMethodBasedDependencyXMLizer(XMLOutputter xMLOutputter, IJimpleIDGenerator iJimpleIDGenerator, IDependencyAnalysis iDependencyAnalysis) {
        this.writer = xMLOutputter;
        this.idGenerator = iJimpleIDGenerator;
        this.analysis = iDependencyAnalysis;
    }

    public void callback(Stmt stmt, Context context) {
        block11: {
            SootMethod sootMethod = context.getCurrentMethod();
            Collection collection = this.analysis.getDependents(stmt, sootMethod);
            Collection collection2 = this.analysis.getDependees(stmt, sootMethod);
            try {
                if (!collection.isEmpty() || !collection2.isEmpty()) {
                    Pair pair;
                    String string;
                    Object e;
                    this.writer.startTag("dependency_info");
                    this.writer.attribute("stmtId", this.idGenerator.getIdForStmt(stmt, sootMethod));
                    this.totalDependences += collection.size();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        string = null;
                        if (e instanceof Pair) {
                            pair = (Pair)e;
                            string = this.idGenerator.getIdForStmt((Stmt)pair.getFirst(), (SootMethod)pair.getSecond());
                        } else if (e instanceof Stmt) {
                            string = this.idGenerator.getIdForStmt((Stmt)e, sootMethod);
                        }
                        if (string == null) continue;
                        this.writer.startTag("dependent");
                        this.writer.attribute("tid", string);
                        this.writer.endTag();
                    }
                    iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        string = null;
                        if (e instanceof Pair) {
                            pair = (Pair)e;
                            string = this.idGenerator.getIdForStmt((Stmt)pair.getFirst(), (SootMethod)pair.getSecond());
                        } else if (e instanceof Stmt) {
                            string = this.idGenerator.getIdForStmt((Stmt)e, sootMethod);
                        }
                        if (string == null) continue;
                        this.writer.startTag("dependee");
                        this.writer.attribute("eid", string);
                        this.writer.endTag();
                    }
                    this.writer.endTag();
                }
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block11;
                LOGGER.warn((Object)"Error while writing dependency info.", (Throwable)iOException);
            }
        }
    }

    public void callback(SootClass sootClass) {
        block5: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                }
                if (this.processingClass) {
                    this.writer.endTag();
                } else {
                    this.processingClass = true;
                }
                this.writer.startTag("class");
                this.writer.attribute("id", this.idGenerator.getIdForClass(sootClass));
                this.processingMethod = false;
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn((Object)"Error while writing dependency info.", (Throwable)iOException);
            }
        }
    }

    public void callback(SootMethod sootMethod) {
        block4: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                } else {
                    this.processingMethod = true;
                }
                this.writer.startTag("method");
                this.writer.attribute("id", this.idGenerator.getIdForMethod(sootMethod));
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn((Object)"Error while writing dependency info.", (Throwable)iOException);
            }
        }
    }

    public void consolidate() {
        block4: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                }
                if (this.processingClass) {
                    this.writer.endTag();
                }
                this.writer.startTag("count");
                this.writer.pcdata(String.valueOf(this.totalDependences));
                this.writer.endDocument();
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn((Object)"Error while writing dependency info.", (Throwable)iOException);
            }
        }
    }

    public void hookup(ProcessingController processingController) {
        processingController.registerForAllStmts((IProcessor)this);
        processingController.register((IProcessor)this);
    }

    public void processingBegins() {
        block2: {
            try {
                this.writer.declaration();
                this.writer.startTag("dependency");
                this.writer.attribute("id", String.valueOf(this.analysis.getId()));
                this.writer.attribute("class", this.analysis.getClass().getName().toString());
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn((Object)"Error while writing dependency info.", (Throwable)iOException);
            }
        }
    }

    public void unhook(ProcessingController processingController) {
        processingController.unregisterForAllStmts((IProcessor)this);
        processingController.unregister((IProcessor)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

