/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysisTest;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

class StmtAndMethodBasedDependencyAnalysisTest
extends AbstractDependencyAnalysisTest {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyAnalysisTest == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyAnalysisTest = StmtAndMethodBasedDependencyAnalysisTest.class$("edu.ksu.cis.indus.staticanalyses.dependency.StmtAndMethodBasedDependencyAnalysisTest")) : class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyAnalysisTest));
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$StmtAndMethodBasedDependencyAnalysisTest;

    StmtAndMethodBasedDependencyAnalysisTest() {
    }

    protected void verifyDAFor(Stmt stmt, SootMethod sootMethod) {
        IDependencyAnalysis iDependencyAnalysis = this.getDA();
        this.verifyDependentPosition(stmt, sootMethod, iDependencyAnalysis);
        this.verifyDependeePosition(stmt, sootMethod, iDependencyAnalysis);
    }

    private void verifyDependeePosition(Stmt stmt, SootMethod sootMethod, IDependencyAnalysis iDependencyAnalysis) {
        Collection collection = iDependencyAnalysis.getDependents(stmt, sootMethod);
        if (!collection.isEmpty()) {
            Object e = collection.iterator().next();
            Object object = e instanceof Pair ? new Pair((Object)stmt, (Object)sootMethod) : stmt;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Stmt stmt2;
                Object e2 = iterator.next();
                SootMethod sootMethod2 = sootMethod;
                if (e2 instanceof Pair) {
                    Pair pair = (Pair)e2;
                    stmt2 = (Stmt)pair.getFirst();
                    sootMethod2 = (SootMethod)pair.getSecond();
                } else if (e2 instanceof Stmt) {
                    stmt2 = (Stmt)e2;
                } else {
                    LOGGER.error((Object)"This class can only handle Pair and Stmt as targets of dependence information.");
                    throw new IllegalStateException("This class can only handle Pair and Stmt as targets of dependence information.");
                }
                StmtAndMethodBasedDependencyAnalysisTest.assertTrue((String)("Dependee:" + this.getDA().getClass().getName() + ": (" + stmt + ", " + sootMethod + ") -> (" + stmt2 + ", " + sootMethod2 + ")"), (boolean)iDependencyAnalysis.getDependees(stmt2, sootMethod2).contains(object));
            }
        }
    }

    private void verifyDependentPosition(Stmt stmt, SootMethod sootMethod, IDependencyAnalysis iDependencyAnalysis) {
        Collection collection = iDependencyAnalysis.getDependees(stmt, sootMethod);
        if (!collection.isEmpty()) {
            Object e = collection.iterator().next();
            Object object = e instanceof Pair ? new Pair((Object)stmt, (Object)sootMethod) : stmt;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Stmt stmt2;
                Object e2 = iterator.next();
                SootMethod sootMethod2 = sootMethod;
                if (e2 instanceof Pair) {
                    Pair pair = (Pair)e2;
                    stmt2 = (Stmt)pair.getFirst();
                    sootMethod2 = (SootMethod)pair.getSecond();
                } else if (e2 instanceof Stmt) {
                    stmt2 = (Stmt)e2;
                } else {
                    LOGGER.error((Object)"This class can only handle Pair and Stmt as targets of dependence information.");
                    throw new IllegalStateException("This class can only handle Pair and Stmt as targets of dependence information.");
                }
                StmtAndMethodBasedDependencyAnalysisTest.assertTrue((String)("Dependent:" + this.getDA().getClass().getName() + ": (" + stmt + ", " + sootMethod + ") -> (" + stmt2 + ", " + sootMethod2 + ")"), (boolean)iDependencyAnalysis.getDependents(stmt2, sootMethod2).contains(object));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

