/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

public class ReferenceBasedDataDA
extends AbstractDependencyAnalysis {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$ReferenceBasedDataDA == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$ReferenceBasedDataDA = ReferenceBasedDataDA.class$("edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA")) : class$edu$ksu$cis$indus$staticanalyses$dependency$ReferenceBasedDataDA));
    protected IUseDefInfo aliasedUD;
    private final Context contextCache = new Context();
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$ReferenceBasedDataDA;

    public Collection getDependees(Object object, Object object2) {
        Collection collection;
        Stmt stmt = (Stmt)object;
        if (stmt.containsArrayRef() || stmt.containsFieldRef()) {
            this.contextCache.setRootMethod((SootMethod)object2);
            collection = this.aliasedUD.getDefs(stmt, this.contextCache);
        } else {
            collection = Collections.EMPTY_LIST;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getDependees(stmt = " + object + ", method = " + object2 + ") - _result = " + collection));
        }
        return collection;
    }

    public Collection getDependents(Object object, Object object2) {
        Collection collection;
        Stmt stmt = (Stmt)object;
        if (object instanceof DefinitionStmt && (stmt.containsArrayRef() || stmt.containsFieldRef())) {
            this.contextCache.setRootMethod((SootMethod)object2);
            collection = this.aliasedUD.getUses((DefinitionStmt)object, this.contextCache);
        } else {
            collection = Collections.EMPTY_LIST;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getDependents(stmt = " + object + ", method = " + object2 + ") - _result = " + collection));
        }
        return collection;
    }

    public Object getId() {
        return IDependencyAnalysis.REFERENCE_BASED_DATA_DA;
    }

    public void analyze() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Reference Based Data Dependence processing");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("ReferenceBasedDataDA.analyze() - " + this.toString()));
        }
        if (this.aliasedUD.isStable()) {
            this.stable();
        } else {
            this.unstable();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Reference Based Data Dependence processing");
        }
    }

    public String toString() {
        return this.aliasedUD + "";
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.aliasedUD = (IUseDefInfo)this.info.get("Aliased Use-Def Information");
        if (this.aliasedUD == null) {
            throw new InitializationException("Aliased Use-Def Information was not provided.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

