/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.allocation.AllocationContext;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

public class ReadyDAv1
extends AbstractDependencyAnalysis {
    public static final int RULE_1 = 1;
    public static final int RULE_2 = 2;
    public static final int RULE_3 = 4;
    public static final int RULE_4 = 8;
    protected static final Object SYNC_METHOD_PROXY_STMT = "SYNC_METHOD_PROXY_STMT";
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$ReadyDAv1 == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$ReadyDAv1 = ReadyDAv1.class$("edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1")) : class$edu$ksu$cis$indus$staticanalyses$dependency$ReadyDAv1));
    protected int rules = 15;
    final Collection monitorMethods = new HashSet();
    Collection notifyMethods;
    final Collection readyMethods = new HashSet();
    Collection waitMethods;
    final Map enterMonitors = new HashMap();
    final Map exitMonitors = new HashMap();
    final Map notifies = new HashMap();
    final Map waits = new HashMap();
    private final Collection specials = new HashSet();
    private ICallGraphInfo callgraph;
    private IEnvironment env;
    private IThreadGraphInfo threadgraph;
    private IValueAnalyzer ofa;
    private Pair.PairManager pairMgr;
    private boolean considerCallSites;
    private boolean useOFA;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$ReadyDAv1;
    static /* synthetic */ Class class$soot$jimple$EnterMonitorStmt;
    static /* synthetic */ Class class$soot$jimple$ExitMonitorStmt;
    static /* synthetic */ Class class$soot$jimple$InvokeStmt;

    public ReadyDAv1() {
        this.preprocessor = new PreProcessor();
        this.considerCallSites = false;
    }

    public void setConsiderCallSites(boolean bl) {
        this.considerCallSites = bl;
    }

    public Collection getDependees(Object object, Object object2) {
        Map map = (Map)this.dependent2dependee.get(object2);
        Collection<Object> collection = Collections.EMPTY_LIST;
        if (map != null && map.containsKey(object)) {
            collection = Collections.unmodifiableCollection((Collection)map.get(object));
        }
        return collection;
    }

    public Collection getDependents(Object object, Object object2) {
        Map map = (Map)this.dependee2dependent.get(object2);
        Collection<Object> collection = Collections.EMPTY_LIST;
        if (map != null && map.containsKey(object)) {
            collection = Collections.unmodifiableCollection((Collection)map.get(object));
        }
        return collection;
    }

    public Object getId() {
        return IDependencyAnalysis.READY_DA;
    }

    public void setRules(int n) {
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("rules has to be a combination of RULE_XX constants defined in this class.");
        }
        this.rules = n;
    }

    public int getRules() {
        return this.rules;
    }

    public Collection getSynchronizedMethodEntryExitPoints(Collection collection) {
        HashSet hashSet = new HashSet(collection);
        hashSet.retainAll(this.specials);
        return hashSet;
    }

    public final void setUseOFA(boolean bl) {
        this.useOFA = bl;
    }

    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("BEGIN: Ready Dependence [" + this.getClass() + " processing"));
        }
        if (!this.threadgraph.getStartSites().isEmpty()) {
            if (!this.monitorMethods.isEmpty() && (this.rules & 5) != 0) {
                this.processRule1And3();
            }
            if (!this.waits.isEmpty() && !this.notifies.isEmpty()) {
                if ((this.rules & 2) != 0) {
                    this.processRule2();
                }
                if ((this.rules & 8) != 0) {
                    this.processRule4();
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("analyze() - " + this.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Ready Dependence processing");
        }
        this.stable();
    }

    public void reset() {
        super.reset();
        this.enterMonitors.clear();
        this.exitMonitors.clear();
        this.specials.clear();
        this.waits.clear();
        this.notifies.clear();
        this.monitorMethods.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Statistics for Ready dependence as calculated by " + this.getClass().getName() + "\n");
        int n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.dependent2dependee.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            stringBuffer.append("In method " + k + "\n ");
            Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                Object k2 = entry2.getKey();
                int n2 = 0;
                Iterator<Object> iterator3 = ((Collection)entry2.getValue()).iterator();
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    stringBuffer2.append("\t\t" + e + " <-- " + k2 + "\n");
                }
                n2 += ((Collection)entry2.getValue()).size();
                iterator3 = entry2.getKey();
                stringBuffer.append("\tFor " + iterator3 + "[");
                if (iterator3 != null) {
                    stringBuffer.append(iterator3.hashCode());
                } else {
                    stringBuffer.append(0);
                }
                stringBuffer.append("] there are " + n2 + " Ready dependence edges.\n");
                stringBuffer.append(stringBuffer2);
                stringBuffer2.delete(0, stringBuffer2.length());
                n += n2;
            }
        }
        stringBuffer.append("A total of " + n + " Ready dependence edges exist.");
        return stringBuffer.toString();
    }

    protected final boolean getUseOFA() {
        return this.useOFA;
    }

    protected final boolean ifDependentOnBasedOnOFAByRule4(Pair pair, Pair pair2) {
        SootMethod sootMethod = (SootMethod)pair.getSecond();
        SootMethod sootMethod2 = (SootMethod)pair2.getSecond();
        Object object = pair.getFirst();
        Object object2 = pair2.getFirst();
        AllocationContext allocationContext = new AllocationContext();
        Stmt stmt = (Stmt)object;
        InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)stmt.getInvokeExpr();
        allocationContext.setProgramPoint(instanceInvokeExpr.getBaseBox());
        allocationContext.setStmt(stmt);
        allocationContext.setRootMethod(sootMethod);
        Collection collection = this.ofa.getValues(instanceInvokeExpr.getBase(), allocationContext);
        Stmt stmt2 = (Stmt)object2;
        InstanceInvokeExpr instanceInvokeExpr2 = (InstanceInvokeExpr)stmt2.getInvokeExpr();
        allocationContext.setProgramPoint(instanceInvokeExpr2.getBaseBox());
        allocationContext.setStmt(stmt2);
        allocationContext.setRootMethod(sootMethod2);
        Collection collection2 = this.ofa.getValues(instanceInvokeExpr2.getBase(), allocationContext);
        NullConstant nullConstant = NullConstant.v();
        Collection collection3 = CollectionUtils.intersection((Collection)collection, (Collection)collection2);
        while (collection3.remove(nullConstant)) {
        }
        boolean bl = !collection3.isEmpty();
        return bl;
    }

    protected boolean ifDependentOnByRule2(Pair pair, Pair pair2) {
        boolean bl;
        SootClass sootClass;
        Object object;
        SootClass sootClass2;
        SootMethod sootMethod = (SootMethod)pair.getSecond();
        SootMethod sootMethod2 = (SootMethod)pair2.getSecond();
        boolean bl2 = false;
        boolean bl3 = false;
        Object object2 = pair.getFirst();
        if (object2.equals(SYNC_METHOD_PROXY_STMT)) {
            sootClass2 = sootMethod.getDeclaringClass();
            bl2 = sootMethod.isStatic();
        } else {
            object = (EnterMonitorStmt)object2;
            sootClass2 = this.env.getClass(((RefType)object.getOp().getType()).getClassName());
        }
        object = pair2.getFirst();
        if (object.equals(SYNC_METHOD_PROXY_STMT)) {
            sootClass = sootMethod2.getDeclaringClass();
            bl3 = sootMethod2.isStatic();
        } else {
            ExitMonitorStmt exitMonitorStmt = (ExitMonitorStmt)object;
            sootClass = this.env.getClass(((RefType)exitMonitorStmt.getOp().getType()).getClassName());
        }
        if (bl2 && bl3) {
            bl = sootClass2.equals(sootClass);
        } else if (bl2 ^ bl3) {
            bl = true;
        } else {
            bl = Util.isHierarchicallyRelated((SootClass)sootClass2, (SootClass)sootClass);
            if (bl && this.useOFA) {
                bl = this.ifDependentOnBasedOnOFAByRule2(pair, pair2);
            }
        }
        return bl;
    }

    protected boolean ifDependentOnByRule4(Pair pair, Pair pair2) {
        InvokeStmt invokeStmt = (InvokeStmt)pair2.getFirst();
        SootClass sootClass = this.env.getClass(((RefType)((InstanceInvokeExpr)invokeStmt.getInvokeExpr()).getBase().getType()).getClassName());
        InvokeStmt invokeStmt2 = (InvokeStmt)pair.getFirst();
        SootClass sootClass2 = this.env.getClass(((RefType)((InstanceInvokeExpr)invokeStmt2.getInvokeExpr()).getBase().getType()).getClassName());
        return Util.isHierarchicallyRelated((SootClass)sootClass, (SootClass)sootClass2);
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.env = (IEnvironment)this.info.get("The Environment");
        if (this.env == null) {
            throw new InitializationException("The Environment was not provided in info.");
        }
        Iterator iterator = this.env.getClasses().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            if (!sootClass.getName().equals("java.lang.Object")) continue;
            this.waitMethods = new ArrayList();
            this.waitMethods.add(sootClass.getMethod("void wait()"));
            this.waitMethods.add(sootClass.getMethod("void wait(long)"));
            this.waitMethods.add(sootClass.getMethod("void wait(long,int)"));
            this.waitMethods = Collections.unmodifiableCollection(this.waitMethods);
            this.notifyMethods = new ArrayList();
            this.notifyMethods.add(sootClass.getMethodByName("notify"));
            this.notifyMethods.add(sootClass.getMethodByName("notifyAll"));
            this.notifyMethods = Collections.unmodifiableCollection(this.notifyMethods);
        }
        this.callgraph = (ICallGraphInfo)this.info.get("Callgraph Information");
        if (this.callgraph == null) {
            throw new InitializationException("Callgraph Information was not provided in info.");
        }
        this.threadgraph = (IThreadGraphInfo)this.info.get("Threadgraph Information");
        if (this.threadgraph == null) {
            throw new InitializationException("Threadgraph Information was not provided in info.");
        }
        this.pairMgr = (Pair.PairManager)this.info.get("Pair management service");
        if (this.pairMgr == null) {
            throw new InitializationException("Pair management service was not provided in info.");
        }
        this.ofa = (OFAnalyzer)this.info.get(IValueAnalyzer.ID);
        if (this.ofa == null) {
            throw new InitializationException(IValueAnalyzer.ID + " was not provided in the info.");
        }
    }

    private boolean callsReadyMethod(Stmt stmt, SootMethod sootMethod) {
        boolean bl = false;
        if (this.considerCallSites && stmt.containsInvokeExpr() && !CollectionUtils.intersection((Collection)this.readyMethods, (Collection)this.callgraph.getMethodsReachableFrom(stmt, sootMethod)).isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private boolean ifDependentOnBasedOnOFAByRule2(Pair pair, Pair pair2) {
        boolean bl;
        Collection collection;
        EnterMonitorStmt enterMonitorStmt;
        Collection collection2;
        SootMethod sootMethod = (SootMethod)pair.getSecond();
        SootMethod sootMethod2 = (SootMethod)pair2.getSecond();
        Object object = pair.getFirst();
        Object object2 = pair2.getFirst();
        boolean bl2 = false;
        boolean bl3 = false;
        Context context = new Context();
        if (object.equals(SYNC_METHOD_PROXY_STMT)) {
            bl2 = sootMethod.isStatic();
            if (!bl2) {
                context.setRootMethod(sootMethod);
                collection2 = this.ofa.getValuesForThis(context);
            } else {
                collection2 = Collections.EMPTY_LIST;
            }
        } else {
            enterMonitorStmt = (EnterMonitorStmt)object;
            context.setProgramPoint(enterMonitorStmt.getOpBox());
            context.setStmt((Stmt)enterMonitorStmt);
            context.setRootMethod(sootMethod);
            collection2 = this.ofa.getValues(enterMonitorStmt.getOp(), context);
        }
        if (object2.equals(SYNC_METHOD_PROXY_STMT)) {
            bl3 = sootMethod2.isStatic();
            if (!bl3) {
                context.setProgramPoint(null);
                context.setStmt(null);
                context.setRootMethod(sootMethod2);
                collection = this.ofa.getValuesForThis(context);
            } else {
                collection = Collections.EMPTY_LIST;
            }
        } else {
            enterMonitorStmt = (ExitMonitorStmt)object2;
            context.setProgramPoint(enterMonitorStmt.getOpBox());
            context.setStmt((Stmt)enterMonitorStmt);
            context.setRootMethod(sootMethod2);
            collection = this.ofa.getValues(enterMonitorStmt.getOp(), context);
        }
        if (bl2 ^ bl3) {
            bl = true;
        } else {
            enterMonitorStmt = NullConstant.v();
            Collection collection3 = CollectionUtils.intersection((Collection)collection2, (Collection)collection);
            while (collection3.remove(enterMonitorStmt)) {
            }
            bl = !collection3.isEmpty();
        }
        return bl;
    }

    private void normalizeEntryInformation(Collection collection) {
        HashSet<Pair> hashSet = new HashSet<Pair>();
        HashSet<Pair> hashSet2 = new HashSet<Pair>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            Object object = pair.getFirst();
            if (object instanceof Stmt) continue;
            hashSet2.add(pair);
            SootMethod sootMethod = (SootMethod)pair.getSecond();
            BasicBlockGraph.BasicBlock basicBlock = this.getBasicBlockGraph(sootMethod).getHead();
            Stmt stmt = null;
            if (basicBlock != null) {
                stmt = basicBlock.getLeaderStmt();
            }
            Pair pair2 = this.pairMgr.getOptimizedPair((Object)stmt, (Object)sootMethod);
            this.specials.add(pair2);
            hashSet.add(pair2);
        }
        collection.removeAll(hashSet2);
        collection.addAll(hashSet);
    }

    private void normalizeExitInformation(Collection collection) {
        HashSet<Pair> hashSet = new HashSet<Pair>();
        HashSet<Pair> hashSet2 = new HashSet<Pair>();
        HashSet hashSet3 = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            Object object = pair.getFirst();
            if (object instanceof Stmt) continue;
            hashSet2.add(pair);
            SootMethod sootMethod = (SootMethod)pair.getSecond();
            hashSet3.clear();
            BasicBlockGraph basicBlockGraph = this.getBasicBlockGraph(sootMethod);
            hashSet3.addAll(basicBlockGraph.getPseudoTails());
            hashSet3.addAll(basicBlockGraph.getTails());
            Iterator iterator2 = hashSet3.iterator();
            while (iterator2.hasNext()) {
                BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator2.next();
                Stmt stmt = null;
                if (basicBlock != null) {
                    stmt = basicBlock.getTrailerStmt();
                }
                Pair pair2 = this.pairMgr.getOptimizedPair((Object)stmt, (Object)sootMethod);
                this.specials.add(pair2);
                hashSet.add(pair2);
            }
        }
        collection.removeAll(hashSet2);
        collection.addAll(hashSet);
    }

    private void processRule1And3() {
        Object object;
        BasicBlockGraph basicBlockGraph;
        Object object2;
        Object object3;
        HashSet<Pair> hashSet;
        LIFOWorkBag lIFOWorkBag = new LIFOWorkBag();
        HashSet<BasicBlockGraph.BasicBlock> hashSet2 = new HashSet<BasicBlockGraph.BasicBlock>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if ((this.rules & 1) != 0) {
            hashSet = new ArrayList();
            object3 = this.enterMonitors.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (SootMethod)object3.next();
                if (!object2.isConcrete()) continue;
                basicBlockGraph = new HashSet((Collection)this.enterMonitors.get(object2));
                if (object2.isSynchronized()) {
                    basicBlockGraph.remove(SYNC_METHOD_PROXY_STMT);
                    hashSet.clear();
                    hashSet.add(this.pairMgr.getUnOptimizedPair(SYNC_METHOD_PROXY_STMT, object2));
                    this.normalizeEntryInformation(hashSet);
                    object = hashSet.iterator();
                    while (object.hasNext()) {
                        basicBlockGraph.add(((Pair)object.next()).getFirst());
                    }
                }
                hashMap.put(object2, basicBlockGraph);
            }
        }
        if ((this.rules & 4) != 0) {
            hashSet = this.waits.keySet().iterator();
            while (hashSet.hasNext()) {
                object3 = (SootMethod)hashSet.next();
                if (hashMap.get(object3) != null) {
                    ((Collection)hashMap.get(object3)).addAll((Collection)this.waits.get(object3));
                    continue;
                }
                object2 = new HashSet((Collection)this.waits.get(object3));
                hashMap.put(object3, object2);
            }
        }
        if (this.waits.size() == 0 ^ this.notifies.size() == 0 && LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)"There are wait()s and/or notify()s in this program without corresponding notify()s and/or wait()s that occur in different threads.");
        }
        hashSet = new HashSet<Pair>();
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (SootMethod)object3.next();
            basicBlockGraph = this.getBasicBlockGraph((SootMethod)object2);
            object = (Collection)hashMap.get(object2);
            Map map = CollectionsUtilities.getMapFromMap((Map)this.dependent2dependee, (Object)object2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Stmt stmt;
                Stmt stmt2 = (Stmt)iterator.next();
                BasicBlockGraph.BasicBlock basicBlock = basicBlockGraph.getEnclosingBlock(stmt2);
                List list = basicBlock.getStmtsFrom(stmt2);
                list.remove(0);
                hashSet.clear();
                boolean bl = true;
                Pair pair = this.pairMgr.getOptimizedPair((Object)stmt2, object2);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    stmt = (Stmt)iterator2.next();
                    CollectionsUtilities.putIntoSetInMap((Map)map, (Object)stmt, (Object)pair);
                    hashSet.add(this.pairMgr.getOptimizedPair((Object)stmt, object2));
                    if (!object.contains(stmt) && !this.callsReadyMethod(stmt, (SootMethod)object2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    lIFOWorkBag.clear();
                    hashSet2.clear();
                    lIFOWorkBag.addAllWork(basicBlock.getSuccsOf());
                    while (lIFOWorkBag.hasWork()) {
                        basicBlock = (BasicBlockGraph.BasicBlock)lIFOWorkBag.getWork();
                        bl = true;
                        iterator2 = basicBlock.getStmtsOf().iterator();
                        while (iterator2.hasNext()) {
                            stmt = (Stmt)iterator2.next();
                            CollectionsUtilities.putIntoSetInMap((Map)map, (Object)stmt, (Object)pair);
                            hashSet.add(this.pairMgr.getOptimizedPair((Object)stmt, object2));
                            if (!object.contains(stmt) && !this.callsReadyMethod(stmt, (SootMethod)object2)) continue;
                            bl = false;
                            break;
                        }
                        if (!hashSet2.contains(basicBlock) && bl) {
                            lIFOWorkBag.addAllWork(basicBlock.getSuccsOf());
                        }
                        hashSet2.add(basicBlock);
                    }
                }
                iterator2 = CollectionsUtilities.getMapFromMap((Map)this.dependee2dependent, (Object)object2);
                CollectionsUtilities.putAllIntoSetInMap((Map)((Object)iterator2), (Object)stmt2, hashSet);
            }
        }
    }

    private void processRule2() {
        Object object;
        Iterator<Object> iterator;
        Object object2;
        Object object3;
        HashSet<Pair> hashSet = new HashSet<Pair>();
        Object object4 = this.exitMonitors.entrySet().iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            object2 = object3.getKey();
            iterator = ((Collection)object3.getValue()).iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                hashSet.add(this.pairMgr.getOptimizedPair(object, object2));
            }
        }
        object4 = new HashSet();
        object3 = new HashSet();
        object2 = new HashSet();
        iterator = this.enterMonitors.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            SootMethod sootMethod = (SootMethod)object.getKey();
            Iterator iterator2 = ((Collection)object.getValue()).iterator();
            while (iterator2.hasNext()) {
                Object object5;
                Object e = iterator2.next();
                Pair pair = this.pairMgr.getOptimizedPair(e, (Object)sootMethod);
                object4.clear();
                Stmt stmt = hashSet.iterator();
                while (stmt.hasNext()) {
                    Map map;
                    object5 = (Pair)stmt.next();
                    object3.clear();
                    Object object6 = object5.getFirst();
                    if (!this.ifDependentOnByRule2(pair, (Pair)object5)) continue;
                    object3.add(pair);
                    object4.add(object5);
                    this.normalizeEntryInformation((Collection)object3);
                    SootMethod sootMethod2 = (SootMethod)object5.getSecond();
                    if (object6.equals(SYNC_METHOD_PROXY_STMT)) {
                        object2.clear();
                        map = this.getBasicBlockGraph(sootMethod2);
                        object2.addAll(map.getPseudoTails());
                        object2.addAll(map.getTails());
                        Iterator iterator3 = object2.iterator();
                        while (iterator3.hasNext()) {
                            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator3.next();
                            Map map2 = CollectionsUtilities.getMapFromMap((Map)this.dependee2dependent, (Object)sootMethod2);
                            CollectionsUtilities.putAllIntoSetInMap((Map)map2, (Object)basicBlock.getTrailerStmt(), (Collection)object3);
                        }
                        continue;
                    }
                    map = CollectionsUtilities.getMapFromMap((Map)this.dependee2dependent, (Object)sootMethod2);
                    CollectionsUtilities.putAllIntoSetInMap((Map)map, (Object)object6, (Collection)object3);
                }
                if (object4.isEmpty()) continue;
                this.normalizeExitInformation((Collection)object4);
                stmt = e;
                if (e.equals(SYNC_METHOD_PROXY_STMT)) {
                    object5 = this.getBasicBlockGraph(sootMethod).getHead();
                    stmt = null;
                    if (object5 != null) {
                        stmt = object5.getLeaderStmt();
                    }
                }
                if (stmt != null) {
                    object5 = CollectionsUtilities.getMapFromMap((Map)this.dependent2dependee, (Object)sootMethod);
                    CollectionsUtilities.putAllIntoSetInMap((Map)object5, stmt, (Collection)object4);
                    continue;
                }
                LOGGER.error((Object)"How can we record ready dependence for a synchronized method with no head?");
            }
        }
    }

    private void processRule4() {
        HashSet<Pair> hashSet = new HashSet<Pair>();
        Iterator iterator = this.notifies.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SootMethod sootMethod = (SootMethod)entry.getKey();
            Iterator iterator2 = ((Collection)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                InvokeStmt invokeStmt = (InvokeStmt)iterator2.next();
                Pair pair = this.pairMgr.getOptimizedPair((Object)invokeStmt, (Object)sootMethod);
                hashSet.clear();
                Object object = this.waits.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry2 = object.next();
                    SootMethod sootMethod2 = (SootMethod)entry2.getKey();
                    Iterator iterator3 = ((Collection)entry2.getValue()).iterator();
                    while (iterator3.hasNext()) {
                        InvokeStmt invokeStmt2 = (InvokeStmt)iterator3.next();
                        Pair pair2 = this.pairMgr.getOptimizedPair((Object)invokeStmt2, (Object)sootMethod2);
                        if (!this.ifDependentOnByRule4(pair2, pair)) continue;
                        Map map = CollectionsUtilities.getMapFromMap((Map)this.dependent2dependee, (Object)sootMethod2);
                        CollectionsUtilities.putIntoCollectionInMap((Map)map, (Object)invokeStmt2, (Object)pair, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
                        hashSet.add(pair2);
                    }
                }
                if (hashSet.isEmpty()) continue;
                object = CollectionsUtilities.getMapFromMap((Map)this.dependee2dependent, (Object)sootMethod);
                CollectionsUtilities.putAllIntoCollectionInMap((Map)object, (Object)invokeStmt, hashSet, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PreProcessor
    extends AbstractValueAnalyzerBasedProcessor {
        private PreProcessor() {
        }

        public void callback(SootMethod sootMethod) {
            if (sootMethod.isSynchronized()) {
                ReadyDAv1.this.monitorMethods.add(sootMethod);
                CollectionsUtilities.putIntoCollectionInMap((Map)ReadyDAv1.this.enterMonitors, (Object)sootMethod, (Object)SYNC_METHOD_PROXY_STMT, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
                CollectionsUtilities.putIntoCollectionInMap((Map)ReadyDAv1.this.exitMonitors, (Object)sootMethod, (Object)SYNC_METHOD_PROXY_STMT, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
            }
        }

        public void callback(Stmt stmt, Context context) {
            SootMethod sootMethod = context.getCurrentMethod();
            Map map = null;
            if (stmt instanceof EnterMonitorStmt) {
                map = ReadyDAv1.this.enterMonitors;
                ReadyDAv1.this.monitorMethods.add(sootMethod);
            } else if (stmt instanceof ExitMonitorStmt) {
                map = ReadyDAv1.this.exitMonitors;
                ReadyDAv1.this.monitorMethods.add(sootMethod);
            }
            if (map != null) {
                CollectionsUtilities.putIntoCollectionInMap((Map)map, (Object)sootMethod, (Object)stmt, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
            } else {
                InvokeExpr invokeExpr = null;
                if (stmt instanceof InvokeStmt) {
                    invokeExpr = stmt.getInvokeExpr();
                }
                if (invokeExpr != null && invokeExpr instanceof VirtualInvokeExpr) {
                    VirtualInvokeExpr virtualInvokeExpr = (VirtualInvokeExpr)invokeExpr;
                    SootMethod sootMethod2 = virtualInvokeExpr.getMethod();
                    if (ReadyDAv1.this.waitMethods.contains(sootMethod2)) {
                        map = ReadyDAv1.this.waits;
                    } else if (ReadyDAv1.this.notifyMethods.contains(sootMethod2)) {
                        map = ReadyDAv1.this.notifies;
                    }
                    if (map != null) {
                        CollectionsUtilities.putIntoCollectionInMap((Map)map, (Object)sootMethod, (Object)stmt, (Factory)CollectionsUtilities.HASH_SET_FACTORY);
                    }
                }
            }
        }

        public void consolidate() {
            ReadyDAv1.this.readyMethods.addAll(ReadyDAv1.this.monitorMethods);
            ReadyDAv1.this.readyMethods.addAll(ReadyDAv1.this.waits.keySet());
        }

        public void hookup(ProcessingController processingController) {
            processingController.register(class$soot$jimple$EnterMonitorStmt == null ? (class$soot$jimple$EnterMonitorStmt = ReadyDAv1.class$("soot.jimple.EnterMonitorStmt")) : class$soot$jimple$EnterMonitorStmt, (IProcessor)this);
            processingController.register(class$soot$jimple$ExitMonitorStmt == null ? (class$soot$jimple$ExitMonitorStmt = ReadyDAv1.class$("soot.jimple.ExitMonitorStmt")) : class$soot$jimple$ExitMonitorStmt, (IProcessor)this);
            processingController.register(class$soot$jimple$InvokeStmt == null ? (class$soot$jimple$InvokeStmt = ReadyDAv1.class$("soot.jimple.InvokeStmt")) : class$soot$jimple$InvokeStmt, (IProcessor)this);
            processingController.register((IProcessor)this);
        }

        public void unhook(ProcessingController processingController) {
            processingController.unregister(class$soot$jimple$EnterMonitorStmt == null ? (class$soot$jimple$EnterMonitorStmt = ReadyDAv1.class$("soot.jimple.EnterMonitorStmt")) : class$soot$jimple$EnterMonitorStmt, (IProcessor)this);
            processingController.unregister(class$soot$jimple$ExitMonitorStmt == null ? (class$soot$jimple$ExitMonitorStmt = ReadyDAv1.class$("soot.jimple.ExitMonitorStmt")) : class$soot$jimple$ExitMonitorStmt, (IProcessor)this);
            processingController.unregister(class$soot$jimple$InvokeStmt == null ? (class$soot$jimple$InvokeStmt = ReadyDAv1.class$("soot.jimple.InvokeStmt")) : class$soot$jimple$InvokeStmt, (IProcessor)this);
            processingController.unregister((IProcessor)this);
        }
    }
}

