/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.allocation.AllocationContext;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.NullConstant;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

public class InterferenceDAv1
extends AbstractDependencyAnalysis {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$InterferenceDAv1 == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$InterferenceDAv1 = InterferenceDAv1.class$("edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1")) : class$edu$ksu$cis$indus$staticanalyses$dependency$InterferenceDAv1));
    protected IThreadGraphInfo tgi;
    protected Pair.PairManager pairMgr;
    private IValueAnalyzer ofa;
    private boolean useOFA;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$InterferenceDAv1;
    static /* synthetic */ Class class$soot$jimple$AssignStmt;

    public InterferenceDAv1() {
        this.preprocessor = new PreProcessor();
    }

    public Collection getDependees(Object object, Object object2) {
        Collection collection;
        Collection<Object> collection2 = Collections.EMPTY_LIST;
        Stmt stmt = (Stmt)object;
        Map map = null;
        Type type = null;
        if (stmt.containsArrayRef()) {
            type = stmt.getArrayRef().getBase().getType();
        } else if (stmt.containsFieldRef()) {
            type = stmt.getFieldRef().getField();
        }
        if (type != null && (map = (Map)MapUtils.getObject((Map)this.dependent2dependee, (Object)type, (Object)Collections.EMPTY_MAP)) != null && (collection = (Collection)map.get(this.pairMgr.getUnOptimizedPair(object, object2))) != null) {
            collection2 = Collections.unmodifiableCollection(collection);
        }
        return collection2;
    }

    public Collection getDependents(Object object, Object object2) {
        Collection collection;
        Collection<Object> collection2 = Collections.EMPTY_LIST;
        Stmt stmt = (Stmt)object;
        Map map = null;
        Type type = null;
        if (stmt.containsArrayRef()) {
            type = stmt.getArrayRef().getBase().getType();
        } else if (stmt.containsFieldRef()) {
            type = stmt.getFieldRef().getField();
        }
        if (type != null && (map = (Map)MapUtils.getObject((Map)this.dependee2dependent, (Object)type, (Object)Collections.EMPTY_MAP)) != null && (collection = (Collection)map.get(this.pairMgr.getUnOptimizedPair(object, object2))) != null) {
            collection2 = Collections.unmodifiableCollection(collection);
        }
        return collection2;
    }

    public Object getId() {
        return IDependencyAnalysis.INTERFERENCE_DA;
    }

    public final void setUseOFA(boolean bl) {
        this.useOFA = bl;
    }

    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("BEGIN: Interference Dependence [" + this.getClass() + "] processing"));
        }
        if (this.tgi.getStartSites().size() == 0) {
            this.stable();
            return;
        }
        Iterator iterator = this.dependent2dependee.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (this.dependee2dependent.get(k) == null) continue;
            Map map = (Map)this.dependent2dependee.get(k);
            Map map2 = (Map)this.dependee2dependent.get(k);
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                Iterator iterator3 = map2.keySet().iterator();
                while (iterator3.hasNext()) {
                    Pair pair2 = (Pair)iterator3.next();
                    if (!this.considerEffectOfClassInitializers(pair, pair2) || !this.isDependentOn(pair, pair2)) continue;
                    Collection<Pair> collection = (HashSet<Pair>)map.get(pair);
                    if (((Object)collection).equals(Collections.EMPTY_LIST)) {
                        collection = new HashSet<Pair>();
                        map.put(pair, collection);
                    }
                    collection.add(pair2);
                    collection = (Collection)map2.get(pair2);
                    if (((Object)collection).equals(Collections.EMPTY_LIST)) {
                        collection = new HashSet();
                        map2.put(pair2, collection);
                    }
                    collection.add(pair);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("analyze() - " + this.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Interference Dependence processing");
        }
        this.stable();
    }

    public void reset() {
        super.reset();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Statistics for Interference dependence as calculated by " + this.getClass().getName() + "\n");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.dependent2dependee.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            n = 0;
            Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                Iterator iterator3 = ((Collection)entry2.getValue()).iterator();
                while (iterator3.hasNext()) {
                    stringBuffer2.append("\t\t" + entry2.getKey() + " --> " + iterator3.next() + "\n");
                }
                n += ((Collection)entry2.getValue()).size();
            }
            stringBuffer.append("\tFor " + entry.getKey() + " there are " + n + " Interference dependence edges.\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer2.delete(0, stringBuffer2.length());
            n2 += n;
        }
        stringBuffer.append("A total of " + n2 + " Interference dependence edges exist.");
        return stringBuffer.toString();
    }

    protected boolean isArrayDependentOn(Pair pair, Pair pair2, ArrayRef arrayRef, ArrayRef arrayRef2) {
        Type type;
        Type type2 = arrayRef2.getBase().getType();
        boolean bl = type2.equals(type = arrayRef.getBase().getType());
        if (bl && this.useOFA) {
            bl = this.isArrayDependentOnByOFA(pair, pair2);
        }
        return bl;
    }

    protected boolean isFieldDependentOn(Pair pair, Pair pair2, InstanceFieldRef instanceFieldRef, InstanceFieldRef instanceFieldRef2) {
        SootField sootField;
        SootField sootField2 = instanceFieldRef2.getField();
        boolean bl = sootField2.equals(sootField = instanceFieldRef.getField());
        if (bl && this.useOFA) {
            bl = this.isFieldDependentOnByOFA(pair, pair2);
        }
        return bl;
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.ofa = (OFAnalyzer)this.info.get(IValueAnalyzer.ID);
        if (this.ofa == null) {
            throw new InitializationException(IValueAnalyzer.ID + " was not provided in the info.");
        }
        this.pairMgr = (Pair.PairManager)this.info.get("Pair management service");
        if (this.pairMgr == null) {
            throw new InitializationException("Pair management service was not provided in info.");
        }
        this.tgi = (IThreadGraphInfo)this.info.get("Threadgraph Information");
        if (this.tgi == null) {
            throw new InitializationException("Threadgraph Information was not provided in info.");
        }
    }

    private boolean isArrayDependentOnByOFA(Pair pair, Pair pair2) {
        ArrayRef arrayRef = (ArrayRef)((AssignStmt)pair2.getFirst()).getLeftOp();
        ArrayRef arrayRef2 = (ArrayRef)((AssignStmt)pair.getFirst()).getRightOp();
        AllocationContext allocationContext = new AllocationContext();
        allocationContext.setProgramPoint(arrayRef.getBaseBox());
        allocationContext.setStmt((Stmt)pair2.getFirst());
        allocationContext.setRootMethod((SootMethod)pair2.getSecond());
        Collection collection = this.ofa.getValues(arrayRef.getBase(), allocationContext);
        allocationContext.setProgramPoint(arrayRef2.getBaseBox());
        allocationContext.setStmt((Stmt)pair.getFirst());
        allocationContext.setRootMethod((SootMethod)pair.getSecond());
        Collection collection2 = this.ofa.getValues(arrayRef2.getBase(), allocationContext);
        Collection collection3 = CollectionUtils.intersection((Collection)collection, (Collection)collection2);
        while (collection3.remove(NullConstant.v())) {
        }
        boolean bl = !collection3.isEmpty();
        return bl;
    }

    private boolean isDependentOn(Pair pair, Pair pair2) {
        boolean bl = true;
        Value value = ((AssignStmt)pair2.getFirst()).getLeftOp();
        Value value2 = ((AssignStmt)pair.getFirst()).getRightOp();
        if (value instanceof ArrayRef && value2 instanceof ArrayRef) {
            bl = this.isArrayDependentOn(pair, pair2, (ArrayRef)value2, (ArrayRef)value);
        } else if (value2 instanceof InstanceFieldRef && value instanceof InstanceFieldRef) {
            bl = this.isFieldDependentOn(pair, pair2, (InstanceFieldRef)value2, (InstanceFieldRef)value);
        }
        return bl;
    }

    private boolean isFieldDependentOnByOFA(Pair pair, Pair pair2) {
        InstanceFieldRef instanceFieldRef = (InstanceFieldRef)((AssignStmt)pair2.getFirst()).getLeftOp();
        InstanceFieldRef instanceFieldRef2 = (InstanceFieldRef)((AssignStmt)pair.getFirst()).getRightOp();
        AllocationContext allocationContext = new AllocationContext();
        allocationContext.setProgramPoint(instanceFieldRef.getBaseBox());
        allocationContext.setStmt((Stmt)pair2.getFirst());
        allocationContext.setRootMethod((SootMethod)pair2.getSecond());
        Collection collection = this.ofa.getValues(instanceFieldRef.getBase(), allocationContext);
        allocationContext.setProgramPoint(instanceFieldRef2.getBaseBox());
        allocationContext.setStmt((Stmt)pair.getFirst());
        allocationContext.setRootMethod((SootMethod)pair.getSecond());
        Collection collection2 = this.ofa.getValues(instanceFieldRef2.getBase(), allocationContext);
        Collection collection3 = CollectionUtils.intersection((Collection)collection, (Collection)collection2);
        while (collection3.remove(NullConstant.v())) {
        }
        boolean bl = !collection3.isEmpty();
        return bl;
    }

    private boolean considerEffectOfClassInitializers(Pair pair, Pair pair2) {
        SootMethod sootMethod = (SootMethod)pair2.getSecond();
        SootMethod sootMethod2 = (SootMethod)pair.getSecond();
        boolean bl = true;
        boolean bl2 = sootMethod.getName().equals("<clinit>");
        boolean bl3 = sootMethod2.getName().equals("<clinit>");
        if (bl2 || bl3) {
            SootClass sootClass;
            SootClass sootClass2 = sootMethod.getDeclaringClass();
            boolean bl4 = bl = !Util.isHierarchicallyRelated((SootClass)sootClass2, (SootClass)(sootClass = sootMethod2.getDeclaringClass()));
            if (bl) {
                Value value = ((AssignStmt)pair2.getFirst()).getLeftOp();
                Value value2 = ((AssignStmt)pair.getFirst()).getRightOp();
                if (value2 instanceof StaticFieldRef && value instanceof StaticFieldRef) {
                    SootField sootField;
                    SootField sootField2 = ((StaticFieldRef)value).getField();
                    bl = !sootField2.equals(sootField = ((StaticFieldRef)value2).getField()) || (!bl2 || !sootField2.getDeclaringClass().equals(sootClass2)) && (!bl3 || !sootField2.getDeclaringClass().equals(sootClass));
                }
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PreProcessor
    extends AbstractValueAnalyzerBasedProcessor {
        private PreProcessor() {
        }

        public void callback(Stmt stmt, Context context) {
            SootField sootField;
            SootMethod sootMethod = context.getCurrentMethod();
            AssignStmt assignStmt = (AssignStmt)stmt;
            Map map = null;
            if (assignStmt.containsFieldRef()) {
                if (assignStmt.getLeftOp() instanceof FieldRef) {
                    sootField = ((FieldRef)assignStmt.getLeftOp()).getField();
                    map = this.getDependeXXMapHelper(InterferenceDAv1.this.dependee2dependent, sootField);
                } else {
                    sootField = ((FieldRef)assignStmt.getRightOp()).getField();
                    map = this.getDependeXXMapHelper(InterferenceDAv1.this.dependent2dependee, sootField);
                }
            } else if (assignStmt.containsArrayRef()) {
                if (assignStmt.getLeftOp() instanceof ArrayRef) {
                    sootField = (ArrayType)((ArrayRef)assignStmt.getLeftOp()).getBase().getType();
                    map = this.getDependeXXMapHelper(InterferenceDAv1.this.dependee2dependent, sootField);
                } else {
                    sootField = (ArrayType)((ArrayRef)assignStmt.getRightOp()).getBase().getType();
                    map = this.getDependeXXMapHelper(InterferenceDAv1.this.dependent2dependee, sootField);
                }
            }
            if (map != null && map.get(sootField = InterferenceDAv1.this.pairMgr.getOptimizedPair((Object)assignStmt, (Object)sootMethod)) == null) {
                map.put(sootField, Collections.EMPTY_LIST);
            }
        }

        public void hookup(ProcessingController processingController) {
            if (InterferenceDAv1.this.tgi == null) {
                throw new IllegalStateException("Please setup the enclosing analysis before starting preprocessing.");
            }
            if (InterferenceDAv1.this.tgi.getStartSites().size() != 0) {
                processingController.register(class$soot$jimple$AssignStmt == null ? (class$soot$jimple$AssignStmt = InterferenceDAv1.class$("soot.jimple.AssignStmt")) : class$soot$jimple$AssignStmt, (IProcessor)this);
            }
        }

        public void unhook(ProcessingController processingController) {
            if (InterferenceDAv1.this.tgi == null) {
                throw new IllegalStateException("Please setup the enclosing analysis before starting preprocessing.");
            }
            if (InterferenceDAv1.this.tgi.getStartSites().size() != 0) {
                processingController.unregister(class$soot$jimple$AssignStmt == null ? (class$soot$jimple$AssignStmt = InterferenceDAv1.class$("soot.jimple.AssignStmt")) : class$soot$jimple$AssignStmt, (IProcessor)this);
            }
        }

        private Map getDependeXXMapHelper(Map map, Object object) {
            HashMap hashMap = (HashMap)map.get(object);
            if (hashMap == null) {
                hashMap = new HashMap();
                map.put(object, hashMap);
            }
            return hashMap;
        }
    }
}

