/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.cfg.LocalUseDefAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

public class IdentifierBasedDataDAv2
extends AbstractDependencyAnalysis {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDAv2 == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDAv2 = IdentifierBasedDataDAv2.class$("edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv2")) : class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDAv2));
    private ICallGraphInfo callgraph;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDAv2;

    public Collection getDependees(Object object, Object object2) {
        Collection collection = Collections.EMPTY_LIST;
        LocalUseDefAnalysis localUseDefAnalysis = (LocalUseDefAnalysis)this.dependee2dependent.get(object2);
        if (localUseDefAnalysis != null) {
            if (object instanceof Stmt) {
                collection = this.collectDefInfoForAllLocalsIn((Stmt)object, localUseDefAnalysis);
            } else if (object instanceof Pair) {
                Pair pair = (Pair)object;
                Stmt stmt = (Stmt)pair.getFirst();
                Local local = (Local)pair.getSecond();
                collection = localUseDefAnalysis.getDefsOf(local, stmt);
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)("We do not handle program points of type " + object.getClass().getName() + " - " + object + " in " + object2));
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)("No dependence information available for " + object + " in " + object2));
        }
        return collection;
    }

    public Collection getDependents(Object object, Object object2) {
        LocalUseDefAnalysis localUseDefAnalysis = (LocalUseDefAnalysis)this.dependee2dependent.get(object2);
        Collection collection = Collections.EMPTY_LIST;
        if (localUseDefAnalysis != null) {
            collection = localUseDefAnalysis.getUsesOf((Stmt)object);
        }
        return collection;
    }

    public Object getId() {
        return IDependencyAnalysis.IDENTIFIER_BASED_DATA_DA;
    }

    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Identifier Based Data Dependence processing");
        }
        Iterator iterator = this.callgraph.getReachableMethods().iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            UnitGraph unitGraph = this.getUnitGraph(sootMethod);
            if (unitGraph != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Processing " + sootMethod.getSignature()));
                }
                LocalUseDefAnalysis localUseDefAnalysis = new LocalUseDefAnalysis(unitGraph);
                this.dependee2dependent.put(sootMethod, localUseDefAnalysis);
                this.dependent2dependee.put(sootMethod, localUseDefAnalysis);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn((Object)("Method " + sootMethod.getSignature() + " does not have a unit graph."));
        }
        this.stable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("analyze() - " + this.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END:  Identifier Based Data Dependence processing");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Statistics for Identifier-based Data dependence as calculated by " + this.getClass().getName() + "\n");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.dependee2dependent.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            n = 0;
            LocalUseDefAnalysis localUseDefAnalysis = (LocalUseDefAnalysis)entry.getValue();
            SootMethod sootMethod = (SootMethod)entry.getKey();
            if (sootMethod.hasActiveBody()) {
                Iterator iterator2 = sootMethod.getActiveBody().getUnits().iterator();
                while (iterator2.hasNext()) {
                    Stmt stmt = (Stmt)iterator2.next();
                    Collection collection = localUseDefAnalysis.getUsesOf(stmt);
                    Iterator iterator3 = collection.iterator();
                    while (iterator3.hasNext()) {
                        stringBuffer2.append("\t\t" + stmt + " <-- " + iterator3.next() + "\n");
                    }
                    n += collection.size();
                }
            }
            stringBuffer.append("\tFor " + sootMethod + " there are " + n + " Identifier-based Data dependence edges.\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer2.delete(0, stringBuffer2.length());
            n2 += n;
        }
        stringBuffer.append("A total of " + n2 + " Identifier-based Data dependence edges exist.");
        return stringBuffer.toString();
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get("Callgraph Information");
        if (this.callgraph == null) {
            throw new InitializationException("Callgraph Information was not provided.");
        }
    }

    private Collection collectDefInfoForAllLocalsIn(Stmt stmt, LocalUseDefAnalysis localUseDefAnalysis) {
        HashSet hashSet = new HashSet();
        Iterator iterator = stmt.getUseBoxes().iterator();
        while (iterator.hasNext()) {
            Collection collection;
            Value value = ((ValueBox)iterator.next()).getValue();
            if (!(value instanceof Local) || (collection = localUseDefAnalysis.getDefsOf((Local)value, stmt)).isEmpty()) continue;
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

