/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class IdentifierBasedDataDA
extends AbstractDependencyAnalysis {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDA == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDA = IdentifierBasedDataDA.class$("edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDA")) : class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDA));
    private ICallGraphInfo callgraph;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$IdentifierBasedDataDA;

    public Collection getDependees(Object object, Object object2) {
        Collection<Object> collection = Collections.EMPTY_LIST;
        if (object instanceof Stmt) {
            collection = new HashSet();
            Stmt stmt = (Stmt)object;
            SootMethod sootMethod = (SootMethod)object2;
            List list = (List)this.dependent2dependee.get(object2);
            if (list != null) {
                Map map = (Map)list.get(this.getStmtList(sootMethod).indexOf(stmt));
                Iterator iterator = stmt.getUseBoxes().iterator();
                while (iterator.hasNext()) {
                    Value value = ((ValueBox)iterator.next()).getValue();
                    Collection collection2 = (Collection)map.get(value);
                    if (collection2 == null) continue;
                    collection.addAll(collection2);
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)("No dependence information available for " + stmt + " in " + object2));
            }
        } else if (object instanceof Pair) {
            Pair pair = (Pair)object;
            Stmt stmt = (Stmt)pair.getFirst();
            Local local = (Local)pair.getSecond();
            SootMethod sootMethod = (SootMethod)object2;
            List list = (List)this.dependent2dependee.get(object2);
            Map map = (Map)list.get(this.getStmtList(sootMethod).indexOf(stmt));
            Collection collection3 = (Collection)map.get(local);
            if (collection3 != null) {
                collection = Collections.unmodifiableCollection(collection3);
            }
        }
        return collection;
    }

    public Collection getDependents(Object object, Object object2) {
        Collection collection;
        SootMethod sootMethod = (SootMethod)object2;
        List list = (List)this.dependee2dependent.get(sootMethod);
        Collection<Object> collection2 = Collections.EMPTY_LIST;
        if (list != null && (collection = (Collection)list.get(this.getStmtList(sootMethod).indexOf(object))) != null) {
            collection2 = Collections.unmodifiableCollection(collection);
        }
        return collection2;
    }

    public Object getId() {
        return IDependencyAnalysis.IDENTIFIER_BASED_DATA_DA;
    }

    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Identifier Based Data Dependence processing");
        }
        Iterator iterator = this.callgraph.getReachableMethods().iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            UnitGraph unitGraph = this.getUnitGraph(sootMethod);
            if (unitGraph == null) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn((Object)("Method " + sootMethod.getSignature() + " does not have a unit graph."));
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Processing " + sootMethod.getSignature()));
            }
            this.calculateDAForMethod(sootMethod, unitGraph);
        }
        this.stable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("analyze() - " + this.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END:  Identifier Based Data Dependence processing");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Statistics for Identifier-based Data dependence as calculated by " + this.getClass().getName() + "\n");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.dependee2dependent.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            n = 0;
            List list = this.getStmtList((SootMethod)entry.getKey());
            int n3 = 0;
            Iterator iterator2 = ((Collection)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                Collection collection = (Collection)iterator2.next();
                Stmt stmt = (Stmt)list.get(n3++);
                Iterator iterator3 = collection.iterator();
                while (iterator3.hasNext()) {
                    stringBuffer2.append("\t\t" + stmt + " <-- " + iterator3.next() + "\n");
                }
                n += collection.size();
            }
            stringBuffer.append("\tFor " + entry.getKey() + " there are " + n + " Identifier-based Data dependence edges.\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer2.delete(0, stringBuffer2.length());
            n2 += n;
        }
        stringBuffer.append("A total of " + n2 + " Identifier-based Data dependence edges exist.");
        return stringBuffer.toString();
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get("Callgraph Information");
        if (this.callgraph == null) {
            throw new InitializationException("Callgraph Information was not provided.");
        }
    }

    private void calculateDAForMethod(SootMethod sootMethod, UnitGraph unitGraph) {
        SimpleLocalDefs simpleLocalDefs = new SimpleLocalDefs(unitGraph);
        SimpleLocalUses simpleLocalUses = new SimpleLocalUses(unitGraph, (LocalDefs)simpleLocalDefs);
        List list = this.getStmtList(sootMethod);
        ArrayList arrayList = new ArrayList(list.size());
        ArrayList arrayList2 = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            UnitValueBoxPair unitValueBoxPair;
            Iterator iterator2;
            HashMap<Value, List> hashMap;
            Stmt stmt = (Stmt)iterator.next();
            ArrayList<Unit> arrayList3 = Collections.EMPTY_LIST;
            if (stmt instanceof DefinitionStmt && (hashMap = simpleLocalUses.getUsesOf((Unit)stmt)).size() != 0) {
                arrayList3 = new ArrayList<Unit>();
                iterator2 = hashMap.iterator();
                while (iterator2.hasNext()) {
                    unitValueBoxPair = (UnitValueBoxPair)iterator2.next();
                    arrayList3.add(unitValueBoxPair.getUnit());
                }
            }
            arrayList2.add(arrayList3);
            hashMap = Collections.EMPTY_MAP;
            if (stmt.getUseBoxes().size() > 0) {
                hashMap = new HashMap<Value, List>();
                iterator2 = stmt.getUseBoxes().iterator();
                while (iterator2.hasNext()) {
                    unitValueBoxPair = (ValueBox)iterator2.next();
                    Value value = unitValueBoxPair.getValue();
                    if (!(value instanceof Local) || hashMap.containsKey(value)) continue;
                    hashMap.put(value, simpleLocalDefs.getDefsOfAt((Local)value, (Unit)stmt));
                }
            }
            arrayList.add(hashMap);
        }
        this.dependee2dependent.put(sootMethod, arrayList2);
        this.dependent2dependee.put(sootMethod, arrayList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

