/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

public class ExitControlDA
extends AbstractControlDA {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$ExitControlDA == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$ExitControlDA = ExitControlDA.class$("edu.ksu.cis.indus.staticanalyses.dependency.ExitControlDA")) : class$edu$ksu$cis$indus$staticanalyses$dependency$ExitControlDA));
    private IDependencyAnalysis entryControlDA;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$ExitControlDA;

    public Object getDirection() {
        return IDependencyAnalysis.FORWARD_DIRECTION;
    }

    public final void analyze() {
        this.analyze(this.callgraph.getReachableMethods());
    }

    public final void analyze(Collection collection) {
        this.unstable();
        if (this.entryControlDA.isStable()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: Exit Control Dependence processing");
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SootMethod sootMethod = (SootMethod)iterator.next();
                BasicBlockGraph basicBlockGraph = this.getBasicBlockGraph(sootMethod);
                Collection collection2 = this.calculateDependeesOfSinksIn(basicBlockGraph, sootMethod);
                if (collection2.isEmpty()) continue;
                this.calculateDependenceForStmts(this.calculateDependenceForBBs(basicBlockGraph, collection2), sootMethod);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.toString());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: Exit Control Dependence processing");
            }
            this.stable();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Exit Control Dependence processing due to unstable entry control dependence info.");
        }
    }

    protected void setup() throws InitializationException {
        super.setup();
        Collection collection = (Collection)this.info.get(IDependencyAnalysis.CONTROL_DA);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IDependencyAnalysis iDependencyAnalysis = (IDependencyAnalysis)iterator.next();
            if (!iDependencyAnalysis.getId().equals(IDependencyAnalysis.CONTROL_DA) || !iDependencyAnalysis.getDirection().equals(IDependencyAnalysis.BACKWARD_DIRECTION)) continue;
            this.entryControlDA = iDependencyAnalysis;
        }
        if (this.entryControlDA == null) {
            throw new InitializationException(IDependencyAnalysis.CONTROL_DA + " was not provided or none of the provided control dependences were backward in direction.");
        }
    }

    private Collection calculateDependeesOfSinksIn(BasicBlockGraph basicBlockGraph, SootMethod sootMethod) {
        HashSet<BasicBlockGraph.BasicBlock> hashSet;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(basicBlockGraph.getTails());
        arrayList.addAll(basicBlockGraph.getPseudoTails());
        if (arrayList.size() == 1) {
            hashSet = new HashSet<BasicBlockGraph.BasicBlock>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
                Stmt stmt = basicBlock.getLeaderStmt();
                Collection collection = this.entryControlDA.getDependees(stmt, sootMethod);
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Stmt stmt2 = (Stmt)iterator2.next();
                    BasicBlockGraph.BasicBlock basicBlock2 = basicBlockGraph.getEnclosingBlock(stmt2);
                    hashSet.add(basicBlock2);
                }
            }
        } else {
            hashSet = Collections.EMPTY_SET;
        }
        return hashSet;
    }

    private Map calculateDependenceForBBs(BasicBlockGraph basicBlockGraph, Collection collection) {
        HashMap<BasicBlockGraph.BasicBlock, Collection> hashMap = new HashMap<BasicBlockGraph.BasicBlock, Collection>();
        Iterator iterator = collection.iterator();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
            Collection collection2 = basicBlockGraph.getReachablesFrom((INode)basicBlock, false);
            hashMap.put(basicBlock, collection2);
        }
        return hashMap;
    }

    private void calculateDependenceForStmts(Map map, SootMethod sootMethod) {
        List list = CollectionsUtilities.getListFromMap((Map)this.dependee2dependent, (Object)sootMethod);
        List list2 = CollectionsUtilities.getListFromMap((Map)this.dependent2dependee, (Object)sootMethod);
        List list3 = this.getStmtList(sootMethod);
        int n = list3.size();
        CollectionsUtilities.ensureSize((List)list, (int)n, null);
        CollectionsUtilities.ensureSize((List)list2, (int)n, null);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)entry.getKey();
            Stmt stmt = basicBlock.getTrailerStmt();
            Collection collection = (Collection)CollectionsUtilities.getSetAtIndexFromList((List)list, (int)list3.indexOf(stmt));
            Collection collection2 = (Collection)entry.getValue();
            Iterator iterator2 = collection2.iterator();
            int n2 = collection2.size();
            for (int i = 0; i < n2; ++i) {
                BasicBlockGraph.BasicBlock basicBlock2 = (BasicBlockGraph.BasicBlock)iterator2.next();
                List list4 = basicBlock2.getStmtsOf();
                Iterator iterator3 = list4.iterator();
                int n3 = list4.size();
                for (int j = 0; j < n3; ++j) {
                    Stmt stmt2 = (Stmt)iterator3.next();
                    Collection collection3 = (Collection)CollectionsUtilities.getSetAtIndexFromList((List)list2, (int)list3.indexOf(stmt2));
                    collection3.add(stmt);
                }
                collection.addAll(list4);
            }
        }
        this.dependent2dependee.put(sootMethod, list2);
        this.dependee2dependent.put(sootMethod, list);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

