/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

public class EntryControlDA
extends AbstractControlDA {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$EntryControlDA == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$EntryControlDA = EntryControlDA.class$("edu.ksu.cis.indus.staticanalyses.dependency.EntryControlDA")) : class$edu$ksu$cis$indus$staticanalyses$dependency$EntryControlDA));
    protected Collection nodesWithChildrenCache;
    protected List nodesCache;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$EntryControlDA;

    public Object getDirection() {
        return IDependencyAnalysis.BACKWARD_DIRECTION;
    }

    public final void analyze() {
        this.analyze(this.callgraph.getReachableMethods());
    }

    public final void analyze(Collection collection) {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Entry Control Dependence processing");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            BasicBlockGraph basicBlockGraph = this.getBasicBlockGraph(sootMethod);
            if (basicBlockGraph == null) {
                LOGGER.error((Object)("Method " + sootMethod.getSignature() + " did not have a basic block graph."));
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Processing method: " + sootMethod.getSignature()));
            }
            BitSet[] bitSetArray = this.computeControlDependency((IDirectedGraph)basicBlockGraph);
            this.fixupMaps(basicBlockGraph, bitSetArray, sootMethod);
        }
        this.nodesCache = null;
        this.nodesWithChildrenCache = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("analyze() - " + this.toString()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Entry Control Dependence processing");
        }
        this.stable();
    }

    protected final BitSet getBitSetAtLocation(BitSet[] bitSetArray, int n) {
        BitSet bitSet = bitSetArray[n];
        if (bitSet == null) {
            bitSetArray[n] = bitSet = new BitSet();
        }
        return bitSet;
    }

    protected Collection processNode(INode iNode, BitSet[][] bitSetArray) {
        HashSet hashSet = new HashSet();
        int n = this.nodesCache.indexOf(iNode);
        Iterator iterator = this.nodesWithChildrenCache.iterator();
        int n2 = this.nodesWithChildrenCache.size();
        for (int i = 0; i < n2; ++i) {
            INode iNode2 = (INode)iterator.next();
            int n3 = this.nodesCache.indexOf(iNode2);
            BitSet bitSet = bitSetArray[n][n3];
            if (bitSet == null || n == n3) continue;
            hashSet.addAll(this.propagateTokensIntoNodes(bitSet, iNode.getSuccsOf(), n3, bitSetArray));
        }
        return hashSet;
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get("Callgraph Information");
        if (this.callgraph == null) {
            throw new InitializationException("Callgraph Information was not provided.");
        }
    }

    private Collection getNodesWithChildren() {
        HashSet<INode> hashSet = new HashSet<INode>();
        Iterator iterator = this.nodesCache.iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            if (iNode.getSuccsOf().size() <= 1) continue;
            hashSet.add(iNode);
        }
        return hashSet;
    }

    private BitSet[] calculateCDFromTokenInfo(BitSet[][] bitSetArray) {
        BitSet[] bitSetArray2 = new BitSet[this.nodesCache.size()];
        Iterator iterator = this.nodesWithChildrenCache.iterator();
        for (int i = this.nodesWithChildrenCache.size(); i > 0; --i) {
            INode iNode = (INode)iterator.next();
            int n = this.nodesCache.indexOf(iNode);
            int n2 = iNode.getSuccsOf().size();
            for (int j = this.nodesCache.size() - 1; j >= 0; --j) {
                int n3;
                BitSet bitSet = bitSetArray[j][n];
                if (bitSet == null || (n3 = bitSet.cardinality()) <= 0 || n3 == n2) continue;
                BitSet bitSet2 = this.getBitSetAtLocation(bitSetArray2, j);
                bitSet2.set(n);
            }
        }
        return bitSetArray2;
    }

    private BitSet[] computeControlDependency(IDirectedGraph iDirectedGraph) {
        this.nodesCache = iDirectedGraph.getNodes();
        this.nodesWithChildrenCache = this.getNodesWithChildren();
        BitSet[][] bitSetArray = new BitSet[this.nodesCache.size()][this.nodesCache.size()];
        IWorkBag iWorkBag = this.injectTokensAndGenerateWorkForTokenPropagation(bitSetArray);
        while (iWorkBag.hasWork()) {
            INode iNode = (INode)iWorkBag.getWork();
            iWorkBag.addAllWorkNoDuplicates(this.processNode(iNode, bitSetArray));
        }
        return this.calculateCDFromTokenInfo(bitSetArray);
    }

    private void fixupMaps(BasicBlockGraph basicBlockGraph, BitSet[] bitSetArray, SootMethod sootMethod) {
        int n;
        List list = basicBlockGraph.getNodes();
        List list2 = this.getStmtList(sootMethod);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (n = list2.size(); n > 0; --n) {
            arrayList.add(null);
            arrayList2.add(null);
        }
        n = 0;
        for (int i = bitSetArray.length - 1; i >= 0; --i) {
            BitSet bitSet = bitSetArray[i];
            n |= bitSet != null ? 1 : 0;
            if (bitSet == null) continue;
            ArrayList<Stmt> arrayList3 = new ArrayList<Stmt>();
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)list.get(i);
            Iterator iterator = basicBlock.getStmtsOf().iterator();
            while (iterator.hasNext()) {
                arrayList.set(list2.indexOf(iterator.next()), arrayList3);
            }
            int n2 = bitSet.nextSetBit(0);
            while (n2 != -1) {
                BasicBlockGraph.BasicBlock basicBlock2 = (BasicBlockGraph.BasicBlock)list.get(n2);
                Stmt stmt = basicBlock2.getTrailerStmt();
                arrayList3.add(stmt);
                int n3 = list2.indexOf(stmt);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(n3);
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList();
                    arrayList2.set(n3, arrayList4);
                }
                arrayList4.addAll(basicBlock.getStmtsOf());
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        if (n != 0) {
            this.dependee2dependent.put(sootMethod, new ArrayList(arrayList2));
            this.dependent2dependee.put(sootMethod, new ArrayList(arrayList));
        } else {
            this.dependee2dependent.put(sootMethod, null);
            this.dependent2dependee.put(sootMethod, null);
        }
    }

    private IWorkBag injectTokensAndGenerateWorkForTokenPropagation(BitSet[][] bitSetArray) {
        LIFOWorkBag lIFOWorkBag = new LIFOWorkBag();
        Iterator iterator = this.nodesWithChildrenCache.iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            int n = this.nodesCache.indexOf(iNode);
            Collection collection = iNode.getSuccsOf();
            Iterator iterator2 = collection.iterator();
            int n2 = 0;
            for (int i = collection.size(); i > 0; --i) {
                INode iNode2 = (INode)iterator2.next();
                int n3 = this.nodesCache.indexOf(iNode2);
                BitSet[] bitSetArray2 = bitSetArray[n3];
                BitSet bitSet = this.getBitSetAtLocation(bitSetArray2, n);
                bitSet.set(n2++);
                lIFOWorkBag.addWorkNoDuplicates((Object)iNode2);
            }
        }
        return lIFOWorkBag;
    }

    private Collection propagateTokensIntoNodes(BitSet bitSet, Collection collection, int n, BitSet[][] bitSetArray) {
        HashSet<INode> hashSet = new HashSet<INode>();
        Iterator iterator = collection.iterator();
        BitSet bitSet2 = new BitSet();
        for (int i = collection.size(); i > 0; --i) {
            INode iNode = (INode)iterator.next();
            int n2 = this.nodesCache.indexOf(iNode);
            BitSet[] bitSetArray2 = bitSetArray[n2];
            BitSet bitSet3 = bitSetArray2[n];
            boolean bl = false;
            if (bitSet3 == null) {
                bitSetArray2[n] = bitSet3 = new BitSet();
                bl = true;
            } else {
                bitSet2.clear();
                bitSet2.or(bitSet);
                bitSet2.andNot(bitSet3);
                boolean bl2 = bl = bitSet2.cardinality() > 0;
            }
            if (!bl) continue;
            bitSet3.or(bitSet);
            hashSet.add(iNode);
        }
        return hashSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

