/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

public final class DivergenceDA
extends AbstractDependencyAnalysis {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$DivergenceDA == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$DivergenceDA = DivergenceDA.class$("edu.ksu.cis.indus.staticanalyses.dependency.DivergenceDA")) : class$edu$ksu$cis$indus$staticanalyses$dependency$DivergenceDA));
    private ICallGraphInfo callgraph;
    private final Map method2interProcDivPoints = new HashMap();
    private boolean considerCallSites;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$DivergenceDA;

    public void setConsiderCallSites(boolean bl) {
        this.considerCallSites = bl;
    }

    public Collection getDependees(Object object, Object object2) {
        Collection collection = Collections.EMPTY_LIST;
        List list = (List)this.dependent2dependee.get(object2);
        if (list != null) {
            collection = (Collection)CollectionsUtilities.getAtIndexFromList((List)list, (int)this.getStmtList((SootMethod)object2).indexOf(object), (Factory)CollectionsUtilities.EMPTY_LIST_FACTORY);
        }
        return collection;
    }

    public Collection getDependents(Object object, Object object2) {
        Map map = (Map)MapUtils.getObject((Map)this.dependee2dependent, (Object)object2, (Object)Collections.EMPTY_MAP);
        Collection collection = (Collection)MapUtils.getObject((Map)map, (Object)object, (Object)Collections.EMPTY_LIST);
        return Collections.unmodifiableCollection(collection);
    }

    public Object getId() {
        return IDependencyAnalysis.DIVERGENCE_DA;
    }

    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Divergence Dependence processing");
        }
        HashMap hashMap = new HashMap();
        this.findPreDivPoints(hashMap);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SootMethod sootMethod = (SootMethod)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            Collection collection2 = this.calculateIntraBBDependence(sootMethod, collection);
            this.calculateInterBBDependence(sootMethod, collection2, collection);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Divergence Dependence processing");
        }
        this.stable();
    }

    public void reset() {
        super.reset();
        this.method2interProcDivPoints.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Statistics for divergence dependence as calculated by " + this.getClass().getName() + "[" + this.hashCode() + "]\n");
        stringBuffer.append("The analyses setup was : \n \tinterprocedural: " + this.considerCallSites + "\n");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.dependent2dependee.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SootMethod sootMethod = (SootMethod)entry.getKey();
            n = 0;
            List list = this.getStmtList(sootMethod);
            List list2 = (List)entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                Collection collection = (Collection)list2.get(i);
                if (collection == null) continue;
                stringBuffer2.append("\t\t" + list.get(i) + " --> " + collection + "\n");
                n += collection.size();
            }
            stringBuffer.append("\tFor " + sootMethod + " there are " + n + " divergence dependence edges.\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer2.delete(0, stringBuffer2.length());
            n2 += n;
        }
        stringBuffer.append("A total of " + n2 + " divergence dependence edges exist.");
        return stringBuffer.toString();
    }

    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get("Callgraph Information");
        if (this.callgraph == null) {
            throw new InitializationException("Callgraph Information was not provided.");
        }
    }

    private Collection getValidSuccs(Stmt stmt, BasicBlockGraph.BasicBlock basicBlock, BasicBlockGraph basicBlockGraph, SootMethod sootMethod) {
        HashSet hashSet = new HashSet(basicBlock.getSuccsOf());
        if (!((Collection)CollectionsUtilities.getFromMap((Map)this.method2interProcDivPoints, (Object)sootMethod, (Factory)CollectionsUtilities.EMPTY_LIST_FACTORY)).contains(stmt)) {
            List list = basicBlockGraph.getSCCs(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Collection collection = (Collection)iterator.next();
                if (!collection.contains(basicBlock)) continue;
                hashSet.removeAll(collection);
                break;
            }
        }
        return hashSet;
    }

    private void calculateInterBBDependence(SootMethod sootMethod, Collection collection, Collection collection2) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Processing method " + sootMethod + " with divergent blocks: " + collection));
        }
        List list = this.getStmtList(sootMethod);
        FIFOWorkBag fIFOWorkBag = new FIFOWorkBag();
        HashSet<Stmt> hashSet = new HashSet<Stmt>();
        fIFOWorkBag.addAllWork(collection);
        while (fIFOWorkBag.hasWork()) {
            Collection collection3;
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)fIFOWorkBag.getWork();
            Stmt stmt = basicBlock.getLeaderStmt();
            int n = list.indexOf(stmt);
            Collection collection4 = (Collection)((List)this.dependent2dependee.get(sootMethod)).get(n);
            hashSet.clear();
            if (!collection2.contains(stmt)) {
                collection3 = basicBlock.getStmtsFrom(stmt);
                collection3.remove(stmt);
                Iterator iterator = collection3.iterator();
                while (iterator.hasNext()) {
                    Stmt stmt2 = (Stmt)iterator.next();
                    hashSet.add(stmt2);
                    if (!collection2.contains(stmt2)) continue;
                }
            }
            if (!collection.contains(basicBlock)) {
                collection3 = this.recordDepAcrossBB(sootMethod, collection2, collection4, hashSet, basicBlock.getSuccsOf());
                fIFOWorkBag.addAllWorkNoDuplicates(collection3);
                continue;
            }
            this.recordDependenceInfoInBB(collection4, sootMethod, hashSet);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Processing method " + sootMethod));
        }
    }

    private Collection calculateIntraBBDependence(SootMethod sootMethod, Collection collection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BEGIN: Processing method " + sootMethod + " with divergent points: " + collection));
        }
        HashSet hashSet = new HashSet();
        List list = this.getStmtList(sootMethod);
        HashSet<Stmt> hashSet2 = new HashSet<Stmt>();
        BasicBlockGraph basicBlockGraph = this.getBasicBlockGraph(sootMethod);
        List list2 = CollectionsUtilities.getListFromMap((Map)this.dependent2dependee, (Object)sootMethod);
        CollectionsUtilities.ensureSize((List)list2, (int)list.size(), null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Stmt stmt = (Stmt)iterator.next();
            BasicBlockGraph.BasicBlock basicBlock = basicBlockGraph.getEnclosingBlock(stmt);
            Object object2 = basicBlock.getStmtsOf().iterator();
            while (object2.hasNext() && !collection.contains(stmt = (Stmt)object2.next())) {
            }
            hashSet2.clear();
            object2 = basicBlock.getStmtsFrom(stmt);
            object2.remove(stmt);
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (Stmt)object3.next();
                hashSet2.add((Stmt)object);
                if (!collection.contains(object)) continue;
                this.recordDependenceInfoInBB(Collections.singleton(stmt), sootMethod, hashSet2);
                stmt = object;
                hashSet2.clear();
            }
            object3 = this.getValidSuccs(stmt, basicBlock, basicBlockGraph, sootMethod);
            object = this.recordDepAcrossBB(sootMethod, collection, Collections.singleton(stmt), hashSet2, (Collection)object3);
            hashSet.addAll(object);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("END: Processing method " + sootMethod));
        }
        return hashSet;
    }

    private Collection findIntraproceduralPreDivPoints(Map map) {
        HashSet<Stmt> hashSet = new HashSet<Stmt>();
        HashSet<SootMethod> hashSet2 = this.considerCallSites ? new HashSet<SootMethod>() : null;
        Iterator iterator = this.callgraph.getReachableMethods().iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            BasicBlockGraph basicBlockGraph = this.getBasicBlockGraph(sootMethod);
            List list = basicBlockGraph.getSCCs(true);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Collection collection;
                BasicBlockGraph.BasicBlock basicBlock;
                Collection collection2 = (Collection)iterator2.next();
                if (collection2.size() > 1) {
                    basicBlock = collection2.iterator();
                    while (basicBlock.hasNext()) {
                        collection = (BasicBlockGraph.BasicBlock)basicBlock.next();
                        if (collection2.containsAll(collection.getSuccsOf())) continue;
                        hashSet.add(collection.getTrailerStmt());
                    }
                    continue;
                }
                basicBlock = (BasicBlockGraph.BasicBlock)collection2.iterator().next();
                collection = basicBlock.getSuccsOf();
                if (collection.size() <= 1 || !collection.contains(basicBlock)) continue;
                hashSet.add(basicBlock.getTrailerStmt());
            }
            if (hashSet.isEmpty()) continue;
            map.put(sootMethod, new ArrayList(hashSet));
            if (this.considerCallSites) {
                hashSet2.add(sootMethod);
            }
            hashSet.clear();
        }
        return hashSet2;
    }

    private void findPreDivPoints(Map map) {
        Collection collection = this.findIntraproceduralPreDivPoints(map);
        if (this.considerCallSites) {
            HistoryAwareLIFOWorkBag historyAwareLIFOWorkBag = new HistoryAwareLIFOWorkBag(new HashSet());
            historyAwareLIFOWorkBag.addAllWork(collection);
            while (historyAwareLIFOWorkBag.hasWork()) {
                SootMethod sootMethod = (SootMethod)historyAwareLIFOWorkBag.getWork();
                Iterator iterator = this.callgraph.getCallers(sootMethod).iterator();
                while (iterator.hasNext()) {
                    ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator.next();
                    SootMethod sootMethod2 = callTriple.getMethod();
                    List list = CollectionsUtilities.getListFromMap((Map)map, (Object)sootMethod2);
                    List list2 = CollectionsUtilities.getListFromMap((Map)this.method2interProcDivPoints, (Object)sootMethod2);
                    Stmt stmt = callTriple.getStmt();
                    list.add(stmt);
                    list2.add(stmt);
                    historyAwareLIFOWorkBag.addWork((Object)sootMethod2);
                }
            }
        }
    }

    private Collection recordDepAcrossBB(SootMethod sootMethod, Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        ArrayList<BasicBlockGraph.BasicBlock> arrayList = new ArrayList<BasicBlockGraph.BasicBlock>();
        Iterator iterator = collection4.iterator();
        while (iterator.hasNext()) {
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
            Stmt stmt = basicBlock.getLeaderStmt();
            collection3.add(stmt);
            if (collection.contains(stmt)) continue;
            arrayList.add(basicBlock);
        }
        this.recordDependenceInfoInBB(collection2, sootMethod, collection3);
        return arrayList;
    }

    private void recordDependenceInfoInBB(Collection collection, SootMethod sootMethod, Collection collection2) {
        Collection collection3;
        Object object;
        List list = (List)this.dependent2dependee.get(sootMethod);
        List list2 = this.getStmtList(sootMethod);
        Object object2 = collection2.iterator();
        while (object2.hasNext()) {
            object = (Stmt)object2.next();
            collection3 = (Collection)CollectionsUtilities.getListAtIndexFromList((List)list, (int)list2.indexOf(object));
            collection3.addAll(collection);
        }
        object2 = CollectionsUtilities.getMapFromMap((Map)this.dependee2dependent, (Object)sootMethod);
        object = collection.iterator();
        while (object.hasNext()) {
            collection3 = (Stmt)object.next();
            List list3 = CollectionsUtilities.getListFromMap((Map)object2, (Object)collection3);
            list3.addAll(collection2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

