/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyAnalysisUtil;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.StmtAndMethodBasedDependencyXMLizer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.znerd.xmlenc.XMLOutputter;

public final class DependencyXMLizer
extends AbstractXMLizer {
    public static final Object STMT_LEVEL_DEPENDENCY = "STMT_LEVEL_DEPENDENCY";
    protected static final Properties PROPERTIES = new Properties();
    private static final Log LOGGER;
    final Collection filenames = new ArrayList();
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyXMLizer;

    public String getFileName(String string) {
        return "dependence_" + DependencyXMLizer.xmlizeString((String)string) + ".xml";
    }

    public void flushXMLizers(Map map, ProcessingController processingController) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IProcessor iProcessor = (IProcessor)iterator.next();
            iProcessor.unhook(processingController);
            try {
                FileWriter fileWriter = (FileWriter)map.get(iProcessor);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                LOGGER.error((Object)("Failed to close the xml file based on " + iProcessor.getClass()), (Throwable)iOException);
            }
        }
    }

    public void writeXML(Map map) {
        ProcessingController processingController = new ProcessingController();
        processingController.setEnvironment((IEnvironment)map.get("The Environment"));
        processingController.setStmtGraphFactory((IStmtGraphFactory)map.get(IStmtGraphFactory.ID));
        processingController.setProcessingFilter((IProcessingFilter)new CGBasedXMLizingProcessingFilter((ICallGraphInfo)map.get("Callgraph Information")));
        Map map2 = this.initXMLizers(map, processingController);
        processingController.process();
        this.flushXMLizers(map2, processingController);
    }

    String getDAPartOfFileName(IDependencyAnalysis iDependencyAnalysis) {
        return iDependencyAnalysis.getId() + ":" + iDependencyAnalysis.getClass().getName();
    }

    private StmtAndMethodBasedDependencyXMLizer getXMLizerFor(Writer writer, IDependencyAnalysis iDependencyAnalysis) {
        StmtAndMethodBasedDependencyXMLizer stmtAndMethodBasedDependencyXMLizer = null;
        String string = iDependencyAnalysis.getId().toString();
        String string2 = PROPERTIES.getProperty(string);
        if (string2.equals(STMT_LEVEL_DEPENDENCY)) {
            try {
                stmtAndMethodBasedDependencyXMLizer = new StmtAndMethodBasedDependencyXMLizer((XMLOutputter)new CustomXMLOutputter(writer), this.getIdGenerator(), iDependencyAnalysis);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error((Object)"UTF-8 encoding is unsupported.  Now, this contradicts the documentation!!", (Throwable)unsupportedEncodingException);
            }
        } else {
            LOGGER.error((Object)"Unknown dependency xmlizer type requested.  Bailing on this.");
        }
        return stmtAndMethodBasedDependencyXMLizer;
    }

    private Map initXMLizers(Map map, ProcessingController processingController) {
        HashMap<StmtAndMethodBasedDependencyXMLizer, FileWriter> hashMap = new HashMap<StmtAndMethodBasedDependencyXMLizer, FileWriter>();
        if (this.getXmlOutputDir() == null) {
            LOGGER.fatal((Object)"Defaulting to current directory for xml output.");
            throw new IllegalStateException("Please specify an output directory while using the xmlizer.");
        }
        Iterator iterator = DependencyAnalysisUtil.IDENTIFIERS.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Collection collection = (Collection)map.get(e);
            if (collection == null) continue;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                IDependencyAnalysis iDependencyAnalysis = (IDependencyAnalysis)iterator2.next();
                String string = (String)map.get(FILE_NAME_ID);
                if (string == null) {
                    string = this.getDAPartOfFileName(iDependencyAnalysis);
                }
                String string2 = this.getFileName(string);
                this.filenames.add(string2);
                File file = new File(this.getXmlOutputDir() + File.separator + string2);
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    StmtAndMethodBasedDependencyXMLizer stmtAndMethodBasedDependencyXMLizer = this.getXMLizerFor(fileWriter, iDependencyAnalysis);
                    if (stmtAndMethodBasedDependencyXMLizer == null) {
                        LOGGER.error((Object)("No xmlizer specified for dependency calculated by " + iDependencyAnalysis.getClass() + ".  No xml file written."));
                        fileWriter.close();
                        continue;
                    }
                    stmtAndMethodBasedDependencyXMLizer.hookup(processingController);
                    hashMap.put(stmtAndMethodBasedDependencyXMLizer, fileWriter);
                }
                catch (IOException iOException) {
                    LOGGER.error((Object)("Failed to write the xml file based on " + iDependencyAnalysis.getClass()), (Throwable)iOException);
                }
            }
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("indus.dependencyxmlizer.properties.file");
        if (string == null) {
            string = "edu/ksu/cis/indus/staticanalyses/dependency/DependencyXMLizer.properties";
        }
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        try {
            PROPERTIES.load(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("Well, error loading property file.  Bailing.");
            throw new RuntimeException(iOException);
        }
        LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyXMLizer == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyXMLizer = DependencyXMLizer.class$("edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizer")) : class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyXMLizer));
    }
}

