/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.ErringTestCase;
import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysisTest;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyAnalysisTestSetup;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizer;
import edu.ksu.cis.indus.staticanalyses.dependency.DivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.EntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ExitControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.SynchronizationDA;
import edu.ksu.cis.indus.staticanalyses.dependency.XMLBasedDependencyAnalysisTest;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DependencyAnalysisRegressionTestSuite
extends TestCase {
    public static final String DEPENDENCY_ANALYSIS_TEST_PROPERTIES_FILE = "indus.staticanalyses.dependency.DependencyAnalysisTest.properties.file";
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyAnalysisRegressionTestSuite == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyAnalysisRegressionTestSuite = DependencyAnalysisRegressionTestSuite.class$("edu.ksu.cis.indus.staticanalyses.dependency.DependencyAnalysisRegressionTestSuite")) : class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyAnalysisRegressionTestSuite));
    private static final Properties TEST_CLASSES_PROPERTIES = new Properties();
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyAnalysisRegressionTestSuite;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$XMLBasedCallGraphTest;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraphTest;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$XMLBasedOFATest;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$flow$FATest;

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{(class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyAnalysisRegressionTestSuite == null ? (class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyAnalysisRegressionTestSuite = DependencyAnalysisRegressionTestSuite.class$("edu.ksu.cis.indus.staticanalyses.dependency.DependencyAnalysisRegressionTestSuite")) : class$edu$ksu$cis$indus$staticanalyses$dependency$DependencyAnalysisRegressionTestSuite).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Test for edu.ksu.cis.indus.staticanalyses.dependency");
        String string = System.getProperty(DEPENDENCY_ANALYSIS_TEST_PROPERTIES_FILE);
        if (string == null) {
            throw new RuntimeException("Please provide a property file like DependencyAnalysisTest.properties via -Dindus.staticanalyses.dependency.DependencyAnalysisTest.properties.file");
        }
        DependencyAnalysisRegressionTestSuite.setupTests(string, testSuite);
        return testSuite;
    }

    private static Test getDATestFor(IDependencyAnalysis iDependencyAnalysis) {
        AbstractDependencyAnalysisTest abstractDependencyAnalysisTest = null;
        String string = iDependencyAnalysis.getClass().getName();
        String string2 = TEST_CLASSES_PROPERTIES.getProperty(string);
        if (string2 == null) {
            LOGGER.error((Object)("How can the test class for a dependency analysis be undefined? " + string));
        } else {
            try {
                Class<?> clazz = Class.forName(string2);
                AbstractDependencyAnalysisTest abstractDependencyAnalysisTest2 = (AbstractDependencyAnalysisTest)clazz.newInstance();
                abstractDependencyAnalysisTest2.setDA(iDependencyAnalysis);
                abstractDependencyAnalysisTest = abstractDependencyAnalysisTest2;
            }
            catch (InstantiationException instantiationException) {
                LOGGER.error((Object)("Error while creating an object of type. " + string2), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error((Object)("Error while accessing the constructor of type. " + string2), (Throwable)illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.error((Object)("Error while finding type. " + string2), (Throwable)classNotFoundException);
            }
            catch (SecurityException securityException) {
                LOGGER.error((Object)("Security violation while accessing the constructor of type. " + string2), (Throwable)securityException);
            }
        }
        return abstractDependencyAnalysisTest;
    }

    private static void setupTests(String string, TestSuite testSuite) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(string)));
            String[] stringArray = properties.getProperty("configs").split(" ");
            ArrayList<AbstractDependencyAnalysis> arrayList = new ArrayList<AbstractDependencyAnalysis>();
            ExceptionFlowSensitiveStmtGraphFactory exceptionFlowSensitiveStmtGraphFactory = new ExceptionFlowSensitiveStmtGraphFactory();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = properties.getProperty(string2 + ".classNames");
                String string4 = properties.getProperty(string2 + ".xmlTestDir");
                String string5 = properties.getProperty(string2 + ".xmlControlDir");
                String string6 = properties.getProperty(string2 + ".classpath");
                String string7 = properties.getProperty(string2 + ".jimpleXMLDumpDir");
                String string8 = TestHelper.checkXMLBasedTestExecutability((String)string2, (String)string4, (String)string5);
                try {
                    TestSuite testSuite2 = new TestSuite(string2);
                    if (string8.length() > 0) {
                        testSuite2.addTest((Test)new ErringTestCase(string8));
                        TestHelper.appendSuiteNameToTestsIn((TestSuite)testSuite2, (boolean)true);
                        testSuite.addTest((Test)testSuite2);
                        continue;
                    }
                    arrayList.clear();
                    arrayList.add(new DivergenceDA());
                    arrayList.add(new EntryControlDA());
                    arrayList.add(new ExitControlDA());
                    arrayList.add(new IdentifierBasedDataDA());
                    arrayList.add(new InterferenceDAv1());
                    arrayList.add(new InterferenceDAv2());
                    arrayList.add(new InterferenceDAv3());
                    arrayList.add(new ReadyDAv1());
                    arrayList.add(new ReadyDAv2());
                    arrayList.add(new ReadyDAv3());
                    arrayList.add(new ReferenceBasedDataDA());
                    arrayList.add(new SynchronizationDA());
                    String string9 = properties.getProperty("ignore.das");
                    if (string9 == null) {
                        string9 = "^$";
                    }
                    DependencyXMLizer dependencyXMLizer = new DependencyXMLizer();
                    Object object = arrayList.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        if (Pattern.matches(string9, e.getClass().getName())) continue;
                        XMLBasedDependencyAnalysisTest xMLBasedDependencyAnalysisTest = new XMLBasedDependencyAnalysisTest((IDependencyAnalysis)e, dependencyXMLizer);
                        testSuite2.addTest((Test)xMLBasedDependencyAnalysisTest);
                        Test test = DependencyAnalysisRegressionTestSuite.getDATestFor((IDependencyAnalysis)e);
                        if (test == null) continue;
                        testSuite2.addTest(test);
                    }
                    testSuite2.addTestSuite(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$XMLBasedCallGraphTest == null ? DependencyAnalysisRegressionTestSuite.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.XMLBasedCallGraphTest") : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$XMLBasedCallGraphTest);
                    testSuite2.addTestSuite(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraphTest == null ? DependencyAnalysisRegressionTestSuite.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraphTest") : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$processors$CallGraphTest);
                    testSuite2.addTestSuite(class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$XMLBasedOFATest == null ? DependencyAnalysisRegressionTestSuite.class$("edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.XMLBasedOFATest") : class$edu$ksu$cis$indus$staticanalyses$flow$instances$ofa$XMLBasedOFATest);
                    testSuite2.addTestSuite(class$edu$ksu$cis$indus$staticanalyses$flow$FATest == null ? DependencyAnalysisRegressionTestSuite.class$("edu.ksu.cis.indus.staticanalyses.flow.FATest") : class$edu$ksu$cis$indus$staticanalyses$flow$FATest);
                    TestHelper.appendSuiteNameToTestsIn((TestSuite)testSuite2, (boolean)true);
                    object = new DependencyAnalysisTestSetup(testSuite2, string3, string6);
                    object.setIdGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
                    object.setJimpleXMLDumpLocation(string7);
                    object.setStmtGraphFactory((IStmtGraphFactory)exceptionFlowSensitiveStmtGraphFactory);
                    object.setXMLTestDir(string4);
                    object.setXMLControlDir(string5);
                    testSuite.addTest(object);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Specified property file does not exist.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("indus.dependencyxmlizer.properties.file");
        if (string == null) {
            string = "edu/ksu/cis/indus/staticanalyses/dependency/DependencyAnalysisTestClasses.properties";
        }
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        try {
            TEST_CLASSES_PROPERTIES.load(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("Well, error loading property file.  Bailing.");
            throw new RuntimeException(iOException);
        }
    }
}

