/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysisTest;
import java.util.Iterator;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;

public abstract class AbstractDependencyAnalysisTest
extends IndusTestCase
implements IDependencyAnalysisTest {
    private IDependencyAnalysis da;
    private IEnvironment env;

    protected AbstractDependencyAnalysisTest() {
        this.setName("testDependencyAnalysis");
    }

    public final void setDA(IDependencyAnalysis iDependencyAnalysis) {
        this.da = iDependencyAnalysis;
    }

    public final void testDependencyAnalysis() {
        Iterator iterator = this.env.getClasses().iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            Iterator iterator2 = sootClass.getMethods().iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod = (SootMethod)iterator2.next();
                if (!sootMethod.isConcrete()) continue;
                Iterator iterator3 = sootMethod.retrieveActiveBody().getUnits().iterator();
                while (iterator3.hasNext()) {
                    Stmt stmt = (Stmt)iterator3.next();
                    this.verifyDAFor(stmt, sootMethod);
                }
            }
        }
    }

    public IDependencyAnalysis getDA() {
        return this.da;
    }

    public void setEnvironment(IEnvironment iEnvironment) {
        this.env = iEnvironment;
    }

    protected void tearDown() throws Exception {
        this.da = null;
        this.env = null;
        super.tearDown();
    }

    protected abstract void verifyDAFor(Stmt var1, SootMethod var2);

    protected final IDependencyAnalysis getDa() {
        return this.da;
    }
}

