/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.datastructures.FastUnionFindElement;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.Local;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.util.Switch;

public class RufsEscapeAnalysis
extends AbstractValueAnalyzerBasedProcessor {
    static final String ARRAY_FIELD = "$ELT";
    static final String THIS = "$THIS";
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis == null ? (class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis = RufsEscapeAnalysis.class$("edu.ksu.cis.indus.staticanalyses.concurrency.escape.RufsEscapeAnalysis")) : class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis));
    final Context context;
    final ICallGraphInfo cgi;
    final IThreadGraphInfo tgi;
    final Map globalASs;
    final Map methodCtxt2triple;
    final Scene scm;
    final StmtProcessor stmtProcessor;
    final ValueProcessor valueProcessor;
    Jimple jimple = Jimple.v();
    Map localASsCache;
    Map scCache;
    MethodContext methodCtxtCache;
    private final BasicBlockGraphMgr bbm;
    private final Collection threadAllocSitesMulti;
    private final Collection threadAllocSitesSingle;
    private CFGAnalysis cfg;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis$AliasSet;
    static /* synthetic */ Class class$soot$jimple$NewExpr;

    public RufsEscapeAnalysis(Scene scene, ICallGraphInfo iCallGraphInfo, IThreadGraphInfo iThreadGraphInfo) {
        this.scm = scene;
        this.cgi = iCallGraphInfo;
        this.tgi = iThreadGraphInfo;
        this.bbm = new BasicBlockGraphMgr();
        this.threadAllocSitesSingle = new HashSet();
        this.threadAllocSitesMulti = new HashSet();
        this.globalASs = new HashMap();
        this.methodCtxt2triple = new HashMap();
        this.stmtProcessor = new StmtProcessor();
        this.valueProcessor = new ValueProcessor();
        this.context = new Context();
        this.cfg = new CFGAnalysis(iCallGraphInfo, new BasicBlockGraphMgr());
    }

    public boolean isGlobal(SootMethod sootMethod, Local local) {
        Triple triple = (Triple)this.methodCtxt2triple.get(sootMethod);
        boolean bl = true;
        if (triple != null) {
            Map map = (Map)triple.getSecond();
            FastUnionFindElement fastUnionFindElement = (FastUnionFindElement)map.get(local);
            bl = fastUnionFindElement != null ? ((AliasSet)fastUnionFindElement).isGlobal() : false;
        }
        return bl;
    }

    public boolean isMethodEscaping(NewExpr newExpr) {
        return true;
    }

    public boolean isSingleThreadSynchronized(Stmt stmt) {
        return false;
    }

    public boolean isThreadEscaping(NewExpr newExpr) {
        return false;
    }

    public void callback(ValueBox valueBox, Context context) {
        if (valueBox.getValue() instanceof NewExpr) {
            this.processNewExpr((NewExpr)valueBox.getValue(), context);
        }
    }

    public void callback(SootField sootField) {
        AliasSet aliasSet;
        if (Modifier.isStatic((int)sootField.getModifiers()) && (aliasSet = this.getASForType(sootField.getType())) != null) {
            aliasSet.setGlobal();
            this.globalASs.put(sootField.getSignature(), aliasSet);
        }
    }

    public void callback(SootMethod sootMethod) {
        this.methodCtxt2triple.put(sootMethod, new Triple((Object)new MethodContext(sootMethod), new HashMap(), new HashMap()));
    }

    public boolean canHaveAliasSet(Type type) {
        return type instanceof RefType || type instanceof ArrayType;
    }

    public void consolidate() {
        IThreadGraphInfo.NewExprTriple newExprTriple;
        Object object;
        Object object2;
        HashSet hashSet = new HashSet(this.threadAllocSitesSingle);
        Context context = hashSet.iterator();
        while (context.hasNext()) {
            object2 = (IThreadGraphInfo.NewExprTriple)context.next();
            object = object2.getMethod();
            if (!this.executedMultipleTimes((SootMethod)object)) continue;
            this.threadAllocSitesSingle.remove(object2);
            this.threadAllocSitesMulti.add(object2);
        }
        context = new Context();
        object2 = new HashSet();
        object = this.threadAllocSitesMulti.iterator();
        while (object.hasNext()) {
            newExprTriple = (IThreadGraphInfo.NewExprTriple)object.next();
            context.setRootMethod(newExprTriple.getMethod());
            context.setStmt(newExprTriple.getStmt());
            object2.addAll(this.tgi.getExecutedMethods(newExprTriple.getExpr(), context));
        }
        hashSet.clear();
        hashSet.addAll(this.threadAllocSitesSingle);
        object = hashSet.iterator();
        while (object.hasNext()) {
            newExprTriple = (IThreadGraphInfo.NewExprTriple)object.next();
            SootMethod sootMethod = newExprTriple.getMethod();
            if (!object2.contains(sootMethod)) continue;
            this.threadAllocSitesSingle.remove(newExprTriple);
            this.threadAllocSitesMulti.add(newExprTriple);
        }
    }

    public boolean escapes(SootMethod sootMethod, Local local) {
        Triple triple = (Triple)this.methodCtxt2triple.get(sootMethod);
        boolean bl = true;
        if (triple != null) {
            Map map = (Map)triple.getSecond();
            FastUnionFindElement fastUnionFindElement = (FastUnionFindElement)map.get(local);
            bl = fastUnionFindElement != null ? ((AliasSet)fastUnionFindElement).isSynced() || !CollectionUtils.intersection((Collection)this.tgi.getMultiThreadAllocSites(), (Collection)this.tgi.getExecutionThreads(sootMethod)).isEmpty() : false;
        }
        return bl;
    }

    public void execute() {
        SootMethod sootMethod;
        Object object;
        Object object2;
        Object object3;
        SootMethod sootMethod2;
        Object object4;
        List list;
        List list2 = this.cgi.getSCCs(false);
        HistoryAwareLIFOWorkBag historyAwareLIFOWorkBag = list2.iterator();
        while (historyAwareLIFOWorkBag.hasNext()) {
            list = (List)historyAwareLIFOWorkBag.next();
            object4 = list.iterator();
            while (object4.hasNext()) {
                sootMethod2 = (SootMethod)object4.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Processing method " + sootMethod2));
                }
                if (!sootMethod2.isConcrete()) {
                    LOGGER.warn((Object)"Punting ?????????????");
                    continue;
                }
                object3 = (JimpleBody)sootMethod2.retrieveActiveBody();
                object2 = (Triple)this.methodCtxt2triple.get(sootMethod2);
                this.methodCtxtCache = (MethodContext)object2.getFirst();
                this.localASsCache = (Map)object2.getSecond();
                this.scCache = (Map)object2.getThird();
                this.context.setRootMethod(sootMethod2);
                if (Modifier.isSynchronized((int)sootMethod2.getModifiers()) && !sootMethod2.isStatic()) {
                    this.methodCtxtCache.getThisAS().setSynced();
                }
                object = object3.getUnits().iterator();
                while (object.hasNext()) {
                    sootMethod = (Stmt)object.next();
                    this.context.setStmt((Stmt)sootMethod);
                    sootMethod.apply((Switch)this.stmtProcessor);
                }
            }
        }
        historyAwareLIFOWorkBag = new HistoryAwareLIFOWorkBag(new HashSet());
        historyAwareLIFOWorkBag.addAllWork(this.cgi.getHeads());
        while (historyAwareLIFOWorkBag.hasWork()) {
            list = (SootMethod)historyAwareLIFOWorkBag.getWork();
            object4 = this.cgi.getCallees((SootMethod)list);
            sootMethod2 = (Triple)this.methodCtxt2triple.get(list);
            object3 = (Map)sootMethod2.getThird();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (ICallGraphInfo.CallTriple)object2.next();
                sootMethod = object.getMethod();
                sootMethod2 = (Triple)this.methodCtxt2triple.get(sootMethod);
                MethodContext methodContext = (MethodContext)sootMethod2.getFirst();
                ICallGraphInfo.CallTriple callTriple = new ICallGraphInfo.CallTriple((SootMethod)list, object.getStmt(), object.getExpr());
                MethodContext methodContext2 = (MethodContext)object3.get(callTriple);
                methodContext2.propogateSyncInfoFromTo(methodContext);
                historyAwareLIFOWorkBag.addWorkNoDuplicates((Object)sootMethod);
            }
        }
    }

    public void hookup(ProcessingController processingController) {
        processingController.register(class$soot$jimple$NewExpr == null ? (class$soot$jimple$NewExpr = RufsEscapeAnalysis.class$("soot.jimple.NewExpr")) : class$soot$jimple$NewExpr, (IProcessor)this);
        processingController.register((IProcessor)this);
    }

    public void unhook(ProcessingController processingController) {
        processingController.unregister(class$soot$jimple$NewExpr == null ? (class$soot$jimple$NewExpr = RufsEscapeAnalysis.class$("soot.jimple.NewExpr")) : class$soot$jimple$NewExpr, (IProcessor)this);
        processingController.unregister((IProcessor)this);
    }

    AliasSet getASForClass(SootClass sootClass) {
        AliasSet aliasSet = new AliasSet();
        Iterator iterator = sootClass.getFields().iterator();
        while (iterator.hasNext()) {
            SootField sootField = (SootField)iterator.next();
            if (Modifier.isStatic((int)sootField.getModifiers()) || !(sootField.getType() instanceof RefType) || sootField.getType() instanceof ArrayType) continue;
            aliasSet.putASForField(sootField.getSignature(), new AliasSet());
        }
        return aliasSet;
    }

    AliasSet getASForType(Type type) {
        AliasSet aliasSet = null;
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            AliasSet aliasSet2 = new AliasSet();
            AliasSet aliasSet3 = aliasSet = new AliasSet();
            for (int i = arrayType.numDimensions; i >= 1; --i) {
                aliasSet2 = new AliasSet();
                aliasSet3.putASForField(ARRAY_FIELD, aliasSet2);
                aliasSet3 = aliasSet2;
            }
        } else if (type instanceof RefType) {
            aliasSet = this.getASForClass(this.scm.getSootClass(((RefType)type).getClassName()));
        }
        return aliasSet;
    }

    AliasSet getAliasSetFor(Value value, SootMethod sootMethod) {
        Triple triple = (Triple)this.methodCtxt2triple.get(sootMethod);
        if (triple == null) {
            throw new IllegalArgumentException("Method " + sootMethod + " was not analyzed.");
        }
        Map map = (Map)triple.getSecond();
        AliasSet aliasSet = null;
        if (this.canHaveAliasSet(value.getType())) {
            if (value instanceof InstanceFieldRef) {
                InstanceFieldRef instanceFieldRef = (InstanceFieldRef)value;
                aliasSet = ((AliasSet)map.get(instanceFieldRef.getBase())).getASForField(((FieldRef)value).getField().getSignature());
            } else if (value instanceof StaticFieldRef) {
                aliasSet = (AliasSet)this.globalASs.get(((FieldRef)value).getField().getSignature());
            } else if (value instanceof ArrayRef) {
                ArrayRef arrayRef = (ArrayRef)value;
                aliasSet = ((AliasSet)map.get(arrayRef.getBase())).getASForField(ARRAY_FIELD);
            } else if (value instanceof Local) {
                aliasSet = (AliasSet)map.get(value);
            }
        }
        return aliasSet;
    }

    MethodContext getSiteContext(SootMethod sootMethod, AliasSet aliasSet, List list, AliasSet aliasSet2, AliasSet aliasSet3) {
        MethodContext methodContext = new MethodContext();
        methodContext.method = sootMethod;
        methodContext.thisAS = aliasSet;
        methodContext.argAlSets = list;
        methodContext.ret = aliasSet2;
        methodContext.thrown = aliasSet3;
        return methodContext;
    }

    String tpgetInfo(SootField sootField, Map map) {
        FastUnionFindElement fastUnionFindElement = (FastUnionFindElement)this.globalASs.get(sootField.getSignature());
        AliasSet aliasSet = (AliasSet)fastUnionFindElement;
        if (aliasSet != null) {
            return ((AliasSet)fastUnionFindElement).toString("  ", map);
        }
        return "";
    }

    String tpgetInfo(SootMethod sootMethod, Local local, Map map) {
        Triple triple = (Triple)this.methodCtxt2triple.get(sootMethod);
        if (triple == null) {
            return "";
        }
        Map map2 = (Map)triple.getSecond();
        FastUnionFindElement fastUnionFindElement = (FastUnionFindElement)map2.get(local);
        if (fastUnionFindElement != null) {
            return ((AliasSet)fastUnionFindElement).toString("  ", map);
        }
        return "";
    }

    String tpgetInfo(SootMethod sootMethod, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Triple triple = (Triple)this.methodCtxt2triple.get(sootMethod);
        if (triple != null) {
            MethodContext methodContext = (MethodContext)triple.getFirst();
            if (methodContext.getThisAS() != null) {
                stringBuffer.append("  Info for @this:\n" + methodContext.getThisAS().toString("    ", map) + "\n");
            }
            for (int i = 0; i < sootMethod.getParameterCount(); ++i) {
                AliasSet aliasSet = methodContext.getParamAS(i);
                if (aliasSet == null) continue;
                stringBuffer.append("  Info for @parameter" + i + ":\n" + aliasSet.toString("    ", map) + "\n");
            }
            if (sootMethod.getReturnType() instanceof RefType || sootMethod.getReturnType() instanceof ArrayType) {
                stringBuffer.append("  Info for @return:\n" + methodContext.getReturnAS().toString("    ", map) + "\n");
            }
        } else {
            LOGGER.warn((Object)("Method " + sootMethod + " did not have a method context."));
        }
        return stringBuffer.toString();
    }

    private boolean executedMultipleTimes(SootMethod sootMethod) {
        boolean bl;
        block4: {
            bl = false;
            Collection collection = this.cgi.getCallers(sootMethod);
            if (collection.size() > 1) {
                bl = true;
            } else if (collection.size() == 1) {
                Collection collection2;
                ICallGraphInfo.CallTriple callTriple = this.cgi.getSCCs(true).iterator();
                while (callTriple.hasNext()) {
                    collection2 = (Collection)callTriple.next();
                    if (!collection2.contains(sootMethod)) continue;
                    bl = true;
                    break block4;
                }
                callTriple = (ICallGraphInfo.CallTriple)collection.iterator().next();
                collection2 = callTriple.getMethod();
                BasicBlockGraph basicBlockGraph = this.bbm.getBasicBlockGraph((SootMethod)collection2);
                bl = this.cfg.occursInCycle((IDirectedGraph)basicBlockGraph, basicBlockGraph.getEnclosingBlock(callTriple.getStmt())) ? true : this.executedMultipleTimes((SootMethod)collection2);
            }
        }
        return bl;
    }

    private void processNewExpr(NewExpr newExpr, Context context) {
        String string = newExpr.getBaseType().getClassName();
        SootMethod sootMethod = context.getCurrentMethod();
        if (Util.isDescendentOf((SootClass)this.scm.getSootClass(string), (String)"java.lang.Thread")) {
            Stmt stmt;
            BasicBlockGraph basicBlockGraph = this.bbm.getBasicBlockGraph(sootMethod);
            if (basicBlockGraph.isReachable((INode)basicBlockGraph.getEnclosingBlock(stmt = context.getStmt()), (INode)basicBlockGraph.getEnclosingBlock(stmt), true)) {
                this.threadAllocSitesMulti.add(new IThreadGraphInfo.NewExprTriple(sootMethod, stmt, newExpr));
            } else {
                this.threadAllocSitesSingle.add(new IThreadGraphInfo.NewExprTriple(sootMethod, stmt, newExpr));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ValueProcessor
    extends AbstractJimpleValueSwitch {
        ValueProcessor() {
        }

        public void caseArrayRef(ArrayRef arrayRef) {
            AliasSet aliasSet = null;
            if (arrayRef.getType() instanceof RefType || arrayRef.getType() instanceof ArrayType) {
                arrayRef.getBase().apply((Switch)this);
                AliasSet aliasSet2 = (AliasSet)this.getResult();
                aliasSet = aliasSet2.getASForField(RufsEscapeAnalysis.ARRAY_FIELD);
                if (aliasSet == null) {
                    aliasSet = new AliasSet();
                    aliasSet2.putASForField(RufsEscapeAnalysis.ARRAY_FIELD, aliasSet);
                }
                aliasSet.setSynced();
            }
            this.setResult(aliasSet);
        }

        public void caseInstanceFieldRef(InstanceFieldRef instanceFieldRef) {
            SootField sootField = instanceFieldRef.getField();
            AliasSet aliasSet = null;
            if (sootField.getType() instanceof RefType || sootField.getType() instanceof ArrayType) {
                instanceFieldRef.getBase().apply((Switch)this);
                AliasSet aliasSet2 = (AliasSet)this.getResult();
                String string = instanceFieldRef.getField().getSignature();
                aliasSet = aliasSet2.getASForField(string);
                if (aliasSet == null) {
                    aliasSet = new AliasSet();
                    aliasSet2.putASForField(string, aliasSet);
                }
                aliasSet.setSynced();
            }
            this.setResult(aliasSet);
        }

        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr interfaceInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)interfaceInvokeExpr);
        }

        public void caseLocal(Local local) {
            AliasSet aliasSet = null;
            if (local.getType() instanceof RefType || local.getType() instanceof ArrayType) {
                aliasSet = (AliasSet)RufsEscapeAnalysis.this.localASsCache.get(local);
                if (aliasSet == null) {
                    aliasSet = new AliasSet();
                    RufsEscapeAnalysis.this.localASsCache.put(local, aliasSet);
                }
                aliasSet.setSynced();
            }
            this.setResult(aliasSet);
        }

        public void caseParameterRef(ParameterRef parameterRef) {
            if (parameterRef.getType() instanceof RefType || parameterRef.getType() instanceof ArrayType) {
                this.setResult(RufsEscapeAnalysis.this.methodCtxtCache.getParamAS(parameterRef.getIndex()));
            } else {
                this.setResult(null);
            }
        }

        public void caseSpecialInvokeExpr(SpecialInvokeExpr specialInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)specialInvokeExpr);
        }

        public void caseStaticFieldRef(StaticFieldRef staticFieldRef) {
            if (staticFieldRef.getType() instanceof RefType || staticFieldRef.getType() instanceof ArrayType) {
                this.setResult(RufsEscapeAnalysis.this.globalASs.get(staticFieldRef.getField().getSignature()));
            } else {
                this.setResult(null);
            }
        }

        public void caseStaticInvokeExpr(StaticInvokeExpr staticInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)staticInvokeExpr);
        }

        public void caseThisRef(ThisRef thisRef) {
            this.setResult(RufsEscapeAnalysis.this.methodCtxtCache.getThisAS());
        }

        public void caseVirtualInvokeExpr(VirtualInvokeExpr virtualInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)virtualInvokeExpr);
        }

        public void defaultCase(Object object) {
            this.setResult(null);
        }

        private boolean notInSameSCC(SootMethod sootMethod, SootMethod sootMethod2) {
            boolean bl = true;
            List list = RufsEscapeAnalysis.this.cgi.getSCCs(true);
            Collection collection = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !(collection = (Collection)iterator.next()).contains(sootMethod)) {
                collection = null;
            }
            if (collection != null) {
                bl = !collection.contains(sootMethod2);
            }
            return bl;
        }

        private void processInvokeExpr(InvokeExpr invokeExpr) {
            Object object;
            Object object2;
            AliasSet aliasSet;
            ArrayList<SootMethod> arrayList = new ArrayList<SootMethod>();
            SootMethod sootMethod = RufsEscapeAnalysis.this.context.getCurrentMethod();
            SootMethod sootMethod2 = invokeExpr.getMethod();
            Stmt stmt = RufsEscapeAnalysis.this.context.getStmt();
            AliasSet aliasSet2 = aliasSet = sootMethod2.getReturnType() instanceof RefType || sootMethod2.getReturnType() instanceof ArrayType ? new AliasSet() : null;
            if (stmt instanceof AssignStmt && ((AssignStmt)stmt).getLeftOp().getType() instanceof RefType) {
                ((AssignStmt)stmt).getLeftOp().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
                aliasSet = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            }
            AliasSet aliasSet3 = null;
            if (!sootMethod2.isStatic()) {
                ((InstanceInvokeExpr)invokeExpr).getBase().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
                aliasSet3 = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            }
            ArrayList<AliasSet> arrayList2 = new ArrayList<AliasSet>();
            for (int i = 0; i < sootMethod2.getParameterCount(); ++i) {
                object2 = invokeExpr.getArg(i);
                if (object2 instanceof StringConstant || object2 instanceof NullConstant) {
                    object = new AliasSet();
                } else {
                    invokeExpr.getArg(i).apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
                    object = RufsEscapeAnalysis.this.valueProcessor.getResult();
                }
                arrayList2.add((AliasSet)object);
            }
            MethodContext methodContext = RufsEscapeAnalysis.this.getSiteContext(sootMethod2, aliasSet3, arrayList2, aliasSet, new AliasSet());
            RufsEscapeAnalysis.this.scCache.put(new ICallGraphInfo.CallTriple(sootMethod, RufsEscapeAnalysis.this.context.getStmt(), invokeExpr), methodContext);
            if (invokeExpr instanceof StaticInvokeExpr || invokeExpr instanceof SpecialInvokeExpr) {
                arrayList.add(sootMethod2);
            } else if (invokeExpr instanceof InterfaceInvokeExpr || invokeExpr instanceof VirtualInvokeExpr) {
                RufsEscapeAnalysis.this.context.setProgramPoint(((InstanceInvokeExpr)invokeExpr).getBaseBox());
                arrayList.addAll(RufsEscapeAnalysis.this.cgi.getCallees(invokeExpr, RufsEscapeAnalysis.this.context));
            }
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (SootMethod)object2.next();
                Triple triple = (Triple)RufsEscapeAnalysis.this.methodCtxt2triple.get(object);
                if (triple == null) continue;
                MethodContext methodContext2 = (MethodContext)triple.getFirst();
                if (this.notInSameSCC(sootMethod, (SootMethod)object)) {
                    try {
                        methodContext2 = (MethodContext)methodContext2.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        LOGGER.error((Object)"Hell NO!  This should not happen.", (Throwable)cloneNotSupportedException);
                    }
                }
                methodContext.unify(methodContext2);
            }
        }
    }

    class StmtProcessor
    extends AbstractStmtSwitch {
        StmtProcessor() {
        }

        public void caseAssignStmt(AssignStmt assignStmt) {
            assignStmt.getRightOp().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            AliasSet aliasSet = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            assignStmt.getLeftOp().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            AliasSet aliasSet2 = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet != null && aliasSet2 != null) {
                aliasSet2.unify(aliasSet);
            }
        }

        public void caseEnterMonitorStmt(EnterMonitorStmt enterMonitorStmt) {
            enterMonitorStmt.getOp().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            AliasSet aliasSet = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet.isGlobal()) {
                aliasSet.addSyncThreads(RufsEscapeAnalysis.this.tgi.getExecutionThreads(RufsEscapeAnalysis.this.context.getCurrentMethod()));
            }
        }

        public void caseExitMonitorStmt(ExitMonitorStmt exitMonitorStmt) {
            exitMonitorStmt.getOp().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            AliasSet aliasSet = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet.isGlobal()) {
                aliasSet.addSyncThreads(RufsEscapeAnalysis.this.tgi.getExecutionThreads(RufsEscapeAnalysis.this.context.getCurrentMethod()));
            }
        }

        public void caseIdentityStmt(IdentityStmt identityStmt) {
            Value value = identityStmt.getLeftOp();
            identityStmt.getRightOp().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            AliasSet aliasSet = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            value.apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            AliasSet aliasSet2 = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet != null && aliasSet2 != null) {
                aliasSet2.unify(aliasSet);
            }
        }

        public void caseInvokeStmt(InvokeStmt invokeStmt) {
            invokeStmt.getInvokeExpr().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
        }

        public void caseReturnStmt(ReturnStmt returnStmt) {
            Value value = returnStmt.getOp();
            value.apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            AliasSet aliasSet = (AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet != null) {
                RufsEscapeAnalysis.this.methodCtxtCache.getReturnAS().unify(aliasSet);
            }
        }

        public void caseThrowStmt(ThrowStmt throwStmt) {
            throwStmt.getOp().apply((Switch)RufsEscapeAnalysis.this.valueProcessor);
            RufsEscapeAnalysis.this.methodCtxtCache.getThrownAS().unify((AliasSet)RufsEscapeAnalysis.this.valueProcessor.getResult());
        }
    }

    class MethodContext
    extends FastUnionFindElement
    implements Cloneable {
        AliasSet ret;
        AliasSet thisAS;
        AliasSet thrown;
        List argAlSets;
        SootMethod method;

        MethodContext() {
        }

        MethodContext(SootMethod sootMethod) {
            this.method = sootMethod;
            this.argAlSets = new ArrayList(sootMethod.getParameterCount());
            for (int i = 0; i < sootMethod.getParameterCount(); ++i) {
                Type type = sootMethod.getParameterType(i);
                AliasSet aliasSet = null;
                if (type instanceof RefType || type instanceof ArrayType) {
                    aliasSet = RufsEscapeAnalysis.this.getASForType(type);
                }
                this.argAlSets.add(i, aliasSet);
            }
            if (sootMethod.getReturnType() instanceof RefType || sootMethod.getReturnType() instanceof ArrayType) {
                this.ret = new AliasSet();
            }
            this.thrown = new AliasSet();
            if (!sootMethod.isStatic()) {
                this.thisAS = RufsEscapeAnalysis.this.getASForClass(sootMethod.getDeclaringClass());
            }
        }

        public Object clone() throws CloneNotSupportedException {
            if (this.set != null) {
                return (MethodContext)((MethodContext)this.find()).clone();
            }
            MethodContext methodContext = (MethodContext)super.clone();
            HashMap hashMap = new HashMap();
            methodContext.set = null;
            if (this.thisAS != null) {
                methodContext.thisAS = (AliasSet)this.thisAS.clone();
                this.buildClonee2CloneMap(this.thisAS, methodContext.thisAS, hashMap);
            }
            methodContext.argAlSets = new ArrayList();
            Iterator iterator = this.argAlSets.iterator();
            while (iterator.hasNext()) {
                AliasSet aliasSet = (AliasSet)iterator.next();
                if (aliasSet != null) {
                    Object object = aliasSet.clone();
                    methodContext.argAlSets.add(object);
                    this.buildClonee2CloneMap(aliasSet, (AliasSet)object, hashMap);
                    continue;
                }
                methodContext.argAlSets.add(null);
            }
            if (this.ret != null) {
                methodContext.ret = (AliasSet)this.ret.clone();
                this.buildClonee2CloneMap(this.ret, methodContext.ret, hashMap);
            }
            methodContext.thrown = (AliasSet)this.thrown.clone();
            this.buildClonee2CloneMap(this.thrown, methodContext.thrown, hashMap);
            this.unionclones(hashMap);
            return methodContext;
        }

        AliasSet getParamAS(int n) {
            return (AliasSet)((MethodContext)this.find()).argAlSets.get(n);
        }

        AliasSet getReturnAS() {
            return ((MethodContext)this.find()).ret;
        }

        AliasSet getThisAS() {
            return ((MethodContext)this.find()).thisAS;
        }

        AliasSet getThrownAS() {
            return ((MethodContext)this.find()).thrown;
        }

        void propogateSyncInfoFromTo(MethodContext methodContext) {
            MethodContext methodContext2 = (MethodContext)this.find();
            MethodContext methodContext3 = (MethodContext)methodContext.find();
            for (int i = this.method.getParameterCount() - 1; i >= 0; --i) {
                AliasSet aliasSet = (AliasSet)methodContext2.argAlSets.get(i);
                if (aliasSet == null) continue;
                aliasSet.propogateSyncInfoFromTo((AliasSet)methodContext3.argAlSets.get(i));
            }
            if (methodContext2.ret != null) {
                methodContext2.ret.propogateSyncInfoFromTo(methodContext3.ret);
            }
            this.thrown.propogateSyncInfoFromTo(methodContext.thrown);
            if (methodContext2.thisAS != null) {
                methodContext2.thisAS.propogateSyncInfoFromTo(methodContext3.thisAS);
            }
        }

        void unify(MethodContext methodContext) throws IllegalStateException {
            MethodContext methodContext2;
            if (methodContext == null) {
                return;
            }
            MethodContext methodContext3 = (MethodContext)this.find();
            if (methodContext3 == (methodContext2 = (MethodContext)methodContext.find())) {
                return;
            }
            for (int i = this.method.getParameterCount() - 1; i >= 0; --i) {
                AliasSet aliasSet = (AliasSet)methodContext3.argAlSets.get(i);
                AliasSet aliasSet2 = (AliasSet)methodContext2.argAlSets.get(i);
                if (aliasSet != null && aliasSet2 == null || aliasSet == null && aliasSet2 != null) {
                    throw new IllegalStateException("Incompatible method contexts being unified - argument position " + i + " of " + this.method);
                }
                if (aliasSet == null) continue;
                aliasSet.unify((AliasSet)methodContext2.argAlSets.get(i));
            }
            if (methodContext3.ret == null && methodContext2.ret != null || methodContext3.ret != null && methodContext2.ret == null) {
                throw new IllegalStateException("Incompatible method contexts being unified - return value of " + this.method);
            }
            if (methodContext3.ret != null) {
                methodContext3.ret.unify(methodContext2.ret);
            }
            methodContext3.thrown.unify(methodContext2.thrown);
            if (methodContext3.thisAS == null && methodContext2.thisAS != null || methodContext3.thisAS != null && methodContext2.thisAS == null) {
                throw new IllegalStateException("Incompatible method contexts being unified - staticness of " + this.method);
            }
            if (methodContext3.thisAS != null) {
                methodContext3.thisAS.unify(methodContext2.thisAS);
            }
            methodContext3.union(methodContext2);
        }

        private void buildClonee2CloneMap(AliasSet aliasSet, AliasSet aliasSet2, Map map) {
            map.put(aliasSet, aliasSet2);
            AliasSet aliasSet3 = (AliasSet)aliasSet.find();
            AliasSet aliasSet4 = (AliasSet)aliasSet2.find();
            Iterator iterator = aliasSet3.fieldMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                AliasSet aliasSet5 = (AliasSet)aliasSet3.fieldMap.get(k);
                AliasSet aliasSet6 = (AliasSet)aliasSet4.fieldMap.get(k);
                if (map.containsKey(aliasSet5)) continue;
                this.buildClonee2CloneMap(aliasSet5, aliasSet6, map);
            }
        }

        private void unionclones(Map map) {
            HashSet<FastUnionFindElement> hashSet = new HashSet<FastUnionFindElement>();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                FastUnionFindElement fastUnionFindElement = (FastUnionFindElement)iterator.next();
                if (hashSet.contains(fastUnionFindElement)) continue;
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    FastUnionFindElement fastUnionFindElement2 = (FastUnionFindElement)iterator2.next();
                    if (fastUnionFindElement == fastUnionFindElement2 || hashSet.contains(fastUnionFindElement2) || fastUnionFindElement.find() != fastUnionFindElement2.find()) continue;
                    FastUnionFindElement fastUnionFindElement3 = (FastUnionFindElement)map.get(fastUnionFindElement);
                    FastUnionFindElement fastUnionFindElement4 = (FastUnionFindElement)map.get(fastUnionFindElement2);
                    fastUnionFindElement3.find().union(fastUnionFindElement4.find());
                }
                hashSet.add(fastUnionFindElement);
            }
        }
    }

    class AliasSet
    extends FastUnionFindElement
    implements Cloneable {
        Map fieldMap;
        private Collection syncThreads;
        private final Log logger = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis$AliasSet == null ? (class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis$AliasSet = RufsEscapeAnalysis.class$("edu.ksu.cis.indus.staticanalyses.concurrency.escape.RufsEscapeAnalysis$AliasSet")) : class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufsEscapeAnalysis$AliasSet));
        private Object theClone = null;
        private boolean global = false;
        private boolean propogating = false;
        private boolean stringifying = false;
        private boolean synced = false;

        AliasSet() {
            this.fieldMap = new HashMap();
            this.syncThreads = new HashSet();
        }

        public Object clone() throws CloneNotSupportedException {
            if (this.theClone != null) {
                return this.theClone;
            }
            if (this.isGlobal()) {
                return this.find();
            }
            if (this.set != null) {
                return (AliasSet)((AliasSet)this.find()).clone();
            }
            AliasSet aliasSet = (AliasSet)super.clone();
            this.theClone = aliasSet;
            aliasSet.fieldMap = new HashMap();
            aliasSet.set = null;
            if (this.isSynced()) {
                aliasSet.setSynced();
            }
            AliasSet aliasSet2 = (AliasSet)this.find();
            Iterator iterator = aliasSet2.fieldMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                AliasSet aliasSet3 = (AliasSet)entry.getValue();
                if (!aliasSet3.isGlobal()) {
                    aliasSet3 = (AliasSet)aliasSet3.clone();
                    aliasSet3.set = null;
                }
                aliasSet.fieldMap.put(entry.getKey(), aliasSet3);
            }
            this.theClone = null;
            aliasSet.syncThreads = new HashSet(aliasSet2.syncThreads);
            return aliasSet;
        }

        AliasSet getASForField(String string) {
            return (AliasSet)((AliasSet)this.find()).fieldMap.get(string);
        }

        void setGlobal() {
            if (this.isGlobal()) {
                return;
            }
            AliasSet aliasSet = (AliasSet)this.find();
            aliasSet.global = true;
            Iterator iterator = aliasSet.fieldMap.values().iterator();
            while (iterator.hasNext()) {
                AliasSet aliasSet2 = (AliasSet)iterator.next();
                aliasSet2.setGlobal();
            }
        }

        boolean isGlobal() {
            return ((AliasSet)this.find()).global;
        }

        void setSynced() {
            AliasSet aliasSet = (AliasSet)this.find();
            aliasSet.synced = true;
        }

        boolean isSynced() {
            return ((AliasSet)this.find()).synced;
        }

        void addSyncThreads(Collection collection) {
            ((AliasSet)this.find()).syncThreads.addAll(collection);
        }

        void propogateSyncInfoFromTo(AliasSet aliasSet) {
            if (this.propogating) {
                return;
            }
            AliasSet aliasSet2 = (AliasSet)this.find();
            AliasSet aliasSet3 = (AliasSet)aliasSet.find();
            if (aliasSet3.isSynced()) {
                aliasSet3.addSyncThreads(this.syncThreads);
            }
            this.propogating = true;
            Iterator iterator = aliasSet3.fieldMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                AliasSet aliasSet4 = (AliasSet)((AliasSet)aliasSet3.fieldMap.get(entry.getKey())).find();
                if (!aliasSet4.isSynced()) continue;
                AliasSet aliasSet5 = (AliasSet)((AliasSet)aliasSet2.fieldMap.get(entry.getKey())).find();
                aliasSet5.propogateSyncInfoFromTo(aliasSet4);
            }
            this.propogating = false;
        }

        void putASForField(String string, AliasSet aliasSet) {
            ((AliasSet)this.find()).fieldMap.put(string, aliasSet);
            if (this.isGlobal()) {
                aliasSet.setGlobal();
            }
        }

        String toString(String string, Map map) {
            Object object;
            Object object2;
            if (this.stringifying) {
                return string + "Cycle from here on.";
            }
            this.stringifying = true;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            AliasSet aliasSet = (AliasSet)this.find();
            if (aliasSet.syncThreads.isEmpty()) {
                stringBuffer2.append("NONE");
            } else {
                object2 = aliasSet.syncThreads.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (map.get(object) == null) {
                        stringBuffer2.append(object + ",");
                        continue;
                    }
                    stringBuffer2.append(map.get(object) + ",");
                }
            }
            object2 = new StringBuffer();
            object = string + "  ";
            if (aliasSet.fieldMap.isEmpty()) {
                ((StringBuffer)object2).append(object + "NONE");
            } else {
                Iterator iterator = aliasSet.fieldMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ((StringBuffer)object2).append(object + entry.getKey() + ":\n" + ((AliasSet)entry.getValue()).toString(object + "    ", map) + "\n");
                }
            }
            stringBuffer.append(string + "GLOBAL: " + aliasSet.isGlobal() + "\n");
            stringBuffer.append(string + "SYNCHRONIZED: " + aliasSet.isSynced() + "\n");
            stringBuffer.append(string + "SYNCHRONIZED THREADS: " + stringBuffer2 + "\n");
            stringBuffer.append(string + "FIELD MAPS:\n" + object2);
            this.stringifying = false;
            return stringBuffer.toString();
        }

        void unify(AliasSet aliasSet) throws NullPointerException {
            AliasSet aliasSet2;
            String string;
            AliasSet aliasSet3;
            AliasSet aliasSet4;
            if (aliasSet == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"Unification with null requested.");
                }
                throw new NullPointerException("Trying to unify with null.");
            }
            boolean bl = false;
            if (this.isGlobal() && !aliasSet.isGlobal() && aliasSet.isSynced() || aliasSet.isGlobal() && !this.isGlobal() && this.isSynced()) {
                bl = true;
            }
            if ((aliasSet4 = (AliasSet)this.find()) == (aliasSet3 = (AliasSet)aliasSet.find())) {
                return;
            }
            aliasSet4.union(aliasSet3);
            AliasSet aliasSet5 = (AliasSet)aliasSet4.find();
            AliasSet aliasSet6 = aliasSet5 == aliasSet4 ? aliasSet3 : aliasSet4;
            aliasSet5.synced = aliasSet5.synced || aliasSet6.synced;
            aliasSet5.addSyncThreads(aliasSet6.syncThreads);
            HashSet hashSet = new HashSet();
            hashSet.addAll(aliasSet6.fieldMap.keySet());
            Set set = aliasSet5.fieldMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                aliasSet2 = (AliasSet)((FastUnionFindElement)aliasSet5.fieldMap.get(string)).find();
                hashSet.remove(string);
                FastUnionFindElement fastUnionFindElement = (FastUnionFindElement)aliasSet6.fieldMap.get(string);
                if (fastUnionFindElement == null) continue;
                aliasSet2.unify((AliasSet)fastUnionFindElement.find());
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                aliasSet2 = (AliasSet)((FastUnionFindElement)aliasSet6.fieldMap.get(string)).find();
                aliasSet5.putASForField(string, aliasSet2);
            }
            if (aliasSet5.global || aliasSet6.global) {
                aliasSet5.setGlobal();
            }
            if (bl) {
                aliasSet5.addSyncThreads(RufsEscapeAnalysis.this.tgi.getExecutionThreads(RufsEscapeAnalysis.this.context.getCurrentMethod()));
            }
        }
    }
}

