/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.RufsEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.CollectionTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Local;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.FieldRef;
import soot.jimple.JimpleBody;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;

public final class RufEATester
extends SootBasedDriver {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufEATester == null ? (class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufEATester = RufEATester.class$("edu.ksu.cis.indus.staticanalyses.concurrency.escape.RufEATester")) : class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufEATester));
    private final String[] args;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$RufEATester;

    private RufEATester(String[] stringArray) {
        this.args = stringArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Please specify a class to consider for the analysis.");
        }
        new RufEATester(stringArray).execute();
    }

    public void writeInfo(Object object) {
        System.out.println(object.toString());
    }

    protected void execute() {
        this.setClassNames(Arrays.asList(this.args));
        this.initialize();
        OFAnalyzer oFAnalyzer = OFAnalyzer.getFSOSAnalyzer("RufEATester", new CollectionTokenManager(new SootValueTypeManager()));
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.rootMethods.iterator();
        while (iterator.hasNext()) {
            arrayList.clear();
            arrayList.add(iterator.next());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: FA analysis");
            }
            long l = System.currentTimeMillis();
            oFAnalyzer.reset();
            oFAnalyzer.analyze(this.scene, arrayList);
            long l2 = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: FA analysis");
            }
            this.addTimeLog("FA analysis", l2 - l);
            ValueAnalyzerBasedProcessingController valueAnalyzerBasedProcessingController = new ValueAnalyzerBasedProcessingController();
            valueAnalyzerBasedProcessingController.setAnalyzer(oFAnalyzer);
            CallGraph callGraph = new CallGraph();
            callGraph.hookup(valueAnalyzerBasedProcessingController);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: FA postprocessing");
            }
            l = System.currentTimeMillis();
            valueAnalyzerBasedProcessingController.process();
            callGraph.unhook(valueAnalyzerBasedProcessingController);
            valueAnalyzerBasedProcessingController.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(callGraph));
            ThreadGraph threadGraph = new ThreadGraph(callGraph, new CFGAnalysis(callGraph, this.bbm));
            threadGraph.hookup(valueAnalyzerBasedProcessingController);
            valueAnalyzerBasedProcessingController.process();
            threadGraph.unhook(valueAnalyzerBasedProcessingController);
            RufsEscapeAnalysis rufsEscapeAnalysis = new RufsEscapeAnalysis(this.scene, callGraph, threadGraph);
            rufsEscapeAnalysis.hookup(valueAnalyzerBasedProcessingController);
            valueAnalyzerBasedProcessingController.process();
            l2 = System.currentTimeMillis();
            rufsEscapeAnalysis.unhook(valueAnalyzerBasedProcessingController);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: FA postprocessing");
            }
            this.addTimeLog("FA postprocessing took ", l2 - l);
            System.out.println("CALL GRAPH:\n" + callGraph.dumpGraph());
            System.out.println("THREAD GRAPH:\n" + threadGraph.dumpGraph());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("BEGIN: " + rufsEscapeAnalysis.getClass().getName() + " processing"));
            }
            l = System.currentTimeMillis();
            rufsEscapeAnalysis.execute();
            l2 = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("END: " + rufsEscapeAnalysis.getClass().getName() + " processing"));
            }
            this.addTimeLog(rufsEscapeAnalysis.getClass().getName(), l2 - l);
            int n = 1;
            HashMap<IThreadGraphInfo.NewExprTriple, String> hashMap = new HashMap<IThreadGraphInfo.NewExprTriple, String>();
            System.out.println("\nThread mapping:");
            Object object = threadGraph.getAllocationSites().iterator();
            while (object.hasNext()) {
                IThreadGraphInfo.NewExprTriple newExprTriple = (IThreadGraphInfo.NewExprTriple)object.next();
                String string = "T" + n++;
                hashMap.put(newExprTriple, string);
                if (newExprTriple.getMethod() == null) {
                    System.out.println(string + " -> " + newExprTriple.getExpr().getType());
                    continue;
                }
                System.out.println(string + " -> " + newExprTriple.getStmt() + "@" + newExprTriple.getMethod());
            }
            object = new HashSet();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.args.length; ++i) {
                SootClass sootClass = this.scene.getSootClass(this.args[i]);
                System.out.println("Info for class " + sootClass.getName() + "\n");
                Iterator iterator2 = CollectionUtils.intersection((Collection)callGraph.getReachableMethods(), (Collection)sootClass.getMethods()).iterator();
                while (iterator2.hasNext()) {
                    SootMethod sootMethod = (SootMethod)iterator2.next();
                    System.out.println("\nInfo for Method " + sootMethod.getSignature());
                    if (sootMethod.isConcrete()) {
                        Local local;
                        JimpleBody jimpleBody = (JimpleBody)sootMethod.retrieveActiveBody();
                        Iterator iterator3 = jimpleBody.getLocals().iterator();
                        while (iterator3.hasNext()) {
                            local = (Local)iterator3.next();
                            System.out.println(" Local " + local + ":" + local.getType() + "\n" + " escapes -> " + rufsEscapeAnalysis.escapes(sootMethod, local) + "\n" + " global -> " + rufsEscapeAnalysis.isGlobal(sootMethod, local));
                        }
                        iterator3 = jimpleBody.getUseAndDefBoxes().iterator();
                        while (iterator3.hasNext()) {
                            local = (ValueBox)iterator3.next();
                            Value value = local.getValue();
                            if (value instanceof ArrayRef || value instanceof FieldRef) {
                                RufsEscapeAnalysis.AliasSet aliasSet = rufsEscapeAnalysis.getAliasSetFor(value, sootMethod);
                                if (aliasSet == null) continue;
                                if (!object.contains(aliasSet = (RufsEscapeAnalysis.AliasSet)aliasSet.find())) {
                                    object.add(aliasSet);
                                }
                                if (!aliasSet.isSynced()) continue;
                                ++n2;
                                continue;
                            }
                            if (!(value instanceof NewExpr) && !(value instanceof NewArrayExpr) && !(value instanceof NewMultiArrayExpr)) continue;
                            ++n3;
                        }
                        continue;
                    }
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info((Object)(sootMethod + " is not a concrete method.  Hence, it's body could not be retrieved."));
                }
            }
            System.out.println("Total number of abstract objects is " + object.size());
            System.out.println("Total number of allocation sites is " + n3);
            System.out.println("Total number of shared accesses based on escape information is " + n2);
            System.out.println("Total classes loaded: " + this.scene.getClasses().size());
            this.printTimingStats();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

