/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.ContainmentPredicate;
import edu.ksu.cis.indus.common.datastructures.FastUnionFindElement;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.MethodContext;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Local;
import soot.Modifier;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.VoidType;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.util.Switch;

public final class EquivalenceClassBasedEscapeAnalysis
extends AbstractValueAnalyzerBasedProcessor {
    public static final String ID = "Shared Access Information";
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis == null ? (class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis = EquivalenceClassBasedEscapeAnalysis.class$("edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis")) : class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis));
    final BasicBlockGraphMgr bbm;
    final CFGAnalysis cfgAnalysis;
    final Collection notifyMethods = new HashSet();
    final Collection waitMethods = new HashSet();
    final Context context;
    final ICallGraphInfo cgi;
    final IThreadGraphInfo tgi;
    final Map globalASs;
    final Map method2Triple;
    final StmtProcessor stmtProcessor;
    final ValueProcessor valueProcessor;
    Map localASsCache;
    Map scCache;
    MethodContext methodCtxtCache;
    private final ContainmentPredicate containmentPredicate = new ContainmentPredicate();
    private Map delayedSet = new HashMap();
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$StmtProcessor;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$ValueProcessor;

    public EquivalenceClassBasedEscapeAnalysis(ICallGraphInfo iCallGraphInfo, IThreadGraphInfo iThreadGraphInfo, BasicBlockGraphMgr basicBlockGraphMgr) {
        this.cgi = iCallGraphInfo;
        this.tgi = iThreadGraphInfo;
        this.globalASs = new HashMap();
        this.method2Triple = new HashMap();
        this.stmtProcessor = new StmtProcessor();
        this.valueProcessor = new ValueProcessor();
        this.bbm = basicBlockGraphMgr;
        this.context = new Context();
        this.cfgAnalysis = new CFGAnalysis(this.cgi, this.bbm);
    }

    public boolean isReadyDependent(InvokeStmt invokeStmt, SootMethod sootMethod, InvokeStmt invokeStmt2, SootMethod sootMethod2) {
        Triple triple = (Triple)this.method2Triple.get(sootMethod);
        if (triple == null) {
            throw new IllegalArgumentException(sootMethod + " was not processed.");
        }
        Triple triple2 = (Triple)this.method2Triple.get(sootMethod2);
        if (triple2 == null) {
            throw new IllegalArgumentException(sootMethod2 + " was not processed.");
        }
        InvokeExpr invokeExpr = invokeStmt.getInvokeExpr();
        InvokeExpr invokeExpr2 = invokeStmt2.getInvokeExpr();
        boolean bl = false;
        if (invokeExpr instanceof VirtualInvokeExpr && invokeExpr2 instanceof VirtualInvokeExpr) {
            VirtualInvokeExpr virtualInvokeExpr = (VirtualInvokeExpr)invokeExpr;
            VirtualInvokeExpr virtualInvokeExpr2 = (VirtualInvokeExpr)invokeExpr2;
            SootMethod sootMethod3 = virtualInvokeExpr.getMethod();
            SootMethod sootMethod4 = virtualInvokeExpr2.getMethod();
            if (this.waitMethods.contains(sootMethod3) && this.notifyMethods.contains(sootMethod4)) {
                AliasSet aliasSet = (AliasSet)((Map)triple.getSecond()).get(virtualInvokeExpr.getBase());
                AliasSet aliasSet2 = (AliasSet)((Map)triple2.getSecond()).get(virtualInvokeExpr2.getBase());
                if (aliasSet.getReadyEntity() != null && aliasSet2.getReadyEntity() != null) {
                    this.containmentPredicate.setContainer(aliasSet2.getReadyEntity());
                    bl = CollectionUtils.exists((Collection)aliasSet.getReadyEntity(), (Predicate)this.containmentPredicate);
                    this.containmentPredicate.setContainer(null);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("There are wait()s and/or notify()s in this program without corresponding notify()s and/or wait()s that occur in different threads - " + virtualInvokeExpr + "@" + sootMethod3 + " " + virtualInvokeExpr2 + "@" + sootMethod4));
                }
            }
        }
        return bl;
    }

    public void analyze() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"BEGIN: Equivalence Class-based and Symbol-based Escape Analysis");
        }
        this.performPhase2();
        this.performPhase3();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"END: Equivalence Class-based and Symbol-based Escape Analysis");
        }
    }

    public void callback(SootField sootField) {
        AliasSet aliasSet;
        if (Modifier.isStatic((int)sootField.getModifiers()) && (aliasSet = AliasSet.getASForType(sootField.getType())) != null) {
            aliasSet.setGlobal();
            this.globalASs.put(sootField.getSignature(), aliasSet);
        }
    }

    public void callback(SootMethod sootMethod) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Update method2Triple for " + sootMethod));
        }
        this.method2Triple.put(sootMethod, new Triple((Object)new MethodContext(sootMethod), new HashMap(), new HashMap()));
        SootClass sootClass = sootMethod.getDeclaringClass();
        if (sootClass.getName().equals("java.lang.Object")) {
            this.waitMethods.add(sootClass.getMethod("void wait()"));
            this.waitMethods.add(sootClass.getMethod("void wait(long)"));
            this.waitMethods.add(sootClass.getMethod("void wait(long,int)"));
            this.notifyMethods.add(sootClass.getMethodByName("notify"));
            this.notifyMethods.add(sootClass.getMethodByName("notifyAll"));
        }
    }

    public boolean escapes(Value value, SootMethod sootMethod) {
        boolean bl;
        block2: {
            bl = true;
            try {
                bl = AliasSet.canHaveAliasSet(value.getType()) ? this.getAliasSetFor(value, sootMethod).escapes() : false;
            }
            catch (NullPointerException nullPointerException) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn((Object)("There is no information about " + value + " occurring in " + sootMethod + ".  So, providing pessimistic info (true)."), (Throwable)nullPointerException);
            }
        }
        return bl;
    }

    public void hookup(ProcessingController processingController) {
        processingController.register((IProcessor)this);
    }

    public void reset() {
        this.globalASs.clear();
        this.method2Triple.clear();
        this.waitMethods.clear();
        this.notifyMethods.clear();
    }

    public boolean shared(Value value, SootMethod sootMethod, Value value2, SootMethod sootMethod2) {
        boolean bl;
        block3: {
            boolean bl2 = bl = this.escapes(value, sootMethod) && this.escapes(value2, sootMethod2);
            if (bl && !(value instanceof StaticFieldRef) && !(value2 instanceof StaticFieldRef)) {
                try {
                    Collection collection = this.getAliasSetFor(value, sootMethod).getShareEntities();
                    Collection collection2 = this.getAliasSetFor(value2, sootMethod2).getShareEntities();
                    bl = collection != null && collection2 != null && !CollectionUtils.intersection((Collection)collection, (Collection)collection2).isEmpty();
                }
                catch (NullPointerException nullPointerException) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn((Object)("There is no information about " + value + "/" + value2 + " occurring in " + sootMethod + "/" + sootMethod2 + ".  So, providing pessimistic info (true)."), (Throwable)nullPointerException);
                }
            }
        }
        return bl;
    }

    public boolean thisEscapes(SootMethod sootMethod) {
        boolean bl = true;
        Triple triple = (Triple)this.method2Triple.get(sootMethod);
        if (triple == null && LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)("There is no information about " + sootMethod + ".  So, providing pessimistic info (true)."));
        } else {
            AliasSet aliasSet = ((MethodContext)triple.getFirst()).getThisAS();
            if (aliasSet != null) {
                bl = aliasSet.escapes();
            }
        }
        return bl;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("method2Triple", (Object)this.method2Triple).toString();
    }

    public void unhook(ProcessingController processingController) {
        processingController.unregister((IProcessor)this);
    }

    AliasSet getAliasSetFor(Value value, SootMethod sootMethod) {
        Triple triple = (Triple)this.method2Triple.get(sootMethod);
        if (triple == null) {
            throw new IllegalArgumentException("Method " + sootMethod + " was not analyzed.");
        }
        Map map = (Map)triple.getSecond();
        AliasSet aliasSet = null;
        if (AliasSet.canHaveAliasSet(value.getType())) {
            if (value instanceof InstanceFieldRef) {
                InstanceFieldRef instanceFieldRef = (InstanceFieldRef)value;
                AliasSet aliasSet2 = (AliasSet)map.get(instanceFieldRef.getBase());
                aliasSet = aliasSet2.getASForField(((FieldRef)value).getField().getSignature());
            } else if (value instanceof StaticFieldRef) {
                aliasSet = (AliasSet)this.globalASs.get(((FieldRef)value).getField().getSignature());
            } else if (value instanceof ArrayRef) {
                ArrayRef arrayRef = (ArrayRef)value;
                AliasSet aliasSet3 = (AliasSet)map.get(arrayRef.getBase());
                aliasSet = aliasSet3.getASForField("$ELT");
            } else if (value instanceof Local) {
                aliasSet = (AliasSet)map.get(value);
            }
        }
        return aliasSet;
    }

    boolean isGlobal(Value value, SootMethod sootMethod) {
        boolean bl;
        block2: {
            bl = true;
            try {
                bl = AliasSet.canHaveAliasSet(value.getType()) ? this.getAliasSetFor(value, sootMethod).isGlobal() : false;
            }
            catch (NullPointerException nullPointerException) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn((Object)("There is no information about " + value + " occurring in " + sootMethod + ".  So, providing pessimistic info (true)."), (Throwable)nullPointerException);
            }
        }
        return bl;
    }

    void addToDelayedUnificationSet(MethodContext methodContext, MethodContext methodContext2) {
        CollectionsUtilities.putIntoSetInMap((Map)this.delayedSet, (Object)methodContext, (Object)methodContext2);
    }

    private void discardReferentialAliasSetv2s(SootMethod sootMethod) {
        AliasSet aliasSet;
        FastUnionFindElement fastUnionFindElement;
        Map.Entry entry;
        Iterator iterator;
        if (this.localASsCache.isEmpty()) {
            this.localASsCache = Collections.EMPTY_MAP;
        } else {
            iterator = this.localASsCache.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                fastUnionFindElement = (AliasSet)entry.getValue();
                aliasSet = (AliasSet)fastUnionFindElement.find();
                if (aliasSet == fastUnionFindElement) continue;
                entry.setValue(aliasSet);
            }
        }
        if (this.scCache.isEmpty()) {
            this.scCache = Collections.EMPTY_MAP;
        } else {
            iterator = this.scCache.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                fastUnionFindElement = (MethodContext)entry.getValue();
                aliasSet = fastUnionFindElement.find();
                if (aliasSet != fastUnionFindElement) {
                    entry.setValue(aliasSet);
                    continue;
                }
                fastUnionFindElement.discardReferentialAliasSets();
            }
        }
        this.method2Triple.put(sootMethod, new Triple((Object)this.methodCtxtCache, (Object)this.localASsCache, (Object)this.scCache));
    }

    private void performDelayedUnification() {
        Iterator iterator = this.delayedSet.keySet().iterator();
        while (iterator.hasNext()) {
            MethodContext methodContext = (MethodContext)iterator.next();
            Iterator iterator2 = ((Collection)this.delayedSet.get(methodContext)).iterator();
            while (iterator2.hasNext()) {
                MethodContext methodContext2 = (MethodContext)iterator2.next();
                methodContext.unify(methodContext2);
            }
        }
        this.delayedSet.clear();
    }

    private void performPhase2() {
        HashSet hashSet = new HashSet();
        HistoryAwareFIFOWorkBag historyAwareFIFOWorkBag = new HistoryAwareFIFOWorkBag(hashSet);
        List list = this.cgi.getSCCs(false);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod = (SootMethod)iterator2.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Bottom-up processing method " + sootMethod));
                }
                if (!sootMethod.isConcrete()) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn((Object)("NO BODY: " + sootMethod.getSignature()));
                    continue;
                }
                Triple triple = (Triple)this.method2Triple.get(sootMethod);
                if (triple == null) {
                    LOGGER.error((Object)("NO METHOD TRIPLE: " + sootMethod.getSignature()));
                    continue;
                }
                this.methodCtxtCache = (MethodContext)triple.getFirst();
                this.localASsCache = (Map)triple.getSecond();
                this.scCache = (Map)triple.getThird();
                this.context.setRootMethod(sootMethod);
                BasicBlockGraph basicBlockGraph = this.bbm.getBasicBlockGraph(sootMethod);
                historyAwareFIFOWorkBag.clear();
                hashSet.clear();
                historyAwareFIFOWorkBag.addAllWork(basicBlockGraph.getHeads());
                while (historyAwareFIFOWorkBag.hasWork()) {
                    Object object;
                    BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)historyAwareFIFOWorkBag.getWork();
                    Iterator iterator3 = basicBlock.getStmtsOf().iterator();
                    while (iterator3.hasNext()) {
                        object = (Stmt)iterator3.next();
                        this.context.setStmt(object);
                        this.stmtProcessor.process((Stmt)object);
                    }
                    iterator3 = basicBlock.getSuccsOf().iterator();
                    while (iterator3.hasNext()) {
                        object = iterator3.next();
                        historyAwareFIFOWorkBag.addWorkNoDuplicates(object);
                    }
                }
                this.performDelayedUnification();
                this.discardReferentialAliasSetv2s(sootMethod);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("LocalASsCache: " + triple.getSecond()));
            }
        }
    }

    private void performPhase3() {
        HashSet hashSet = new HashSet();
        HistoryAwareFIFOWorkBag historyAwareFIFOWorkBag = new HistoryAwareFIFOWorkBag(hashSet);
        historyAwareFIFOWorkBag.addAllWork(this.cgi.getHeads());
        while (historyAwareFIFOWorkBag.hasWork()) {
            SootMethod sootMethod = (SootMethod)historyAwareFIFOWorkBag.getWork();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Top-down processing method : CALLER : " + sootMethod));
            }
            Collection collection = this.cgi.getCallees(sootMethod);
            Triple triple = (Triple)this.method2Triple.get(sootMethod);
            Map map = (Map)triple.getThird();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ICallGraphInfo.CallTriple callTriple = (ICallGraphInfo.CallTriple)iterator.next();
                SootMethod sootMethod2 = callTriple.getMethod();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Top-down processing : CALLEE : " + sootMethod2));
                }
                if ((triple = (Triple)this.method2Triple.get(sootMethod2)) == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("NO CALLEE TRIPLE: " + sootMethod2.getSignature()));
                    continue;
                }
                MethodContext methodContext = (MethodContext)triple.getFirst();
                ICallGraphInfo.CallTriple callTriple2 = new ICallGraphInfo.CallTriple(sootMethod, callTriple.getStmt(), callTriple.getExpr());
                MethodContext methodContext2 = (MethodContext)map.get(callTriple2);
                if (sootMethod2.getName().equals("start") && sootMethod2.getDeclaringClass().getName().equals("java.lang.Thread") && sootMethod2.getReturnType() instanceof VoidType && sootMethod2.getParameterCount() == 0 && this.cfgAnalysis.executedMultipleTimes(callTriple.getStmt(), sootMethod)) {
                    methodContext2.selfUnify();
                }
                methodContext2.propogateInfoFromTo(methodContext);
                historyAwareFIFOWorkBag.addWorkNoDuplicates((Object)sootMethod2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class ValueProcessor
    extends AbstractJimpleValueSwitch {
        boolean read = true;
        private final Log valueProcessorLogger = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$ValueProcessor == null ? (class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$ValueProcessor = EquivalenceClassBasedEscapeAnalysis.class$("edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis$ValueProcessor")) : class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$ValueProcessor));

        ValueProcessor() {
        }

        public void caseArrayRef(ArrayRef arrayRef) {
            boolean bl = this.read;
            this.read = true;
            arrayRef.getBase().apply((Switch)this);
            this.read = bl;
            AliasSet aliasSet = (AliasSet)this.getResult();
            AliasSet aliasSet2 = aliasSet.getASForField("$ELT");
            if (aliasSet2 == null && (aliasSet2 = AliasSet.getASForType(arrayRef.getType())) != null) {
                aliasSet.putASForField("$ELT", aliasSet2);
            }
            if (aliasSet2 != null) {
                aliasSet2.setAccessedTo(true);
                this.setReadOrWritten(aliasSet2);
            }
            this.setResult(aliasSet2);
        }

        public void caseCastExpr(CastExpr castExpr) {
            this.process(castExpr.getOp());
        }

        public void caseInstanceFieldRef(InstanceFieldRef instanceFieldRef) {
            boolean bl = this.read;
            this.read = true;
            instanceFieldRef.getBase().apply((Switch)this);
            this.read = bl;
            AliasSet aliasSet = (AliasSet)this.getResult();
            String string = instanceFieldRef.getField().getSignature();
            AliasSet aliasSet2 = aliasSet.getASForField(string);
            if (aliasSet2 == null && (aliasSet2 = AliasSet.getASForType(instanceFieldRef.getType())) != null) {
                aliasSet.putASForField(string, aliasSet2);
            }
            if (aliasSet2 != null) {
                aliasSet2.setAccessedTo(true);
                this.setReadOrWritten(aliasSet2);
            }
            this.setResult(aliasSet2);
        }

        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr interfaceInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)interfaceInvokeExpr);
        }

        public void caseLocal(Local local) {
            AliasSet aliasSet = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.localASsCache.get(local);
            if (aliasSet == null && (aliasSet = AliasSet.getASForType(local.getType())) != null) {
                EquivalenceClassBasedEscapeAnalysis.this.localASsCache.put(local, aliasSet);
            }
            if (aliasSet != null) {
                aliasSet.setAccessedTo(true);
                this.setReadOrWritten(aliasSet);
            }
            this.setResult(aliasSet);
        }

        public void caseParameterRef(ParameterRef parameterRef) {
            AliasSet aliasSet = EquivalenceClassBasedEscapeAnalysis.this.methodCtxtCache.getParamAS(parameterRef.getIndex());
            this.setReadOrWritten(aliasSet);
            this.setResult(aliasSet);
        }

        public void caseSpecialInvokeExpr(SpecialInvokeExpr specialInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)specialInvokeExpr);
        }

        public void caseStaticFieldRef(StaticFieldRef staticFieldRef) {
            this.setResult(EquivalenceClassBasedEscapeAnalysis.this.globalASs.get(staticFieldRef.getField().getSignature()));
        }

        public void caseStaticInvokeExpr(StaticInvokeExpr staticInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)staticInvokeExpr);
        }

        public void caseStringConstant(StringConstant stringConstant) {
            this.setResult(AliasSet.getASForType(stringConstant.getType()));
        }

        public void caseThisRef(ThisRef thisRef) {
            AliasSet aliasSet = EquivalenceClassBasedEscapeAnalysis.this.methodCtxtCache.getThisAS();
            this.setReadOrWritten(aliasSet);
            this.setResult(aliasSet);
        }

        public void caseVirtualInvokeExpr(VirtualInvokeExpr virtualInvokeExpr) {
            this.processInvokeExpr((InvokeExpr)virtualInvokeExpr);
        }

        public void defaultCase(Object object) {
            if (object instanceof Value) {
                this.setResult(AliasSet.getASForType(((Value)object).getType()));
            } else {
                this.setResult(null);
            }
        }

        void process(Value value) {
            if (this.valueProcessorLogger.isDebugEnabled()) {
                this.valueProcessorLogger.debug((Object)("Processing value: " + value));
            }
            value.apply((Switch)this);
        }

        private void setReadOrWritten(AliasSet aliasSet) {
            if (aliasSet != null) {
                if (this.read) {
                    aliasSet.setRead();
                } else {
                    aliasSet.setWritten();
                }
            }
        }

        private List processArguments(InvokeExpr invokeExpr, SootMethod sootMethod) {
            ArrayList<Object> arrayList;
            int n = sootMethod.getParameterCount();
            if (n == 0) {
                arrayList = Collections.EMPTY_LIST;
            } else {
                arrayList = new ArrayList<Object>();
                for (int i = 0; i < n; ++i) {
                    Value value = invokeExpr.getArg(i);
                    Object object = null;
                    if (AliasSet.canHaveAliasSet(value.getType())) {
                        invokeExpr.getArg(i).apply((Switch)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor);
                        object = EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
                    }
                    arrayList.add(object);
                }
            }
            return arrayList;
        }

        private void processCallees(Collection collection, SootMethod sootMethod, AliasSet aliasSet, MethodContext methodContext) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SootMethod sootMethod2 = (SootMethod)iterator.next();
                Triple triple = (Triple)EquivalenceClassBasedEscapeAnalysis.this.method2Triple.get(sootMethod2);
                if (triple == null) {
                    if (!this.valueProcessorLogger.isDebugEnabled()) continue;
                    this.valueProcessorLogger.debug((Object)("NO TRIPLE.  May be due to open system. - " + sootMethod2.getSignature()));
                    continue;
                }
                boolean bl = this.processNotifyStartWait(aliasSet, sootMethod2);
                MethodContext methodContext2 = (MethodContext)triple.getFirst();
                if (EquivalenceClassBasedEscapeAnalysis.this.cfgAnalysis.notInSameSCC(sootMethod, sootMethod2)) {
                    try {
                        methodContext2 = (MethodContext)methodContext2.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        this.valueProcessorLogger.error((Object)"Hell NO!  This should not happen.", (Throwable)cloneNotSupportedException);
                        throw new RuntimeException(cloneNotSupportedException);
                    }
                }
                if (bl) {
                    methodContext2.markMultiThreadAccess();
                    EquivalenceClassBasedEscapeAnalysis.this.addToDelayedUnificationSet(methodContext, methodContext2);
                    continue;
                }
                methodContext.unify(methodContext2);
            }
        }

        private void processInvokeExpr(InvokeExpr invokeExpr) {
            ArrayList<SootMethod> arrayList = new ArrayList<SootMethod>();
            SootMethod sootMethod = EquivalenceClassBasedEscapeAnalysis.this.context.getCurrentMethod();
            SootMethod sootMethod2 = invokeExpr.getMethod();
            AliasSet aliasSet = null;
            aliasSet = AliasSet.getASForType(sootMethod2.getReturnType());
            AliasSet aliasSet2 = null;
            if (!sootMethod2.isStatic()) {
                ((InstanceInvokeExpr)invokeExpr).getBase().apply((Switch)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor);
                aliasSet2 = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
            }
            List list = this.processArguments(invokeExpr, sootMethod2);
            MethodContext methodContext = new MethodContext(sootMethod2, aliasSet2, list, aliasSet, AliasSet.createAliasSet());
            EquivalenceClassBasedEscapeAnalysis.this.scCache.put(new ICallGraphInfo.CallTriple(sootMethod, EquivalenceClassBasedEscapeAnalysis.this.context.getStmt(), invokeExpr), methodContext);
            if (invokeExpr instanceof StaticInvokeExpr) {
                arrayList.add(sootMethod2);
            } else if (invokeExpr instanceof InterfaceInvokeExpr || invokeExpr instanceof VirtualInvokeExpr || invokeExpr instanceof SpecialInvokeExpr) {
                EquivalenceClassBasedEscapeAnalysis.this.context.setProgramPoint(((InstanceInvokeExpr)invokeExpr).getBaseBox());
                arrayList.addAll(EquivalenceClassBasedEscapeAnalysis.this.cgi.getCallees(invokeExpr, EquivalenceClassBasedEscapeAnalysis.this.context));
            }
            this.processCallees(arrayList, sootMethod, aliasSet2, methodContext);
            this.setResult(aliasSet);
        }

        private boolean processNotifyStartWait(AliasSet aliasSet, SootMethod sootMethod) {
            boolean bl = false;
            if (sootMethod.getName().equals("start") && sootMethod.getDeclaringClass().getName().equals("java.lang.Thread") && sootMethod.getReturnType() instanceof VoidType && sootMethod.getParameterCount() == 0) {
                bl = true;
            } else if (sootMethod.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (EquivalenceClassBasedEscapeAnalysis.this.waitMethods.contains(sootMethod)) {
                    aliasSet.setWaits();
                } else if (EquivalenceClassBasedEscapeAnalysis.this.notifyMethods.contains(sootMethod)) {
                    aliasSet.setNotifies();
                }
            }
            return bl;
        }
    }

    final class StmtProcessor
    extends AbstractStmtSwitch {
        private final Log stmtProcessorLogger = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$StmtProcessor == null ? (class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$StmtProcessor = EquivalenceClassBasedEscapeAnalysis.class$("edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis$StmtProcessor")) : class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EquivalenceClassBasedEscapeAnalysis$StmtProcessor));

        StmtProcessor() {
        }

        public void caseAssignStmt(AssignStmt assignStmt) {
            boolean bl = EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = true;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(assignStmt.getRightOp());
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = bl;
            AliasSet aliasSet = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
            bl = EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = false;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(assignStmt.getLeftOp());
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = bl;
            AliasSet aliasSet2 = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet != null && aliasSet2 != null) {
                aliasSet2.unify(aliasSet);
            }
        }

        public void caseEnterMonitorStmt(EnterMonitorStmt enterMonitorStmt) {
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(enterMonitorStmt.getOp());
        }

        public void caseExitMonitorStmt(ExitMonitorStmt exitMonitorStmt) {
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(exitMonitorStmt.getOp());
        }

        public void caseIdentityStmt(IdentityStmt identityStmt) {
            boolean bl = EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = true;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(identityStmt.getRightOp());
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = bl;
            AliasSet aliasSet = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
            bl = EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = false;
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(identityStmt.getLeftOp());
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.read = bl;
            AliasSet aliasSet2 = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet != null && aliasSet2 != null) {
                aliasSet2.unify(aliasSet);
            }
        }

        public void caseInvokeStmt(InvokeStmt invokeStmt) {
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process((Value)invokeStmt.getInvokeExpr());
        }

        public void caseReturnStmt(ReturnStmt returnStmt) {
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(returnStmt.getOp());
            AliasSet aliasSet = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet != null) {
                EquivalenceClassBasedEscapeAnalysis.this.methodCtxtCache.getReturnAS().unify(aliasSet);
            }
        }

        public void caseThrowStmt(ThrowStmt throwStmt) {
            EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.process(throwStmt.getOp());
            AliasSet aliasSet = (AliasSet)EquivalenceClassBasedEscapeAnalysis.this.valueProcessor.getResult();
            if (aliasSet != null) {
                EquivalenceClassBasedEscapeAnalysis.this.methodCtxtCache.getThrownAS().unify(aliasSet);
            }
        }

        void process(Stmt stmt) {
            if (this.stmtProcessorLogger.isDebugEnabled()) {
                this.stmtProcessorLogger.debug((Object)("Processing statement: " + stmt));
            }
            stmt.apply((Switch)this);
        }
    }
}

