/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.concurrency.escape;

import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.AliasSet;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.CallGraph;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.CollectionTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.SootValueTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Local;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.FieldRef;
import soot.jimple.JimpleBody;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;

public final class EADriver
extends SootBasedDriver {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EADriver == null ? (class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EADriver = EADriver.class$("edu.ksu.cis.indus.staticanalyses.concurrency.escape.EADriver")) : class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EADriver));
    private String[] args;
    static /* synthetic */ Class class$edu$ksu$cis$indus$staticanalyses$concurrency$escape$EADriver;

    private EADriver(String[] stringArray) {
        this.args = stringArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Please specify a class to consider for the analysis.");
        }
        new EADriver(stringArray).execute();
    }

    public void writeInfo(Object object) {
        if (object != null) {
            System.out.println(object.toString());
        } else {
            System.out.println("null");
        }
    }

    protected void execute() {
        this.setClassNames(Arrays.asList(this.args));
        this.initialize();
        OFAnalyzer oFAnalyzer = OFAnalyzer.getFSOSAnalyzer("EADriver:FA", new CollectionTokenManager(new SootValueTypeManager()));
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.rootMethods.iterator();
        while (iterator.hasNext()) {
            arrayList.clear();
            arrayList.add(iterator.next());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: FA analysis");
            }
            long l = System.currentTimeMillis();
            oFAnalyzer.reset();
            oFAnalyzer.analyze(this.scene, arrayList);
            long l2 = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: FA analysis");
            }
            this.addTimeLog("FA analysis", l2 - l);
            ValueAnalyzerBasedProcessingController valueAnalyzerBasedProcessingController = new ValueAnalyzerBasedProcessingController();
            valueAnalyzerBasedProcessingController.setAnalyzer(oFAnalyzer);
            valueAnalyzerBasedProcessingController.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("EADriver:FA"));
            CallGraph callGraph = new CallGraph();
            callGraph.hookup(valueAnalyzerBasedProcessingController);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"BEGIN: FA postprocessing");
            }
            l = System.currentTimeMillis();
            valueAnalyzerBasedProcessingController.process();
            callGraph.unhook(valueAnalyzerBasedProcessingController);
            valueAnalyzerBasedProcessingController.reset();
            valueAnalyzerBasedProcessingController.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(callGraph));
            valueAnalyzerBasedProcessingController.setAnalyzer(oFAnalyzer);
            ThreadGraph threadGraph = new ThreadGraph(callGraph, new CFGAnalysis(callGraph, this.bbm));
            threadGraph.hookup(valueAnalyzerBasedProcessingController);
            valueAnalyzerBasedProcessingController.process();
            threadGraph.unhook(valueAnalyzerBasedProcessingController);
            EquivalenceClassBasedEscapeAnalysis equivalenceClassBasedEscapeAnalysis = new EquivalenceClassBasedEscapeAnalysis(callGraph, threadGraph, this.bbm);
            equivalenceClassBasedEscapeAnalysis.hookup(valueAnalyzerBasedProcessingController);
            valueAnalyzerBasedProcessingController.process();
            l2 = System.currentTimeMillis();
            equivalenceClassBasedEscapeAnalysis.unhook(valueAnalyzerBasedProcessingController);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"END: FA postprocessing");
            }
            this.addTimeLog("FA postprocessing took ", l2 - l);
            System.out.println("CALL GRAPH:\n" + callGraph.dumpGraph());
            System.out.println("THREAD GRAPH:\n" + threadGraph.dumpGraph());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("BEGIN: " + equivalenceClassBasedEscapeAnalysis.getClass().getName() + " processing"));
            }
            l = System.currentTimeMillis();
            equivalenceClassBasedEscapeAnalysis.analyze();
            l2 = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("END: " + equivalenceClassBasedEscapeAnalysis.getClass().getName() + " processing"));
            }
            this.addTimeLog(equivalenceClassBasedEscapeAnalysis.getClass().getName(), l2 - l);
            HashSet<AliasSet> hashSet = new HashSet<AliasSet>();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.args.length; ++i) {
                SootClass sootClass = this.scene.getSootClass(this.args[i]);
                System.out.println("Info for class " + sootClass.getName() + "\n");
                Iterator iterator2 = CollectionUtils.intersection((Collection)callGraph.getReachableMethods(), (Collection)sootClass.getMethods()).iterator();
                while (iterator2.hasNext()) {
                    Local local;
                    SootMethod sootMethod = (SootMethod)iterator2.next();
                    System.out.println("\nInfo for Method " + sootMethod.getSignature());
                    if (!sootMethod.isConcrete()) {
                        if (!LOGGER.isInfoEnabled()) continue;
                        LOGGER.info((Object)(sootMethod + " is not a concrete method.  Hence, it's body could not be retrieved."));
                        continue;
                    }
                    JimpleBody jimpleBody = (JimpleBody)sootMethod.retrieveActiveBody();
                    Iterator iterator3 = jimpleBody.getLocals().iterator();
                    while (iterator3.hasNext()) {
                        local = (Local)iterator3.next();
                        System.out.println(" Local " + local + ":" + local.getType() + "\n" + " escapes -> " + equivalenceClassBasedEscapeAnalysis.escapes((Value)local, sootMethod) + "\n" + " global -> " + equivalenceClassBasedEscapeAnalysis.isGlobal((Value)local, sootMethod));
                    }
                    iterator3 = jimpleBody.getUseAndDefBoxes().iterator();
                    while (iterator3.hasNext()) {
                        local = (ValueBox)iterator3.next();
                        Value value = local.getValue();
                        if (value instanceof ArrayRef || value instanceof FieldRef) {
                            AliasSet aliasSet = equivalenceClassBasedEscapeAnalysis.getAliasSetFor(value, sootMethod);
                            if (aliasSet == null) continue;
                            if (!hashSet.contains(aliasSet = aliasSet.find())) {
                                hashSet.add(aliasSet);
                            }
                            if (!equivalenceClassBasedEscapeAnalysis.escapes(value, sootMethod)) continue;
                            ++n;
                            continue;
                        }
                        if (!(value instanceof NewExpr) && !(value instanceof NewArrayExpr) && !(value instanceof NewMultiArrayExpr)) continue;
                        ++n2;
                    }
                }
            }
            System.out.println("Total number of abstract objects is " + hashSet.size());
            System.out.println("Total numbef of allocation sites is " + n2);
            System.out.println("Total number of shared accesses based on escape information is " + n);
            System.out.println("Total classes loaded: " + this.scene.getClasses().size());
            this.printTimingStats();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

