/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.cfg;

import edu.ksu.cis.indus.common.CollectionsUtilities;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import soot.Body;
import soot.Local;
import soot.PatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

public final class LocalUseDefAnalysis {
    private final Map defInfo = new HashMap();
    private final Map useInfo = new HashMap();
    private List stmtList;
    private UnitGraph unitGraph;

    public LocalUseDefAnalysis(UnitGraph unitGraph) {
        Body body = unitGraph.getBody();
        PatchingChain patchingChain = body.getUnits();
        BitSet[][] bitSetArray = new BitSet[patchingChain.size()][body.getLocalCount()];
        this.stmtList = new ArrayList();
        this.stmtList.addAll(patchingChain);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(body.getLocals());
        this.unitGraph = unitGraph;
        this.analyze(bitSetArray, arrayList);
        this.extract(bitSetArray, arrayList);
        this.unitGraph = null;
        this.stmtList = null;
    }

    public Collection getDefsOf(Local local, Stmt stmt) {
        return Collections.unmodifiableCollection((Collection)MapUtils.getObject((Map)this.defInfo, (Object)new Pair((Object)local, (Object)stmt), (Object)Collections.EMPTY_LIST));
    }

    public Collection getDefsOf(Pair pair) {
        return Collections.unmodifiableCollection((Collection)MapUtils.getObject((Map)this.defInfo, (Object)pair, (Object)Collections.EMPTY_LIST));
    }

    public Collection getUsesOf(Stmt stmt) {
        return (Collection)MapUtils.getObject((Map)this.useInfo, (Object)stmt, (Object)Collections.EMPTY_LIST);
    }

    private void analyze(BitSet[][] bitSetArray, List list) {
        FIFOWorkBag fIFOWorkBag = new FIFOWorkBag();
        BitSet bitSet = new BitSet();
        HashMap hashMap = new HashMap();
        fIFOWorkBag.addAllWork(this.seedDefInfo(bitSetArray, list, hashMap));
        while (fIFOWorkBag.hasWork()) {
            Value value;
            Stmt stmt = (Stmt)fIFOWorkBag.getWork();
            BitSet[] bitSetArray2 = bitSetArray[this.stmtList.indexOf(stmt)];
            Collection collection = (Collection)hashMap.get(stmt);
            if (stmt instanceof DefinitionStmt && (value = ((DefinitionStmt)stmt).getLeftOp()) instanceof Local) {
                collection.remove(new Integer(list.indexOf(value)));
            }
            value = collection.iterator();
            while (value.hasNext()) {
                Integer n = (Integer)value.next();
                int n2 = n;
                BitSet bitSet2 = bitSetArray2[n2];
                Iterator iterator = this.unitGraph.getSuccsOf((Object)stmt).iterator();
                while (iterator.hasNext()) {
                    Stmt stmt2 = (Stmt)iterator.next();
                    int n3 = this.stmtList.indexOf(stmt2);
                    BitSet[] bitSetArray3 = bitSetArray[n3];
                    if (bitSetArray3[n2] == null) {
                        bitSetArray3[n2] = new BitSet();
                    }
                    bitSet.clear();
                    bitSet.or(bitSet2);
                    bitSet.andNot(bitSetArray3[n2]);
                    if (bitSet.cardinality() <= 0) continue;
                    bitSetArray3[n2].or(bitSet2);
                    fIFOWorkBag.addWorkNoDuplicates((Object)stmt2);
                    ((Collection)hashMap.get(stmt2)).add(n);
                }
            }
            collection.clear();
        }
    }

    private void extract(BitSet[][] bitSetArray, List list) {
        ArrayList arrayList = new ArrayList();
        Pair.PairManager pairManager = new Pair.PairManager();
        Iterator iterator = this.unitGraph.iterator();
        while (iterator.hasNext()) {
            Stmt stmt = (Stmt)iterator.next();
            int n = this.stmtList.indexOf(stmt);
            BitSet[] bitSetArray2 = bitSetArray[n];
            Iterator iterator2 = stmt.getUseBoxes().iterator();
            while (iterator2.hasNext()) {
                Local local;
                int n2;
                BitSet bitSet;
                ValueBox valueBox = (ValueBox)iterator2.next();
                if (!(valueBox.getValue() instanceof Local) || (bitSet = bitSetArray2[n2 = list.indexOf(local = (Local)valueBox.getValue())]) == null || bitSet.isEmpty()) continue;
                arrayList.clear();
                int n3 = bitSet.nextSetBit(0);
                while (n3 >= 0) {
                    Object e = this.stmtList.get(n3);
                    arrayList.add(e);
                    CollectionsUtilities.getListFromMap((Map)this.useInfo, e).add(stmt);
                    n3 = bitSet.nextSetBit(n3 + 1);
                }
                CollectionsUtilities.putAllIntoSetInMap((Map)this.defInfo, (Object)pairManager.getUnOptimizedPair((Object)local, (Object)stmt), arrayList);
            }
        }
    }

    private Collection seedDefInfo(BitSet[][] bitSetArray, List list, Map map) {
        Stmt stmt;
        ArrayList<Stmt> arrayList = new ArrayList<Stmt>();
        ArrayList<Stmt> arrayList2 = new ArrayList<Stmt>();
        Iterator iterator = this.unitGraph.iterator();
        while (iterator.hasNext()) {
            stmt = (Stmt)iterator.next();
            map.put(stmt, new HashSet());
            if (!(stmt instanceof DefinitionStmt)) continue;
            arrayList2.add(stmt);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            stmt = (Stmt)iterator.next();
            Value value = ((DefinitionStmt)stmt).getLeftOp();
            if (!(value instanceof Local)) continue;
            int n = list.indexOf(value);
            int n2 = this.stmtList.indexOf(stmt);
            Iterator iterator2 = this.unitGraph.getSuccsOf((Object)stmt).iterator();
            while (iterator2.hasNext()) {
                Stmt stmt2 = (Stmt)iterator2.next();
                int n3 = this.stmtList.indexOf(stmt2);
                BitSet bitSet = bitSetArray[n3][n];
                if (bitSet == null) {
                    bitSetArray[n3][n] = bitSet = new BitSet();
                }
                bitSet.set(n2, true);
                arrayList.add(stmt2);
                ((Collection)map.get(stmt2)).add(new Integer(n));
            }
        }
        return arrayList;
    }
}

