/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.cfg;

import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import soot.SootMethod;
import soot.jimple.Stmt;

public final class CFGAnalysis {
    private final BasicBlockGraphMgr bbm;
    private final ICallGraphInfo cgi;

    public CFGAnalysis(ICallGraphInfo iCallGraphInfo, BasicBlockGraphMgr basicBlockGraphMgr) {
        this.cgi = iCallGraphInfo;
        this.bbm = basicBlockGraphMgr;
    }

    public boolean checkForLoopEnclosedNewExpr(Stmt stmt, SootMethod sootMethod) {
        boolean bl = false;
        BasicBlockGraph basicBlockGraph = this.bbm.getBasicBlockGraph(sootMethod);
        if (this.occursInCycle((IDirectedGraph)basicBlockGraph, basicBlockGraph.getEnclosingBlock(stmt))) {
            bl = true;
        }
        return bl;
    }

    public boolean executedMultipleTimes(Stmt stmt, SootMethod sootMethod) {
        BasicBlockGraph basicBlockGraph = this.bbm.getBasicBlockGraph(sootMethod);
        return this.occursInCycle((IDirectedGraph)basicBlockGraph, basicBlockGraph.getEnclosingBlock(stmt)) || this.executedMultipleTimes(sootMethod);
    }

    public boolean executedMultipleTimes(SootMethod sootMethod) {
        boolean bl;
        block4: {
            bl = false;
            Collection collection = this.cgi.getCallers(sootMethod);
            if (collection.size() > 1) {
                bl = true;
            } else if (collection.size() == 1) {
                Collection collection2;
                ICallGraphInfo.CallTriple callTriple = this.cgi.getSCCs(true).iterator();
                while (callTriple.hasNext()) {
                    collection2 = (Collection)callTriple.next();
                    if (!collection2.contains(sootMethod) || collection2.size() <= 1) continue;
                    bl = true;
                    break block4;
                }
                callTriple = (ICallGraphInfo.CallTriple)collection.iterator().next();
                collection2 = callTriple.getMethod();
                BasicBlockGraph basicBlockGraph = this.bbm.getBasicBlockGraph((SootMethod)collection2);
                bl = this.occursInCycle((IDirectedGraph)basicBlockGraph, basicBlockGraph.getEnclosingBlock(callTriple.getStmt())) ? true : this.executedMultipleTimes((SootMethod)collection2);
            }
        }
        return bl;
    }

    public boolean notInSameSCC(SootMethod sootMethod, SootMethod sootMethod2) {
        boolean bl = true;
        List list = this.cgi.getSCCs(true);
        Collection collection = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !(collection = (Collection)iterator.next()).contains(sootMethod)) {
            collection = null;
        }
        if (collection != null) {
            bl = !collection.contains(sootMethod2);
        }
        return bl;
    }

    public boolean occursInCycle(IDirectedGraph iDirectedGraph, BasicBlockGraph.BasicBlock basicBlock) {
        return iDirectedGraph.isReachable((INode)basicBlock, (INode)basicBlock, true);
    }
}

