/*
 * Decompiled with CFR 0.152.
 */
package org.znerd.xmlenc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.znerd.xmlenc.InvalidXMLException;
import org.znerd.xmlenc.SevenBitXMLEncoder;
import org.znerd.xmlenc.UnicodeXMLEncoder;
import org.znerd.xmlenc.XMLChecker;

public abstract class XMLEncoder {
    private static final char CHAR_TAB_9 = '\t';
    private static final char CHAR_LF_10 = '\n';
    private static final char CHAR_CR_13 = '\r';
    private static final char CHAR_31 = '\u001f';
    private static final char CHAR_QUOTE_34 = '\"';
    private static final char CHAR_AMPERSAND_38 = '&';
    private static final char CHAR_APOSTROPHE_39 = '\'';
    private static final char CHAR_LESS_THAN_60 = '<';
    private static final char CHAR_GREATER_THAN_62 = '>';

    public static final XMLEncoder getEncoder(String string) throws IllegalArgumentException, UnsupportedEncodingException {
        if (string == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        if ("UTF-8".equalsIgnoreCase(string) || "UTF-16".equalsIgnoreCase(string) || "ISO-10646-UCS-2".equalsIgnoreCase(string) || "ISO-10646-UCS-4".equalsIgnoreCase(string) || "ISO-10646-UTF-1".equalsIgnoreCase(string)) {
            return new UnicodeXMLEncoder(string);
        }
        if ("US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string) || string.startsWith("iso-8859-") || string.startsWith("isO-8859-") || string.startsWith("iSo-8859-") || string.startsWith("iSO-8859-") || string.startsWith("Iso-8859-") || string.startsWith("IsO-8859-") || string.startsWith("ISo-8859-") || string.startsWith("ISO-8859-")) {
            return new SevenBitXMLEncoder(string);
        }
        throw new UnsupportedEncodingException(string);
    }

    protected XMLEncoder() {
    }

    public abstract String getEncoding();

    public void text(Writer writer, String string, boolean bl) throws NullPointerException, InvalidXMLException, IOException {
        int n = string.length();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c > '>') {
                    this.text(writer, c);
                    continue;
                }
                if (c > '\u001f') {
                    if (c == '&') {
                        writer.write("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    this.text(writer, c);
                    continue;
                }
                if (c == '\t' || c == '\n' || c == '\r') {
                    this.text(writer, c);
                    continue;
                }
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
        } else {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c > '>') {
                    this.text(writer, c);
                    continue;
                }
                if (c > '\u001f') {
                    if (c == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    this.text(writer, c);
                    continue;
                }
                if (c == '\t' || c == '\n' || c == '\r') {
                    this.text(writer, c);
                    continue;
                }
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
        }
    }

    public void text(Writer writer, char[] cArray, int n, int n2, boolean bl) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        int n3 = n + n2;
        if (bl) {
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c > '>') {
                    this.text(writer, c);
                    continue;
                }
                if (c > '\u001f') {
                    if (c == '&') {
                        writer.write("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    this.text(writer, c);
                    continue;
                }
                if (c == '\t' || c == '\n' || c == '\r') {
                    this.text(writer, c);
                    continue;
                }
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
        } else {
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c > '>') {
                    this.text(writer, c);
                    continue;
                }
                if (c > '\u001f') {
                    if (c == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    this.text(writer, c);
                    continue;
                }
                if (c == '\t' || c == '\n' || c == '\r') {
                    this.text(writer, c);
                    continue;
                }
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
        }
    }

    public abstract void text(Writer var1, char var2) throws IOException;

    public abstract void declaration(Writer var1) throws NullPointerException, IOException;

    public void whitespace(Writer writer, String string) throws NullPointerException, InvalidXMLException, IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        this.whitespace(writer, cArray, 0, n);
    }

    public void whitespace(Writer writer, char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        XMLChecker.checkS(cArray, n, n2);
        writer.write(cArray, n, n2);
    }

    public void attribute(Writer writer, String string, String string2, char c, boolean bl) throws NullPointerException, IOException {
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        writer.write(32);
        writer.write(string);
        if (c == '\'') {
            writer.write("='");
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    char c2 = cArray[i];
                    if (c2 >= '\"' && c2 <= '>') {
                        if (c2 == '&') {
                            writer.write("&amp;");
                            continue;
                        }
                        if (c2 == '<') {
                            writer.write("&lt;");
                            continue;
                        }
                        if (c2 == '>') {
                            writer.write("&gt;");
                            continue;
                        }
                        if (c2 == '\'') {
                            writer.write("&apos;");
                            continue;
                        }
                        this.text(writer, c2);
                        continue;
                    }
                    this.text(writer, c2);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    char c3 = cArray[i];
                    if (c3 >= '\"' && c3 <= '>') {
                        if (c3 == '<') {
                            writer.write("&lt;");
                            continue;
                        }
                        if (c3 == '>') {
                            writer.write("&gt;");
                            continue;
                        }
                        if (c3 == '\'') {
                            writer.write("&apos;");
                            continue;
                        }
                        this.text(writer, c3);
                        continue;
                    }
                    this.text(writer, c3);
                }
            }
            writer.write(39);
        } else if (c == '\"') {
            writer.write("=\"");
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    char c4 = cArray[i];
                    if (c4 >= '\"' && c4 <= '>') {
                        if (c4 == '&') {
                            writer.write("&amp;");
                            continue;
                        }
                        if (c4 == '<') {
                            writer.write("&lt;");
                            continue;
                        }
                        if (c4 == '>') {
                            writer.write("&gt;");
                            continue;
                        }
                        if (c4 == '\"') {
                            writer.write("&quot;");
                            continue;
                        }
                        this.text(writer, c4);
                        continue;
                    }
                    this.text(writer, c4);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    char c5 = cArray[i];
                    if (c5 >= '\"' && c5 <= '>') {
                        if (c5 == '<') {
                            writer.write("&lt;");
                            continue;
                        }
                        if (c5 == '>') {
                            writer.write("&gt;");
                            continue;
                        }
                        if (c5 == '\"') {
                            writer.write("&quot;");
                            continue;
                        }
                        this.text(writer, c5);
                        continue;
                    }
                    this.text(writer, c5);
                }
            }
            writer.write(34);
        } else {
            throw new IllegalArgumentException("Character 0x" + Integer.toHexString(c) + " ('" + c + "') is not a valid quotation mark.");
        }
    }
}

