/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.processing.AbstractProcessingFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

public final class XMLizingProcessingFilter
extends AbstractProcessingFilter {
    private static final Comparator CLASS_COMPARATOR = new LexographicalClassComparator();
    private static final Comparator FIELD_COMPARATOR = new LexographicalFieldComparator();
    private static final Comparator METHOD_COMPARATOR = new LexographicalMethodComparator();

    protected Collection localFilterClasses(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, CLASS_COMPARATOR);
        return arrayList;
    }

    protected Collection localFilterFields(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, FIELD_COMPARATOR);
        return arrayList;
    }

    protected Collection localFilterMethods(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, METHOD_COMPARATOR);
        return arrayList;
    }

    private static final class LexographicalMethodComparator
    implements Comparator {
        private LexographicalMethodComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((SootMethod)object).getSignature();
            String string2 = ((SootMethod)object2).getSignature();
            return string.compareTo(string2);
        }
    }

    private static final class LexographicalFieldComparator
    implements Comparator {
        private LexographicalFieldComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((SootField)object).getSignature();
            String string2 = ((SootField)object2).getSignature();
            return string.compareTo(string2);
        }
    }

    private static final class LexographicalClassComparator
    implements Comparator {
        private LexographicalClassComparator() {
        }

        public int compare(Object object, Object object2) {
            SootClass sootClass = (SootClass)object;
            SootClass sootClass2 = (SootClass)object2;
            return sootClass.getName().compareTo(sootClass2.getName());
        }
    }
}

