/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.ValueBox;
import soot.jimple.Stmt;

public final class UniqueJimpleIDGenerator
implements IJimpleIDGenerator {
    private final Map class2fields = new HashMap();
    private final Map class2methods = new HashMap();
    private final Map method2locals = new HashMap();
    private List classes = new ArrayList();

    public String getIdForClass(SootClass sootClass) {
        if (!this.classes.contains(sootClass)) {
            this.classes.add(sootClass);
        }
        return "c" + String.valueOf(this.classes.indexOf(sootClass));
    }

    public String getIdForField(SootField sootField) {
        SootClass sootClass = sootField.getDeclaringClass();
        List list = (List)this.class2fields.get(sootClass);
        if (list == null) {
            list = this.sort((Collection)sootClass.getFields());
            this.class2fields.put(sootClass, list);
        }
        return this.getIdForClass(sootClass) + "_f" + list.indexOf(sootField);
    }

    public String getIdForLocal(Local local, SootMethod sootMethod) {
        List list = (List)this.method2locals.get(sootMethod);
        if (list == null) {
            list = this.sort((Collection)sootMethod.getActiveBody().getLocals());
            this.method2locals.put(sootMethod, list);
        }
        return this.getIdForMethod(sootMethod) + "_l" + list.indexOf(local);
    }

    public String getIdForMethod(SootMethod sootMethod) {
        SootClass sootClass = sootMethod.getDeclaringClass();
        List list = (List)this.class2methods.get(sootClass);
        if (list == null) {
            list = this.sort(sootClass.getMethods());
            this.class2methods.put(sootMethod.getDeclaringClass(), list);
        }
        return this.getIdForClass(sootMethod.getDeclaringClass()) + "_m" + list.indexOf(sootMethod);
    }

    public String getIdForStmt(Stmt stmt, SootMethod sootMethod) {
        String string = "?";
        if (sootMethod.isConcrete()) {
            PatchingChain patchingChain = sootMethod.getActiveBody().getUnits();
            int n = 0;
            Iterator iterator = patchingChain.iterator();
            while (iterator.hasNext() && stmt != iterator.next()) {
                ++n;
            }
            string = String.valueOf(n);
        }
        return this.getIdForMethod(sootMethod) + "_s" + string;
    }

    public String getIdForType(Type type) {
        String string;
        if (type instanceof RefType) {
            string = this.getIdForClass(((RefType)type).getSootClass());
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            StringBuffer stringBuffer = new StringBuffer(this.getIdForType(arrayType.baseType));
            stringBuffer.append(".." + arrayType.numDimensions);
            string = stringBuffer.toString();
        } else {
            string = type.toString().replaceAll("[\\[\\]]", "_.").replaceAll("\\p{Blank}", "");
        }
        return string;
    }

    public String getIdForValueBox(ValueBox valueBox, Stmt stmt, SootMethod sootMethod) {
        List list = stmt.getUseAndDefBoxes();
        return this.getIdForStmt(stmt, sootMethod) + "_v" + list.indexOf(valueBox);
    }

    public void reset() {
        this.method2locals.clear();
        this.class2fields.clear();
        this.class2methods.clear();
        this.classes.clear();
    }

    private List sort(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        return arrayList;
    }
}

