/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.AbstractProcessingFilter;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.JimpleXMLizer;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.util.Collection;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Scene;
import soot.SootClass;
import soot.tagkit.Tag;

public final class JimpleXMLizerCLI {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI == null ? (class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI = JimpleXMLizerCLI.class$("edu.ksu.cis.indus.xmlizer.JimpleXMLizerCLI")) : class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI));
    static /* synthetic */ Class class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI;

    private JimpleXMLizerCLI() {
    }

    public static void main(String[] stringArray) {
        Scene scene = Scene.v();
        Options options = new Options();
        Option option = new Option("d", "dump directory", true, "The directory in which to write the xml files.  If unspecified, the xml output will be directed standard out.");
        option.setArgs(1);
        option.setArgName("path");
        option.setOptionalArg(false);
        options.addOption(option);
        option = new Option("h", "help", false, "Display message.");
        options.addOption(option);
        option = new Option("p", "soot-classpath", true, "Prepend this to soot class path.");
        option.setArgs(1);
        option.setArgName("classpath");
        option.setOptionalArg(false);
        options.addOption(option);
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            CommandLine commandLine = new BasicParser().parse(options, stringArray);
            String[] stringArray2 = commandLine.getArgs();
            if (commandLine.hasOption('h')) {
                String string = "java " + (class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI == null ? (class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI = JimpleXMLizerCLI.class$("edu.ksu.cis.indus.xmlizer.JimpleXMLizerCLI")) : class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI).getName() + "<options> <class names>";
                helpFormatter.printHelp(string.length(), string, "", options, "", true);
            } else if (stringArray2.length > 0) {
                if (commandLine.hasOption('p')) {
                    scene.setSootClassPath(commandLine.getOptionValue('p') + File.pathSeparator + scene.getSootClassPath());
                }
                final NamedTag namedTag = new NamedTag("JimpleXMLizer");
                for (int i = 0; i < stringArray2.length; ++i) {
                    SootClass sootClass = scene.loadClassAndSupport(stringArray2[i]);
                    sootClass.addTag((Tag)namedTag);
                }
                JimpleXMLizerCLI.writeJimpleAsXML(scene, commandLine.getOptionValue('d'), null, new UniqueJimpleIDGenerator(), new AbstractProcessingFilter(){

                    public Collection localFilterClasses(Collection collection) {
                        return Util.getHostsWithTag(collection, namedTag.getName());
                    }
                });
            } else {
                System.out.println("No classes were specified.");
            }
        }
        catch (ParseException parseException) {
            LOGGER.error((Object)"Error while parsing command line");
            String string = "java " + (class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI == null ? (class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI = JimpleXMLizerCLI.class$("edu.ksu.cis.indus.xmlizer.JimpleXMLizerCLI")) : class$edu$ksu$cis$indus$xmlizer$JimpleXMLizerCLI).getName() + "<options> <class names>";
            helpFormatter.printHelp(string.length(), string, "", options, "", true);
        }
    }

    public static void writeJimpleAsXML(Scene scene, String string, String string2, IJimpleIDGenerator iJimpleIDGenerator, IProcessingFilter iProcessingFilter) {
        JimpleXMLizer jimpleXMLizer = new JimpleXMLizer(iJimpleIDGenerator);
        Environment environment = new Environment(scene);
        ProcessingController processingController = new ProcessingController();
        processingController.setStmtGraphFactory(new ExceptionFlowSensitiveStmtGraphFactory());
        processingController.setEnvironment(environment);
        XMLizingProcessingFilter xMLizingProcessingFilter = new XMLizingProcessingFilter();
        if (iProcessingFilter != null) {
            xMLizingProcessingFilter.chain(iProcessingFilter);
        }
        processingController.setProcessingFilter(xMLizingProcessingFilter);
        jimpleXMLizer.setDumpOptions(string, string2);
        jimpleXMLizer.hookup(processingController);
        processingController.process();
        jimpleXMLizer.unhook(processingController);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

