/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.JimpleStmtXMLizer;
import edu.ksu.cis.indus.xmlizer.JimpleValueXMLizer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.Body;
import soot.Local;
import soot.Modifier;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.jimple.Stmt;
import soot.util.Chain;

public class JimpleXMLizer
extends AbstractProcessor {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$xmlizer$JimpleXMLizer == null ? (class$edu$ksu$cis$indus$xmlizer$JimpleXMLizer = JimpleXMLizer.class$("edu.ksu.cis.indus.xmlizer.JimpleXMLizer")) : class$edu$ksu$cis$indus$xmlizer$JimpleXMLizer));
    private final IJimpleIDGenerator idGenerator;
    private final JimpleStmtXMLizer stmtXmlizer;
    private String currType;
    private String dumpDirectory;
    private String fileSuffix;
    private XMLOutputter writer;
    private boolean processingClass;
    private boolean processingMethod;
    static /* synthetic */ Class class$edu$ksu$cis$indus$xmlizer$JimpleXMLizer;

    public JimpleXMLizer(IJimpleIDGenerator iJimpleIDGenerator) {
        this.idGenerator = iJimpleIDGenerator;
        this.stmtXmlizer = new JimpleStmtXMLizer(new JimpleValueXMLizer(iJimpleIDGenerator), iJimpleIDGenerator);
    }

    public final void setDumpOptions(String string, String string2) {
        File file;
        this.dumpDirectory = string;
        if (string != null && !(file = new File(string)).exists()) {
            file.mkdirs();
        }
        this.fileSuffix = string2 == null ? "" : "_" + string2;
    }

    public final void callback(Stmt stmt, Context context) {
        this.stmtXmlizer.setMethod(context.getCurrentMethod());
        this.stmtXmlizer.apply(stmt);
    }

    public final void callback(SootMethod sootMethod) {
        block7: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                } else {
                    this.processingMethod = true;
                }
                this.writer.startTag("method");
                this.writer.attribute("name", AbstractXMLizer.xmlizeString(sootMethod.getName()));
                this.writer.attribute("id", this.idGenerator.getIdForMethod(sootMethod));
                this.writer.attribute("abstract", String.valueOf(sootMethod.isAbstract()));
                this.writer.attribute("static", String.valueOf(sootMethod.isStatic()));
                this.writer.attribute("native", String.valueOf(sootMethod.isNative()));
                this.writer.attribute("synchronized", String.valueOf(sootMethod.isSynchronized()));
                this.writer.attribute("accessSpec", this.getAccessSpecifier(sootMethod.getModifiers()));
                this.writer.startTag("signature");
                this.writer.startTag("returnType");
                this.writer.attribute("typeId", this.idGenerator.getIdForType(sootMethod.getReturnType()));
                this.writer.endTag();
                int n = 0;
                Iterator iterator = sootMethod.getParameterTypes().iterator();
                while (iterator.hasNext()) {
                    this.writer.startTag("paramType");
                    this.writer.attribute("typeId", this.idGenerator.getIdForType((Type)iterator.next()));
                    this.writer.attribute("position", String.valueOf(n++));
                    this.writer.endTag();
                }
                iterator = sootMethod.getExceptions().iterator();
                while (iterator.hasNext()) {
                    this.writer.startTag("exception");
                    this.writer.attribute("typeId", this.idGenerator.getIdForClass((SootClass)iterator.next()));
                    this.writer.endTag();
                }
                this.writer.endTag();
                if (sootMethod.isConcrete()) {
                    this.xmlizeTrapListAndLocals(sootMethod);
                }
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn((Object)"Error while writing xmlized jimple info.", (Throwable)iOException);
            }
        }
    }

    public final void callback(SootClass sootClass) {
        try {
            Object object;
            if (this.processingClass) {
                this.writer.endDocument();
            } else {
                this.processingClass = true;
            }
            String string = this.setupFile(sootClass);
            this.currType = sootClass.isInterface() ? "interface" : "class";
            this.writer.startTag(this.currType);
            this.writer.attribute("name", sootClass.getJavaStyleName());
            this.writer.attribute("id", string);
            this.writer.attribute("package", sootClass.getJavaPackageName());
            this.writer.attribute("abstract", String.valueOf(sootClass.isAbstract()));
            this.writer.attribute("accessSpec", this.getAccessSpecifier(sootClass.getModifiers()));
            if (sootClass.hasSuperclass()) {
                object = sootClass.getSuperclass();
                this.writer.startTag("superclass");
                this.writer.attribute("typeId", this.idGenerator.getIdForClass((SootClass)object));
                this.writer.endTag();
            }
            if (sootClass.getInterfaceCount() > 0) {
                this.writer.startTag("interfaceList");
                object = sootClass.getInterfaces().iterator();
                while (object.hasNext()) {
                    SootClass sootClass2 = (SootClass)object.next();
                    this.writer.startTag("superinterface");
                    this.writer.attribute("typeId", this.idGenerator.getIdForClass(sootClass2));
                    this.writer.endTag();
                }
                this.writer.endTag();
            }
            this.processingMethod = false;
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"Error while writing xmlized jimple info.", (Throwable)iOException);
        }
    }

    public final void callback(SootField sootField) {
        block7: {
            try {
                this.writer.startTag("field");
                this.writer.attribute("name", sootField.getName());
                this.writer.attribute("id", this.idGenerator.getIdForField(sootField));
                this.writer.attribute("typeId", this.idGenerator.getIdForType(sootField.getType()));
                this.writer.attribute("static", String.valueOf(sootField.isStatic()));
                this.writer.attribute("final", String.valueOf(sootField.isFinal()));
                String string = "";
                if (sootField.isPublic()) {
                    string = "public";
                } else if (sootField.isPrivate()) {
                    string = "private";
                } else if (sootField.isProtected()) {
                    string = "proctected";
                }
                this.writer.attribute("accessSpec", string);
                this.writer.endTag();
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn((Object)"Error while writing xmlized jimple info.", (Throwable)iOException);
            }
        }
    }

    public final void consolidate() {
        block2: {
            try {
                this.writer.endDocument();
                this.writer.getWriter().close();
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn((Object)"Error while writing xmlized jimple info.", (Throwable)iOException);
            }
        }
    }

    public final void hookup(ProcessingController processingController) {
        processingController.registerForAllStmts(this);
        processingController.register(this);
    }

    public final void unhook(ProcessingController processingController) {
        processingController.unregisterForAllStmts(this);
        processingController.unregister(this);
    }

    private String getAccessSpecifier(int n) {
        String string = "";
        if (Modifier.isPublic((int)n)) {
            string = "public";
        } else if (Modifier.isPrivate((int)n)) {
            string = "private";
        } else if (Modifier.isProtected((int)n)) {
            string = "proctected";
        }
        return string;
    }

    private String setupFile(SootClass sootClass) throws IOException {
        String string = this.idGenerator.getIdForClass(sootClass);
        if (this.dumpDirectory == null) {
            if (this.writer == null) {
                this.writer = new CustomXMLOutputter(new BufferedWriter(new OutputStreamWriter(System.out)));
            } else {
                this.writer.reset(this.writer.getWriter(), this.writer.getEncoding());
            }
            this.stmtXmlizer.setWriter(this.writer);
        } else {
            String string2 = this.dumpDirectory + File.separator + string + this.fileSuffix + ".xml";
            try {
                if (this.writer != null && this.writer.getWriter() != null) {
                    this.writer.getWriter().close();
                }
                File file = new File(string2);
                this.writer = new CustomXMLOutputter(new BufferedWriter(new FileWriter(file)));
                this.stmtXmlizer.setWriter(this.writer);
                this.writer.declaration();
            }
            catch (IOException iOException) {
                LOGGER.error((Object)("Exception while trying to open " + string2), (Throwable)iOException);
                throw iOException;
            }
        }
        return string;
    }

    private void xmlizeTrapListAndLocals(SootMethod sootMethod) {
        block5: {
            Body body = sootMethod.retrieveActiveBody();
            Chain chain = body.getTraps();
            try {
                Local local;
                Iterator iterator;
                if (!chain.isEmpty()) {
                    this.writer.startTag("traplist");
                    iterator = chain.iterator();
                    while (iterator.hasNext()) {
                        local = (Trap)iterator.next();
                        this.writer.startTag("trap");
                        this.writer.attribute("typeId", this.idGenerator.getIdForClass(local.getException()));
                        this.writer.attribute("beginId", this.idGenerator.getIdForStmt((Stmt)local.getBeginUnit(), sootMethod));
                        this.writer.attribute("endId", this.idGenerator.getIdForStmt((Stmt)local.getEndUnit(), sootMethod));
                        this.writer.attribute("handlerId", this.idGenerator.getIdForStmt((Stmt)local.getHandlerUnit(), sootMethod));
                        this.writer.endTag();
                    }
                    this.writer.endTag();
                }
                iterator = body.getLocals().iterator();
                while (iterator.hasNext()) {
                    local = (Local)iterator.next();
                    this.writer.startTag("local");
                    this.writer.attribute("id", this.idGenerator.getIdForLocal(local, sootMethod));
                    this.writer.attribute("name", local.getName());
                    this.writer.attribute("typeId", this.idGenerator.getIdForType(local.getType()));
                    this.writer.endTag();
                }
            }
            catch (IOException iOException) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn((Object)"Error while writing xmlized jimple info.", (Throwable)iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

