/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import java.io.IOException;
import org.znerd.xmlenc.XMLOutputter;
import soot.ArrayType;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EqExpr;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GtExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.ThisRef;
import soot.jimple.UnopExpr;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.util.Switch;

public class JimpleValueXMLizer
extends AbstractJimpleValueSwitch {
    final StringBuffer tabs = new StringBuffer("\t\t\t");
    private final IJimpleIDGenerator idGenerator;
    private Object newId;
    private SootMethod currMethod;
    private Stmt currStmt;
    private XMLOutputter xmlWriter;

    JimpleValueXMLizer(IJimpleIDGenerator iJimpleIDGenerator) {
        this.idGenerator = iJimpleIDGenerator;
    }

    public final void caseAddExpr(AddExpr addExpr) {
        this.writeBinaryExpr("add", (BinopExpr)addExpr);
    }

    public final void caseAndExpr(AndExpr andExpr) {
        this.writeBinaryExpr("binary and", (BinopExpr)andExpr);
    }

    public final void caseArrayRef(ArrayRef arrayRef) {
        try {
            this.xmlWriter.startTag("array_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.writeBase(arrayRef.getBaseBox());
            this.xmlWriter.startTag("index");
            this.apply(arrayRef.getIndexBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseCastExpr(CastExpr castExpr) {
        try {
            this.xmlWriter.startTag("cast");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(castExpr.getCastType()));
            this.apply(castExpr.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseCaughtExceptionRef(CaughtExceptionRef caughtExceptionRef) {
        try {
            this.xmlWriter.startTag("caught_exception_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("exceptionTypeId", this.idGenerator.getIdForType(caughtExceptionRef.getType()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseCmpExpr(CmpExpr cmpExpr) {
        this.writeBinaryExpr("compare", (BinopExpr)cmpExpr);
    }

    public final void caseCmpgExpr(CmpgExpr cmpgExpr) {
        this.writeBinaryExpr("compare greater", (BinopExpr)cmpgExpr);
    }

    public final void caseCmplExpr(CmplExpr cmplExpr) {
        this.writeBinaryExpr("compare lesser", (BinopExpr)cmplExpr);
    }

    public final void caseDivExpr(DivExpr divExpr) {
        this.writeBinaryExpr("divide", (BinopExpr)divExpr);
    }

    public final void caseDoubleConstant(DoubleConstant doubleConstant) {
        try {
            this.xmlWriter.startTag("double");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(doubleConstant.value));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseEqExpr(EqExpr eqExpr) {
        this.writeBinaryExpr("equal", (BinopExpr)eqExpr);
    }

    public final void caseFloatConstant(FloatConstant floatConstant) {
        try {
            this.xmlWriter.startTag("float");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(floatConstant.value));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseGeExpr(GeExpr geExpr) {
        this.writeBinaryExpr("greater than or equal", (BinopExpr)geExpr);
    }

    public final void caseGtExpr(GtExpr gtExpr) {
        this.writeBinaryExpr("greater than", (BinopExpr)gtExpr);
    }

    public final void caseInstanceFieldRef(InstanceFieldRef instanceFieldRef) {
        try {
            this.xmlWriter.startTag("instance_field_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.writeBase(instanceFieldRef.getBaseBox());
            this.writeField(instanceFieldRef.getField());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseInstanceOfExpr(InstanceOfExpr instanceOfExpr) {
        try {
            this.xmlWriter.startTag("instanceof");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(instanceOfExpr.getCheckType()));
            this.apply(instanceOfExpr.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseIntConstant(IntConstant intConstant) {
        try {
            this.xmlWriter.startTag("integer");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(intConstant.value));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseInterfaceInvokeExpr(InterfaceInvokeExpr interfaceInvokeExpr) {
        this.writeInvokeExpr((InvokeExpr)interfaceInvokeExpr);
    }

    public final void caseLeExpr(LeExpr leExpr) {
        this.writeBinaryExpr("less than or equal", (BinopExpr)leExpr);
    }

    public final void caseLengthExpr(LengthExpr lengthExpr) {
        this.writeUnaryExpr("length", (UnopExpr)lengthExpr);
    }

    public final void caseLocal(Local local) {
        try {
            this.xmlWriter.startTag("local_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("localId", this.idGenerator.getIdForLocal(local, this.currMethod));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseLongConstant(LongConstant longConstant) {
        try {
            this.xmlWriter.startTag("long");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(longConstant.value));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseLtExpr(LtExpr ltExpr) {
        this.writeBinaryExpr("less than", (BinopExpr)ltExpr);
    }

    public final void caseMulExpr(MulExpr mulExpr) {
        this.writeBinaryExpr("multiply", (BinopExpr)mulExpr);
    }

    public final void caseNeExpr(NeExpr neExpr) {
        this.writeBinaryExpr("not equal", (BinopExpr)neExpr);
    }

    public final void caseNegExpr(NegExpr negExpr) {
        this.writeUnaryExpr("negation", (UnopExpr)negExpr);
    }

    public final void caseNewArrayExpr(NewArrayExpr newArrayExpr) {
        try {
            this.xmlWriter.startTag("new_array");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(newArrayExpr.getBaseType()));
            this.writeDimensionSize(1, newArrayExpr.getSizeBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseNewExpr(NewExpr newExpr) {
        try {
            this.xmlWriter.startTag("new");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(newExpr.getType()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseNewMultiArrayExpr(NewMultiArrayExpr newMultiArrayExpr) {
        ArrayType arrayType = newMultiArrayExpr.getBaseType();
        try {
            this.xmlWriter.startTag("new_multi_array");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(arrayType.baseType));
            this.xmlWriter.attribute("dimension", String.valueOf(arrayType.numDimensions));
            for (int i = 0; i < newMultiArrayExpr.getSizeCount(); ++i) {
                this.writeDimensionSize(i + 1, newMultiArrayExpr.getSizeBox(i));
            }
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseNullConstant(NullConstant nullConstant) {
        try {
            this.xmlWriter.startTag("null");
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseOrExpr(OrExpr orExpr) {
        this.writeBinaryExpr("binary or", (BinopExpr)orExpr);
    }

    public final void caseParameterRef(ParameterRef parameterRef) {
        try {
            this.xmlWriter.startTag("parameter_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("position", String.valueOf(parameterRef.getIndex()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseRemExpr(RemExpr remExpr) {
        this.writeBinaryExpr("reminder", (BinopExpr)remExpr);
    }

    public final void caseShlExpr(ShlExpr shlExpr) {
        this.writeBinaryExpr("shift left", (BinopExpr)shlExpr);
    }

    public final void caseShrExpr(ShrExpr shrExpr) {
        this.writeBinaryExpr("shift right", (BinopExpr)shrExpr);
    }

    public final void caseSpecialInvokeExpr(SpecialInvokeExpr specialInvokeExpr) {
        this.writeInvokeExpr((InvokeExpr)specialInvokeExpr);
    }

    public final void caseStaticFieldRef(StaticFieldRef staticFieldRef) {
        try {
            this.xmlWriter.startTag("static_field_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.writeField(staticFieldRef.getField());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseStaticInvokeExpr(StaticInvokeExpr staticInvokeExpr) {
        this.writeInvokeExpr((InvokeExpr)staticInvokeExpr);
    }

    public final void caseStringConstant(StringConstant stringConstant) {
        try {
            this.xmlWriter.startTag("string");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.cdata(AbstractXMLizer.encode(String.valueOf(stringConstant.value), this.xmlWriter.getEncoding()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseSubExpr(SubExpr subExpr) {
        this.writeBinaryExpr("subtract", (BinopExpr)subExpr);
    }

    public final void caseThisRef(ThisRef thisRef) {
        try {
            this.xmlWriter.startTag("this");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void caseUshrExpr(UshrExpr ushrExpr) {
        this.writeBinaryExpr("unsigned shift right", (BinopExpr)ushrExpr);
    }

    public final void caseVirtualInvokeExpr(VirtualInvokeExpr virtualInvokeExpr) {
        this.writeInvokeExpr((InvokeExpr)virtualInvokeExpr);
    }

    public final void caseXorExpr(XorExpr xorExpr) {
        this.writeBinaryExpr("binary xor", (BinopExpr)xorExpr);
    }

    final void setMethod(SootMethod sootMethod) {
        this.currMethod = sootMethod;
    }

    final void setStmt(Stmt stmt) {
        this.currStmt = stmt;
    }

    final void setWriter(XMLOutputter xMLOutputter) {
        this.xmlWriter = xMLOutputter;
    }

    final void apply(ValueBox valueBox) {
        Object object = this.newId;
        this.newId = this.idGenerator.getIdForValueBox(valueBox, this.currStmt, this.currMethod);
        this.incrementTabs();
        valueBox.getValue().apply((Switch)this);
        this.decrementTabs();
        this.newId = object;
    }

    private void decrementTabs() {
        this.tabs.deleteCharAt(0);
    }

    private void incrementTabs() {
        this.tabs.append("\t");
    }

    private void writeBase(ValueBox valueBox) {
        try {
            this.xmlWriter.startTag("base");
            this.apply(valueBox);
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeBinaryExpr(String string, BinopExpr binopExpr) {
        try {
            this.xmlWriter.startTag("binary_expr");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("op", string);
            this.xmlWriter.startTag("left_op");
            this.apply(binopExpr.getOp1Box());
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("right_op");
            this.apply(binopExpr.getOp2Box());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeDimensionSize(int n, ValueBox valueBox) {
        try {
            this.xmlWriter.startTag("size");
            this.xmlWriter.attribute("dimension", String.valueOf(n));
            this.apply(valueBox);
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeField(SootField sootField) {
        try {
            this.xmlWriter.startTag("field_ref");
            this.xmlWriter.attribute("fieldId", this.idGenerator.getIdForField(sootField));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeInvokeExpr(InvokeExpr invokeExpr) {
        String string = "";
        if (invokeExpr instanceof InterfaceInvokeExpr) {
            string = "interface";
        } else if (invokeExpr instanceof SpecialInvokeExpr) {
            string = "special";
        } else if (invokeExpr instanceof StaticInvokeExpr) {
            string = "static";
        } else if (invokeExpr instanceof VirtualInvokeExpr) {
            string = "virtual";
        } else {
            throw new IllegalArgumentException("v has to be of VirtualInvokeExpr, StaticInvokeExpr, SpecialInvokeExpr, or InterfaceInvokeExpr.");
        }
        try {
            this.xmlWriter.startTag("invoke_expr");
            this.xmlWriter.attribute("name", string);
            this.xmlWriter.attribute("id", this.newId.toString());
            SootMethod sootMethod = invokeExpr.getMethod();
            this.xmlWriter.startTag("method_ref");
            this.xmlWriter.attribute("methodId", this.idGenerator.getIdForMethod(sootMethod));
            this.xmlWriter.endTag();
            if (invokeExpr instanceof InstanceInvokeExpr) {
                this.writeBase(((InstanceInvokeExpr)invokeExpr).getBaseBox());
            }
            if (invokeExpr.getArgCount() > 0) {
                this.xmlWriter.startTag("arguments");
                for (int i = 0; i < invokeExpr.getArgCount(); ++i) {
                    this.apply(invokeExpr.getArgBox(i));
                }
                this.xmlWriter.endTag();
            }
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeUnaryExpr(String string, UnopExpr unopExpr) {
        try {
            this.xmlWriter.startTag("unary_expr");
            this.xmlWriter.attribute("op", string);
            this.xmlWriter.attribute("id", this.newId.toString());
            this.apply(unopExpr.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

