/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.JimpleValueXMLizer;
import java.io.IOException;
import org.znerd.xmlenc.XMLOutputter;
import soot.Body;
import soot.SootMethod;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NopStmt;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.util.Switch;

final class JimpleStmtXMLizer
extends AbstractStmtSwitch {
    JimpleValueXMLizer valueXMLizer;
    private final IJimpleIDGenerator idGenerator;
    private Body currMethodBody;
    private SootMethod currMethod;
    private XMLOutputter xmlWriter;

    JimpleStmtXMLizer(JimpleValueXMLizer jimpleValueXMLizer, IJimpleIDGenerator iJimpleIDGenerator) {
        this.valueXMLizer = jimpleValueXMLizer;
        this.idGenerator = iJimpleIDGenerator;
    }

    public void caseAssignStmt(AssignStmt assignStmt) {
        try {
            boolean bl = !assignStmt.getBoxesPointingToThis().isEmpty();
            this.xmlWriter.startTag("assign_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)assignStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(bl));
            this.xmlWriter.startTag("lhs");
            this.valueXMLizer.apply(assignStmt.getLeftOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("rhs");
            this.valueXMLizer.apply(assignStmt.getRightOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseBreakpointStmt(BreakpointStmt breakpointStmt) {
        try {
            this.xmlWriter.startTag("breakpoint_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)breakpointStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!breakpointStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseEnterMonitorStmt(EnterMonitorStmt enterMonitorStmt) {
        try {
            this.xmlWriter.startTag("entermonitor_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)enterMonitorStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!enterMonitorStmt.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(enterMonitorStmt.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseExitMonitorStmt(ExitMonitorStmt exitMonitorStmt) {
        try {
            this.xmlWriter.startTag("exitmonitor_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)exitMonitorStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!exitMonitorStmt.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(exitMonitorStmt.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseGotoStmt(GotoStmt gotoStmt) {
        try {
            this.xmlWriter.startTag("goto_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)gotoStmt, this.currMethod));
            this.xmlWriter.attribute("target", this.idGenerator.getIdForStmt((Stmt)gotoStmt.getTarget(), this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!gotoStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseIdentityStmt(IdentityStmt identityStmt) {
        try {
            this.xmlWriter.startTag("identity_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)identityStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!identityStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.startTag("lhs");
            this.valueXMLizer.apply(identityStmt.getLeftOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("rhs");
            this.valueXMLizer.apply(identityStmt.getRightOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseIfStmt(IfStmt ifStmt) {
        try {
            this.xmlWriter.startTag("if_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)ifStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!ifStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.attribute("trueTargetId", this.idGenerator.getIdForStmt(ifStmt.getTarget(), this.currMethod));
            this.xmlWriter.attribute("falseTargetId", this.idGenerator.getIdForStmt((Stmt)this.currMethodBody.getUnits().getSuccOf((Object)ifStmt), this.currMethod));
            this.xmlWriter.startTag("condition");
            this.valueXMLizer.apply(ifStmt.getConditionBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseInvokeStmt(InvokeStmt invokeStmt) {
        try {
            this.xmlWriter.startTag("invoke_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)invokeStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!invokeStmt.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(invokeStmt.getInvokeExprBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseLookupSwitchStmt(LookupSwitchStmt lookupSwitchStmt) {
        try {
            this.xmlWriter.startTag("lookupswitch_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)lookupSwitchStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!lookupSwitchStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.attribute("defaultTargetId", this.idGenerator.getIdForStmt((Stmt)lookupSwitchStmt.getDefaultTarget(), this.currMethod));
            this.xmlWriter.startTag("key");
            this.valueXMLizer.apply(lookupSwitchStmt.getKeyBox());
            this.xmlWriter.endTag();
            for (int i = 0; i < lookupSwitchStmt.getTargetCount(); ++i) {
                this.xmlWriter.startTag("case");
                this.xmlWriter.attribute("value", String.valueOf(lookupSwitchStmt.getLookupValue(i)));
                this.xmlWriter.attribute("targetId", this.idGenerator.getIdForStmt((Stmt)lookupSwitchStmt.getTarget(i), this.currMethod));
                this.xmlWriter.endTag();
            }
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseNopStmt(NopStmt nopStmt) {
        try {
            this.xmlWriter.startTag("nop_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)nopStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!nopStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseRetStmt(RetStmt retStmt) {
        try {
            this.xmlWriter.startTag("ret_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)retStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!retStmt.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(retStmt.getStmtAddressBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseReturnStmt(ReturnStmt returnStmt) {
        try {
            this.xmlWriter.startTag("return_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)returnStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!returnStmt.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(returnStmt.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseReturnVoidStmt(ReturnVoidStmt returnVoidStmt) {
        try {
            this.xmlWriter.startTag("returnvoid_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)returnVoidStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!returnVoidStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseTableSwitchStmt(TableSwitchStmt tableSwitchStmt) {
        try {
            this.xmlWriter.startTag("tableswitch_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)tableSwitchStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!tableSwitchStmt.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.attribute("defaultTargetId", this.idGenerator.getIdForStmt((Stmt)tableSwitchStmt.getDefaultTarget(), this.currMethod));
            this.xmlWriter.startTag("key");
            this.valueXMLizer.apply(tableSwitchStmt.getKeyBox());
            this.xmlWriter.endTag();
            for (int i = 0; i < tableSwitchStmt.getHighIndex() - tableSwitchStmt.getLowIndex(); ++i) {
                this.xmlWriter.startTag("case");
                this.xmlWriter.attribute("value", String.valueOf(i));
                this.xmlWriter.attribute("targetId", this.idGenerator.getIdForStmt((Stmt)tableSwitchStmt.getTarget(i), this.currMethod));
                this.xmlWriter.endTag();
            }
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void caseThrowStmt(ThrowStmt throwStmt) {
        try {
            this.xmlWriter.startTag("throw_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)throwStmt, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!throwStmt.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(throwStmt.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void setMethod(SootMethod sootMethod) {
        this.currMethod = sootMethod;
        this.currMethodBody = sootMethod.isConcrete() ? sootMethod.retrieveActiveBody() : null;
        this.valueXMLizer.setMethod(sootMethod);
    }

    void setWriter(XMLOutputter xMLOutputter) {
        this.xmlWriter = xMLOutputter;
        this.valueXMLizer.setWriter(xMLOutputter);
    }

    void apply(Stmt stmt) {
        this.valueXMLizer.setStmt(stmt);
        stmt.apply((Switch)this);
    }
}

