/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.IXMLizer;
import edu.ksu.cis.indus.xmlizer.JimpleXMLizer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractXMLizer
implements IXMLizer {
    public static final Object FILE_NAME_ID = "FILE_NAME_ID";
    private static final int LOWER_NIBBLE_MASK = 15;
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$xmlizer$AbstractXMLizer == null ? (class$edu$ksu$cis$indus$xmlizer$AbstractXMLizer = AbstractXMLizer.class$("edu.ksu.cis.indus.xmlizer.AbstractXMLizer")) : class$edu$ksu$cis$indus$xmlizer$AbstractXMLizer));
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int NO_SHIFTS_FROM_HIGHER_TO_LOWER_NIBBLE = 4;
    private IJimpleIDGenerator idGenerator;
    private String xmlOutDir;
    static /* synthetic */ Class class$edu$ksu$cis$indus$xmlizer$AbstractXMLizer;

    public final void setGenerator(IJimpleIDGenerator iJimpleIDGenerator) {
        this.idGenerator = iJimpleIDGenerator;
    }

    public final IJimpleIDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public final void setXmlOutputDir(String string) {
        File file = new File(string);
        if (!file.exists() | !file.canWrite()) {
            LOGGER.error((Object)"XML output directory should exists with proper permissions.");
            throw new IllegalArgumentException("XML output directory should exists with proper permissions.");
        }
        this.xmlOutDir = string;
    }

    public final String getXmlOutputDir() {
        return this.xmlOutDir;
    }

    public final void dumpJimple(String string, String string2, ProcessingController processingController) {
        JimpleXMLizer jimpleXMLizer = new JimpleXMLizer(this.idGenerator);
        jimpleXMLizer.setDumpOptions(string2, this.getFileName(string).replaceAll("\\.xml$", ""));
        jimpleXMLizer.hookup(processingController);
        processingController.process();
        jimpleXMLizer.unhook(processingController);
    }

    public static final String xmlizeString(String string) {
        String string2 = "";
        if (string != null) {
            char[] cArray = string.toCharArray();
            boolean bl = AbstractXMLizer.needsEncoding(cArray);
            String string3 = string;
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                block8: for (int i = 0; i < cArray.length; ++i) {
                    switch (cArray[i]) {
                        case '&': {
                            stringBuffer.append("&amp;");
                            continue block8;
                        }
                        case '\"': {
                            stringBuffer.append("&quot;");
                            continue block8;
                        }
                        case '\'': {
                            stringBuffer.append("&apos;");
                            continue block8;
                        }
                        case '<': {
                            stringBuffer.append("&lt;");
                            continue block8;
                        }
                        case '\r': {
                            stringBuffer.append("&#xd;");
                            continue block8;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            continue block8;
                        }
                        default: {
                            if (cArray[i] > '\u007f') {
                                stringBuffer.append("&#");
                                stringBuffer.append((int)cArray[i]);
                                stringBuffer.append(";");
                                continue block8;
                            }
                            stringBuffer.append(cArray[i]);
                        }
                    }
                }
                string3 = stringBuffer.toString();
            }
            string2 = string3.replaceAll(":", "_");
        }
        return string2;
    }

    public static String encode(String string, String string2) {
        Charset charset = Charset.forName(string2);
        ByteBuffer byteBuffer = charset.encode(string);
        byte[] byArray = byteBuffer.array();
        StringBuffer stringBuffer = new StringBuffer("\\u");
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            char[] cArray = new char[]{HEX_DIGITS[by >> 4 & 0xF], HEX_DIGITS[by & 0xF]};
            stringBuffer.append(new String(cArray));
        }
        return stringBuffer.toString();
    }

    private static boolean needsEncoding(char[] cArray) {
        boolean bl = false;
        block3: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    bl = true;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

