/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.transformations.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.StringConstant;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.util.Switch;

public final class ASTCloner
extends AbstractJimpleValueSwitch
implements StmtSwitch {
    private static final Jimple JIMPLE = Jimple.v();
    private final IASTClonerHelper helper;
    private SootMethod method;
    private Stmt cloneStmt;
    private Value cloneValue;

    public ASTCloner(IASTClonerHelper iASTClonerHelper) {
        this.helper = iASTClonerHelper;
    }

    public void caseArrayRef(ArrayRef arrayRef) {
        arrayRef.getBase().apply((Switch)this);
        Value value = this.cloneValue;
        arrayRef.getIndex().apply((Switch)this);
        this.cloneValue = JIMPLE.newArrayRef(value, this.cloneValue);
    }

    public void caseAssignStmt(AssignStmt assignStmt) {
        assignStmt.getLeftOp().apply((Switch)this);
        Value value = this.cloneValue;
        assignStmt.getRightOp().apply((Switch)this);
        Value value2 = this.cloneValue;
        this.cloneStmt = JIMPLE.newAssignStmt(value, value2);
    }

    public void caseBreakpointStmt(BreakpointStmt breakpointStmt) {
        this.cloneStmt = (BreakpointStmt)breakpointStmt.clone();
    }

    public void caseCastExpr(CastExpr castExpr) {
        castExpr.getOp().apply((Switch)this);
        this.cloneValue = JIMPLE.newCastExpr(this.cloneValue, castExpr.getType());
    }

    public void caseCaughtExceptionRef(CaughtExceptionRef caughtExceptionRef) {
        this.cloneValue = (CaughtExceptionRef)caughtExceptionRef.clone();
    }

    public void caseDoubleConstant(DoubleConstant doubleConstant) {
        this.cloneValue = (DoubleConstant)doubleConstant.clone();
    }

    public void caseEnterMonitorStmt(EnterMonitorStmt enterMonitorStmt) {
        enterMonitorStmt.getOp().apply((Switch)this);
        this.cloneStmt = JIMPLE.newEnterMonitorStmt(this.cloneValue);
    }

    public void caseExitMonitorStmt(ExitMonitorStmt exitMonitorStmt) {
        exitMonitorStmt.getOp().apply((Switch)this);
        this.cloneStmt = JIMPLE.newExitMonitorStmt(this.cloneValue);
    }

    public void caseFloatConstant(FloatConstant floatConstant) {
        this.cloneValue = (FloatConstant)floatConstant.clone();
    }

    public void caseGotoStmt(GotoStmt gotoStmt) {
        this.cloneStmt = JIMPLE.newGotoStmt(gotoStmt.getTarget());
    }

    public void caseIdentityStmt(IdentityStmt identityStmt) {
        identityStmt.getLeftOp().apply((Switch)this);
        Value value = this.cloneValue;
        identityStmt.getRightOp().apply((Switch)this);
        Value value2 = this.cloneValue;
        this.cloneStmt = JIMPLE.newIdentityStmt(value, value2);
    }

    public void caseIfStmt(IfStmt ifStmt) {
        ifStmt.getCondition().apply((Switch)this);
        this.cloneStmt = JIMPLE.newIfStmt(this.cloneValue, (Unit)ifStmt.getTarget());
    }

    public void caseInstanceFieldRef(InstanceFieldRef instanceFieldRef) {
        instanceFieldRef.getBase().apply((Switch)this);
        this.cloneValue = JIMPLE.newInstanceFieldRef(this.cloneValue, this.helper.getCloneOf(instanceFieldRef.getField()));
    }

    public void caseInstanceOfExpr(InstanceOfExpr instanceOfExpr) {
        instanceOfExpr.getOp().apply((Switch)this);
        this.cloneValue = JIMPLE.newInstanceOfExpr(this.cloneValue, instanceOfExpr.getCheckType());
    }

    public void caseIntConstant(IntConstant intConstant) {
        this.cloneValue = (IntConstant)intConstant.clone();
    }

    public void caseInterfaceInvokeExpr(InterfaceInvokeExpr interfaceInvokeExpr) {
        interfaceInvokeExpr.getBase().apply((Switch)this);
        Local local = (Local)this.cloneValue;
        this.cloneValue = JIMPLE.newInterfaceInvokeExpr(local, this.helper.getCloneOf(interfaceInvokeExpr.getMethod()), this.getArgs((InvokeExpr)interfaceInvokeExpr));
    }

    public void caseInvokeStmt(InvokeStmt invokeStmt) {
        invokeStmt.getInvokeExpr().apply((Switch)this);
        this.cloneStmt = JIMPLE.newInvokeStmt(this.cloneValue);
    }

    public void caseLengthExpr(LengthExpr lengthExpr) {
        lengthExpr.getOp().apply((Switch)this);
        this.cloneValue = JIMPLE.newLengthExpr(this.cloneValue);
    }

    public void caseLocal(Local local) {
        this.cloneValue = this.helper.getLocal(local, this.method);
    }

    public void caseLongConstant(LongConstant longConstant) {
        this.cloneValue = (LongConstant)longConstant.clone();
    }

    public void caseLookupSwitchStmt(LookupSwitchStmt lookupSwitchStmt) {
        lookupSwitchStmt.getKey().apply((Switch)this);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        Iterator iterator = lookupSwitchStmt.getLookupValues().iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            value.apply((Switch)this);
            arrayList.add(this.cloneValue);
        }
        this.cloneStmt = JIMPLE.newLookupSwitchStmt(this.cloneValue, arrayList, lookupSwitchStmt.getTargets(), lookupSwitchStmt.getDefaultTarget());
    }

    public void caseNewArrayExpr(NewArrayExpr newArrayExpr) {
        newArrayExpr.getSize().apply((Switch)this);
        this.cloneValue = JIMPLE.newNewArrayExpr(newArrayExpr.getBaseType(), this.cloneValue);
    }

    public void caseNewExpr(NewExpr newExpr) {
        this.cloneValue = JIMPLE.newNewExpr(newExpr.getBaseType());
    }

    public void caseNewMultiArrayExpr(NewMultiArrayExpr newMultiArrayExpr) {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            newMultiArrayExpr.getSize(i).apply((Switch)this);
            arrayList.add(i, this.cloneValue);
        }
        this.cloneValue = JIMPLE.newNewMultiArrayExpr(newMultiArrayExpr.getBaseType(), arrayList);
    }

    public void caseNopStmt(NopStmt nopStmt) {
        this.cloneStmt = (NopStmt)nopStmt.clone();
    }

    public void caseNullConstant(NullConstant nullConstant) {
        this.cloneValue = (NullConstant)nullConstant.clone();
    }

    public void caseParameterRef(ParameterRef parameterRef) {
        this.cloneValue = (ParameterRef)parameterRef.clone();
    }

    public void caseRetStmt(RetStmt retStmt) {
        retStmt.getStmtAddress().apply((Switch)this);
        this.cloneStmt = JIMPLE.newRetStmt(this.cloneValue);
    }

    public void caseReturnStmt(ReturnStmt returnStmt) {
        returnStmt.getOp().apply((Switch)this);
        this.cloneStmt = JIMPLE.newReturnStmt(this.cloneValue);
    }

    public void caseReturnVoidStmt(ReturnVoidStmt returnVoidStmt) {
        this.cloneStmt = (ReturnVoidStmt)returnVoidStmt.clone();
    }

    public void caseSpecialInvokeExpr(SpecialInvokeExpr specialInvokeExpr) {
        specialInvokeExpr.getBase().apply((Switch)this);
        Local local = (Local)this.cloneValue;
        this.cloneValue = JIMPLE.newSpecialInvokeExpr(local, this.helper.getCloneOf(specialInvokeExpr.getMethod()), this.getArgs((InvokeExpr)specialInvokeExpr));
    }

    public void caseStaticFieldRef(StaticFieldRef staticFieldRef) {
        this.cloneValue = JIMPLE.newStaticFieldRef(this.helper.getCloneOf(staticFieldRef.getField()));
    }

    public void caseStaticInvokeExpr(StaticInvokeExpr staticInvokeExpr) {
        this.cloneValue = JIMPLE.newStaticInvokeExpr(this.helper.getCloneOf(staticInvokeExpr.getMethod()), this.getArgs((InvokeExpr)staticInvokeExpr));
    }

    public void caseStringConstant(StringConstant stringConstant) {
        this.cloneValue = (StringConstant)stringConstant.clone();
    }

    public void caseTableSwitchStmt(TableSwitchStmt tableSwitchStmt) {
        tableSwitchStmt.getKey().apply((Switch)this);
        this.cloneStmt = JIMPLE.newTableSwitchStmt(this.cloneValue, tableSwitchStmt.getLowIndex(), tableSwitchStmt.getHighIndex(), tableSwitchStmt.getTargets(), tableSwitchStmt.getDefaultTarget());
    }

    public void caseThisRef(ThisRef thisRef) {
        this.cloneValue = JIMPLE.newThisRef((RefType)thisRef.getType());
    }

    public void caseThrowStmt(ThrowStmt throwStmt) {
        throwStmt.getOp().apply((Switch)this);
        this.cloneStmt = JIMPLE.newThrowStmt(this.cloneValue);
    }

    public void caseVirtualInvokeExpr(VirtualInvokeExpr virtualInvokeExpr) {
        virtualInvokeExpr.getBase().apply((Switch)this);
        Local local = (Local)this.cloneValue;
        this.cloneValue = JIMPLE.newVirtualInvokeExpr(local, this.helper.getCloneOf(virtualInvokeExpr.getMethod()), this.getArgs((InvokeExpr)virtualInvokeExpr));
    }

    public Stmt cloneASTFragment(Stmt stmt, SootMethod sootMethod) {
        this.method = sootMethod;
        stmt.apply((Switch)this);
        return this.cloneStmt;
    }

    public Value cloneASTFragment(Value value, SootMethod sootMethod) {
        this.method = sootMethod;
        value.apply((Switch)this);
        return this.cloneValue;
    }

    private List getArgs(InvokeExpr invokeExpr) {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            invokeExpr.getArg(i).apply((Switch)this);
            arrayList.add(i, this.cloneValue);
        }
        return arrayList;
    }

    public static interface IASTClonerHelper {
        public SootMethod getCloneOf(SootMethod var1);

        public SootField getCloneOf(SootField var1);

        public SootClass getCloneOf(SootClass var1);

        public SootClass getCloneOf(String var1);

        public Local getLocal(Local var1, SootMethod var2);
    }
}

