/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.tools.AbstractToolConfigurator;
import edu.ksu.cis.indus.tools.CompositeToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurationFactory;
import edu.ksu.cis.indus.tools.IToolConfigurator;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public final class CompositeToolConfigurator
extends AbstractToolConfigurator {
    private Combo configCombo;
    private Composite childComposite;
    private CompositeToolConfiguration compositeConfiguration;
    private IToolConfigurationFactory toolConfigFactory;
    private IToolConfigurator childConfigurator;
    private int selectedIndex;

    public CompositeToolConfigurator(CompositeToolConfiguration compositeToolConfiguration, IToolConfigurator iToolConfigurator, IToolConfigurationFactory iToolConfigurationFactory) {
        this.compositeConfiguration = compositeToolConfiguration;
        this.childConfigurator = iToolConfigurator;
        this.toolConfigFactory = iToolConfigurationFactory;
    }

    protected void checkConfiguration(IToolConfiguration iToolConfiguration) {
    }

    protected void setup() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.parent.setLayout((Layout)gridLayout);
        Label label = new Label(this.parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText("Configurations:");
        this.configCombo = new Combo(this.parent, 4);
        this.configCombo.setItems(new String[0]);
        this.configCombo.setLayoutData((Object)new GridData(768));
        this.configCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CompositeToolConfigurator.this.recordSelection();
                CompositeToolConfigurator.this.displayChild();
                CompositeToolConfigurator.this.parent.layout();
                CompositeToolConfigurator.this.parent.pack();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        this.configCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CompositeToolConfigurator.this.updateConfigName();
            }

            public void focusGained(FocusEvent focusEvent) {
                CompositeToolConfigurator.this.recordSelection();
            }
        });
        this.configCombo.setVisible(true);
        Button button = new Button(this.parent, 8);
        button.setText("Create");
        gridData = new GridData(128);
        gridData.horizontalIndent = button.getText().length();
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CompositeToolConfigurator.this.createNewConfiguration();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        if (this.compositeConfiguration.configurations.isEmpty()) {
            this.compositeConfiguration.configurations.add(this.toolConfigFactory.createToolConfiguration());
        }
        Object object = this.compositeConfiguration.configurations.iterator();
        while (object.hasNext()) {
            IToolConfiguration iToolConfiguration = (IToolConfiguration)object.next();
            this.configCombo.add(iToolConfiguration.getConfigName());
        }
        object = this.compositeConfiguration.getActiveToolConfiguration();
        this.configCombo.select(this.compositeConfiguration.configurations.indexOf(object));
        this.displayChild();
    }

    void createNewConfiguration() {
        IToolConfiguration iToolConfiguration = this.toolConfigFactory.createToolConfiguration();
        iToolConfiguration.setConfigName("tool_configuration_" + this.compositeConfiguration.configurations.size());
        this.compositeConfiguration.addToolConfiguration(iToolConfiguration);
        this.configCombo.add(iToolConfiguration.getConfigName());
        this.configCombo.select(this.compositeConfiguration.configurations.indexOf(iToolConfiguration));
    }

    void displayChild() {
        if (this.childComposite != null) {
            this.childComposite.dispose();
        }
        this.childComposite = new Composite(this.parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.childComposite.setLayoutData((Object)gridData);
        this.childComposite.setVisible(true);
        int n = this.configCombo.getSelectionIndex();
        IToolConfiguration iToolConfiguration = (IToolConfiguration)this.compositeConfiguration.configurations.get(n);
        this.compositeConfiguration.setActiveToolConfiguration(iToolConfiguration);
        this.childConfigurator.setConfiguration(iToolConfiguration);
        this.childConfigurator.initialize(this.childComposite);
    }

    void recordSelection() {
        this.selectedIndex = this.configCombo.getSelectionIndex();
    }

    void updateConfigName() {
        int n = this.configCombo.getSelectionIndex();
        if (n < 0) {
            List list = this.compositeConfiguration.configurations;
            IToolConfiguration iToolConfiguration = (IToolConfiguration)list.get(this.selectedIndex);
            String string = this.configCombo.getText();
            boolean bl = true;
            for (int i = this.configCombo.getItemCount() - 1; i >= 0 && bl; --i) {
                if (!((IToolConfiguration)list.get(i)).getConfigName().equals(string)) continue;
                MessageBox messageBox = new MessageBox(this.parent.getShell(), 34);
                messageBox.setMessage("A configuration with the name of \"" + string + "\" exists.  \nNo changes will be made.");
                bl = false;
            }
            if (bl) {
                iToolConfiguration.setConfigName(string);
                this.configCombo.remove(this.selectedIndex);
                this.configCombo.add(string, this.selectedIndex);
            }
        }
    }
}

