/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.tools.CompositeToolConfiguration;
import edu.ksu.cis.indus.tools.ITool;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTool
extends AbstractStatus
implements ITool {
    static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$tools$AbstractTool == null ? (class$edu$ksu$cis$indus$tools$AbstractTool = AbstractTool.class$("edu.ksu.cis.indus.tools.AbstractTool")) : class$edu$ksu$cis$indus$tools$AbstractTool));
    protected final Object control = new Object();
    protected IToolConfiguration configurationInfo;
    protected IToolConfigurator configurator;
    Exception childException;
    boolean pause;
    Thread thread;
    static /* synthetic */ Class class$edu$ksu$cis$indus$tools$AbstractTool;

    public final IToolConfiguration getActiveConfiguration() {
        IToolConfiguration iToolConfiguration = this.configurationInfo instanceof CompositeToolConfiguration ? ((CompositeToolConfiguration)this.configurationInfo).getActiveToolConfiguration() : this.configurationInfo;
        return iToolConfiguration;
    }

    public final IToolConfigurator getConfigurator() {
        return this.configurator;
    }

    public final void abort() {
    }

    public final void pause() {
        this.pause = true;
    }

    public final void resume() {
        this.pause = false;
        this.control.notify();
    }

    public final synchronized void run(final Object object, boolean bl) {
        block6: {
            if (!this.pause || this.isNotAlive()) {
                this.checkConfiguration();
                this.childException = null;
                this.unstable();
                this.thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        block9: {
                            Exception exception = null;
                            try {
                                try {
                                    AbstractTool.this.execute(object);
                                }
                                catch (InterruptedException interruptedException) {
                                    LOGGER.fatal((Object)"Interrupted while executing the tool.", (Throwable)interruptedException);
                                    exception = interruptedException;
                                    Object var4_3 = null;
                                    if (exception != null) {
                                        AbstractTool.this.childException = exception;
                                    }
                                    AbstractTool.this.pause = false;
                                    break block9;
                                }
                                catch (Exception exception2) {
                                    LOGGER.fatal((Object)"Tool failed.", (Throwable)exception2);
                                    exception = exception2;
                                    Object var4_4 = null;
                                    if (exception != null) {
                                        AbstractTool.this.childException = exception;
                                    }
                                    AbstractTool.this.pause = false;
                                }
                                Object var4_2 = null;
                                if (exception != null) {
                                    AbstractTool.this.childException = exception;
                                }
                                AbstractTool.this.pause = false;
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                if (exception != null) {
                                    AbstractTool.this.childException = exception;
                                }
                                AbstractTool.this.pause = false;
                                throw throwable;
                            }
                        }
                    }
                };
                this.thread.start();
                if (bl) {
                    try {
                        this.thread.join();
                        if (this.childException != null) {
                            throw new RuntimeException(this.childException);
                        }
                        break block6;
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.error((Object)"Interrupted while waiting on the run to complete.", (Throwable)interruptedException);
                        throw new RuntimeException(interruptedException);
                    }
                }
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            AbstractTool.this.thread.join();
                            AbstractTool.this.stable();
                        }
                        catch (InterruptedException interruptedException) {
                            LOGGER.error((Object)"Interrupted while waiting on the helper thread.", (Throwable)interruptedException);
                        }
                    }
                };
                thread.start();
            } else {
                throw new IllegalStateException("run() should be called when the tool is paused or running.");
            }
        }
    }

    protected void checkConfiguration() {
    }

    protected abstract void execute(Object var1) throws InterruptedException;

    protected final void movingToNextPhase() throws InterruptedException {
        if (this.pause) {
            this.control.wait();
        }
    }

    private boolean isNotAlive() {
        return this.thread == null || !this.thread.isAlive();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

