/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.processing;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.Local;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.toolkits.graph.UnitGraph;
import soot.util.Switch;

public class ProcessingController {
    public static final Collection STMT_CLASSES;
    public static final Collection VALUE_CLASSES;
    private static final Log LOGGER;
    protected final Collection interfaceProcessors = new ArrayList();
    protected Context context = new Context();
    protected final Map class2processors = new HashMap();
    protected final StmtSwitcher stmtSwitcher = new StmtSwitcher(new ValueSwitcher());
    boolean processStmts;
    boolean processValues;
    private IEnvironment env;
    private IProcessingFilter processingFilter;
    private IStmtGraphFactory stmtGraphFactory;
    static /* synthetic */ Class class$edu$ksu$cis$indus$processing$ProcessingController;
    static /* synthetic */ Class class$soot$jimple$AssignStmt;
    static /* synthetic */ Class class$soot$jimple$BreakpointStmt;
    static /* synthetic */ Class class$soot$jimple$EnterMonitorStmt;
    static /* synthetic */ Class class$soot$jimple$ExitMonitorStmt;
    static /* synthetic */ Class class$soot$jimple$GotoStmt;
    static /* synthetic */ Class class$soot$jimple$IdentityStmt;
    static /* synthetic */ Class class$soot$jimple$IfStmt;
    static /* synthetic */ Class class$soot$jimple$InvokeStmt;
    static /* synthetic */ Class class$soot$jimple$LookupSwitchStmt;
    static /* synthetic */ Class class$soot$jimple$NopStmt;
    static /* synthetic */ Class class$soot$jimple$RetStmt;
    static /* synthetic */ Class class$soot$jimple$ReturnVoidStmt;
    static /* synthetic */ Class class$soot$jimple$ReturnStmt;
    static /* synthetic */ Class class$soot$jimple$TableSwitchStmt;
    static /* synthetic */ Class class$soot$jimple$ThrowStmt;
    static /* synthetic */ Class class$soot$jimple$AddExpr;
    static /* synthetic */ Class class$soot$jimple$AndExpr;
    static /* synthetic */ Class class$soot$jimple$ArrayRef;
    static /* synthetic */ Class class$soot$jimple$CastExpr;
    static /* synthetic */ Class class$soot$jimple$CaughtExceptionRef;
    static /* synthetic */ Class class$soot$jimple$CmpExpr;
    static /* synthetic */ Class class$soot$jimple$CmpgExpr;
    static /* synthetic */ Class class$soot$jimple$CmplExpr;
    static /* synthetic */ Class class$soot$jimple$DivExpr;
    static /* synthetic */ Class class$soot$jimple$DoubleConstant;
    static /* synthetic */ Class class$soot$jimple$EqExpr;
    static /* synthetic */ Class class$soot$jimple$FloatConstant;
    static /* synthetic */ Class class$soot$jimple$GeExpr;
    static /* synthetic */ Class class$soot$jimple$GtExpr;
    static /* synthetic */ Class class$soot$jimple$InstanceFieldRef;
    static /* synthetic */ Class class$soot$jimple$InstanceOfExpr;
    static /* synthetic */ Class class$soot$jimple$IntConstant;
    static /* synthetic */ Class class$soot$jimple$InterfaceInvokeExpr;
    static /* synthetic */ Class class$soot$jimple$LeExpr;
    static /* synthetic */ Class class$soot$jimple$LengthExpr;
    static /* synthetic */ Class class$soot$Local;
    static /* synthetic */ Class class$soot$jimple$LongConstant;
    static /* synthetic */ Class class$soot$jimple$LtExpr;
    static /* synthetic */ Class class$soot$jimple$MulExpr;
    static /* synthetic */ Class class$soot$jimple$NeExpr;
    static /* synthetic */ Class class$soot$jimple$NegExpr;
    static /* synthetic */ Class class$soot$jimple$NewArrayExpr;
    static /* synthetic */ Class class$soot$jimple$NewExpr;
    static /* synthetic */ Class class$soot$jimple$NewMultiArrayExpr;
    static /* synthetic */ Class class$soot$jimple$NullConstant;
    static /* synthetic */ Class class$soot$jimple$OrExpr;
    static /* synthetic */ Class class$soot$jimple$ParameterRef;
    static /* synthetic */ Class class$soot$jimple$RemExpr;
    static /* synthetic */ Class class$soot$jimple$ShlExpr;
    static /* synthetic */ Class class$soot$jimple$ShrExpr;
    static /* synthetic */ Class class$soot$jimple$SpecialInvokeExpr;
    static /* synthetic */ Class class$soot$jimple$StaticFieldRef;
    static /* synthetic */ Class class$soot$jimple$StaticInvokeExpr;
    static /* synthetic */ Class class$soot$jimple$StringConstant;
    static /* synthetic */ Class class$soot$jimple$SubExpr;
    static /* synthetic */ Class class$soot$jimple$ThisRef;
    static /* synthetic */ Class class$soot$jimple$UshrExpr;
    static /* synthetic */ Class class$soot$jimple$VirtualInvokeExpr;
    static /* synthetic */ Class class$soot$jimple$XorExpr;

    public final void setEnvironment(IEnvironment iEnvironment) {
        this.env = iEnvironment;
    }

    public final void setProcessingFilter(IProcessingFilter iProcessingFilter) {
        this.processingFilter = iProcessingFilter;
    }

    public void setStmtGraphFactory(IStmtGraphFactory iStmtGraphFactory) {
        this.stmtGraphFactory = iStmtGraphFactory;
    }

    public final void driveProcessors(Collection collection) {
        IProcessor iProcessor;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            iProcessor = (IProcessor)iterator.next();
            iProcessor.hookup(this);
        }
        this.process();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            iProcessor = (IProcessor)iterator.next();
            iProcessor.unhook(this);
        }
    }

    public final void process() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BEGIN: processing classes");
        }
        this.initializeProcessors();
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.interfaceProcessors);
        Iterator<Object> iterator = this.class2processors.values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll((Collection)iterator.next());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((IProcessor)iterator.next()).processingBegins();
        }
        this.processStmts = !CollectionUtils.intersection(this.class2processors.keySet(), (Collection)STMT_CLASSES).isEmpty();
        this.processValues = !CollectionUtils.intersection(this.class2processors.keySet(), (Collection)VALUE_CLASSES).isEmpty();
        this.processClasses(this.env.getClasses());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: processing classes");
            LOGGER.debug((Object)"BEGIN: consolidation");
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((IProcessor)iterator.next()).consolidate();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"END: consolidation");
        }
    }

    public final void register(Class clazz, IProcessor iProcessor) {
        HashSet<IProcessor> hashSet = (HashSet<IProcessor>)this.class2processors.get(clazz);
        if (hashSet == null) {
            hashSet = new HashSet<IProcessor>();
            this.class2processors.put(clazz, hashSet);
        }
        hashSet.add(iProcessor);
    }

    public final void register(IProcessor iProcessor) {
        if (!this.interfaceProcessors.contains(iProcessor)) {
            this.interfaceProcessors.add(iProcessor);
        }
    }

    public final void registerForAllStmts(IProcessor iProcessor) {
        Iterator iterator = STMT_CLASSES.iterator();
        while (iterator.hasNext()) {
            this.register((Class)iterator.next(), iProcessor);
        }
    }

    public final void registerForAllValues(IProcessor iProcessor) {
        Iterator iterator = VALUE_CLASSES.iterator();
        while (iterator.hasNext()) {
            this.register((Class)iterator.next(), iProcessor);
        }
    }

    public final void reset() {
        this.class2processors.clear();
        this.interfaceProcessors.clear();
        this.processStmts = false;
        this.processValues = false;
        this.context.setStmt(null);
        this.context.setProgramPoint(null);
        this.context.setRootMethod(null);
        this.context.returnFromCurrentMethod();
    }

    public final void unregister(Class clazz, IProcessor iProcessor) {
        Set set = (Set)this.class2processors.get(clazz);
        if (set == null) {
            throw new IllegalArgumentException("There are no processors registered  for " + clazz.getName());
        }
        set.remove(iProcessor);
    }

    public final void unregister(IProcessor iProcessor) {
        this.interfaceProcessors.remove(iProcessor);
    }

    public final void unregisterForAllStmts(IProcessor iProcessor) {
        Iterator iterator = STMT_CLASSES.iterator();
        while (iterator.hasNext()) {
            this.unregister((Class)iterator.next(), iProcessor);
        }
    }

    public final void unregisterForAllValues(IProcessor iProcessor) {
        Iterator iterator = VALUE_CLASSES.iterator();
        while (iterator.hasNext()) {
            this.unregister((Class)iterator.next(), iProcessor);
        }
    }

    protected void initializeProcessors() {
    }

    protected final void processClasses(Collection collection) {
        Collection collection2;
        if (this.processingFilter == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)"Performance may be hit as processing filter is not set.");
            }
            collection2 = collection;
        } else {
            collection2 = this.processingFilter.filterClasses(collection);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Classes to be processed:\n" + collection2));
        }
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Processing class " + sootClass));
            }
            Iterator iterator2 = this.interfaceProcessors.iterator();
            while (iterator2.hasNext()) {
                IProcessor iProcessor = (IProcessor)iterator2.next();
                iProcessor.callback(sootClass);
                Object object = this.processingFilter == null ? sootClass.getFields() : this.processingFilter.filterFields((Collection)sootClass.getFields());
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    iProcessor.callback((SootField)iterator3.next());
                }
            }
            this.processMethods(sootClass.getMethods());
        }
    }

    protected final void processMethods(Collection collection) {
        Collection collection2 = this.processingFilter == null ? collection : this.processingFilter.filterMethods(collection);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Methods to be processed:\n" + collection2));
        }
        boolean bl = this.processStmts || this.processValues;
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            this.context.setRootMethod(sootMethod);
            Iterator iterator2 = this.interfaceProcessors.iterator();
            while (iterator2.hasNext()) {
                ((IProcessor)iterator2.next()).callback(sootMethod);
            }
            if (bl && sootMethod.isConcrete()) {
                this.processMethodBody(sootMethod);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)(sootMethod + " is not a concrete method.  Hence, it's body could not be retrieved."));
        }
    }

    private void processMethodBody(SootMethod sootMethod) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Processing method " + sootMethod));
        }
        try {
            if (this.stmtGraphFactory == null) {
                if (sootMethod.hasActiveBody()) {
                    Iterator iterator = sootMethod.getActiveBody().getUnits().iterator();
                    while (iterator.hasNext()) {
                        Stmt stmt = (Stmt)iterator.next();
                        this.context.setStmt(stmt);
                        stmt.apply((Switch)this.stmtSwitcher);
                    }
                } else {
                    LOGGER.error((Object)("Active body was not available for " + sootMethod.getSignature()));
                }
            } else {
                UnitGraph unitGraph = this.stmtGraphFactory.getStmtGraph(sootMethod);
                Iterator iterator = unitGraph.iterator();
                while (iterator.hasNext()) {
                    Stmt stmt = (Stmt)iterator.next();
                    this.context.setStmt(stmt);
                    stmt.apply((Switch)this.stmtSwitcher);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error((Object)("Well, exception while processing statements of a method may mean the processor does not recognize the given method or it's parts or method has not stored in jimple representation. : " + sootMethod.getSignature()), (Throwable)runtimeException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$processing$ProcessingController == null ? (class$edu$ksu$cis$indus$processing$ProcessingController = ProcessingController.class$("edu.ksu.cis.indus.processing.ProcessingController")) : class$edu$ksu$cis$indus$processing$ProcessingController));
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(class$soot$jimple$AssignStmt == null ? (class$soot$jimple$AssignStmt = ProcessingController.class$("soot.jimple.AssignStmt")) : class$soot$jimple$AssignStmt);
        hashSet.add(class$soot$jimple$BreakpointStmt == null ? (class$soot$jimple$BreakpointStmt = ProcessingController.class$("soot.jimple.BreakpointStmt")) : class$soot$jimple$BreakpointStmt);
        hashSet.add(class$soot$jimple$EnterMonitorStmt == null ? (class$soot$jimple$EnterMonitorStmt = ProcessingController.class$("soot.jimple.EnterMonitorStmt")) : class$soot$jimple$EnterMonitorStmt);
        hashSet.add(class$soot$jimple$ExitMonitorStmt == null ? (class$soot$jimple$ExitMonitorStmt = ProcessingController.class$("soot.jimple.ExitMonitorStmt")) : class$soot$jimple$ExitMonitorStmt);
        hashSet.add(class$soot$jimple$GotoStmt == null ? (class$soot$jimple$GotoStmt = ProcessingController.class$("soot.jimple.GotoStmt")) : class$soot$jimple$GotoStmt);
        hashSet.add(class$soot$jimple$IdentityStmt == null ? (class$soot$jimple$IdentityStmt = ProcessingController.class$("soot.jimple.IdentityStmt")) : class$soot$jimple$IdentityStmt);
        hashSet.add(class$soot$jimple$IfStmt == null ? (class$soot$jimple$IfStmt = ProcessingController.class$("soot.jimple.IfStmt")) : class$soot$jimple$IfStmt);
        hashSet.add(class$soot$jimple$InvokeStmt == null ? (class$soot$jimple$InvokeStmt = ProcessingController.class$("soot.jimple.InvokeStmt")) : class$soot$jimple$InvokeStmt);
        hashSet.add(class$soot$jimple$LookupSwitchStmt == null ? (class$soot$jimple$LookupSwitchStmt = ProcessingController.class$("soot.jimple.LookupSwitchStmt")) : class$soot$jimple$LookupSwitchStmt);
        hashSet.add(class$soot$jimple$NopStmt == null ? (class$soot$jimple$NopStmt = ProcessingController.class$("soot.jimple.NopStmt")) : class$soot$jimple$NopStmt);
        hashSet.add(class$soot$jimple$RetStmt == null ? (class$soot$jimple$RetStmt = ProcessingController.class$("soot.jimple.RetStmt")) : class$soot$jimple$RetStmt);
        hashSet.add(class$soot$jimple$ReturnVoidStmt == null ? (class$soot$jimple$ReturnVoidStmt = ProcessingController.class$("soot.jimple.ReturnVoidStmt")) : class$soot$jimple$ReturnVoidStmt);
        hashSet.add(class$soot$jimple$ReturnStmt == null ? (class$soot$jimple$ReturnStmt = ProcessingController.class$("soot.jimple.ReturnStmt")) : class$soot$jimple$ReturnStmt);
        hashSet.add(class$soot$jimple$TableSwitchStmt == null ? (class$soot$jimple$TableSwitchStmt = ProcessingController.class$("soot.jimple.TableSwitchStmt")) : class$soot$jimple$TableSwitchStmt);
        hashSet.add(class$soot$jimple$ThrowStmt == null ? (class$soot$jimple$ThrowStmt = ProcessingController.class$("soot.jimple.ThrowStmt")) : class$soot$jimple$ThrowStmt);
        STMT_CLASSES = Collections.unmodifiableCollection(hashSet);
        hashSet = new HashSet();
        hashSet.add(class$soot$jimple$AddExpr == null ? (class$soot$jimple$AddExpr = ProcessingController.class$("soot.jimple.AddExpr")) : class$soot$jimple$AddExpr);
        hashSet.add(class$soot$jimple$AndExpr == null ? (class$soot$jimple$AndExpr = ProcessingController.class$("soot.jimple.AndExpr")) : class$soot$jimple$AndExpr);
        hashSet.add(class$soot$jimple$ArrayRef == null ? (class$soot$jimple$ArrayRef = ProcessingController.class$("soot.jimple.ArrayRef")) : class$soot$jimple$ArrayRef);
        hashSet.add(class$soot$jimple$CastExpr == null ? (class$soot$jimple$CastExpr = ProcessingController.class$("soot.jimple.CastExpr")) : class$soot$jimple$CastExpr);
        hashSet.add(class$soot$jimple$CaughtExceptionRef == null ? (class$soot$jimple$CaughtExceptionRef = ProcessingController.class$("soot.jimple.CaughtExceptionRef")) : class$soot$jimple$CaughtExceptionRef);
        hashSet.add(class$soot$jimple$CmpExpr == null ? (class$soot$jimple$CmpExpr = ProcessingController.class$("soot.jimple.CmpExpr")) : class$soot$jimple$CmpExpr);
        hashSet.add(class$soot$jimple$CmpgExpr == null ? (class$soot$jimple$CmpgExpr = ProcessingController.class$("soot.jimple.CmpgExpr")) : class$soot$jimple$CmpgExpr);
        hashSet.add(class$soot$jimple$CmplExpr == null ? (class$soot$jimple$CmplExpr = ProcessingController.class$("soot.jimple.CmplExpr")) : class$soot$jimple$CmplExpr);
        hashSet.add(class$soot$jimple$DivExpr == null ? (class$soot$jimple$DivExpr = ProcessingController.class$("soot.jimple.DivExpr")) : class$soot$jimple$DivExpr);
        hashSet.add(class$soot$jimple$DoubleConstant == null ? (class$soot$jimple$DoubleConstant = ProcessingController.class$("soot.jimple.DoubleConstant")) : class$soot$jimple$DoubleConstant);
        hashSet.add(class$soot$jimple$EqExpr == null ? (class$soot$jimple$EqExpr = ProcessingController.class$("soot.jimple.EqExpr")) : class$soot$jimple$EqExpr);
        hashSet.add(class$soot$jimple$FloatConstant == null ? (class$soot$jimple$FloatConstant = ProcessingController.class$("soot.jimple.FloatConstant")) : class$soot$jimple$FloatConstant);
        hashSet.add(class$soot$jimple$GeExpr == null ? (class$soot$jimple$GeExpr = ProcessingController.class$("soot.jimple.GeExpr")) : class$soot$jimple$GeExpr);
        hashSet.add(class$soot$jimple$GtExpr == null ? (class$soot$jimple$GtExpr = ProcessingController.class$("soot.jimple.GtExpr")) : class$soot$jimple$GtExpr);
        hashSet.add(class$soot$jimple$InstanceFieldRef == null ? (class$soot$jimple$InstanceFieldRef = ProcessingController.class$("soot.jimple.InstanceFieldRef")) : class$soot$jimple$InstanceFieldRef);
        hashSet.add(class$soot$jimple$InstanceOfExpr == null ? (class$soot$jimple$InstanceOfExpr = ProcessingController.class$("soot.jimple.InstanceOfExpr")) : class$soot$jimple$InstanceOfExpr);
        hashSet.add(class$soot$jimple$IntConstant == null ? (class$soot$jimple$IntConstant = ProcessingController.class$("soot.jimple.IntConstant")) : class$soot$jimple$IntConstant);
        hashSet.add(class$soot$jimple$InterfaceInvokeExpr == null ? (class$soot$jimple$InterfaceInvokeExpr = ProcessingController.class$("soot.jimple.InterfaceInvokeExpr")) : class$soot$jimple$InterfaceInvokeExpr);
        hashSet.add(class$soot$jimple$LeExpr == null ? (class$soot$jimple$LeExpr = ProcessingController.class$("soot.jimple.LeExpr")) : class$soot$jimple$LeExpr);
        hashSet.add(class$soot$jimple$LengthExpr == null ? (class$soot$jimple$LengthExpr = ProcessingController.class$("soot.jimple.LengthExpr")) : class$soot$jimple$LengthExpr);
        hashSet.add(class$soot$Local == null ? (class$soot$Local = ProcessingController.class$("soot.Local")) : class$soot$Local);
        hashSet.add(class$soot$jimple$LongConstant == null ? (class$soot$jimple$LongConstant = ProcessingController.class$("soot.jimple.LongConstant")) : class$soot$jimple$LongConstant);
        hashSet.add(class$soot$jimple$LtExpr == null ? (class$soot$jimple$LtExpr = ProcessingController.class$("soot.jimple.LtExpr")) : class$soot$jimple$LtExpr);
        hashSet.add(class$soot$jimple$MulExpr == null ? (class$soot$jimple$MulExpr = ProcessingController.class$("soot.jimple.MulExpr")) : class$soot$jimple$MulExpr);
        hashSet.add(class$soot$jimple$NeExpr == null ? (class$soot$jimple$NeExpr = ProcessingController.class$("soot.jimple.NeExpr")) : class$soot$jimple$NeExpr);
        hashSet.add(class$soot$jimple$NegExpr == null ? (class$soot$jimple$NegExpr = ProcessingController.class$("soot.jimple.NegExpr")) : class$soot$jimple$NegExpr);
        hashSet.add(class$soot$jimple$NewArrayExpr == null ? (class$soot$jimple$NewArrayExpr = ProcessingController.class$("soot.jimple.NewArrayExpr")) : class$soot$jimple$NewArrayExpr);
        hashSet.add(class$soot$jimple$NewExpr == null ? (class$soot$jimple$NewExpr = ProcessingController.class$("soot.jimple.NewExpr")) : class$soot$jimple$NewExpr);
        hashSet.add(class$soot$jimple$NewMultiArrayExpr == null ? (class$soot$jimple$NewMultiArrayExpr = ProcessingController.class$("soot.jimple.NewMultiArrayExpr")) : class$soot$jimple$NewMultiArrayExpr);
        hashSet.add(class$soot$jimple$NullConstant == null ? (class$soot$jimple$NullConstant = ProcessingController.class$("soot.jimple.NullConstant")) : class$soot$jimple$NullConstant);
        hashSet.add(class$soot$jimple$OrExpr == null ? (class$soot$jimple$OrExpr = ProcessingController.class$("soot.jimple.OrExpr")) : class$soot$jimple$OrExpr);
        hashSet.add(class$soot$jimple$ParameterRef == null ? (class$soot$jimple$ParameterRef = ProcessingController.class$("soot.jimple.ParameterRef")) : class$soot$jimple$ParameterRef);
        hashSet.add(class$soot$jimple$RemExpr == null ? (class$soot$jimple$RemExpr = ProcessingController.class$("soot.jimple.RemExpr")) : class$soot$jimple$RemExpr);
        hashSet.add(class$soot$jimple$ShlExpr == null ? (class$soot$jimple$ShlExpr = ProcessingController.class$("soot.jimple.ShlExpr")) : class$soot$jimple$ShlExpr);
        hashSet.add(class$soot$jimple$ShrExpr == null ? (class$soot$jimple$ShrExpr = ProcessingController.class$("soot.jimple.ShrExpr")) : class$soot$jimple$ShrExpr);
        hashSet.add(class$soot$jimple$SpecialInvokeExpr == null ? (class$soot$jimple$SpecialInvokeExpr = ProcessingController.class$("soot.jimple.SpecialInvokeExpr")) : class$soot$jimple$SpecialInvokeExpr);
        hashSet.add(class$soot$jimple$StaticFieldRef == null ? (class$soot$jimple$StaticFieldRef = ProcessingController.class$("soot.jimple.StaticFieldRef")) : class$soot$jimple$StaticFieldRef);
        hashSet.add(class$soot$jimple$StaticInvokeExpr == null ? (class$soot$jimple$StaticInvokeExpr = ProcessingController.class$("soot.jimple.StaticInvokeExpr")) : class$soot$jimple$StaticInvokeExpr);
        hashSet.add(class$soot$jimple$StringConstant == null ? (class$soot$jimple$StringConstant = ProcessingController.class$("soot.jimple.StringConstant")) : class$soot$jimple$StringConstant);
        hashSet.add(class$soot$jimple$SubExpr == null ? (class$soot$jimple$SubExpr = ProcessingController.class$("soot.jimple.SubExpr")) : class$soot$jimple$SubExpr);
        hashSet.add(class$soot$jimple$ThisRef == null ? (class$soot$jimple$ThisRef = ProcessingController.class$("soot.jimple.ThisRef")) : class$soot$jimple$ThisRef);
        hashSet.add(class$soot$jimple$UshrExpr == null ? (class$soot$jimple$UshrExpr = ProcessingController.class$("soot.jimple.UshrExpr")) : class$soot$jimple$UshrExpr);
        hashSet.add(class$soot$jimple$VirtualInvokeExpr == null ? (class$soot$jimple$VirtualInvokeExpr = ProcessingController.class$("soot.jimple.VirtualInvokeExpr")) : class$soot$jimple$VirtualInvokeExpr);
        hashSet.add(class$soot$jimple$XorExpr == null ? (class$soot$jimple$XorExpr = ProcessingController.class$("soot.jimple.XorExpr")) : class$soot$jimple$XorExpr);
        VALUE_CLASSES = Collections.unmodifiableCollection(hashSet);
    }

    private final class ValueSwitcher
    extends AbstractJimpleValueSwitch {
        private ValueSwitcher() {
        }

        public void caseAddExpr(AddExpr addExpr) {
            this.defaultCase(class$soot$jimple$AddExpr == null ? (class$soot$jimple$AddExpr = ProcessingController.class$("soot.jimple.AddExpr")) : class$soot$jimple$AddExpr);
            this.processBinaryExpr((BinopExpr)addExpr);
        }

        public void caseAndExpr(AndExpr andExpr) {
            this.defaultCase(class$soot$jimple$AndExpr == null ? (class$soot$jimple$AndExpr = ProcessingController.class$("soot.jimple.AndExpr")) : class$soot$jimple$AndExpr);
            this.processBinaryExpr((BinopExpr)andExpr);
        }

        public void caseArrayRef(ArrayRef arrayRef) {
            this.defaultCase(class$soot$jimple$ArrayRef == null ? (class$soot$jimple$ArrayRef = ProcessingController.class$("soot.jimple.ArrayRef")) : class$soot$jimple$ArrayRef);
            ProcessingController.this.context.setProgramPoint(arrayRef.getBaseBox());
            arrayRef.getBase().apply((Switch)this);
            ProcessingController.this.context.setProgramPoint(arrayRef.getIndexBox());
            arrayRef.getIndex().apply((Switch)this);
        }

        public void caseCastExpr(CastExpr castExpr) {
            this.defaultCase(class$soot$jimple$CastExpr == null ? (class$soot$jimple$CastExpr = ProcessingController.class$("soot.jimple.CastExpr")) : class$soot$jimple$CastExpr);
            ProcessingController.this.context.setProgramPoint(castExpr.getOpBox());
            castExpr.getOp().apply((Switch)this);
        }

        public void caseCaughtExceptionRef(CaughtExceptionRef caughtExceptionRef) {
            this.defaultCase(class$soot$jimple$CaughtExceptionRef == null ? (class$soot$jimple$CaughtExceptionRef = ProcessingController.class$("soot.jimple.CaughtExceptionRef")) : class$soot$jimple$CaughtExceptionRef);
        }

        public void caseCmpExpr(CmpExpr cmpExpr) {
            this.defaultCase(class$soot$jimple$CmpExpr == null ? (class$soot$jimple$CmpExpr = ProcessingController.class$("soot.jimple.CmpExpr")) : class$soot$jimple$CmpExpr);
            this.processBinaryExpr((BinopExpr)cmpExpr);
        }

        public void caseCmpgExpr(CmpgExpr cmpgExpr) {
            this.defaultCase(class$soot$jimple$CmpgExpr == null ? (class$soot$jimple$CmpgExpr = ProcessingController.class$("soot.jimple.CmpgExpr")) : class$soot$jimple$CmpgExpr);
            this.processBinaryExpr((BinopExpr)cmpgExpr);
        }

        public void caseCmplExpr(CmplExpr cmplExpr) {
            this.defaultCase(class$soot$jimple$CmplExpr == null ? (class$soot$jimple$CmplExpr = ProcessingController.class$("soot.jimple.CmplExpr")) : class$soot$jimple$CmplExpr);
            this.processBinaryExpr((BinopExpr)cmplExpr);
        }

        public void caseDivExpr(DivExpr divExpr) {
            this.defaultCase(class$soot$jimple$DivExpr == null ? (class$soot$jimple$DivExpr = ProcessingController.class$("soot.jimple.DivExpr")) : class$soot$jimple$DivExpr);
            this.processBinaryExpr((BinopExpr)divExpr);
        }

        public void caseDoubleConstant(DoubleConstant doubleConstant) {
            this.defaultCase(class$soot$jimple$DoubleConstant == null ? (class$soot$jimple$DoubleConstant = ProcessingController.class$("soot.jimple.DoubleConstant")) : class$soot$jimple$DoubleConstant);
        }

        public void caseEqExpr(EqExpr eqExpr) {
            this.defaultCase(class$soot$jimple$EqExpr == null ? (class$soot$jimple$EqExpr = ProcessingController.class$("soot.jimple.EqExpr")) : class$soot$jimple$EqExpr);
            this.processBinaryExpr((BinopExpr)eqExpr);
        }

        public void caseFloatConstant(FloatConstant floatConstant) {
            this.defaultCase(class$soot$jimple$FloatConstant == null ? (class$soot$jimple$FloatConstant = ProcessingController.class$("soot.jimple.FloatConstant")) : class$soot$jimple$FloatConstant);
        }

        public void caseGeExpr(GeExpr geExpr) {
            this.defaultCase(class$soot$jimple$GeExpr == null ? (class$soot$jimple$GeExpr = ProcessingController.class$("soot.jimple.GeExpr")) : class$soot$jimple$GeExpr);
            this.processBinaryExpr((BinopExpr)geExpr);
        }

        public void caseGtExpr(GtExpr gtExpr) {
            this.defaultCase(class$soot$jimple$GtExpr == null ? (class$soot$jimple$GtExpr = ProcessingController.class$("soot.jimple.GtExpr")) : class$soot$jimple$GtExpr);
            this.processBinaryExpr((BinopExpr)gtExpr);
        }

        public void caseInstanceFieldRef(InstanceFieldRef instanceFieldRef) {
            this.defaultCase(class$soot$jimple$InstanceFieldRef == null ? (class$soot$jimple$InstanceFieldRef = ProcessingController.class$("soot.jimple.InstanceFieldRef")) : class$soot$jimple$InstanceFieldRef);
            ProcessingController.this.context.setProgramPoint(instanceFieldRef.getBaseBox());
            instanceFieldRef.getBase().apply((Switch)this);
        }

        public void caseInstanceOfExpr(InstanceOfExpr instanceOfExpr) {
            this.defaultCase(class$soot$jimple$InstanceOfExpr == null ? (class$soot$jimple$InstanceOfExpr = ProcessingController.class$("soot.jimple.InstanceOfExpr")) : class$soot$jimple$InstanceOfExpr);
            ProcessingController.this.context.setProgramPoint(instanceOfExpr.getOpBox());
            instanceOfExpr.getOp().apply((Switch)this);
        }

        public void caseIntConstant(IntConstant intConstant) {
            this.defaultCase(class$soot$jimple$IntConstant == null ? (class$soot$jimple$IntConstant = ProcessingController.class$("soot.jimple.IntConstant")) : class$soot$jimple$IntConstant);
        }

        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr interfaceInvokeExpr) {
            this.defaultCase(class$soot$jimple$InterfaceInvokeExpr == null ? (class$soot$jimple$InterfaceInvokeExpr = ProcessingController.class$("soot.jimple.InterfaceInvokeExpr")) : class$soot$jimple$InterfaceInvokeExpr);
            this.processInvokeExpr((InvokeExpr)interfaceInvokeExpr);
        }

        public void caseLeExpr(LeExpr leExpr) {
            this.defaultCase(class$soot$jimple$LeExpr == null ? (class$soot$jimple$LeExpr = ProcessingController.class$("soot.jimple.LeExpr")) : class$soot$jimple$LeExpr);
            this.processBinaryExpr((BinopExpr)leExpr);
        }

        public void caseLengthExpr(LengthExpr lengthExpr) {
            this.defaultCase(class$soot$jimple$LengthExpr == null ? (class$soot$jimple$LengthExpr = ProcessingController.class$("soot.jimple.LengthExpr")) : class$soot$jimple$LengthExpr);
            this.processUnaryExpr((UnopExpr)lengthExpr);
        }

        public void caseLocal(Local local) {
            this.defaultCase(class$soot$Local == null ? (class$soot$Local = ProcessingController.class$("soot.Local")) : class$soot$Local);
        }

        public void caseLongConstant(LongConstant longConstant) {
            this.defaultCase(class$soot$jimple$LongConstant == null ? (class$soot$jimple$LongConstant = ProcessingController.class$("soot.jimple.LongConstant")) : class$soot$jimple$LongConstant);
        }

        public void caseLtExpr(LtExpr ltExpr) {
            this.defaultCase(class$soot$jimple$LtExpr == null ? (class$soot$jimple$LtExpr = ProcessingController.class$("soot.jimple.LtExpr")) : class$soot$jimple$LtExpr);
            this.processBinaryExpr((BinopExpr)ltExpr);
        }

        public void caseMulExpr(MulExpr mulExpr) {
            this.defaultCase(class$soot$jimple$MulExpr == null ? (class$soot$jimple$MulExpr = ProcessingController.class$("soot.jimple.MulExpr")) : class$soot$jimple$MulExpr);
            this.processBinaryExpr((BinopExpr)mulExpr);
        }

        public void caseNeExpr(NeExpr neExpr) {
            this.defaultCase(class$soot$jimple$NeExpr == null ? (class$soot$jimple$NeExpr = ProcessingController.class$("soot.jimple.NeExpr")) : class$soot$jimple$NeExpr);
            this.processBinaryExpr((BinopExpr)neExpr);
        }

        public void caseNegExpr(NegExpr negExpr) {
            this.defaultCase(class$soot$jimple$NegExpr == null ? (class$soot$jimple$NegExpr = ProcessingController.class$("soot.jimple.NegExpr")) : class$soot$jimple$NegExpr);
            this.processUnaryExpr((UnopExpr)negExpr);
        }

        public void caseNewArrayExpr(NewArrayExpr newArrayExpr) {
            this.defaultCase(class$soot$jimple$NewArrayExpr == null ? (class$soot$jimple$NewArrayExpr = ProcessingController.class$("soot.jimple.NewArrayExpr")) : class$soot$jimple$NewArrayExpr);
            ProcessingController.this.context.setProgramPoint(newArrayExpr.getSizeBox());
            newArrayExpr.getSize().apply((Switch)this);
        }

        public void caseNewExpr(NewExpr newExpr) {
            this.defaultCase(class$soot$jimple$NewExpr == null ? (class$soot$jimple$NewExpr = ProcessingController.class$("soot.jimple.NewExpr")) : class$soot$jimple$NewExpr);
        }

        public void caseNewMultiArrayExpr(NewMultiArrayExpr newMultiArrayExpr) {
            this.defaultCase(class$soot$jimple$NewMultiArrayExpr == null ? (class$soot$jimple$NewMultiArrayExpr = ProcessingController.class$("soot.jimple.NewMultiArrayExpr")) : class$soot$jimple$NewMultiArrayExpr);
            for (int i = 0; i < newMultiArrayExpr.getSizeCount(); ++i) {
                ProcessingController.this.context.setProgramPoint(newMultiArrayExpr.getSizeBox(i));
                newMultiArrayExpr.getSize(i).apply((Switch)this);
            }
        }

        public void caseNullConstant(NullConstant nullConstant) {
            this.defaultCase(class$soot$jimple$NullConstant == null ? (class$soot$jimple$NullConstant = ProcessingController.class$("soot.jimple.NullConstant")) : class$soot$jimple$NullConstant);
        }

        public void caseOrExpr(OrExpr orExpr) {
            this.defaultCase(class$soot$jimple$OrExpr == null ? (class$soot$jimple$OrExpr = ProcessingController.class$("soot.jimple.OrExpr")) : class$soot$jimple$OrExpr);
            this.processBinaryExpr((BinopExpr)orExpr);
        }

        public void caseParameterRef(ParameterRef parameterRef) {
            this.defaultCase(class$soot$jimple$ParameterRef == null ? (class$soot$jimple$ParameterRef = ProcessingController.class$("soot.jimple.ParameterRef")) : class$soot$jimple$ParameterRef);
        }

        public void caseRemExpr(RemExpr remExpr) {
            this.defaultCase(class$soot$jimple$RemExpr == null ? (class$soot$jimple$RemExpr = ProcessingController.class$("soot.jimple.RemExpr")) : class$soot$jimple$RemExpr);
            this.processBinaryExpr((BinopExpr)remExpr);
        }

        public void caseShlExpr(ShlExpr shlExpr) {
            this.defaultCase(class$soot$jimple$ShlExpr == null ? (class$soot$jimple$ShlExpr = ProcessingController.class$("soot.jimple.ShlExpr")) : class$soot$jimple$ShlExpr);
            this.processBinaryExpr((BinopExpr)shlExpr);
        }

        public void caseShrExpr(ShrExpr shrExpr) {
            this.defaultCase(class$soot$jimple$ShrExpr == null ? (class$soot$jimple$ShrExpr = ProcessingController.class$("soot.jimple.ShrExpr")) : class$soot$jimple$ShrExpr);
            this.processBinaryExpr((BinopExpr)shrExpr);
        }

        public void caseSpecialInvokeExpr(SpecialInvokeExpr specialInvokeExpr) {
            this.defaultCase(class$soot$jimple$SpecialInvokeExpr == null ? (class$soot$jimple$SpecialInvokeExpr = ProcessingController.class$("soot.jimple.SpecialInvokeExpr")) : class$soot$jimple$SpecialInvokeExpr);
            this.processInvokeExpr((InvokeExpr)specialInvokeExpr);
        }

        public void caseStaticFieldRef(StaticFieldRef staticFieldRef) {
            this.defaultCase(class$soot$jimple$StaticFieldRef == null ? (class$soot$jimple$StaticFieldRef = ProcessingController.class$("soot.jimple.StaticFieldRef")) : class$soot$jimple$StaticFieldRef);
        }

        public void caseStaticInvokeExpr(StaticInvokeExpr staticInvokeExpr) {
            this.defaultCase(class$soot$jimple$StaticInvokeExpr == null ? (class$soot$jimple$StaticInvokeExpr = ProcessingController.class$("soot.jimple.StaticInvokeExpr")) : class$soot$jimple$StaticInvokeExpr);
            this.processInvokeExpr((InvokeExpr)staticInvokeExpr);
        }

        public void caseStringConstant(StringConstant stringConstant) {
            this.defaultCase(class$soot$jimple$StringConstant == null ? (class$soot$jimple$StringConstant = ProcessingController.class$("soot.jimple.StringConstant")) : class$soot$jimple$StringConstant);
        }

        public void caseSubExpr(SubExpr subExpr) {
            this.defaultCase(class$soot$jimple$SubExpr == null ? (class$soot$jimple$SubExpr = ProcessingController.class$("soot.jimple.SubExpr")) : class$soot$jimple$SubExpr);
            this.processBinaryExpr((BinopExpr)subExpr);
        }

        public void caseThisRef(ThisRef thisRef) {
            this.defaultCase(class$soot$jimple$ThisRef == null ? (class$soot$jimple$ThisRef = ProcessingController.class$("soot.jimple.ThisRef")) : class$soot$jimple$ThisRef);
        }

        public void caseUshrExpr(UshrExpr ushrExpr) {
            this.defaultCase(class$soot$jimple$UshrExpr == null ? (class$soot$jimple$UshrExpr = ProcessingController.class$("soot.jimple.UshrExpr")) : class$soot$jimple$UshrExpr);
            this.processBinaryExpr((BinopExpr)ushrExpr);
        }

        public void caseVirtualInvokeExpr(VirtualInvokeExpr virtualInvokeExpr) {
            this.defaultCase(class$soot$jimple$VirtualInvokeExpr == null ? (class$soot$jimple$VirtualInvokeExpr = ProcessingController.class$("soot.jimple.VirtualInvokeExpr")) : class$soot$jimple$VirtualInvokeExpr);
            this.processInvokeExpr((InvokeExpr)virtualInvokeExpr);
        }

        public void caseXorExpr(XorExpr xorExpr) {
            this.defaultCase(class$soot$jimple$XorExpr == null ? (class$soot$jimple$XorExpr = ProcessingController.class$("soot.jimple.XorExpr")) : class$soot$jimple$XorExpr);
            this.processBinaryExpr((BinopExpr)xorExpr);
        }

        public void defaultCase(Class clazz) {
            Collection collection = (Collection)ProcessingController.this.class2processors.get(clazz);
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IProcessor iProcessor = (IProcessor)iterator.next();
                    iProcessor.callback(ProcessingController.this.context.getProgramPoint(), ProcessingController.this.context);
                }
            }
        }

        private void processBinaryExpr(BinopExpr binopExpr) {
            ProcessingController.this.context.setProgramPoint(binopExpr.getOp1Box());
            binopExpr.getOp1().apply((Switch)this);
            ProcessingController.this.context.setProgramPoint(binopExpr.getOp2Box());
            binopExpr.getOp2().apply((Switch)this);
        }

        private void processInvokeExpr(InvokeExpr invokeExpr) {
            if (invokeExpr instanceof InstanceInvokeExpr) {
                ProcessingController.this.context.setProgramPoint(((InstanceInvokeExpr)invokeExpr).getBaseBox());
                ((InstanceInvokeExpr)invokeExpr).getBase().apply((Switch)this);
            }
            for (int i = 0; i < invokeExpr.getArgCount(); ++i) {
                ProcessingController.this.context.setProgramPoint(invokeExpr.getArgBox(i));
                invokeExpr.getArg(i).apply((Switch)this);
            }
        }

        private void processUnaryExpr(UnopExpr unopExpr) {
            ProcessingController.this.context.setProgramPoint(unopExpr.getOpBox());
            unopExpr.getOp().apply((Switch)this);
        }
    }

    private final class StmtSwitcher
    extends AbstractStmtSwitch {
        private final ValueSwitcher valueSwitcher;

        StmtSwitcher(ValueSwitcher valueSwitcher) {
            this.valueSwitcher = valueSwitcher;
        }

        public void caseAssignStmt(AssignStmt assignStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$AssignStmt == null ? (class$soot$jimple$AssignStmt = ProcessingController.class$("soot.jimple.AssignStmt")) : class$soot$jimple$AssignStmt, assignStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(assignStmt.getLeftOpBox());
                assignStmt.getLeftOp().apply((Switch)this.valueSwitcher);
                ProcessingController.this.context.setProgramPoint(assignStmt.getRightOpBox());
                assignStmt.getRightOp().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseBreakpointStmt(BreakpointStmt breakpointStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$BreakpointStmt == null ? (class$soot$jimple$BreakpointStmt = ProcessingController.class$("soot.jimple.BreakpointStmt")) : class$soot$jimple$BreakpointStmt, breakpointStmt);
            }
        }

        public void caseEnterMonitorStmt(EnterMonitorStmt enterMonitorStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$EnterMonitorStmt == null ? (class$soot$jimple$EnterMonitorStmt = ProcessingController.class$("soot.jimple.EnterMonitorStmt")) : class$soot$jimple$EnterMonitorStmt, enterMonitorStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(enterMonitorStmt.getOpBox());
                enterMonitorStmt.getOp().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseExitMonitorStmt(ExitMonitorStmt exitMonitorStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$ExitMonitorStmt == null ? (class$soot$jimple$ExitMonitorStmt = ProcessingController.class$("soot.jimple.ExitMonitorStmt")) : class$soot$jimple$ExitMonitorStmt, exitMonitorStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(exitMonitorStmt.getOpBox());
                exitMonitorStmt.getOp().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseGotoStmt(GotoStmt gotoStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$GotoStmt == null ? (class$soot$jimple$GotoStmt = ProcessingController.class$("soot.jimple.GotoStmt")) : class$soot$jimple$GotoStmt, gotoStmt);
            }
        }

        public void caseIdentityStmt(IdentityStmt identityStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$IdentityStmt == null ? (class$soot$jimple$IdentityStmt = ProcessingController.class$("soot.jimple.IdentityStmt")) : class$soot$jimple$IdentityStmt, identityStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(identityStmt.getLeftOpBox());
                identityStmt.getLeftOp().apply((Switch)this.valueSwitcher);
                ProcessingController.this.context.setProgramPoint(identityStmt.getRightOpBox());
                identityStmt.getRightOp().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseIfStmt(IfStmt ifStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$IfStmt == null ? (class$soot$jimple$IfStmt = ProcessingController.class$("soot.jimple.IfStmt")) : class$soot$jimple$IfStmt, ifStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(ifStmt.getConditionBox());
                ifStmt.getCondition().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseInvokeStmt(InvokeStmt invokeStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$InvokeStmt == null ? (class$soot$jimple$InvokeStmt = ProcessingController.class$("soot.jimple.InvokeStmt")) : class$soot$jimple$InvokeStmt, invokeStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(invokeStmt.getInvokeExprBox());
                invokeStmt.getInvokeExpr().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseLookupSwitchStmt(LookupSwitchStmt lookupSwitchStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$LookupSwitchStmt == null ? (class$soot$jimple$LookupSwitchStmt = ProcessingController.class$("soot.jimple.LookupSwitchStmt")) : class$soot$jimple$LookupSwitchStmt, lookupSwitchStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(lookupSwitchStmt.getKeyBox());
                lookupSwitchStmt.getKey().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseNopStmt(NopStmt nopStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$NopStmt == null ? (class$soot$jimple$NopStmt = ProcessingController.class$("soot.jimple.NopStmt")) : class$soot$jimple$NopStmt, nopStmt);
            }
        }

        public void caseRetStmt(RetStmt retStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$RetStmt == null ? (class$soot$jimple$RetStmt = ProcessingController.class$("soot.jimple.RetStmt")) : class$soot$jimple$RetStmt, retStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(retStmt.getStmtAddressBox());
                retStmt.getStmtAddress().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseReturnStmt(ReturnStmt returnStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$ReturnStmt == null ? (class$soot$jimple$ReturnStmt = ProcessingController.class$("soot.jimple.ReturnStmt")) : class$soot$jimple$ReturnStmt, returnStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(returnStmt.getOpBox());
                returnStmt.getOp().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseReturnVoidStmt(ReturnVoidStmt returnVoidStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$ReturnVoidStmt == null ? (class$soot$jimple$ReturnVoidStmt = ProcessingController.class$("soot.jimple.ReturnVoidStmt")) : class$soot$jimple$ReturnVoidStmt, returnVoidStmt);
            }
        }

        public void caseTableSwitchStmt(TableSwitchStmt tableSwitchStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$TableSwitchStmt == null ? (class$soot$jimple$TableSwitchStmt = ProcessingController.class$("soot.jimple.TableSwitchStmt")) : class$soot$jimple$TableSwitchStmt, tableSwitchStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(tableSwitchStmt.getKeyBox());
                tableSwitchStmt.getKey().apply((Switch)this.valueSwitcher);
            }
        }

        public void caseThrowStmt(ThrowStmt throwStmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(class$soot$jimple$ThrowStmt == null ? (class$soot$jimple$ThrowStmt = ProcessingController.class$("soot.jimple.ThrowStmt")) : class$soot$jimple$ThrowStmt, throwStmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.context.setProgramPoint(throwStmt.getOpBox());
                throwStmt.getOp().apply((Switch)this.valueSwitcher);
            }
        }

        public void defaultCase(Class clazz, Object object) {
            Collection collection = (Collection)ProcessingController.this.class2processors.get(clazz);
            if (collection != null) {
                Stmt stmt = (Stmt)object;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    IProcessor iProcessor = (IProcessor)iterator.next();
                    iProcessor.callback(stmt, ProcessingController.this.context);
                }
            }
        }
    }
}

