/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.Environment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;

public class UtilTest
extends IndusTestCase {
    private static Scene scene;
    private static SootClass sc;
    private static final int NUMBER_OF_TESTS = 12;
    private static int count;

    public final void testFindMethodInSuperClassesAndInterfaces() {
        Collection collection = Util.findMethodInSuperClassesAndInterfaces(sc.getMethodByName("add"));
        UtilTest.assertFalse((boolean)collection.isEmpty());
        ArrayList<RefType> arrayList = new ArrayList<RefType>();
        arrayList.add(scene.loadClassAndSupport("java.lang.Object").getType());
        UtilTest.assertTrue((boolean)collection.contains(scene.loadClassAndSupport("java.util.Collection").getMethod("add", arrayList)));
        UtilTest.assertFalse((boolean)collection.isEmpty());
    }

    public final void testFixupThreadStartBody() {
        SootClass sootClass = scene.loadClassAndSupport("java.lang.Thread");
        Util.fixupThreadStartBody(scene);
        SootMethod sootMethod = sootClass.getMethodByName("start");
        UtilTest.assertFalse((boolean)sootMethod.isNative());
        UtilTest.assertTrue((sootMethod.getActiveBody() != null ? 1 : 0) != 0);
        UtilTest.assertTrue((boolean)sootMethod.isConcrete());
    }

    public final void testGetAncestors() {
        Collection collection = Util.getAncestors(sc);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("java.lang.Object");
        arrayList.add("java.util.Collection");
        arrayList.add("java.util.Set");
        arrayList.add("java.lang.Cloneable");
        arrayList.add("java.io.Serializable");
        arrayList.add("java.util.AbstractSet");
        arrayList.add("java.util.AbstractCollection");
        UtilTest.assertEquals((int)arrayList.size(), (int)collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            arrayList.remove(sootClass.getName());
        }
        UtilTest.assertTrue((boolean)arrayList.isEmpty());
    }

    public final void testGetDeclaringClass() {
        SootClass sootClass = Util.getDeclaringClass(sc, "notify", Collections.EMPTY_LIST, (Type)VoidType.v());
        UtilTest.assertTrue((boolean)sootClass.getName().equals("java.lang.Object"));
    }

    public final void testGetDefaultValueFor() {
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)IntType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)FloatType.v()).equals(FloatConstant.v((float)0.0f)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)DoubleType.v()).equals(DoubleConstant.v((double)0.0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)CharType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)BooleanType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)ByteType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)LongType.v()).equals(LongConstant.v((long)0L)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)ShortType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)ArrayType.v((Type)CharType.v(), (int)2)).equals(NullConstant.v()));
    }

    public final void testImplementsInterface() {
        UtilTest.assertTrue((boolean)Util.implementsInterface(sc, "java.util.Collection"));
        UtilTest.assertFalse((boolean)Util.implementsInterface(sc, "java.text.CharacterIterator"));
    }

    public final void testIsDescendentOfSootClassSootClass() {
        UtilTest.assertTrue((boolean)Util.isDescendentOf(sc, scene.getSootClass("java.util.AbstractSet")));
        UtilTest.assertFalse((boolean)Util.isDescendentOf(scene.getSootClass("java.util.AbstractSet"), sc));
        UtilTest.assertFalse((boolean)Util.isDescendentOf(sc, scene.loadClassAndSupport("java.util.AbstractList")));
    }

    public final void testIsDescendentOfSootClassString() {
        UtilTest.assertTrue((boolean)Util.isDescendentOf(sc, "java.util.AbstractSet"));
        UtilTest.assertFalse((boolean)Util.isDescendentOf(sc, "java.util.AbstractList"));
    }

    public final void testIsHierarchicallyRelated() {
        UtilTest.assertTrue((boolean)Util.isHierarchicallyRelated(sc, scene.getSootClass("java.util.AbstractSet")));
        UtilTest.assertFalse((boolean)Util.isHierarchicallyRelated(sc, scene.loadClassAndSupport("java.util.AbstractList")));
        UtilTest.assertTrue((boolean)Util.isHierarchicallyRelated(scene.getSootClass("java.util.AbstractSet"), sc));
    }

    public final void testIsSameOrSubType() {
        Environment environment = new Environment(scene);
        UtilTest.assertTrue((boolean)Util.isSameOrSubType((Type)sc.getType(), (Type)scene.getSootClass("java.util.AbstractSet").getType(), environment));
        UtilTest.assertFalse((boolean)Util.isSameOrSubType((Type)scene.getSootClass("java.util.AbstractSet").getType(), (Type)sc.getType(), environment));
        UtilTest.assertFalse((boolean)Util.isSameOrSubType((Type)sc.getType(), (Type)scene.loadClassAndSupport("java.util.AbstractList").getType(), environment));
        UtilTest.assertFalse((boolean)Util.isSameOrSubType((Type)scene.getSootClass("java.util.AbstractList").getType(), (Type)sc.getType(), environment));
    }

    public final void testRemoveMethodsWithSameSignature() {
        SootClass sootClass = scene.getSootClass("java.lang.Object");
        ArrayList arrayList = new ArrayList(sc.getMethods());
        int n = arrayList.size();
        Util.removeMethodsWithSameSignature(arrayList, sootClass.getMethods());
        UtilTest.assertTrue((arrayList.size() == n - 3 ? 1 : 0) != 0);
        arrayList = new ArrayList(sootClass.getMethods());
        n = arrayList.size();
        Util.removeMethodsWithSameSignature(arrayList, sootClass.getMethods());
        UtilTest.assertTrue((arrayList.size() != n ? 1 : 0) != 0);
        UtilTest.assertTrue((boolean)arrayList.isEmpty());
    }

    public final void testRetainMethodsWithSameSignature() {
        SootClass sootClass = scene.getSootClass("java.lang.Object");
        ArrayList arrayList = new ArrayList(sc.getMethods());
        int n = arrayList.size();
        Util.retainMethodsWithSameSignature(arrayList, sootClass.getMethods());
        UtilTest.assertTrue((arrayList.size() != n ? 1 : 0) != 0);
        UtilTest.assertTrue((arrayList.size() == 3 ? 1 : 0) != 0);
        arrayList = new ArrayList(sootClass.getMethods());
        n = arrayList.size();
        Util.retainMethodsWithSameSignature(arrayList, sootClass.getMethods());
        UtilTest.assertTrue((arrayList.size() == n ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        if (scene == null) {
            scene = Scene.v();
            sc = scene.loadClassAndSupport("java.util.HashSet");
        }
    }

    protected void tearDown() throws Exception {
        if (++count == 12) {
            G.reset();
            scene = null;
        }
    }
}

