/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.tagkit.Host;

public final class Util {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$common$soot$Util == null ? (class$edu$ksu$cis$indus$common$soot$Util = Util.class$("edu.ksu.cis.indus.common.soot.Util")) : class$edu$ksu$cis$indus$common$soot$Util));
    static /* synthetic */ Class class$edu$ksu$cis$indus$common$soot$Util;

    private Util() {
    }

    public static Collection getAncestors(SootClass sootClass) {
        HashSet hashSet = new HashSet();
        HashSet<SootClass> hashSet2 = new HashSet<SootClass>();
        HistoryAwareLIFOWorkBag historyAwareLIFOWorkBag = new HistoryAwareLIFOWorkBag(hashSet);
        historyAwareLIFOWorkBag.addWork(sootClass);
        while (historyAwareLIFOWorkBag.hasWork()) {
            Object object;
            SootClass sootClass2 = (SootClass)historyAwareLIFOWorkBag.getWork();
            if (sootClass2.hasSuperclass()) {
                object = sootClass2.getSuperclass();
                hashSet2.add((SootClass)object);
            }
            hashSet2.addAll((Collection<SootClass>)sootClass2.getInterfaces());
            object = hashSet2.iterator();
            while (object.hasNext()) {
                SootClass sootClass3 = (SootClass)object.next();
                historyAwareLIFOWorkBag.addWorkNoDuplicates(sootClass3);
            }
        }
        hashSet.remove(sootClass);
        return hashSet;
    }

    public static List getClassesInTopologicallySortedOrder(Collection collection, boolean bl) {
        Object object;
        SimpleNodeGraph simpleNodeGraph = new SimpleNodeGraph();
        HistoryAwareLIFOWorkBag historyAwareLIFOWorkBag = new HistoryAwareLIFOWorkBag(new HashSet());
        historyAwareLIFOWorkBag.addAllWork(collection);
        while (historyAwareLIFOWorkBag.hasWork()) {
            object = (SootClass)historyAwareLIFOWorkBag.getWork();
            INode iNode = simpleNodeGraph.getNode(object);
            Collection collection2 = CollectionUtils.intersection((Collection)object.getInterfaces(), (Collection)collection);
            SootClass sootClass = collection2.iterator();
            while (sootClass.hasNext()) {
                SootClass sootClass2 = (SootClass)sootClass.next();
                simpleNodeGraph.addEdgeFromTo(simpleNodeGraph.getNode(sootClass2), iNode);
                historyAwareLIFOWorkBag.addWorkNoDuplicates(sootClass2);
            }
            if (!object.hasSuperclass()) continue;
            sootClass = object.getSuperclass();
            simpleNodeGraph.addEdgeFromTo(simpleNodeGraph.getNode(sootClass), iNode);
            historyAwareLIFOWorkBag.addWorkNoDuplicates(sootClass);
        }
        object = simpleNodeGraph.performTopologicalSort(bl);
        CollectionUtils.transform((Collection)object, (Transformer)SimpleNodeGraph.OBJECT_EXTRACTOR);
        return object;
    }

    public static SootClass getDeclaringClass(SootClass sootClass, String string, List list, Type type) {
        SootClass sootClass2 = sootClass;
        while (!sootClass2.declaresMethod(string, list, type)) {
            if (Util.hasSuperclass(sootClass2)) {
                sootClass2 = sootClass2.getSuperclass();
                continue;
            }
            sootClass2 = null;
            break;
        }
        return sootClass2;
    }

    public static Value getDefaultValueFor(Type type) {
        NullConstant nullConstant = null;
        if (type instanceof RefLikeType) {
            nullConstant = NullConstant.v();
        } else if (type instanceof IntType) {
            nullConstant = IntConstant.v((int)0);
        } else if (type instanceof CharType) {
            nullConstant = IntConstant.v((int)0);
        } else if (type instanceof ByteType) {
            nullConstant = IntConstant.v((int)0);
        } else if (type instanceof BooleanType) {
            nullConstant = IntConstant.v((int)0);
        } else if (type instanceof DoubleType) {
            nullConstant = DoubleConstant.v((double)0.0);
        } else if (type instanceof FloatType) {
            nullConstant = FloatConstant.v((float)0.0f);
        } else if (type instanceof LongType) {
            nullConstant = LongConstant.v((long)0L);
        } else if (type instanceof ShortType) {
            nullConstant = IntConstant.v((int)0);
        } else {
            LOGGER.error((Object)("Illegal type specified." + type));
            throw new IllegalArgumentException("Illegal type specified." + type);
        }
        return nullConstant;
    }

    public static boolean isDescendentOf(SootClass sootClass, String string) {
        boolean bl = false;
        SootClass sootClass2 = sootClass;
        while (!bl) {
            if (sootClass2.getName().equals(string)) {
                bl = true;
                continue;
            }
            if (!Util.hasSuperclass(sootClass2)) break;
            sootClass2 = sootClass2.getSuperclass();
        }
        if (!bl) {
            bl = Util.implementsInterface(sootClass, string);
        }
        return bl;
    }

    public static boolean isDescendentOf(SootClass sootClass, SootClass sootClass2) {
        return Util.isDescendentOf(sootClass, sootClass2.getName());
    }

    public static boolean isHierarchicallyRelated(SootClass sootClass, SootClass sootClass2) {
        return Util.isDescendentOf(sootClass, sootClass2.getName()) || Util.isDescendentOf(sootClass2, sootClass.getName());
    }

    public static Collection getHostsWithTag(Collection collection, String string) {
        List<Host> list = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            if (!host.hasTag(string)) continue;
            list.add(host);
        }
        if (list.isEmpty()) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public static Type getPrimitiveTypeFor(String string, Scene scene) {
        IntType intType;
        if (string.equals("int")) {
            intType = IntType.v();
        } else if (string.equals("char")) {
            intType = CharType.v();
        } else if (string.equals("byte")) {
            intType = ByteType.v();
        } else if (string.equals("long")) {
            intType = LongType.v();
        } else if (string.equals("short")) {
            intType = ShortType.v();
        } else if (string.equals("float")) {
            intType = FloatType.v();
        } else if (string.equals("double")) {
            intType = DoubleType.v();
        } else if (string.equals("boolean")) {
            intType = BooleanType.v();
        } else if (string.equals("void")) {
            intType = VoidType.v();
        } else {
            SootClass sootClass = scene.getSootClass(string);
            if (sootClass == null) {
                String string2 = string + " is not available in the System.";
                LOGGER.error((Object)string2);
                throw new MissingResourceException("Given type is not available in the System", string, null);
            }
            intType = sootClass.getType();
        }
        return intType;
    }

    public static boolean isReferenceType(Type type) {
        return type instanceof RefType || type instanceof ArrayType || type instanceof NullType;
    }

    public static boolean isSameOrSubType(Type type, Type type2, IEnvironment iEnvironment) {
        boolean bl = false;
        if (type.equals(type2)) {
            bl = true;
        } else if (type instanceof RefType && type2 instanceof RefType) {
            bl = Util.isDescendentOf(iEnvironment.getClass(((RefType)type).getClassName()), iEnvironment.getClass(((RefType)type2).getClassName()));
        }
        return bl;
    }

    public static String[] getSootOptions() {
        String[] stringArray = new String[]{"-p", "jb", "enabled:true,use-original-names:false", "-p", "jb.ls", "enabled:true", "-p", "jb.a", "enabled:true,only-stack-locals:true", "-p", "jb.ulp", "enabled:false"};
        return stringArray;
    }

    public static Type getTypeFor(String string, Scene scene) {
        int n = string.indexOf("[", 0);
        Object object = n == -1 ? Util.getPrimitiveTypeFor(string, scene) : ArrayType.v((Type)Util.getPrimitiveTypeFor(string.substring(0, n), scene), (int)(string.length() - n + 1));
        return object;
    }

    public static Collection findMethodInSuperClassesAndInterfaces(SootMethod sootMethod) {
        HistoryAwareFIFOWorkBag historyAwareFIFOWorkBag = new HistoryAwareFIFOWorkBag(new HashSet());
        Set<SootMethod> set = new HashSet();
        historyAwareFIFOWorkBag.addWork(sootMethod.getDeclaringClass());
        List list = sootMethod.getParameterTypes();
        Type type = sootMethod.getReturnType();
        String string = sootMethod.getName();
        while (historyAwareFIFOWorkBag.hasWork()) {
            Object object;
            SootClass sootClass = (SootClass)historyAwareFIFOWorkBag.getWork();
            if (sootClass.declaresMethod(string, list, type)) {
                set.add(sootClass.getMethod(string, list, type));
            }
            if (sootClass.hasSuperclass()) {
                object = sootClass.getSuperclass();
                historyAwareFIFOWorkBag.addWorkNoDuplicates(object);
            }
            object = sootClass.getInterfaces().iterator();
            while (object.hasNext()) {
                SootClass sootClass2 = (SootClass)object.next();
                historyAwareFIFOWorkBag.addWorkNoDuplicates(sootClass2);
            }
        }
        if (set.isEmpty()) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public static void fixupThreadStartBody(Scene scene) {
        SootClass sootClass;
        boolean bl = false;
        Iterator iterator = scene.getClasses().iterator();
        while (iterator.hasNext()) {
            sootClass = (SootClass)iterator.next();
            if (!Util.implementsInterface(sootClass, "java.lang.Runnable")) continue;
            bl = true;
            break;
        }
        if (bl && !(sootClass = (iterator = scene.getSootClass("java.lang.Thread")).getMethodByName("start")).isConcrete()) {
            iterator.setApplicationClass();
            iterator.setPhantom(false);
            sootClass.setModifiers(sootClass.getModifiers() & 0xFFFFFEFF);
            sootClass.setPhantom(false);
            Jimple jimple = Jimple.v();
            JimpleBody jimpleBody = jimple.newBody((SootMethod)sootClass);
            PatchingChain patchingChain = jimpleBody.getUnits();
            Local local = jimple.newLocal("$this", (Type)RefType.v((String)iterator.getName()));
            jimpleBody.getLocals().add((Object)local);
            patchingChain.addFirst((Object)jimple.newIdentityStmt((Value)local, (Value)jimple.newThisRef(RefType.v((SootClass)iterator))));
            VirtualInvokeExpr virtualInvokeExpr = jimple.newVirtualInvokeExpr(local, iterator.getMethodByName("run"), Collections.EMPTY_LIST);
            patchingChain.addLast((Object)jimple.newInvokeStmt((Value)virtualInvokeExpr));
            patchingChain.addLast((Object)jimple.newReturnVoidStmt());
            sootClass.setActiveBody((Body)jimpleBody);
        }
    }

    public static boolean hasSuperclass(SootClass sootClass) {
        boolean bl = false;
        if (!sootClass.getName().equals("java.lang.Object")) {
            bl = sootClass.hasSuperclass();
        }
        return bl;
    }

    public static boolean implementsInterface(SootClass sootClass, String string) {
        boolean bl = false;
        SootClass sootClass2 = sootClass;
        while (!bl && (sootClass2.getInterfaceCount() > 0 || Util.hasSuperclass(sootClass2))) {
            if (sootClass2.implementsInterface(string)) {
                bl = true;
                continue;
            }
            sootClass2 = sootClass2.getSuperclass();
        }
        return bl;
    }

    public static void removeMethodsWithSameSignature(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(collection);
        Util.retainMethodsWithSameSignature(hashSet, collection2);
        collection.removeAll(hashSet);
    }

    public static void retainMethodsWithSameSignature(Collection collection, Collection collection2) {
        HashSet<SootMethod> hashSet = new HashSet<SootMethod>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SootMethod sootMethod = (SootMethod)iterator.next();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod2 = (SootMethod)iterator2.next();
                if (!sootMethod.getSubSignature().equals(sootMethod2.getSubSignature())) continue;
                hashSet.add(sootMethod);
            }
        }
        collection.retainAll(hashSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

