/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import soot.ArrayType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.options.Options;

public class SootBasedDriver {
    public static final String TRAPPER_CLASS_PROPERTY;
    private static final Log LOGGER;
    private static final String STMT_GRAPH_FACTORY_CLASS_PROPERTY;
    private static final RootMethodTrapper DEFAULT_INSTANCE_OF_ROOT_METHOD_TRAPPER;
    private static final IStmtGraphFactory DEFAULT_INSTANCE_OF_STMT_GRAPH_FACTORY;
    protected BasicBlockGraphMgr bbm;
    protected Collection rootMethods = new HashSet();
    protected IStmtGraphFactory cfgProvider;
    protected List classNames;
    protected Scene scene;
    private Log logger;
    private final Map times = new LinkedHashMap();
    private RootMethodTrapper rootMethodTrapper;
    private String classpathToAdd;
    static /* synthetic */ Class class$edu$ksu$cis$indus$common$soot$SootBasedDriver;

    public SootBasedDriver() {
        this.cfgProvider = this.getStmtGraphFactory();
        this.bbm = new BasicBlockGraphMgr();
        this.bbm.setUnitGraphFactory(this.cfgProvider);
    }

    public final BasicBlockGraphMgr getBbm() {
        return this.bbm;
    }

    public final void setClassNames(Collection collection) {
        this.classNames = new ArrayList(collection);
    }

    public final void setLogger(Log log) {
        this.logger = log;
    }

    public final void setRootMethodTrapper(RootMethodTrapper rootMethodTrapper) {
        this.rootMethodTrapper = rootMethodTrapper;
    }

    public final Collection getRootMethods() {
        return Collections.unmodifiableCollection(this.rootMethods);
    }

    public final Scene getScene() {
        return this.scene;
    }

    public IStmtGraphFactory getStmtGraphFactory() {
        return DEFAULT_INSTANCE_OF_STMT_GRAPH_FACTORY;
    }

    public final void addTimeLog(String string, long l) {
        this.times.put("[" + this.times.size() + "]" + string, new Long(l));
    }

    public final void addToSootClassPath(String string) {
        this.classpathToAdd = string;
    }

    public final void initialize(String[] stringArray) {
        if (this.classNames == null) {
            throw new RuntimeException("Please call setClassNames() before using this object.");
        }
        this.writeInfo("Loading classes....");
        this.scene = this.loadupClassesAndCollectMains(stringArray);
    }

    public final void initialize() {
        this.initialize(Util.getSootOptions());
    }

    public final void printTimingStats() {
        this.writeInfo("Timing statistics:");
        Iterator iterator = this.times.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.writeInfo(k + " => " + this.times.get(k) + "ms");
        }
    }

    public void writeInfo(Object object) {
        if (this.logger != null && this.logger.isInfoEnabled()) {
            if (object != null) {
                this.logger.info((Object)object.toString());
            } else {
                this.logger.info((Object)"null");
            }
        }
    }

    private Scene loadupClassesAndCollectMains(String[] stringArray) {
        Object object;
        Scene scene = Scene.v();
        String string = scene.getSootClassPath();
        Options.v().parse(stringArray);
        string = string != null ? string + File.pathSeparator + this.classpathToAdd + File.pathSeparator + System.getProperty("java.class.path") : this.classpathToAdd;
        scene.setSootClassPath(string);
        Object object2 = this.classNames.iterator();
        while (object2.hasNext()) {
            object = scene.loadClassAndSupport((String)object2.next());
            object.setApplicationClass();
        }
        object2 = new HashSet();
        object2.addAll(scene.getClasses());
        object = this.rootMethodTrapper;
        if (object == null) {
            object = DEFAULT_INSTANCE_OF_ROOT_METHOD_TRAPPER;
        }
        ((RootMethodTrapper)object).setClassNames(Collections.unmodifiableCollection(this.classNames));
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            if (!((RootMethodTrapper)object).considerClassForEntryPoint(sootClass)) continue;
            List list = sootClass.getMethods();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod = (SootMethod)iterator2.next();
                if (!((RootMethodTrapper)object).trapRootMethods(sootMethod)) continue;
                this.rootMethods.add(sootMethod);
            }
        }
        Util.fixupThreadStartBody(scene);
        return scene;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$common$soot$SootBasedDriver == null ? (class$edu$ksu$cis$indus$common$soot$SootBasedDriver = SootBasedDriver.class$("edu.ksu.cis.indus.common.soot.SootBasedDriver")) : class$edu$ksu$cis$indus$common$soot$SootBasedDriver));
        TRAPPER_CLASS_PROPERTY = "indus.common.soot.SootBasedDriver.RootMethodTrapper.class";
        String string = System.getProperty(TRAPPER_CLASS_PROPERTY);
        RootMethodTrapper rootMethodTrapper = new RootMethodTrapper();
        if (string != null) {
            try {
                object = ClassLoader.getSystemClassLoader().loadClass(string).newInstance();
                if (!(object instanceof RootMethodTrapper)) {
                    throw new IllegalArgumentException(string + " is not a subclass of SootBasedDriver.RootMethodTrapper.");
                }
                rootMethodTrapper = (RootMethodTrapper)object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.fatal((Object)("class " + string + " could not be loaded/resolved. Bailing."), (Throwable)classNotFoundException);
                throw new RuntimeException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                LOGGER.fatal((Object)("An instance of class " + string + " could not be created. Bailing."), (Throwable)instantiationException);
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.fatal((Object)("No-arg constructor of " + string + " cannot be accessed.  Bailing."), (Throwable)illegalAccessException);
                throw new RuntimeException(illegalAccessException);
            }
        }
        DEFAULT_INSTANCE_OF_ROOT_METHOD_TRAPPER = rootMethodTrapper;
        STMT_GRAPH_FACTORY_CLASS_PROPERTY = "indus.common.soot.SootBasedDriver.StmtGraphFactory.class";
        object = System.getProperty(STMT_GRAPH_FACTORY_CLASS_PROPERTY);
        IStmtGraphFactory iStmtGraphFactory = new ExceptionFlowSensitiveStmtGraphFactory();
        if (object != null) {
            try {
                Object obj = ClassLoader.getSystemClassLoader().loadClass((String)object).newInstance();
                if (!(obj instanceof IStmtGraphFactory)) {
                    throw new IllegalArgumentException(object + " is not a subclass of IStmtGraphFactory.");
                }
                iStmtGraphFactory = (IStmtGraphFactory)obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.fatal((Object)("class " + object + " could not be loaded/resolved. Bailing."), (Throwable)classNotFoundException);
                throw new RuntimeException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                LOGGER.fatal((Object)("An instance of class " + object + " could not be created. Bailing."), (Throwable)instantiationException);
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.fatal((Object)("No-arg constructor of " + object + " cannot be accessed.  Bailing."), (Throwable)illegalAccessException);
                throw new RuntimeException(illegalAccessException);
            }
        }
        DEFAULT_INSTANCE_OF_STMT_GRAPH_FACTORY = iStmtGraphFactory;
    }

    public static class RootMethodTrapper {
        protected Collection theClassNames;
        private Pattern rootClassNamePattern;
        private Pattern rootMethodNamePattern;

        protected RootMethodTrapper() {
            String string = System.getProperty("indus.common.soot.SootBasedDriver.rootClasses");
            this.rootClassNamePattern = string != null ? Pattern.compile(string) : null;
            String string2 = System.getProperty("indus.common.soot.SootBasedDriver.rootMethods");
            this.rootMethodNamePattern = string2 != null ? Pattern.compile(string2) : null;
        }

        protected void setClassNames(Collection collection) {
            this.theClassNames = collection;
        }

        protected boolean considerClassForEntryPoint(SootClass sootClass) {
            boolean bl = false;
            if (this.rootClassNamePattern != null) {
                bl = this.rootClassNamePattern.matcher(sootClass.getName()).matches();
            } else if (this.theClassNames != null) {
                bl = this.theClassNames.contains(sootClass.getName());
            }
            return bl;
        }

        protected boolean trapRootMethods(SootMethod sootMethod) {
            boolean bl = false;
            if (this.rootMethodNamePattern != null) {
                bl = this.rootMethodNamePattern.matcher(sootMethod.getSignature()).matches();
            } else if (sootMethod.getName().equals("main") && sootMethod.isStatic() && sootMethod.getParameterCount() == 1 && sootMethod.getParameterType(0).equals(ArrayType.v((Type)RefType.v((String)"java.lang.String"), (int)1))) {
                bl = true;
            }
            return bl;
        }
    }
}

