/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.soot.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.PatchingChain;
import soot.SootClass;
import soot.Trap;
import soot.TrapManager;
import soot.Unit;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.util.Chain;

final class ExceptionFlowSensitiveStmtGraph
extends UnitGraph {
    private static final List NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING = new ArrayList();
    private Collection predsToBeProcessedCache = new HashSet();
    private Collection succsToBeProcessedCache = new HashSet();
    private List nodes;

    ExceptionFlowSensitiveStmtGraph(JimpleBody jimpleBody, Collection collection, boolean bl) {
        super((Body)jimpleBody, true, bl);
        Stmt stmt;
        this.deleteEdgesResultingFromTheseExceptions(collection);
        this.pruneExceptionBasedControlFlow();
        Iterator iterator = this.succsToBeProcessedCache.iterator();
        while (iterator.hasNext()) {
            stmt = (Stmt)iterator.next();
            this.unitToSuccs.put(stmt, Collections.unmodifiableList((List)this.unitToSuccs.get(stmt)));
        }
        iterator = this.predsToBeProcessedCache.iterator();
        while (iterator.hasNext()) {
            stmt = (Stmt)iterator.next();
            this.unitToPreds.put(stmt, Collections.unmodifiableList((List)this.unitToPreds.get(stmt)));
        }
        this.predsToBeProcessedCache = null;
        this.succsToBeProcessedCache = null;
        this.fixupMapsAndIterator();
    }

    public Iterator iterator() {
        return this.nodes.iterator();
    }

    private void deleteEdgesResultingFromTheseExceptions(Collection collection) {
        Chain chain = this.body.getTraps();
        PatchingChain patchingChain = this.body.getUnits();
        Iterator iterator = chain.iterator();
        while (iterator.hasNext()) {
            Trap trap = (Trap)iterator.next();
            if (!collection.contains(trap.getException().getName())) continue;
            Stmt stmt = (Stmt)trap.getHandlerUnit();
            Stmt stmt2 = (Stmt)patchingChain.getPredOf((Object)trap.getEndUnit());
            ArrayList arrayList = new ArrayList((List)this.unitToPreds.get(stmt));
            Iterator iterator2 = patchingChain.iterator((Object)trap.getBeginUnit(), (Object)stmt2);
            while (iterator2.hasNext()) {
                Stmt stmt3 = (Stmt)iterator2.next();
                ArrayList arrayList2 = new ArrayList((List)this.unitToSuccs.get(stmt3));
                arrayList2.remove(stmt);
                this.unitToSuccs.put(stmt3, arrayList2);
                this.succsToBeProcessedCache.add(stmt3);
                arrayList.remove(stmt3);
            }
            this.unitToPreds.put(stmt, arrayList);
            this.predsToBeProcessedCache.add(stmt);
            iterator.remove();
        }
    }

    private void fixupMapsAndIterator() {
        Object object;
        ArrayList arrayList = new ArrayList();
        HistoryAwareFIFOWorkBag historyAwareFIFOWorkBag = new HistoryAwareFIFOWorkBag(arrayList);
        PatchingChain patchingChain = this.getBody().getUnits();
        historyAwareFIFOWorkBag.addWork(patchingChain.getFirst());
        while (historyAwareFIFOWorkBag.hasWork()) {
            object = (Stmt)historyAwareFIFOWorkBag.getWork();
            historyAwareFIFOWorkBag.addAllWork(this.getSuccsOf(object));
        }
        this.nodes = new ArrayList(patchingChain);
        this.nodes.retainAll(arrayList);
        this.nodes = Collections.unmodifiableList(this.nodes);
        object = new ArrayList(patchingChain);
        object.removeAll(arrayList);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.unitToPreds.remove(e);
            this.unitToSuccs.remove(e);
        }
    }

    private void pruneExceptionBasedControlFlow() {
        Iterator iterator = TrapManager.getTrappedUnitsOf((Body)this.body).iterator();
        while (iterator.hasNext()) {
            Stmt stmt = (Stmt)iterator.next();
            List list = TrapManager.getTrapsAt((Unit)stmt, (Body)this.body);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                Trap trap = (Trap)iterator2.next();
                SootClass sootClass = trap.getException();
                if (NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.contains(sootClass.getName())) continue;
                Stmt stmt2 = (Stmt)trap.getHandlerUnit();
                boolean bl = stmt.containsArrayRef();
                boolean bl2 = stmt.containsFieldRef();
                boolean bl3 = bl2 && stmt.getFieldRef() instanceof InstanceFieldRef;
                boolean bl4 = stmt.containsInvokeExpr();
                InvokeExpr invokeExpr = bl4 ? stmt.getInvokeExpr() : null;
                boolean bl5 = bl4 && invokeExpr instanceof InstanceInvokeExpr;
                boolean bl6 = (bl || bl3 || bl5) && Util.isDescendentOf(sootClass, "java.lang.NullPointerException");
                bl6 |= bl && Util.isDescendentOf(sootClass, "java.lang.ArrayIndexOutOfBoundsException");
                if (bl4) {
                    object2 = invokeExpr.getMethod().getExceptions().iterator();
                    while (object2.hasNext()) {
                        object = (SootClass)object2.next();
                        bl6 |= Util.isDescendentOf((SootClass)object, sootClass);
                    }
                }
                if (bl6) continue;
                object2 = new ArrayList((List)this.unitToPreds.get(stmt2));
                object2.remove(stmt);
                this.unitToPreds.put(stmt2, object2);
                this.predsToBeProcessedCache.add(stmt2);
                object = new ArrayList((List)this.unitToSuccs.get(stmt));
                object.remove(stmt2);
                this.unitToSuccs.put(stmt, object);
                this.succsToBeProcessedCache.add(stmt);
            }
        }
    }

    static {
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.RuntimeException");
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.Exception");
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.Throwable");
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.Error");
    }
}

