/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.common.soot.AbstractStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.TrapStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;

public abstract class Driver {
    public static final ArrayType STR_ARRAY_TYPE = ArrayType.v((Type)RefType.v((String)"java.lang.String"), (int)1);
    protected AbstractStmtGraphFactory cfgProvider;
    protected BasicBlockGraphMgr bbm;
    protected Collection rootMethods = new HashSet();
    private final Map times = new LinkedHashMap();

    protected Driver() {
        this.cfgProvider = new TrapStmtGraphFactory();
        this.bbm = new BasicBlockGraphMgr();
        this.bbm.setUnitGraphFactory(this.cfgProvider);
    }

    public void run() {
        this.initialize();
        this.execute();
    }

    protected void addTimeLog(String string, long l) {
        this.times.put(this.getClass().getName() + ":" + string, new Long(l));
    }

    protected final Scene loadupClassesAndCollectMains(String[] stringArray) {
        Scene scene = Scene.v();
        List<String> list = Arrays.asList(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            scene.loadClassAndSupport(stringArray[i]);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(scene.getClasses());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = (SootClass)iterator.next();
            if (!this.considerClassForEntryPoint(sootClass, list)) continue;
            List list2 = sootClass.getMethods();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                SootMethod sootMethod = (SootMethod)iterator2.next();
                this.trapRootMethods(sootMethod);
            }
        }
        Util.fixupThreadStartBody(scene);
        return scene;
    }

    protected boolean considerClassForEntryPoint(SootClass sootClass, Collection collection) {
        return collection.contains(sootClass.getName()) && sootClass.isPublic();
    }

    protected abstract void execute();

    protected void initialize() {
    }

    protected void printTimingStats(PrintStream printStream) {
        printStream.println("Timing statistics:");
        Iterator iterator = this.times.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            printStream.println(k + " => " + this.times.get(k) + "ms");
        }
    }

    protected void trapRootMethods(SootMethod sootMethod) {
        if (sootMethod.getName().equals("main") && sootMethod.isStatic() && sootMethod.getParameterCount() == 1 && sootMethod.getParameterType(0).equals(STR_ARRAY_TYPE)) {
            this.rootMethods.add(sootMethod);
        }
    }
}

