/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.TrapStmtGraphFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.collections.CollectionUtils;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

public class BasicBlockGraphTest
extends AbstractDirectedGraphTest {
    IStmtGraphFactory factory;
    Scene scene;
    private BasicBlockGraph bbGraph;
    private String className;
    private String methodName;
    static /* synthetic */ Class class$edu$ksu$cis$indus$common$soot$BasicBlockGraphTest;

    public final void testBasicBlockGraphAgainstStmtGraph() {
        UnitGraph unitGraph = this.bbGraph.getStmtGraph();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        CollectionUtils.addAll(arrayList, (Iterator)unitGraph.iterator());
        Iterator iterator = this.bbGraph.getNodes().iterator();
        while (iterator.hasNext()) {
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
            arrayList2.addAll(basicBlock.getStmtsOf());
        }
        BasicBlockGraphTest.assertTrue((String)(unitGraph.getClass().getName() + ":" + unitGraph.getBody().getMethod() + " - " + CollectionUtils.subtract(arrayList2, arrayList).toString()), (boolean)arrayList.containsAll(arrayList2));
        BasicBlockGraphTest.assertTrue((String)(unitGraph.getClass().getName() + ":" + unitGraph.getBody().getMethod() + " - " + CollectionUtils.subtract(arrayList, arrayList2).toString()), (boolean)arrayList2.containsAll(arrayList));
    }

    public final void testBasicBlockGraphStructure() {
        UnitGraph unitGraph = this.bbGraph.getStmtGraph();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.bbGraph.getNodes().iterator();
        while (iterator.hasNext()) {
            Stmt stmt;
            Stmt stmt2;
            Object object;
            Object object2;
            BasicBlockGraph.BasicBlock basicBlock = (BasicBlockGraph.BasicBlock)iterator.next();
            Stmt stmt3 = basicBlock.getLeaderStmt();
            List list = unitGraph.getPredsOf((Object)stmt3);
            if (!list.isEmpty()) {
                boolean bl;
                boolean bl2 = bl = list.size() > 1;
                if (!bl) {
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (Stmt)object2.next();
                        bl |= unitGraph.getSuccsOf(object).size() > 1;
                    }
                }
                BasicBlockGraphTest.assertTrue((String)(stmt3.toString() + unitGraph.getBody().getMethod()), (boolean)bl);
            }
            if (!(object2 = unitGraph.getSuccsOf((Object)(stmt2 = basicBlock.getTrailerStmt()))).isEmpty()) {
                boolean bl;
                boolean bl3 = bl = object2.size() > 1;
                if (!bl) {
                    stmt = object2.iterator();
                    while (stmt.hasNext()) {
                        Stmt stmt4 = (Stmt)stmt.next();
                        bl |= unitGraph.getPredsOf((Object)stmt4).size() > 1;
                    }
                }
                BasicBlockGraphTest.assertTrue((String)(stmt2.toString() + unitGraph.getBody().getMethod()), (boolean)bl);
            }
            arrayList.clear();
            arrayList.addAll(basicBlock.getStmtsOf());
            arrayList.remove(stmt3);
            arrayList.remove(stmt2);
            object = arrayList.iterator();
            while (object.hasNext()) {
                stmt = (Stmt)object.next();
                BasicBlockGraphTest.assertTrue((unitGraph.getPredsOf((Object)stmt).size() == 1 ? 1 : 0) != 0);
                BasicBlockGraphTest.assertTrue((unitGraph.getSuccsOf((Object)stmt).size() == 1 ? 1 : 0) != 0);
            }
        }
    }

    protected void setUp() {
        BasicBlockGraphMgr basicBlockGraphMgr = new BasicBlockGraphMgr();
        basicBlockGraphMgr.setUnitGraphFactory(this.factory);
        SootClass sootClass = this.scene.getSootClass(this.className);
        SootMethod sootMethod = sootClass.getMethodByName(this.methodName);
        this.bbGraph = basicBlockGraphMgr.getBasicBlockGraph(sootMethod);
        this.dg = this.bbGraph;
    }

    protected void tearDown() throws Exception {
        this.factory.reset();
        this.methodName = null;
        this.className = null;
        this.factory = null;
        this.bbGraph = null;
        this.dg = null;
        this.scene = null;
    }

    static Test getTests() {
        final TestSuite testSuite = new TestSuite();
        testSuite.setName("BasicBlockGraphTest");
        IStmtGraphFactory[] iStmtGraphFactoryArray = new IStmtGraphFactory[]{new CompleteStmtGraphFactory(), new TrapStmtGraphFactory(), new ExceptionFlowSensitiveStmtGraphFactory()};
        final String[] stringArray = new String[]{"notify", "equals", "loadOneMoreProvider"};
        final String[] stringArray2 = new String[]{"java.lang.Object", "java.lang.Object", "java.security.Security"};
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < iStmtGraphFactoryArray.length; ++j) {
                IStmtGraphFactory iStmtGraphFactory = iStmtGraphFactoryArray[j];
                TestSuite testSuite2 = new TestSuite(class$edu$ksu$cis$indus$common$soot$BasicBlockGraphTest == null ? BasicBlockGraphTest.class$("edu.ksu.cis.indus.common.soot.BasicBlockGraphTest") : class$edu$ksu$cis$indus$common$soot$BasicBlockGraphTest);
                String string = iStmtGraphFactory.getClass().getName() + ":BasicBlockGraphTest";
                Enumeration enumeration = testSuite2.tests();
                while (enumeration.hasMoreElements()) {
                    BasicBlockGraphTest basicBlockGraphTest = (BasicBlockGraphTest)((Object)enumeration.nextElement());
                    basicBlockGraphTest.setTestName(string + ":" + stringArray[i] + ":" + stringArray2[i] + ":" + basicBlockGraphTest.getTestMethodName());
                    basicBlockGraphTest.factory = iStmtGraphFactory;
                    basicBlockGraphTest.methodName = stringArray[i];
                    basicBlockGraphTest.className = stringArray2[i];
                }
                testSuite.addTest((Test)testSuite2);
            }
        }
        return new TestSetup((Test)testSuite){
            private Scene scene;

            public void setUp() {
                this.scene = Scene.v();
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.scene.loadClassAndSupport(stringArray2[i]).getMethodByName(stringArray[i]);
                }
                Iterator iterator = TestHelper.getTestCasesReachableFromSuite(testSuite, class$edu$ksu$cis$indus$common$soot$BasicBlockGraphTest == null ? (class$edu$ksu$cis$indus$common$soot$BasicBlockGraphTest = BasicBlockGraphTest.class$("edu.ksu.cis.indus.common.soot.BasicBlockGraphTest")) : class$edu$ksu$cis$indus$common$soot$BasicBlockGraphTest).iterator();
                while (iterator.hasNext()) {
                    BasicBlockGraphTest basicBlockGraphTest = (BasicBlockGraphTest)((Object)iterator.next());
                    basicBlockGraphTest.scene = this.scene;
                }
            }

            public void tearDown() {
                this.scene = null;
                G.reset();
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

