/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import soot.SootMethod;
import soot.toolkits.graph.UnitGraph;

public final class BasicBlockGraphMgr {
    private final Map method2graph = new HashMap();
    private IStmtGraphFactory stmtGraphProvider;

    public BasicBlockGraph getBasicBlockGraph(SootMethod sootMethod) {
        if (this.stmtGraphProvider == null) {
            throw new IllegalStateException("You need to set the unit graph provider via setStmtGraphProvider() before calling this method.");
        }
        SoftReference softReference = (SoftReference)this.method2graph.get(sootMethod);
        BasicBlockGraph basicBlockGraph = null;
        boolean bl = false;
        if (softReference == null) {
            bl = true;
        } else {
            basicBlockGraph = (BasicBlockGraph)softReference.get();
            if (basicBlockGraph == null) {
                bl = true;
            }
        }
        if (bl) {
            UnitGraph unitGraph = this.stmtGraphProvider.getStmtGraph(sootMethod);
            basicBlockGraph = new BasicBlockGraph(unitGraph);
            this.method2graph.put(sootMethod, new SoftReference<BasicBlockGraph>(basicBlockGraph));
        }
        return basicBlockGraph;
    }

    public UnitGraph getUnitGraph(SootMethod sootMethod) {
        return this.stmtGraphProvider.getStmtGraph(sootMethod);
    }

    public void setUnitGraphFactory(IStmtGraphFactory iStmtGraphFactory) {
        this.stmtGraphProvider = iStmtGraphFactory;
    }

    public void reset() {
        this.method2graph.clear();
    }
}

