/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.graph.AbstractMutableDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import soot.Trap;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.util.Chain;

public final class BasicBlockGraph
extends AbstractMutableDirectedGraph {
    final List stmtList;
    private final List blocks;
    private final Map stmt2BlockMap;
    private final UnitGraph stmtGraph;

    BasicBlockGraph(UnitGraph unitGraph) {
        this.stmtGraph = unitGraph;
        this.stmtList = Collections.unmodifiableList(new ArrayList(this.stmtGraph.getBody().getUnits()));
        int n = this.stmtList.size();
        if (n == 0) {
            this.blocks = Collections.EMPTY_LIST;
            this.stmt2BlockMap = Collections.EMPTY_MAP;
            return;
        }
        ArrayList arrayList = new ArrayList();
        HistoryAwareLIFOWorkBag historyAwareLIFOWorkBag = new HistoryAwareLIFOWorkBag(new HashSet());
        historyAwareLIFOWorkBag.addWork(this.stmtList.get(0));
        this.blocks = new ArrayList();
        this.stmt2BlockMap = new HashMap(n);
        while (historyAwareLIFOWorkBag.hasWork()) {
            Stmt stmt = (Stmt)historyAwareLIFOWorkBag.getWork();
            arrayList.clear();
            this.getBasicBlockStmtsInto(stmt, historyAwareLIFOWorkBag, arrayList);
            BasicBlock basicBlock = new BasicBlock(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.stmt2BlockMap.put(iterator.next(), basicBlock);
            }
            this.blocks.add(basicBlock);
        }
        this.setupGraph();
    }

    public BasicBlock getEnclosingBlock(Stmt stmt) {
        return (BasicBlock)this.stmt2BlockMap.get(stmt);
    }

    public Collection getHandlerBlocks() {
        Collection<BasicBlock> collection;
        Chain chain = this.stmtGraph.getBody().getTraps();
        if (!chain.isEmpty()) {
            collection = new HashSet();
            Iterator iterator = chain.iterator();
            while (iterator.hasNext()) {
                BasicBlock basicBlock = this.getEnclosingBlock((Stmt)((Trap)iterator.next()).getHandlerUnit());
                if (basicBlock == null) continue;
                collection.add(basicBlock);
            }
        } else {
            collection = Collections.EMPTY_LIST;
        }
        return collection;
    }

    public BasicBlock getHead() {
        Collection collection = this.getHeads();
        BasicBlock basicBlock = null;
        if (collection.size() == 1) {
            basicBlock = (BasicBlock)collection.iterator().next();
        } else {
            Stmt stmt = (Stmt)this.stmtGraph.getBody().getUnits().getFirst();
            Iterator iterator = this.stmtGraph.iterator();
            while (iterator.hasNext()) {
                Stmt stmt2 = (Stmt)iterator.next();
                if (!stmt.equals(stmt2)) continue;
                basicBlock = this.getEnclosingBlock(stmt);
                break;
            }
        }
        return basicBlock;
    }

    public List getNodes() {
        return Collections.unmodifiableList(this.blocks);
    }

    public UnitGraph getStmtGraph() {
        return this.stmtGraph;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("blocks", (Object)this.blocks).toString();
    }

    protected boolean containsNodes(INode iNode) {
        return this.blocks.contains(iNode);
    }

    private void getBasicBlockStmtsInto(Stmt stmt, IWorkBag iWorkBag, List list) {
        Stmt stmt2 = stmt;
        Stmt stmt3 = stmt;
        while (true) {
            List list2 = this.stmtGraph.getPredsOf((Object)stmt2);
            List list3 = this.stmtGraph.getSuccsOf((Object)stmt2);
            int n = list3.size();
            if (list2.size() > 1 && stmt3 != stmt2) {
                iWorkBag.addWorkNoDuplicates(stmt2);
                break;
            }
            list.add(stmt2);
            if (n > 1 || n == 0) {
                if (n <= 1) break;
                iWorkBag.addAllWorkNoDuplicates(list3);
                break;
            }
            stmt3 = stmt2;
            stmt2 = (Stmt)this.stmtGraph.getSuccsOf((Object)stmt3).get(0);
        }
    }

    private void setupGraph() {
        Object object;
        Object object2;
        Object object3 = this.blocks.iterator();
        while (object3.hasNext()) {
            object2 = (BasicBlock)object3.next();
            object = ((BasicBlock)object2).getTrailerStmt();
            Iterator iterator = this.stmtGraph.getSuccsOf(object).iterator();
            while (iterator.hasNext()) {
                Stmt stmt = (Stmt)iterator.next();
                BasicBlock basicBlock = this.getEnclosingBlock(stmt);
                if (basicBlock == null) continue;
                this.addEdgeFromTo((INode)object2, basicBlock);
            }
        }
        object3 = this.stmtGraph.getHeads();
        if (!object3.isEmpty() && (object2 = this.getEnclosingBlock((Stmt)object3.get(0))) != null) {
            this.heads.add(object2);
        }
        object2 = this.stmtGraph.getTails().iterator();
        while (object2.hasNext()) {
            object = this.getEnclosingBlock((Stmt)object2.next());
            if (object == null) continue;
            this.tails.add(object);
        }
    }

    public final class BasicBlock
    extends AbstractMutableDirectedGraph.AbstractMutableNode {
        private final List stmts;
        private final Stmt leaderStmt;
        private final Stmt trailerStmt;

        BasicBlock(List list) {
            super(new HashSet(), new HashSet());
            this.stmts = new ArrayList(list);
            this.leaderStmt = (Stmt)this.stmts.get(0);
            this.trailerStmt = (Stmt)this.stmts.get(this.stmts.size() - 1);
        }

        public Stmt getLeaderStmt() {
            return this.leaderStmt;
        }

        public List getStmtFromTo(Stmt stmt, Stmt stmt2) {
            ArrayList arrayList;
            int n = BasicBlockGraph.this.stmtList.indexOf(stmt);
            int n2 = BasicBlockGraph.this.stmtList.indexOf(stmt2);
            int n3 = BasicBlockGraph.this.stmtList.indexOf(this.leaderStmt);
            int n4 = BasicBlockGraph.this.stmtList.indexOf(this.trailerStmt);
            if (n >= n3 && n2 <= n4 && n <= n2) {
                arrayList = new ArrayList(BasicBlockGraph.this.stmtList.subList(n, n2 + 1));
                arrayList.retainAll(this.stmts);
            } else {
                arrayList = Collections.EMPTY_LIST;
            }
            return arrayList;
        }

        public List getStmtsFrom(Stmt stmt) {
            return this.getStmtFromTo(stmt, this.trailerStmt);
        }

        public List getStmtsOf() {
            return Collections.unmodifiableList(this.stmts);
        }

        public Stmt getTrailerStmt() {
            return this.trailerStmt;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("stmts", (Object)this.stmts).toString();
        }
    }
}

