/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import soot.PatchingChain;
import soot.SootMethod;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.toolkits.graph.UnitGraph;

public abstract class AbstractStmtGraphFactory
implements IStmtGraphFactory {
    private final Map method2UnitGraph = new HashMap();

    public final UnitGraph getStmtGraph(SootMethod sootMethod) {
        WeakReference weakReference = (WeakReference)this.method2UnitGraph.get(sootMethod);
        UnitGraph unitGraph = null;
        boolean bl = false;
        if (weakReference == null) {
            bl = true;
        } else {
            unitGraph = (UnitGraph)weakReference.get();
            if (unitGraph == null) {
                bl = true;
            }
        }
        if (bl) {
            unitGraph = this.getStmtGraphForMethod(sootMethod);
            if (unitGraph == null) {
                Jimple jimple = Jimple.v();
                JimpleBody jimpleBody = jimple.newBody();
                jimpleBody.setMethod(sootMethod);
                PatchingChain patchingChain = jimpleBody.getUnits();
                if (sootMethod.getReturnType() instanceof VoidType) {
                    patchingChain.add(jimple.newReturnVoidStmt());
                } else {
                    patchingChain.add(jimple.newReturnStmt(Util.getDefaultValueFor(sootMethod.getReturnType())));
                }
                unitGraph = this.getStmtGraphForBody(jimpleBody);
            }
            this.method2UnitGraph.put(sootMethod, new WeakReference<UnitGraph>(unitGraph));
        }
        return unitGraph;
    }

    public final void reset() {
        this.method2UnitGraph.clear();
    }

    protected abstract UnitGraph getStmtGraphForBody(JimpleBody var1);

    protected abstract UnitGraph getStmtGraphForMethod(SootMethod var1);
}

