/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleNodeGraphTest
extends AbstractDirectedGraphTest {
    protected final Map name2node = new HashMap();
    protected SimpleNodeGraph sng;

    public final void testGetNode() {
        Iterator iterator = this.name2node.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            INode iNode = this.sng.getNode(entry.getKey());
            SimpleNodeGraphTest.assertTrue((boolean)iNode.equals(entry.getValue()));
            SimpleNodeGraphTest.assertTrue((boolean)((SimpleNodeGraph.SimpleNode)iNode).getObject().equals(entry.getKey()));
        }
        try {
            this.sng.getNode(null);
            SimpleNodeGraphTest.fail((String)"Should have raised an exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetNodes() {
        List list = this.dg.getNodes();
        SimpleNodeGraphTest.assertTrue((boolean)this.name2node.values().containsAll(this.dg.getNodes()));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(this.name2node.values()));
        List list2 = this.dg.getNodes();
        SimpleNodeGraphTest.assertTrue((boolean)((Object)list).equals(list2));
    }

    protected void setSNG(SimpleNodeGraph simpleNodeGraph) {
        this.sng = simpleNodeGraph;
        this.dg = this.sng;
    }

    protected void setUp() throws Exception {
        SimpleNodeGraph simpleNodeGraph = new SimpleNodeGraph();
        this.name2node.put("a", simpleNodeGraph.getNode("a"));
        this.name2node.put("b", simpleNodeGraph.getNode("b"));
        this.name2node.put("c", simpleNodeGraph.getNode("c"));
        this.name2node.put("d", simpleNodeGraph.getNode("d"));
        this.name2node.put("e", simpleNodeGraph.getNode("e"));
        this.name2node.put("f", simpleNodeGraph.getNode("f"));
        this.name2node.put("g", simpleNodeGraph.getNode("g"));
        this.name2node.put("h", simpleNodeGraph.getNode("h"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("a"), (SimpleNodeGraph.SimpleNode)this.name2node.get("b"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("b"), (SimpleNodeGraph.SimpleNode)this.name2node.get("c"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("b"), (SimpleNodeGraph.SimpleNode)this.name2node.get("f"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("b"), (SimpleNodeGraph.SimpleNode)this.name2node.get("e"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("c"), (SimpleNodeGraph.SimpleNode)this.name2node.get("d"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("c"), (SimpleNodeGraph.SimpleNode)this.name2node.get("g"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("d"), (SimpleNodeGraph.SimpleNode)this.name2node.get("c"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("d"), (SimpleNodeGraph.SimpleNode)this.name2node.get("h"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("e"), (SimpleNodeGraph.SimpleNode)this.name2node.get("f"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("e"), (SimpleNodeGraph.SimpleNode)this.name2node.get("a"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("f"), (SimpleNodeGraph.SimpleNode)this.name2node.get("g"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("g"), (SimpleNodeGraph.SimpleNode)this.name2node.get("h"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("g"), (SimpleNodeGraph.SimpleNode)this.name2node.get("f"));
        simpleNodeGraph.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("h"), (SimpleNodeGraph.SimpleNode)this.name2node.get("h"));
        this.setSNG(simpleNodeGraph);
    }

    protected void localtestAddEdgeFromTo() {
        INode iNode;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.extractPredSuccCopy(this.dg, hashMap, hashMap2);
        this.sng.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("c"), (SimpleNodeGraph.SimpleNode)this.name2node.get("h"));
        SimpleNodeGraphTest.assertTrue((boolean)((INode)this.name2node.get("c")).getSuccsOf().contains(this.name2node.get("h")));
        SimpleNodeGraphTest.assertTrue((boolean)((INode)this.name2node.get("h")).getPredsOf().contains(this.name2node.get("c")));
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        this.extractPredSuccCopy(this.dg, hashMap3, hashMap4);
        Object object = this.dg.getNodes().iterator();
        while (object.hasNext()) {
            iNode = (INode)object.next();
            if (this.name2node.get("h") != iNode) {
                SimpleNodeGraphTest.assertTrue((boolean)hashMap.get(iNode).equals(hashMap3.get(iNode)));
            }
            if (this.name2node.get("c") == iNode) continue;
            SimpleNodeGraphTest.assertTrue((boolean)hashMap2.get(iNode).equals(hashMap4.get(iNode)));
        }
        this.sng.addEdgeFromTo((SimpleNodeGraph.SimpleNode)this.name2node.get("a"), (SimpleNodeGraph.SimpleNode)this.name2node.get("f"));
        hashMap.clear();
        hashMap2.clear();
        this.extractPredSuccCopy(this.dg, hashMap, hashMap2);
        SimpleNodeGraphTest.assertTrue((boolean)((INode)this.name2node.get("a")).getSuccsOf().contains(this.name2node.get("f")));
        SimpleNodeGraphTest.assertTrue((boolean)((INode)this.name2node.get("f")).getPredsOf().contains(this.name2node.get("a")));
        object = this.dg.getNodes().iterator();
        while (object.hasNext()) {
            iNode = (INode)object.next();
            if (this.name2node.get("f") != iNode) {
                SimpleNodeGraphTest.assertTrue((boolean)hashMap.get(iNode).equals(hashMap3.get(iNode)));
            }
            if (this.name2node.get("a") == iNode) continue;
            SimpleNodeGraphTest.assertTrue((boolean)hashMap2.get(iNode).equals(hashMap4.get(iNode)));
        }
        SimpleNodeGraph simpleNodeGraph = this.sng;
        simpleNodeGraph.getClass();
        SimpleNodeGraph.SimpleNode simpleNode = simpleNodeGraph.new SimpleNodeGraph.SimpleNode("t1");
        SimpleNodeGraph simpleNodeGraph2 = this.sng;
        simpleNodeGraph2.getClass();
        SimpleNodeGraphTest.assertFalse((boolean)this.sng.addEdgeFromTo(simpleNode, simpleNodeGraph2.new SimpleNodeGraph.SimpleNode("t2")));
        object = new HashMap(this.dg.getSpanningSuccs());
        SimpleNodeGraphTest.assertTrue((boolean)this.sng.addEdgeFromTo(this.sng.getNode("i"), this.sng.getNode("b")));
        SimpleNodeGraphTest.assertFalse((boolean)object.equals(this.dg.getSpanningSuccs()));
    }

    protected void localtestGetCycles() {
        SimpleNodeGraphTest.assertFalse((boolean)this.dg.getCycles().isEmpty());
    }

    protected void localtestGetHeads() {
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.getHeads().isEmpty());
    }

    protected void localtestGetPseudoTails() {
        Collection collection = this.dg.getPseudoTails();
        SimpleNodeGraphTest.assertTrue((collection.size() == 1 ? 1 : 0) != 0);
        SimpleNodeGraphTest.assertTrue((boolean)collection.contains(this.name2node.get("h")));
    }

    protected void localtestGetSCCs() {
        List list = this.dg.getSCCs(true);
        List list2 = this.dg.getSCCs(false);
        SimpleNodeGraphTest.assertFalse((boolean)list.isEmpty());
        SimpleNodeGraphTest.assertFalse((boolean)list2.isEmpty());
    }

    protected void localtestGraphGetTails() {
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.getTails().isEmpty());
    }

    protected void localtestIsAncestorOf() {
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isAncestorOf((INode)this.name2node.get("a"), (INode)this.name2node.get("a")));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isAncestorOf((INode)this.name2node.get("h"), (INode)this.name2node.get("h")));
    }

    protected void localtestIsReachable() {
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("a"), (INode)this.name2node.get("e"), true));
        SimpleNodeGraphTest.assertFalse((boolean)this.dg.isReachable((INode)this.name2node.get("f"), (INode)this.name2node.get("c"), true));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("h"), (INode)this.name2node.get("a"), false));
        SimpleNodeGraphTest.assertFalse((boolean)this.dg.isReachable((INode)this.name2node.get("c"), (INode)this.name2node.get("h"), false));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("h"), (INode)this.name2node.get("h"), false));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("h"), (INode)this.name2node.get("h"), true));
    }

    protected void tearDown() throws Exception {
        this.dg = null;
        this.sng = null;
        this.name2node.clear();
    }
}

