/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractDirectedGraphTest
extends IndusTestCase {
    protected IDirectedGraph dg;

    public final void testAddEdgeFromTo() {
        this.localtestAddEdgeFromTo();
    }

    public final void testGetBackEdges() {
        Pair pair;
        Collection collection = this.dg.getCycles();
        Collection collection2 = this.dg.getBackEdges();
        HashSet<Object> hashSet = new HashSet<Object>();
        AbstractDirectedGraphTest.assertTrue((collection.isEmpty() == collection2.isEmpty() ? 1 : 0) != 0);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            pair = (Pair)iterator.next();
            hashSet.add(pair.getFirst());
            hashSet.add(pair.getSecond());
        }
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(hashSet));
        iterator = collection2.iterator();
        while (iterator.hasNext()) {
            pair = (Pair)iterator.next();
            INode iNode = (INode)pair.getFirst();
            INode iNode2 = (INode)pair.getSecond();
            AbstractDirectedGraphTest.assertTrue((boolean)iNode.getSuccsOf().contains(iNode2));
            AbstractDirectedGraphTest.assertTrue((boolean)this.dg.isReachable(iNode2, iNode, true));
            boolean bl = false;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Collection collection3 = (Collection)iterator2.next();
                bl |= collection3.contains(iNode);
                bl |= collection3.contains(iNode2);
            }
            AbstractDirectedGraphTest.assertTrue((boolean)bl);
        }
    }

    public final void testGetCycles() {
        Collection collection = this.dg.getCycles();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection collection2 = (Collection)iterator.next();
            INode iNode = (INode)collection2.iterator().next();
            AbstractDirectedGraphTest.assertTrue((boolean)this.dg.isReachable(iNode, iNode, true));
        }
        this.localtestGetCycles();
    }

    public final void testGetDAG() {
        Map map = this.dg.getDAG();
        Collection collection = this.dg.getBackEdges();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            Collection collection2 = (Collection)((Pair)map.get(iNode)).getSecond();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                AbstractDirectedGraphTest.assertFalse((boolean)collection.contains(new Pair(iNode, iterator2.next())));
            }
        }
    }

    public final void testGetHeads() {
        INode iNode;
        Collection collection = this.dg.getHeads();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            iNode = (INode)iterator.next();
            AbstractDirectedGraphTest.assertTrue((boolean)iNode.getPredsOf().isEmpty());
        }
        iterator = this.dg.getNodes().iterator();
        while (iterator.hasNext()) {
            iNode = (INode)iterator.next();
            AbstractDirectedGraphTest.assertTrue((boolean)CollectionUtils.intersection((Collection)iNode.getSuccsOf(), (Collection)collection).isEmpty());
        }
        this.localtestGetHeads();
    }

    public final void testGetPseudoTails() {
        this.localtestGetPseudoTails();
    }

    public final void testGetSCCs() {
        List list = this.dg.getSCCs(true);
        this.checkSCCReachability(list);
        List list2 = this.dg.getSCCs(false);
        this.checkSCCReachability(list2);
        AbstractDirectedGraphTest.assertTrue((boolean)list.containsAll(list2));
        AbstractDirectedGraphTest.assertTrue((boolean)list2.containsAll(list));
        this.localtestGetSCCs();
    }

    public final void testGetSpanningSuccs() {
        Object object;
        HashMap hashMap = new HashMap(this.dg.getSpanningSuccs());
        HashSet hashSet = new HashSet();
        AbstractDirectedGraphTest.assertEquals(hashMap, (Object)this.dg.getSpanningSuccs());
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object = (Collection)iterator.next();
            hashSet.addAll(object);
        }
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(hashMap.keySet()));
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(hashSet));
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (INode)iterator.next();
            AbstractDirectedGraphTest.assertTrue((CollectionUtils.cardinality((Object)object, hashSet) == 1 ? 1 : 0) != 0);
        }
        hashSet.addAll(hashMap.keySet());
        AbstractDirectedGraphTest.assertTrue((boolean)hashSet.containsAll(this.dg.getNodes()));
    }

    public final void testGetTails() {
        INode iNode;
        Collection collection = this.dg.getTails();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            iNode = (INode)iterator.next();
            AbstractDirectedGraphTest.assertTrue((boolean)iNode.getSuccsOf().isEmpty());
        }
        iterator = this.dg.getNodes().iterator();
        while (iterator.hasNext()) {
            iNode = (INode)iterator.next();
            AbstractDirectedGraphTest.assertTrue((boolean)CollectionUtils.intersection((Collection)iNode.getPredsOf(), (Collection)collection).isEmpty());
        }
        this.localtestGraphGetTails();
    }

    public final void testIsAncestorOf() {
        this.localtestIsAncestorOf();
    }

    public final void testIsReachable() {
        this.localtestIsReachable();
    }

    public final void testPerformTopologicalSort() {
        List list = this.dg.performTopologicalSort(true);
        List list2 = this.dg.getNodes();
        AbstractDirectedGraphTest.assertTrue((list2.containsAll(list) && list.containsAll(list2) ? 1 : 0) != 0);
        if (this.dg.getCycles().isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                INode iNode = (INode)iterator.next();
                List list3 = list.subList(list.indexOf(iNode), list.size() - 1);
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    INode iNode2 = (INode)iterator2.next();
                    AbstractDirectedGraphTest.assertFalse((boolean)this.dg.isReachable(iNode2, iNode, true));
                }
            }
        }
    }

    public final void testgetReachablesFrom() {
        List list = this.dg.getNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            Collection collection = this.dg.getReachablesFrom(iNode, true);
            Collection collection2 = this.dg.getReachablesFrom(iNode, false);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                INode iNode2 = (INode)iterator2.next();
                AbstractDirectedGraphTest.assertTrue((collection.contains(iNode2) == this.dg.isReachable(iNode, iNode2, true) ? 1 : 0) != 0);
                AbstractDirectedGraphTest.assertTrue((collection2.contains(iNode2) == this.dg.isReachable(iNode, iNode2, false) ? 1 : 0) != 0);
            }
        }
    }

    protected final void extractPredSuccCopy(IDirectedGraph iDirectedGraph, Map map, Map map2) {
        Iterator iterator = iDirectedGraph.getNodes().iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            map.put(iNode, new ArrayList(iNode.getPredsOf()));
            map2.put(iNode, new ArrayList(iNode.getSuccsOf()));
        }
    }

    protected void localtestAddEdgeFromTo() {
    }

    protected void localtestGetCycles() {
    }

    protected void localtestGetHeads() {
    }

    protected void localtestGetPseudoTails() {
    }

    protected void localtestGetSCCs() {
    }

    protected void localtestGraphGetTails() {
    }

    protected void localtestIsAncestorOf() {
    }

    protected void localtestIsReachable() {
    }

    private void checkSCCReachability(Collection collection) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection collection2 = (Collection)iterator.next();
            hashSet.addAll(collection2);
            if (collection2.size() <= 1) continue;
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                INode iNode = (INode)iterator2.next();
                hashSet2.clear();
                hashSet2.addAll(collection2);
                hashSet2.remove(iNode);
                Iterator iterator3 = hashSet2.iterator();
                while (iterator3.hasNext()) {
                    INode iNode2 = (INode)iterator3.next();
                    AbstractDirectedGraphTest.assertTrue((this.dg.isReachable(iNode, iNode2, true) && this.dg.isReachable(iNode, iNode2, false) ? 1 : 0) != 0);
                }
            }
        }
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(hashSet));
    }
}

