/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Marker;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractDirectedGraph
implements IDirectedGraph {
    protected final Set heads = new HashSet();
    protected final Set tails = new HashSet();
    protected boolean hasSpanningForest;
    private Collection backedges = new ArrayList();
    private final Collection pseudoTails = new HashSet();
    private Map spanningSuccs;
    private boolean[][] backwardReachabilityMatrix;
    private boolean[][] forwardReachabilityMatrix;
    private int[] postnums;
    private int[] prenums;
    private boolean pseudoTailsCalculated;
    private boolean reachability;

    public final Collection getBackEdges() {
        if (!this.hasSpanningForest) {
            this.createSpanningForest();
        }
        List list = this.getNodes();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        Collection<Object> collection = this.backedges.iterator();
        while (collection.hasNext()) {
            Pair pair = (Pair)collection.next();
            int n = list.indexOf(pair.getFirst());
            int n2 = list.indexOf(pair.getSecond());
            if (this.prenums[n2] <= this.prenums[n] && this.postnums[n2] >= this.postnums[n]) continue;
            arrayList.add(pair);
        }
        this.backedges.removeAll(arrayList);
        collection = this.backedges.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.backedges);
        return collection;
    }

    public final Collection getCycles() {
        List list = new ArrayList();
        Iterator iterator = this.getSCCs(true).iterator();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            Collection collection2 = AbstractDirectedGraph.findCycles(collection);
            if (collection2.isEmpty()) continue;
            list.addAll(collection2);
        }
        if (list.isEmpty()) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public final Map getDAG() {
        HashMap<INode, Pair> hashMap = new HashMap<INode, Pair>();
        Map map = Pair.mapify(this.getBackEdges(), true);
        Map map2 = Pair.mapify(this.getBackEdges(), false);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Iterator iterator = this.getNodes().iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            Collection collection = (Collection)map.get(iNode);
            hashSet.clear();
            hashSet.addAll(iNode.getSuccsOf());
            if (collection != null) {
                hashSet.removeAll(collection);
            }
            Collection collection2 = (Collection)map2.get(iNode);
            hashSet2.clear();
            hashSet2.addAll(iNode.getPredsOf());
            if (collection2 != null) {
                hashSet2.removeAll(collection2);
            }
            ArrayList arrayList = hashSet.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(hashSet);
            ArrayList arrayList2 = hashSet2.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(hashSet2);
            hashMap.put(iNode, new Pair(arrayList2, arrayList));
        }
        return hashMap;
    }

    public final Collection getHeads() {
        return Collections.unmodifiableCollection(this.heads);
    }

    public final Collection getPseudoTails() {
        if (!this.pseudoTailsCalculated) {
            Object object;
            Map.Entry entry;
            Map map = this.getDAG();
            HashSet hashSet = new HashSet();
            Object object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                entry = object2.next();
                object = (Pair)entry.getValue();
                if (!((Collection)((Pair)object).getSecond()).isEmpty()) continue;
                hashSet.add(entry.getKey());
            }
            object2 = this.getTails();
            hashSet.removeAll((Collection<?>)object2);
            entry = this.getDestUnreachableSources(hashSet, (Collection)object2, true, false);
            object = this.getDestUnreachableSources((Collection)((Object)entry), (Collection)((Object)entry), true, false);
            if (object.isEmpty()) {
                this.pseudoTails.addAll(entry);
            } else {
                this.pseudoTails.addAll(object);
            }
            this.pseudoTailsCalculated = true;
        }
        return Collections.unmodifiableCollection(this.pseudoTails);
    }

    public abstract List getNodes();

    public final boolean isAncestorOf(INode iNode, INode iNode2) {
        int n;
        int n2;
        if (!this.hasSpanningForest) {
            this.createSpanningForest();
        }
        return this.prenums[n2 = this.getNodes().indexOf(iNode)] <= this.prenums[n = this.getNodes().indexOf(iNode2)] && this.postnums[n2] >= this.postnums[n];
    }

    public final boolean isReachable(INode iNode, INode iNode2, boolean bl) {
        if (!this.reachability) {
            this.calculateReachabilityInfo();
        }
        List list = this.getNodes();
        boolean[][] blArray = bl ? this.forwardReachabilityMatrix : this.backwardReachabilityMatrix;
        return blArray[list.indexOf(iNode)][list.indexOf(iNode2)];
    }

    public final Collection getReachablesFrom(INode iNode, boolean bl) {
        if (!this.reachability) {
            this.calculateReachabilityInfo();
        }
        List list = this.getNodes();
        boolean[] blArray = bl ? this.forwardReachabilityMatrix[list.indexOf(iNode)] : this.backwardReachabilityMatrix[list.indexOf(iNode)];
        ArrayList arrayList = new ArrayList();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!blArray[i]) continue;
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public final List getSCCs(boolean bl) {
        Object object;
        List list = this.getNodes();
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        int n = 0;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (INode)object2.next();
            if (hashSet.contains(object)) continue;
            n = this.getFinishTimes(list, (INode)object, hashSet, hashMap, n, true);
        }
        object2 = this.constructSCCs(hashMap);
        object = new ArrayList();
        object.addAll(object2.keySet());
        Collections.sort(object);
        if (bl) {
            Collections.reverse(object);
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            arrayList.add(object2.get(iterator.next()));
        }
        return arrayList;
    }

    public final Map getSpanningSuccs() {
        if (!this.hasSpanningForest) {
            this.createSpanningForest();
        }
        return Collections.unmodifiableMap(this.spanningSuccs);
    }

    public final Collection getTails() {
        return Collections.unmodifiableCollection(this.tails);
    }

    public final List performTopologicalSort(boolean bl) {
        Object object;
        List list = this.getNodes();
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        int n = 0;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (INode)object2.next();
            if (hashSet.contains(object)) continue;
            n = this.getFinishTimes(list, (INode)object, hashSet, hashMap, n, bl);
        }
        object2 = new ArrayList(hashMap.keySet());
        Collections.sort(object2);
        ArrayList arrayList = new ArrayList();
        object = object2.iterator();
        while (object.hasNext()) {
            arrayList.add(0, hashMap.get(object.next()));
        }
        return arrayList;
    }

    public static Collection findCycles(Collection collection) {
        ArrayList<Collection<INode>> arrayList = new ArrayList<Collection<INode>>();
        if (collection.size() == 1) {
            INode iNode = (INode)collection.iterator().next();
            if (iNode.getSuccsOf().contains(iNode)) {
                arrayList.add(Collections.singleton(iNode));
            }
        } else {
            LIFOWorkBag lIFOWorkBag = new LIFOWorkBag();
            Stack stack = new Stack();
            lIFOWorkBag.addWork(collection.iterator().next());
            while (lIFOWorkBag.hasWork()) {
                Object object;
                Object object2 = lIFOWorkBag.getWork();
                if (object2 instanceof Marker) {
                    object = ((Marker)object2).getContent();
                    while (!object.equals(stack.peek())) {
                        stack.pop();
                    }
                    continue;
                }
                if (stack.contains(object2)) {
                    object = stack.subList(stack.indexOf(object2), stack.size());
                    if (arrayList.contains(object)) continue;
                    arrayList.add(new ArrayList(object));
                    continue;
                }
                object = (INode)object2;
                Collection collection2 = CollectionUtils.intersection((Collection)object.getSuccsOf(), (Collection)collection);
                if (collection2.isEmpty()) continue;
                stack.push(object);
                if (collection2.size() > 1) {
                    Marker marker = new Marker(object);
                    Iterator iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        lIFOWorkBag.addWork(marker);
                        lIFOWorkBag.addWork(e);
                    }
                    continue;
                }
                lIFOWorkBag.addWork(collection2.iterator().next());
            }
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            int n = list.indexOf(iNode);
            Iterator iterator2 = iNode.getSuccsOf().iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                stringBuffer.append(n).append(" -> ").append(list.indexOf(e)).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    protected void shapeChanged() {
        this.hasSpanningForest = false;
        this.pseudoTailsCalculated = false;
        this.reachability = false;
    }

    private Collection getDestUnreachableSources(Collection collection, Collection collection2, boolean bl, boolean bl2) {
        HashSet hashSet = new HashSet(collection);
        ArrayList<INode> arrayList = new ArrayList<INode>(collection2);
        if (!collection2.isEmpty()) {
            Iterator iterator = collection.iterator();
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                INode iNode = (INode)iterator.next();
                Collection collection3 = this.getReachablesFrom(iNode, bl);
                boolean bl3 = collection2.contains(iNode);
                if (bl3 && !bl2) {
                    arrayList.remove(iNode);
                }
                if (CollectionUtils.containsAny((Collection)collection3, arrayList)) {
                    hashSet.remove(iNode);
                }
                if (!bl3 || bl2) continue;
                arrayList.add(iNode);
            }
        }
        return hashSet;
    }

    private int getFinishTimes(List list, INode iNode, Collection collection, Map map, int n, boolean bl) {
        collection.add(iNode);
        int n2 = n;
        ++n2;
        Iterator iterator = iNode.getSuccsNodesInDirection(bl).iterator();
        while (iterator.hasNext()) {
            INode iNode2 = (INode)iterator.next();
            if (collection.contains(iNode2) || !list.contains(iNode2)) continue;
            n2 = this.getFinishTimes(list, iNode2, collection, map, n2, bl);
        }
        map.put(new Integer(++n2), iNode);
        return n2;
    }

    private void calculateReachabilityInfo() {
        if (!this.reachability) {
            int n;
            List list = this.getNodes();
            int n2 = list.size();
            this.forwardReachabilityMatrix = new boolean[n2][n2];
            this.backwardReachabilityMatrix = new boolean[n2][n2];
            for (n = 0; n < n2; ++n) {
                INode iNode = (INode)list.get(n);
                Iterator iterator = iNode.getSuccsOf().iterator();
                int n3 = iNode.getSuccsOf().size();
                for (int i = 0; i < n3; ++i) {
                    INode iNode2 = (INode)iterator.next();
                    this.forwardReachabilityMatrix[n][list.indexOf((Object)iNode2)] = true;
                    this.backwardReachabilityMatrix[list.indexOf((Object)iNode2)][n] = true;
                }
            }
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        if (!this.forwardReachabilityMatrix[i][n] || !this.forwardReachabilityMatrix[n][j]) continue;
                        this.forwardReachabilityMatrix[i][j] = true;
                        this.backwardReachabilityMatrix[j][i] = true;
                    }
                }
            }
            this.reachability = true;
        }
    }

    private Map constructSCCs(Map map) {
        Object object;
        Stack<INode> stack = new Stack<INode>();
        HashMap hashMap = new HashMap();
        HashSet<INode> hashSet = new HashSet<INode>();
        ArrayList arrayList = new ArrayList();
        List list = this.getNodes();
        arrayList.addAll(map.keySet());
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        HashMap hashMap2 = new HashMap();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashMap2.put(map.get(object), object);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext() && !hashSet.containsAll(list)) {
            object = (Integer)iterator.next();
            INode iNode = (INode)map.get(object);
            if (hashSet.contains(iNode)) continue;
            stack.push(iNode);
            ArrayList<INode> arrayList2 = new ArrayList<INode>();
            while (!stack.isEmpty()) {
                iNode = (INode)stack.pop();
                if (hashSet.contains(iNode)) continue;
                arrayList2.add(iNode);
                hashSet.add(iNode);
                stack.addAll(iNode.getPredsOf());
            }
            hashMap.put(object, arrayList2);
        }
        return hashMap;
    }

    private void createSpanningForest() {
        HashSet hashSet = new HashSet();
        if (this.spanningSuccs == null) {
            this.spanningSuccs = new HashMap();
        } else {
            this.spanningSuccs.clear();
        }
        LIFOWorkBag lIFOWorkBag = new LIFOWorkBag();
        List list = this.getNodes();
        if (this.getHeads().isEmpty()) {
            lIFOWorkBag.addAllWork(list);
        } else {
            lIFOWorkBag.addAllWork(this.getHeads());
        }
        ArrayList<INode> arrayList = new ArrayList<INode>();
        int n = 0;
        int n2 = 0;
        this.prenums = new int[list.size()];
        this.postnums = new int[list.size()];
        this.backedges.clear();
        while (lIFOWorkBag.hasWork()) {
            INode iNode;
            Object object = lIFOWorkBag.getWork();
            if (object instanceof Marker) {
                iNode = (INode)((Marker)object).getContent();
                this.postnums[list.indexOf((Object)iNode)] = ++n2;
                continue;
            }
            if (arrayList.contains(object)) continue;
            iNode = (INode)object;
            this.prenums[list.indexOf((Object)iNode)] = ++n;
            arrayList.add(iNode);
            n2 = this.processNodeForSpanningTree(hashSet, lIFOWorkBag, arrayList, n2, iNode);
        }
        this.hasSpanningForest = true;
    }

    private int processNodeForSpanningTree(Collection collection, IWorkBag iWorkBag, Collection collection2, int n, INode iNode) {
        HashSet<INode> hashSet = new HashSet<INode>();
        int n2 = n;
        boolean bl = true;
        this.spanningSuccs.put(iNode, hashSet);
        iWorkBag.addWork(new Marker(iNode));
        Iterator iterator = iNode.getSuccsOf().iterator();
        while (iterator.hasNext()) {
            INode iNode2 = (INode)iterator.next();
            if (!collection.contains(iNode2) && !collection2.contains(iNode2)) {
                hashSet.add(iNode2);
                collection.add(iNode2);
                iWorkBag.addWork(iNode2);
                bl = false;
                continue;
            }
            this.backedges.add(new Pair(iNode, iNode2, false));
        }
        if (bl) {
            this.postnums[this.getNodes().indexOf((Object)iNode)] = ++n2;
            iWorkBag.getWork();
        }
        return n2;
    }
}

