/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.Triple;
import java.util.ArrayList;

public class TripleTest
extends IndusTestCase {
    private Triple triple1;
    private Triple triple2;

    public final void testGetFirst() {
        TripleTest.assertTrue((boolean)this.triple1.getFirst().equals("first"));
    }

    public final void testGetSecond() {
        TripleTest.assertTrue((boolean)this.triple1.getSecond().equals("second"));
    }

    public final void testGetThird() {
        TripleTest.assertTrue((boolean)this.triple1.getThird().equals("third"));
    }

    public final void testHashCodeAndEquals() {
        Triple triple = new Triple("first", "second", "third");
        TripleTest.assertTrue((this.triple1.hashCode() != this.triple2.hashCode() ? 1 : 0) != 0);
        TripleTest.assertTrue((this.triple1.hashCode() == triple.hashCode() ? 1 : 0) != 0);
        TripleTest.assertFalse((boolean)this.triple1.equals(this.triple2));
        TripleTest.assertTrue((boolean)this.triple1.equals(triple));
        Triple triple2 = new Triple(null, null, null);
        Triple triple3 = new Triple(null, null, null);
        TripleTest.assertTrue((boolean)triple2.equals(triple3));
        TripleTest.assertTrue((triple2.hashCode() == triple3.hashCode() ? 1 : 0) != 0);
        TripleTest.assertFalse((boolean)triple2.equals("hi"));
    }

    public final void testOptimizeAndUnOptimize1() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("first");
        Triple triple = new Triple("first", arrayList, "third");
        triple.optimize();
        int n = triple.hashCode();
        arrayList.add("second");
        TripleTest.assertTrue((triple.hashCode() == n ? 1 : 0) != 0);
        triple.unoptimize();
        TripleTest.assertTrue((triple.hashCode() != n ? 1 : 0) != 0);
        triple.optimize();
        TripleTest.assertTrue((triple.hashCode() != n ? 1 : 0) != 0);
    }

    public final void testOptimizeAndUnOptimize2() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("first");
        Triple triple = new Triple("first", stringBuffer, "third");
        int n = triple.hashCode();
        stringBuffer.append("second");
        TripleTest.assertTrue((triple.hashCode() == n ? 1 : 0) != 0);
        triple.unoptimize();
        TripleTest.assertTrue((triple.hashCode() == n ? 1 : 0) != 0);
        triple.optimize();
        TripleTest.assertTrue((triple.hashCode() == n ? 1 : 0) != 0);
    }

    public final void testToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(true);
        Triple triple = new Triple("first", stringBuffer, "third");
        triple.optimize();
        String string = triple.toString();
        triple.unoptimize();
        stringBuffer.append(false);
        String string2 = triple.toString();
        TripleTest.assertFalse((boolean)string.equals(string2));
        triple.optimize();
        String string3 = triple.toString();
        TripleTest.assertFalse((boolean)string.equals(string3));
        TripleTest.assertTrue((boolean)string2.equals(string3));
    }

    protected void setUp() throws Exception {
        this.triple1 = new Triple("first", "second", "third");
        this.triple2 = new Triple("fourth", "fifth", "sixth");
    }

    protected void tearDown() throws Exception {
        this.triple1 = null;
        this.triple2 = null;
    }
}

