/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.Quadraple;
import java.util.ArrayList;

public class QuadrapleTest
extends IndusTestCase {
    private Quadraple quad1;
    private Quadraple quad2;

    public final void testClone() {
        try {
            Quadraple quadraple = (Quadraple)this.quad1.clone();
            QuadrapleTest.assertTrue((quadraple != this.quad1 ? 1 : 0) != 0);
            QuadrapleTest.assertTrue((quadraple.getFirst() == this.quad1.getFirst() ? 1 : 0) != 0);
            QuadrapleTest.assertTrue((quadraple.getSecond() == this.quad1.getSecond() ? 1 : 0) != 0);
            QuadrapleTest.assertTrue((quadraple.getThird() == this.quad1.getThird() ? 1 : 0) != 0);
            QuadrapleTest.assertTrue((quadraple.getFourth() == this.quad1.getFourth() ? 1 : 0) != 0);
            QuadrapleTest.assertTrue((boolean)quadraple.equals(this.quad1));
            QuadrapleTest.assertTrue((quadraple.hashCode() == this.quad1.hashCode() ? 1 : 0) != 0);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            QuadrapleTest.fail((String)"This is incorrect");
        }
    }

    public final void testGetFirst() {
        QuadrapleTest.assertTrue((boolean)this.quad1.getFirst().equals("first"));
    }

    public final void testGetFourth() {
        QuadrapleTest.assertTrue((boolean)this.quad1.getFourth().equals("fourth"));
    }

    public final void testGetSecond() {
        QuadrapleTest.assertTrue((boolean)this.quad1.getSecond().equals("second"));
    }

    public final void testGetThird() {
        QuadrapleTest.assertTrue((boolean)this.quad1.getThird().equals("third"));
    }

    public final void testHashCodeAndEquals() {
        Quadraple quadraple = new Quadraple("first", "second", "third", "fourth");
        QuadrapleTest.assertTrue((this.quad1.hashCode() != this.quad2.hashCode() ? 1 : 0) != 0);
        QuadrapleTest.assertTrue((this.quad1.hashCode() == quadraple.hashCode() ? 1 : 0) != 0);
        QuadrapleTest.assertFalse((boolean)this.quad1.equals(this.quad2));
        QuadrapleTest.assertTrue((boolean)this.quad1.equals(quadraple));
        Quadraple quadraple2 = new Quadraple(null, null, null, null);
        Quadraple quadraple3 = new Quadraple(null, null, null, null);
        QuadrapleTest.assertTrue((boolean)quadraple2.equals(quadraple3));
        QuadrapleTest.assertTrue((quadraple2.hashCode() == quadraple3.hashCode() ? 1 : 0) != 0);
        QuadrapleTest.assertFalse((boolean)quadraple2.equals("hi"));
    }

    public final void testOptimizeAndUnOptimize1() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("first");
        Quadraple quadraple = new Quadraple("first", arrayList, "third", "fourth");
        quadraple.optimize();
        int n = quadraple.hashCode();
        arrayList.add("second");
        QuadrapleTest.assertTrue((quadraple.hashCode() == n ? 1 : 0) != 0);
        quadraple.unoptimize();
        QuadrapleTest.assertTrue((quadraple.hashCode() != n ? 1 : 0) != 0);
        quadraple.optimize();
        QuadrapleTest.assertTrue((quadraple.hashCode() != n ? 1 : 0) != 0);
    }

    public final void testOptimizeAndUnOptimize2() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("first");
        Quadraple quadraple = new Quadraple("first", stringBuffer, "third", "fourth");
        quadraple.optimize();
        int n = quadraple.hashCode();
        stringBuffer.append("second");
        QuadrapleTest.assertTrue((quadraple.hashCode() == n ? 1 : 0) != 0);
        quadraple.unoptimize();
        QuadrapleTest.assertTrue((quadraple.hashCode() == n ? 1 : 0) != 0);
        quadraple.optimize();
        QuadrapleTest.assertTrue((quadraple.hashCode() == n ? 1 : 0) != 0);
    }

    public final void testToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(true);
        Quadraple quadraple = new Quadraple("first", stringBuffer, "third", "fourth");
        quadraple.optimize();
        String string = quadraple.toString();
        quadraple.unoptimize();
        stringBuffer.append(false);
        String string2 = quadraple.toString();
        QuadrapleTest.assertFalse((boolean)string.equals(string2));
        quadraple.optimize();
        String string3 = quadraple.toString();
        QuadrapleTest.assertFalse((boolean)string.equals(string3));
        QuadrapleTest.assertTrue((boolean)string2.equals(string3));
    }

    protected void setUp() throws Exception {
        this.quad1 = new Quadraple("first", "second", "third", "fourth");
        this.quad2 = new Quadraple("fifth", "sixth", "seventh", "eighth");
    }

    protected void tearDown() throws Exception {
        this.quad1 = null;
        this.quad2 = null;
    }
}

