/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.interfaces.IPoolable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class PoolAwareWorkBag
implements IWorkBag {
    private final IWorkBag container;

    public PoolAwareWorkBag(IWorkBag iWorkBag) {
        this.container = iWorkBag;
    }

    public Object getWork() {
        return this.container.getWork();
    }

    public void addAllWork(Collection collection) {
        this.container.addAllWork(collection);
    }

    public Collection addAllWorkNoDuplicates(Collection collection) {
        Collection collection2 = this.container.addAllWorkNoDuplicates(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IPoolable)) continue;
            IPoolable iPoolable = (IPoolable)e;
            iPoolable.returnToPool();
        }
        return Collections.EMPTY_LIST;
    }

    public void addWork(Object object) {
        this.container.addWork(object);
    }

    public boolean addWorkNoDuplicates(Object object) {
        boolean bl = this.container.addWorkNoDuplicates(object);
        if (!bl && object instanceof IPoolable) {
            ((IPoolable)object).returnToPool();
        }
        return bl;
    }

    public void clear() {
        this.container.clear();
    }

    public boolean hasWork() {
        return this.container.hasWork();
    }
}

